/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.asistentes;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.asistentes.AsistenteImportacion;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoMensajes;
import ec.gob.sri.dimm.api.ui.editores.InputEditorModeloBase;
import ec.gob.sri.dimm.aps.modelo.excepciones.ExcepcionContribuyenteNoEncontrado;
import ec.gob.sri.dimm.aps.modelo.impl.AdministradorModeloAPS;
import ec.gob.sri.dimm.aps.modelo.impl.ContenedorObjetosImportacion;
import ec.gob.sri.dimm.aps.modelo.obj.AdaptadorInformanteSujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.Beneficiario;
import ec.gob.sri.dimm.aps.modelo.obj.Informante;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.ImportarAnexoPaginaBusqueda;
import ec.gob.sri.dimm.aps.ui.editores.InputEditorAPS;
import ec.gob.sri.dimm.aps.ui.editores.InputEditorErroresInformacionAPS;
import ec.gob.sri.dimm.aps.ui.operaciones.OperacionValidacionAnexo;
import ec.gob.sri.dimm.aps.ui.paginas.util.AdministradorDatosAuxiliares;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.w3c.dom.Document;

public class AsistenteImportarAPS
extends AsistenteImportacion<Informante> {
    public static final String ID = "ec.gob.sri.dimm.aps.ui.asistentes.AsistenteImportarAPS";
    private ImportarAnexoPaginaBusqueda paginaBusqueda;
    private Informante modeloDatos;
    private InputEditorAPS datosInput;

    public AsistenteImportarAPS() {
        super("Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", "ec.gob.sri.dimm.aps.ui.editores.EditorAPS");
    }

    public void addPages() {
        this.paginaBusqueda = new ImportarAnexoPaginaBusqueda();
        this.addPage((IWizardPage)this.paginaBusqueda);
    }

    protected File getArchivoXML() {
        return this.paginaBusqueda.getArchivoXML();
    }

    protected boolean validarAnexo(File archivoAnexo) {
        File archivoErroresValidacion;
        OperacionValidacionAnexo operacionValidacion = new OperacionValidacionAnexo(archivoAnexo);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)operacionValidacion);
        }
        catch (InvocationTargetException e1) {
            PluginLogger.logError((String)"Error validando anexo externo.", (String)"dimm-aps-ui", (Exception)e1);
            this.mostrarError("Se ha producido un error inesperado al validar el anexo: " + e1.getMessage());
            return false;
        }
        catch (InterruptedException e1) {
            PluginLogger.logError((String)"Se ha interrumpido el proceso de validaci\u00f3n", (String)"dimm-aps-ui", (Exception)e1);
            this.mostrarError(e1.getMessage());
            return false;
        }
        boolean validacionExitosa = true;
        ResultadoValidacion resultadoEsquema = operacionValidacion.getResultadoValidacionEsquema();
        if (resultadoEsquema != null && (resultadoEsquema.tieneVariosErrores() || resultadoEsquema.tieneVariasAdvertencias())) {
            DialogoMensajes mensajesEsquema = new DialogoMensajes(this.getShell(), "Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", resultadoEsquema.getMensajes());
            mensajesEsquema.open();
            validacionExitosa = false;
        }
        if (validacionExitosa && (archivoErroresValidacion = operacionValidacion.getArchivoErroresInformacion()) != null) {
            InputEditorErroresInformacionAPS datosInput = new InputEditorErroresInformacionAPS(archivoErroresValidacion, archivoAnexo);
            try {
                this.getActivePage().openEditor((IEditorInput)datosInput, "ec.gob.sri.dimm.aps.ui.editores.EditorErroresInformacionAPS");
            }
            catch (PartInitException e) {
                this.mostrarError("Se ha producido un problema al abrir el visor de errores de validaci\u00f3n: " + e.getMessage());
                PluginLogger.logError((String)"Error al mostrar errores de validacion de informacion", (String)"dimm-aps-ui", (Exception)((Object)e));
            }
            validacionExitosa = false;
        }
        if (!validacionExitosa) {
            this.mostrarError(String.format("Se han producido errores al validar el anexo que est\u00e1 siendo importado.%n%nRevise los detalles de errores para obtener m\u00e1s informaci\u00f3n.", new Object[0]));
        }
        return validacionExitosa;
    }

    protected Informante obtenerModelo(final Document documentoAnexo) {
        IRunnableWithProgress operacionImportarAnexo = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AdministradorModeloAPS administradorModelo = new AdministradorModeloAPS();
                try {
                    AsistenteImportarAPS.this.modeloDatos = administradorModelo.importar(documentoAnexo);
                }
                catch (ExcepcionContribuyenteNoEncontrado e) {
                    PluginLogger.logError((String)"Contribuyente no existe. Debe ser registrado", (String)"dimm-aps-ui", (Exception)((Object)e));
                    throw new InterruptedException(String.format("El informante del anexo que est\u00e1 intentando importar no se encuentra registrado.%n%nReg\u00edstrelo utilizando la opci\u00f3n de creaci\u00f3n de RUC [Archivo | Nuevo | RUC] e intente importar el anexo nuevamente.", new Object[0]));
                }
            }
        };
        try {
            this.getContainer().run(true, false, operacionImportarAnexo);
            return this.modeloDatos;
        }
        catch (InvocationTargetException e) {
            PluginLogger.logError((String)"Error inesperado al importar anexo.", (String)"dimm-aps-ui", (Exception)e);
            this.mostrarError("Se ha producido un error inesperado al importar el anexo: " + e.getMessage());
        }
        catch (InterruptedException e) {
            this.mostrarError(e.getMessage());
        }
        return null;
    }

    protected InputEditorModeloBase<Informante> obtenerInputEditor(final Informante modeloImportado) {
        IRunnableWithProgress operacionObtencionInputEditor = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                HashMap<String, SujetoRelacionado> cacheSujetos = new HashMap<String, SujetoRelacionado>();
                if (!ContenedorObjetosImportacion.sujetos.isEmpty()) {
                    for (Map.Entry fila : ContenedorObjetosImportacion.sujetos.entrySet()) {
                        Object sujeto = fila.getValue() instanceof Informante ? new AdaptadorInformanteSujetoRelacionado((Informante)fila.getValue()) : (SujetoRelacionado)fila.getValue();
                        cacheSujetos.put(sujeto.getIdentificacion(), (SujetoRelacionado)sujeto);
                    }
                }
                HashMap<String, List<Participacion>> participacionesPorSujeto = new HashMap<String, List<Participacion>>();
                AdministradorDatosAuxiliares.determinarParticipacionesPorSujeto(participacionesPorSujeto, cacheSujetos);
                HashMap<String, List<Beneficiario>> beneficiarios = new HashMap<String, List<Beneficiario>>();
                AdministradorDatosAuxiliares adminDatos = new AdministradorDatosAuxiliares(cacheSujetos, participacionesPorSujeto, beneficiarios, modeloImportado.getTipoSociedad());
                AsistenteImportarAPS.this.datosInput = new InputEditorAPS(modeloImportado.getIdentificacion(), modeloImportado.getAnio(), modeloImportado.getMes(), modeloImportado.getRazonSocial());
                AsistenteImportarAPS.this.datosInput.setModeloDatos((RaizModelo)modeloImportado);
                AsistenteImportarAPS.this.datosInput.setAdminDatosAuxiliares(adminDatos);
                ContenedorObjetosImportacion.sujetos.clear();
                ContenedorObjetosImportacion.participaciones.clear();
            }
        };
        try {
            this.getContainer().run(true, false, operacionObtencionInputEditor);
            return this.datosInput;
        }
        catch (InvocationTargetException e) {
            PluginLogger.logError((String)"Error inesperado al preparar input del anexo.", (String)"dimm-aps-ui", (Exception)e);
        }
        catch (InterruptedException e) {
            PluginLogger.logError((String)"Preparacion de input del anexo interrumpido.", (String)"dimm-aps-ui", (Exception)e);
        }
        return null;
    }
}

