/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.asistentes;

import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.aps.modelo.obj.DatosIdentificacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.ParticipacionDatosSujeto;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.ParticipacionDatosSujetoConfirmar;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.ParticipacionIdentificacion;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.ParticipacionInfoParticipacion;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.ParticipacionUbicacion;
import ec.gob.sri.dimm.aps.ui.paginas.util.AdministradorDatosAuxiliares;
import ec.gob.sri.dimm.aps.ui.paginas.util.AdministradorTotalesParticipaciones;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

public class AsistenteNuevaParticipacion
extends AsistenteBase
implements INewWizard {
    private ParticipacionIdentificacion paginaIdentificacion;
    private ParticipacionDatosSujeto paginaNuevoSujeto;
    private ParticipacionDatosSujetoConfirmar paginaConfirmarSujeto;
    private ParticipacionUbicacion paginaUbicacion;
    private ParticipacionInfoParticipacion paginaParticipacion;
    private boolean identificacionRUC = false;
    private boolean esUltimaPagina;
    private boolean identificacionExiste = false;
    private DatosIdentificacion modeloDatos;
    private Map<String, SujetoRelacionado> cacheSujetos;
    private SujetoRelacionado sujetoPadre;
    private String tipoSociedadPadre;
    private String tipoDeclaracion;
    private String anio;
    private String mes;
    private AdministradorTotalesParticipaciones adminTotales;
    public static final String ID = "ec.gob.sri.dimm.aps.ui.asistentes.AsistenteNuevaParticipacion";

    public AsistenteNuevaParticipacion(SujetoRelacionado sujetoPadre, String tipoDeclaracion, String tipoSociedadPadre, AdministradorDatosAuxiliares adminDatos, AdministradorTotalesParticipaciones adminTotales, String anio, String mes) {
        this.cacheSujetos = adminDatos.getCacheSujetos();
        this.sujetoPadre = sujetoPadre;
        this.tipoDeclaracion = tipoDeclaracion;
        this.tipoSociedadPadre = tipoSociedadPadre;
        this.adminTotales = adminTotales;
        this.anio = anio;
        this.mes = mes;
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        this.modeloDatos = new DatosIdentificacion();
        this.paginaIdentificacion = new ParticipacionIdentificacion(this.tipoDeclaracion, this.tipoSociedadPadre, this.anio, this.mes, false);
        this.paginaIdentificacion.setModeloDatos(this.modeloDatos);
        this.paginaIdentificacion.inicializarModeloValores();
        this.addPage((IWizardPage)this.paginaIdentificacion);
    }

    private void prepararPaginaNuevoSujeto() {
        if (!this.identificacionExiste) {
            this.paginaNuevoSujeto = new ParticipacionDatosSujeto(this.tipoDeclaracion, this.tipoSociedadPadre, false);
            this.paginaNuevoSujeto.setWizard((IWizard)this);
            this.paginaNuevoSujeto.setModeloDatos(this.modeloDatos.getSujeto());
            this.paginaNuevoSujeto.inicializarModeloValores();
            return;
        }
        this.paginaNuevoSujeto.reenlazarDatos();
    }

    private void prepararPaginaConfirmarSujeto() {
        if (this.paginaConfirmarSujeto == null) {
            this.paginaConfirmarSujeto = new ParticipacionDatosSujetoConfirmar();
            this.paginaConfirmarSujeto.setWizard((IWizard)this);
            this.paginaConfirmarSujeto.setModeloDatos(this.modeloDatos.getSujeto());
            return;
        }
        this.paginaConfirmarSujeto.reenlazarDatos();
    }

    private void prepararPaginaParticipacion() {
        if (this.paginaParticipacion == null) {
            this.paginaParticipacion = new ParticipacionInfoParticipacion(this.anio, this.mes, this.tipoDeclaracion, this.tipoSociedadPadre, this.sujetoPadre, this.adminTotales, false);
            this.paginaParticipacion.setWizard((IWizard)this);
            this.modeloDatos.getParticipacion().setSujeto(this.modeloDatos.getSujeto());
            this.paginaParticipacion.setModeloDatos(this.modeloDatos.getParticipacion());
            this.paginaParticipacion.setUltimaPagina(this.esUltimaPagina);
            this.paginaParticipacion.inicializarModeloValores();
            return;
        }
        this.paginaParticipacion.setUltimaPagina(this.esUltimaPagina);
        this.paginaParticipacion.reenlazarDatos();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.paginaIdentificacion) {
            this.identificacionExiste = this.cacheSujetos.containsKey(this.modeloDatos.getIdentificacion());
            SujetoRelacionado sujetoParticipacion = this.modeloDatos.getSujeto();
            if (this.identificacionExiste) {
                DatosIdentificacion datosIdentificacion = new DatosIdentificacion();
                datosIdentificacion.setTipoSujeto(this.modeloDatos.getTipoSujeto());
                datosIdentificacion.setTipoIdentificacion(this.modeloDatos.getTipoIdentificacion());
                datosIdentificacion.setIdentificacion(this.modeloDatos.getIdentificacion());
                datosIdentificacion.setDescripcionTipoIdentificacion(this.modeloDatos.getDescripcionTipoIdentificacion());
                datosIdentificacion.setPrimerNombre(this.modeloDatos.getPrimerNombre());
                datosIdentificacion.setSegundoApellido(this.modeloDatos.getSegundoNombre());
                datosIdentificacion.setPrimerApellido(this.modeloDatos.getPrimerApellido());
                datosIdentificacion.setSegundoApellido(this.modeloDatos.getSegundoApellido());
                this.modeloDatos.setSujeto(this.cacheSujetos.get(this.modeloDatos.getIdentificacion()));
                this.modeloDatos.getSujeto().setTipoSujeto(this.modeloDatos.getTipoSujeto());
                this.modeloDatos.getSujeto().setDatosIdentificacion(datosIdentificacion);
                sujetoParticipacion.actualizarInformacion(this.modeloDatos.getSujeto());
                sujetoParticipacion.getDatosUbicacion().actualizarInformacion(this.modeloDatos.getSujeto().getDatosUbicacion());
                sujetoParticipacion.getDatosContacto().actualizarInformacion(this.modeloDatos.getSujeto().getDatosContacto());
                this.prepararPaginaConfirmarSujeto();
                return this.paginaConfirmarSujeto;
            }
            SujetoRelacionado plantilla = new SujetoRelacionado();
            plantilla.setDatosIdentificacion(this.modeloDatos);
            sujetoParticipacion.setDatosIdentificacion(this.modeloDatos);
            sujetoParticipacion.actualizarInformacion(plantilla);
            sujetoParticipacion.getDatosUbicacion().actualizarInformacion(plantilla.getDatosUbicacion());
            sujetoParticipacion.getDatosContacto().actualizarInformacion(plantilla.getDatosContacto());
            sujetoParticipacion.setTipoIdentificacion(this.modeloDatos.getTipoIdentificacion());
            sujetoParticipacion.setDescripcionTipoIdentificacion(this.modeloDatos.getDescripcionTipoIdentificacion());
            sujetoParticipacion.setIdentificacion(this.modeloDatos.getIdentificacion());
            sujetoParticipacion.setPeriodo(this.sujetoPadre.getPeriodo());
            sujetoParticipacion.setMes(this.sujetoPadre.getMes());
            sujetoParticipacion.setPrimerNombre(this.modeloDatos.getPrimerNombre());
            sujetoParticipacion.setSegundoNombre(this.modeloDatos.getSegundoNombre());
            sujetoParticipacion.setPrimerApellido(this.modeloDatos.getPrimerApellido());
            sujetoParticipacion.setSegundoApellido(this.modeloDatos.getSegundoApellido());
            sujetoParticipacion.setNombresRazonSocial(this.modeloDatos.getRazonSocial());
            sujetoParticipacion.setTipoSujeto(this.modeloDatos.getTipoSujeto());
            sujetoParticipacion.setEsBeneficiarioFinal(this.modeloDatos.getSujeto().getEsBeneficiarioFinal());
            this.prepararPaginaNuevoSujeto();
            return this.paginaNuevoSujeto;
        }
        if (page == this.paginaNuevoSujeto || page == this.paginaConfirmarSujeto) {
            this.esUltimaPagina = true;
            this.prepararPaginaParticipacion();
            return this.paginaParticipacion;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.paginaParticipacion) {
            this.esUltimaPagina = false;
            if ("R".equals(this.modeloDatos.getParticipacion().getSujeto().getTipoIdentificacion())) {
                if (this.identificacionExiste) {
                    return this.paginaNuevoSujeto;
                }
                return this.paginaConfirmarSujeto;
            }
            return this.paginaUbicacion;
        }
        if (page == this.paginaUbicacion) {
            return this.paginaParticipacion;
        }
        if (page == this.paginaUbicacion) {
            if (this.identificacionExiste) {
                return this.paginaNuevoSujeto;
            }
            return this.paginaConfirmarSujeto;
        }
        if (page == this.paginaNuevoSujeto || page == this.paginaConfirmarSujeto) {
            return this.paginaIdentificacion;
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        return this.esUltimaPagina && this.paginaParticipacion.isPageComplete();
    }

    public boolean performFinish() {
        if (this.identificacionExiste) {
            this.modeloDatos.getParticipacion().setSujeto(this.modeloDatos.getSujeto());
        }
        this.modeloDatos.getSujeto().setDatosIdentificacion(this.modeloDatos);
        return true;
    }

    public DatosIdentificacion getModeloDatos() {
        return this.modeloDatos;
    }
}

