/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.asistentes;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.AdministradorPersistencia;
import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.aps.modelo.obj.AdaptadorInformanteSujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.Informante;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.DatosInformante;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.InformacionNuevoAnexo;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.ModoCreacionAnexo;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.NuevoAnexoDatosGenerales;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.NuevoAnexoInformante;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.NuevoAnexoSeleccionModo;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.NuevoAnexoVersionBase;
import ec.gob.sri.dimm.aps.ui.dialogos.DialogoInicioRapido;
import ec.gob.sri.dimm.aps.ui.editores.InputEditorAPS;
import ec.gob.sri.dimm.aps.ui.paginas.util.AdministradorDatosAuxiliares;
import ec.gov.sri.dimm.principal.persistencia.Contribuyente;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PartInitException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class AsistenteNuevoAPS
extends AsistenteBase
implements INewWizard {
    private InformacionNuevoAnexo modeloDatos;
    private NuevoAnexoSeleccionModo paginaModoAnexo;
    private NuevoAnexoInformante paginaInformante;
    private NuevoAnexoDatosGenerales paginaDatos;
    private NuevoAnexoVersionBase paginaVersion;
    private boolean esUltimaPagina;
    public static final String ID = "ec.gob.sri.dimm.aps.ui.asistentes.AsistenteNuevoAPS";
    private static final String K_PUEDE_MOSTRAR_INICIO_RAPIDO = "K_UI_MOSTRAR_INICIORAPIDO";

    public void addPages() {
        this.modeloDatos = new InformacionNuevoAnexo();
        this.paginaModoAnexo = new NuevoAnexoSeleccionModo();
        this.paginaModoAnexo.setModeloDatos(this.modeloDatos);
        this.paginaInformante = new NuevoAnexoInformante();
        this.paginaInformante.setModeloDatos(this.modeloDatos);
        this.paginaInformante.inicializarModeloValores();
        this.paginaDatos = new NuevoAnexoDatosGenerales();
        this.paginaDatos.setWizard((IWizard)this);
        this.paginaDatos.setModeloDatos(this.modeloDatos);
        this.paginaDatos.inicializarModeloValores();
        this.paginaVersion = new NuevoAnexoVersionBase();
        this.paginaVersion.setWizard((IWizard)this);
        this.paginaVersion.setModeloDatos(this.modeloDatos);
        this.addPage((IWizardPage)this.paginaModoAnexo);
        this.addPage((IWizardPage)this.paginaInformante);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.paginaInformante) {
            if (this.modeloDatos.getModoCreacionAnexo() == ModoCreacionAnexo.VERSION) {
                this.paginaVersion.inicializarModeloValores();
                return this.paginaVersion;
            }
            this.esUltimaPagina = true;
            return this.paginaDatos;
        }
        if (page == this.paginaVersion) {
            this.esUltimaPagina = true;
            return this.paginaDatos;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.paginaDatos) {
            this.esUltimaPagina = false;
            if (this.modeloDatos.getModoCreacionAnexo() == ModoCreacionAnexo.VERSION) {
                return this.paginaVersion;
            }
            return this.paginaInformante;
        }
        if (page == this.paginaVersion) {
            return this.paginaInformante;
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        return this.esUltimaPagina && this.paginaDatos.isPageComplete();
    }

    public boolean performFinish() {
        String mensaje;
        Informante modeloEditor = null;
        DatosInformante datosInformante = this.modeloDatos.getDatosInformante();
        Contribuyente contribuyente = this.modeloDatos.getContribuyente();
        switch (this.modeloDatos.getModoCreacionAnexo()) {
            case NUEVO: {
                modeloEditor = new Informante();
                modeloEditor.setIdentificacion(contribuyente.getRuc());
                modeloEditor.setRazonSocial(contribuyente.getRazonSocial());
                break;
            }
            case VERSION: {
                modeloEditor = this.modeloDatos.getModeloDatosBase();
                break;
            }
            default: {
                return false;
            }
        }
        modeloEditor.setDeclaracionMensual(datosInformante.isDeclaracionMensual());
        modeloEditor.setAnio(datosInformante.getAnio());
        modeloEditor.setMes(datosInformante.isDeclaracionMensual() ? datosInformante.getMes() : "00");
        modeloEditor.setPeriodicidad(datosInformante.getPeriodicidad());
        modeloEditor.setTipoSociedad(datosInformante.getTipoSociedad());
        modeloEditor.setPorcentajeNoCotiza(datosInformante.getPorcentajeNoCotiza());
        modeloEditor.setPorcentajeCotiza(datosInformante.getPorcentajeCotiza());
        modeloEditor.setTipoDeclaracion(datosInformante.getTipoDeclaracion());
        String rutaAnexo = AdministradorPersistencia.obtenerRutaArchivoBinario((String)modeloEditor.getCodigoOperativo(), (String)modeloEditor.getIdentificacion(), (String)modeloEditor.getAnio(), (String)modeloEditor.getMes());
        File archivoAnexo = new File(rutaAnexo);
        if (archivoAnexo.exists() && !this.mostrarConfirmacion(mensaje = datosInformante.isDeclaracionMensual() ? String.format("Ya existe un anexo del informante %s para el periodo %s %s.%n%n\u00bfDesea continuar con la creaci\u00f3n del nuevo anexo? Tenga en cuenta que si contin\u00faa, el anexo existente ser\u00e1 reemplazado.", modeloEditor.getIdentificacion(), modeloEditor.getAnio(), modeloEditor.getMes()) : String.format("Ya existe un anexo del informante %s para el a\u00f1o %s.%n%n\u00bfDesea continuar con la creaci\u00f3n del nuevo anexo? Tenga en cuenta que si contin\u00faa, el anexo existente ser\u00e1 reemplazado.", modeloEditor.getIdentificacion(), modeloEditor.getAnio()))) {
            return false;
        }
        try {
            AdaptadorInformanteSujetoRelacionado sujetoInformante = new AdaptadorInformanteSujetoRelacionado(modeloEditor);
            AdministradorDatosAuxiliares adminDatos = new AdministradorDatosAuxiliares();
            adminDatos.getCacheSujetos().put(sujetoInformante.getIdentificacion(), (SujetoRelacionado)sujetoInformante);
            adminDatos.verificarSujetoIncompleto((SujetoRelacionado)sujetoInformante);
            InputEditorAPS datosInput = new InputEditorAPS(modeloEditor.getIdentificacion(), modeloEditor.getAnio(), modeloEditor.getMes(), modeloEditor.getRazonSocial());
            datosInput.setModeloDatos((RaizModelo)modeloEditor);
            datosInput.setAdminDatosAuxiliares(adminDatos);
            this.getActivePage().openEditor((IEditorInput)datosInput, "ec.gob.sri.dimm.aps.ui.editores.EditorAPS");
            if (this.puedeMostrarInicioRapido()) {
                DialogoInicioRapido quickStart = new DialogoInicioRapido(this.getShell());
                quickStart.open();
                if (quickStart.isNoMostrarNuevamente()) {
                    this.cambiarMostrarInicioRapido(false);
                }
            }
            return true;
        }
        catch (PartInitException e) {
            this.mostrarError("Se ha producido un error al abrir el editor: " + e.getMessage());
            return false;
        }
    }

    private boolean puedeMostrarInicioRapido() {
        Preferences preferencias = Platform.getPreferencesService().getRootNode().node("instance").node("dimm-aps-ui");
        if (preferencias == null) {
            return true;
        }
        boolean mostrarInicioRapido = preferencias.getBoolean(K_PUEDE_MOSTRAR_INICIO_RAPIDO, true);
        return mostrarInicioRapido;
    }

    private void cambiarMostrarInicioRapido(boolean mostrar) {
        Preferences preferencias = Platform.getPreferencesService().getRootNode().node("instance").node("dimm-aps-ui");
        if (preferencias == null) {
            return;
        }
        preferencias.putBoolean(K_PUEDE_MOSTRAR_INICIO_RAPIDO, mostrar);
        try {
            preferencias.flush();
        }
        catch (BackingStoreException e) {
            PluginLogger.logError((String)"Error al guardar preferencias del plugin.", (String)"dimm-aps-ui", (Exception)((Object)e));
        }
    }
}

