/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.asistentes;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.aps.ui.asistentes.paginas.ValidarAnexoPaginaBusqueda;
import ec.gob.sri.dimm.aps.ui.operaciones.OperacionValidacionAnexo;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchWizard;

public class AsistenteValidarAPS
extends AsistenteBase
implements IWorkbenchWizard {
    public static final String ID = "ec.gob.sri.dimm.aps.ui.asistentes.AsistenteValidarAPS";
    private ValidarAnexoPaginaBusqueda paginaBusqueda;
    private ResultadoValidacion resultadoValidacion = null;
    private File archivoErroresInformacion = null;
    private File archivoAnexo = null;

    public AsistenteValidarAPS() {
        this.setNeedsProgressMonitor(true);
    }

    public ResultadoValidacion getResultadoValidacion() {
        return this.resultadoValidacion;
    }

    public File getArchivoErroresInformacion() {
        return this.archivoErroresInformacion;
    }

    public File getArchivoAnexo() {
        return this.archivoAnexo;
    }

    public void addPages() {
        this.paginaBusqueda = new ValidarAnexoPaginaBusqueda();
        this.addPage((IWizardPage)this.paginaBusqueda);
    }

    public boolean performFinish() {
        File archivoXML = this.paginaBusqueda.getArchivoXML();
        OperacionValidacionAnexo operacionValidacion = new OperacionValidacionAnexo(archivoXML);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)operacionValidacion);
        }
        catch (InvocationTargetException e) {
            PluginLogger.logError((String)"Error validando anexo externo.", (String)"dimm-aps-ui", (Exception)e);
            this.mostrarError("Se ha producido un error al validar el anexo: " + e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            PluginLogger.logError((String)"Se ha interrumpido el proceso de validaci\u00f3n", (String)"dimm-aps-ui", (Exception)e);
            this.mostrarError(e.getMessage());
            return false;
        }
        this.archivoErroresInformacion = operacionValidacion.getArchivoErroresInformacion();
        this.resultadoValidacion = operacionValidacion.getResultadoValidacionEsquema();
        this.archivoAnexo = archivoXML;
        return true;
    }
}

