/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.asistentes.paginas;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombre;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.DoubleToStringConverter;
import ec.gob.sri.dimm.api.convertidores.StringToDoubleConverter;
import ec.gob.sri.dimm.api.modelo.persistencia.ArchivoTemporalAnexo;
import ec.gob.sri.dimm.api.modelo.validacion.EstadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteControl;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.aps.modelo.obj.Informante;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.DatosInformante;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.InformacionNuevoAnexo;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.ModeloValoresDatosInformante;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class NuevoAnexoDatosGenerales
extends PaginaAsistente
implements VistaValoresPropios,
VistaModelo<InformacionNuevoAnexo> {
    private DataBindingContext m_bindingContext;
    private InformacionNuevoAnexo modeloDatos;
    private ModeloValoresDatosInformante modeloValores;
    private Label lblRUC;
    private Label lblRazonSocial;
    private Text txtPorcentajeAccionesNoBolsa;
    private Text txtPorcentajeAccionesBolsa;
    private ComboViewer cvTipoSociedad;
    private ComboViewer cvTipoDeclaracion;
    private ComboViewer cvAnio;
    private ComboViewer cvMes;
    private Combo cboAnio;
    private Combo cboMes;
    private Button btnAnual;
    private Button btnMensual;
    private Button btnAnticipada;
    private Label lblPorcentajeAccionario;
    private Label lblPorcentaje;
    private Label lblPorcentajeNegocia;
    private Label lblPorcentajeNeg;
    private Label lblTipoDeclaracion;

    public NuevoAnexoDatosGenerales() {
        super("NuevoAnexoDatosGenerales", "Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", "Ingrese los siguientes datos acerca del informante.");
    }

    public void createControl(Composite parent) {
        Composite cDatosInformante = new Composite(parent, 0);
        this.setControl((Control)cDatosInformante);
        cDatosInformante.setLayout((Layout)new GridLayout(1, false));
        Label lblInformante = new Label(cDatosInformante, 0);
        lblInformante.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblInformante.setFont(SWTResourceManager.getBoldFont((Font)lblInformante.getFont()));
        lblInformante.setText("Informante");
        Composite cResumenInformante = new Composite(cDatosInformante, 0);
        cResumenInformante.setLayout((Layout)new GridLayout(1, false));
        cResumenInformante.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblRUC = new Label(cResumenInformante, 0);
        this.lblRUC.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblRUC.setText("1700000001001");
        this.lblRazonSocial = new Label(cResumenInformante, 64);
        GridData gdLblRazonSocial = new GridData(4, 4, false, false, 3, 1);
        gdLblRazonSocial.widthHint = 556;
        this.lblRazonSocial.setLayoutData((Object)gdLblRazonSocial);
        this.lblRazonSocial.setText("RAZON SOCIAL DEL INFORMANTE CIA. LTDA.");
        Label lblPeriodoDeclaracion = new Label(cDatosInformante, 0);
        GridData gdLblPeriodoDeclaracion = new GridData(4, 0x1000000, false, false, 1, 1);
        gdLblPeriodoDeclaracion.verticalIndent = 5;
        lblPeriodoDeclaracion.setLayoutData((Object)gdLblPeriodoDeclaracion);
        lblPeriodoDeclaracion.setFont(SWTResourceManager.getBoldFont((Font)lblPeriodoDeclaracion.getFont()));
        lblPeriodoDeclaracion.setText("Periodo de Declaraci\u00f3n");
        Composite cPeriodoDeclaracion = new Composite(cDatosInformante, 0);
        cPeriodoDeclaracion.setLayout((Layout)new GridLayout(2, false));
        Label lblPeriodicidad = new Label(cPeriodoDeclaracion, 0);
        lblPeriodicidad.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblPeriodicidad.setText("Periodicidad:");
        Composite cPeriodicidad = new Composite(cPeriodoDeclaracion, 0);
        RowLayout rlCPeriodicidad = new RowLayout(256);
        rlCPeriodicidad.spacing = 5;
        rlCPeriodicidad.marginTop = 0;
        rlCPeriodicidad.marginRight = 0;
        rlCPeriodicidad.marginLeft = 0;
        rlCPeriodicidad.marginBottom = 0;
        cPeriodicidad.setLayout((Layout)rlCPeriodicidad);
        this.btnAnual = new Button(cPeriodicidad, 16);
        this.btnAnual.setLayoutData((Object)new RowData(75, -1));
        this.btnAnual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setMes(null);
                NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setAnio(null);
                NuevoAnexoDatosGenerales.this.cboAnio.setEnabled(true);
                NuevoAnexoDatosGenerales.this.cboMes.setEnabled(false);
                NuevoAnexoDatosGenerales.this.lblTipoDeclaracion.setEnabled(false);
                NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.getCombo().setEnabled(false);
                NuevoAnexoDatosGenerales.this.modeloValores.obtenerAnios(Integer.valueOf(0));
                NuevoAnexoDatosGenerales.this.modeloValores.getAnios();
                NuevoAnexoDatosGenerales.this.cvAnio.refresh();
                NuevoAnexoDatosGenerales.this.cvMes.refresh();
                NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.setSelection(null, true);
                NuevoAnexoDatosGenerales.this.cvTipoSociedad.setSelection(null, true);
            }
        });
        this.btnAnual.setText("Anual");
        this.btnMensual = new Button(cPeriodicidad, 16);
        this.btnMensual.setLayoutData((Object)new RowData(75, -1));
        this.btnMensual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setMes(null);
                NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setAnio(null);
                NuevoAnexoDatosGenerales.this.cboAnio.setEnabled(true);
                NuevoAnexoDatosGenerales.this.cboMes.setEnabled(true);
                NuevoAnexoDatosGenerales.this.lblTipoDeclaracion.setEnabled(false);
                NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.getCombo().setEnabled(false);
                NuevoAnexoDatosGenerales.this.modeloValores.obtenerAnios(Integer.valueOf(1));
                NuevoAnexoDatosGenerales.this.modeloValores.getAnios();
                NuevoAnexoDatosGenerales.this.cvAnio.refresh();
                NuevoAnexoDatosGenerales.this.cvMes.refresh();
                NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.setSelection(null, true);
                NuevoAnexoDatosGenerales.this.cvTipoSociedad.setSelection(null, true);
            }
        });
        this.btnMensual.setText("Mensual");
        this.btnAnticipada = new Button(cPeriodicidad, 16);
        this.btnAnticipada.setLayoutData((Object)new RowData(75, -1));
        this.btnAnticipada.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setMes(null);
                NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setAnio(null);
                NuevoAnexoDatosGenerales.this.cboAnio.setEnabled(true);
                NuevoAnexoDatosGenerales.this.cboMes.setEnabled(false);
                NuevoAnexoDatosGenerales.this.lblTipoDeclaracion.setEnabled(false);
                NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.getCombo().setEnabled(false);
                NuevoAnexoDatosGenerales.this.modeloValores.obtenerAnios(Integer.valueOf(2));
                NuevoAnexoDatosGenerales.this.modeloValores.getAnios();
                NuevoAnexoDatosGenerales.this.cvAnio.refresh();
                NuevoAnexoDatosGenerales.this.cvMes.refresh();
                NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.setSelection(null, true);
                NuevoAnexoDatosGenerales.this.cvTipoSociedad.setSelection(null, true);
            }
        });
        this.btnAnticipada.setText("Anticipada");
        Label lblAnio = new Label(cPeriodoDeclaracion, 0);
        GridData gdLblAnio = new GridData(4, 0x1000000, false, false, 1, 1);
        gdLblAnio.widthHint = 100;
        lblAnio.setLayoutData((Object)gdLblAnio);
        lblAnio.setText("A\u00f1o:");
        this.cvAnio = new ComboViewer(cPeriodoDeclaracion, 8);
        this.cvAnio.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombre anio = (ElementoNombre)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (anio != null) {
                    NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setAnio(anio.getNombre());
                    NuevoAnexoDatosGenerales.this.modeloValores.cargarTipoSociedadPorTipoDeclaracion(null, NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().getAnio(), "00");
                    NuevoAnexoDatosGenerales.this.cvTipoSociedad.refresh();
                    if (Integer.parseInt(NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().getAnio()) > 2023) {
                        NuevoAnexoDatosGenerales.this.lblTipoDeclaracion.setEnabled(true);
                        NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.getCombo().setEnabled(true);
                    } else {
                        NuevoAnexoDatosGenerales.this.lblTipoDeclaracion.setEnabled(false);
                        NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.getCombo().setEnabled(false);
                    }
                }
            }
        });
        this.cboAnio = this.cvAnio.getCombo();
        this.cboAnio.setEnabled(false);
        if (!StringUtil.isNullOrEmpty((String)this.modeloDatos.getDatosInformante().getAnio())) {
            this.cboAnio.setEnabled(true);
        }
        GridData gdCboAnio = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdCboAnio.widthHint = 75;
        this.cboAnio.setLayoutData((Object)gdCboAnio);
        Label lblMes = new Label(cPeriodoDeclaracion, 0);
        GridData gdLblMes = new GridData(4, 0x1000000, false, false, 1, 1);
        gdLblMes.widthHint = 100;
        lblMes.setLayoutData((Object)gdLblMes);
        lblMes.setText("Mes:");
        this.cvMes = new ComboViewer(cPeriodoDeclaracion, 8);
        this.cvMes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor mes = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (mes != null) {
                    NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setMes((String)mes.getValor());
                    NuevoAnexoDatosGenerales.this.modeloValores.cargarTipoSociedadPorTipoDeclaracion(null, NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().getAnio(), NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().getMes());
                    NuevoAnexoDatosGenerales.this.cvTipoSociedad.refresh();
                    int anioSeleccionado = Integer.parseInt(NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().getAnio()) >= 0 ? Integer.parseInt(NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().getAnio()) : 0;
                    int mesSeleccionado = Integer.parseInt((String)mes.getValor());
                    if (anioSeleccionado >= 2025 || anioSeleccionado >= 2024 && mesSeleccionado >= 9) {
                        NuevoAnexoDatosGenerales.this.lblTipoDeclaracion.setEnabled(true);
                        NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.getCombo().setEnabled(true);
                    } else {
                        NuevoAnexoDatosGenerales.this.lblTipoDeclaracion.setEnabled(false);
                        NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.getCombo().deselectAll();
                        NuevoAnexoDatosGenerales.this.cvTipoDeclaracion.getCombo().setEnabled(false);
                    }
                }
            }
        });
        this.cboMes = this.cvMes.getCombo();
        this.cboMes.setEnabled(false);
        GridData gdCboMes = new GridData(16384, 128, true, false, 1, 1);
        gdCboMes.widthHint = 75;
        this.cboMes.setLayoutData((Object)gdCboMes);
        new Label(cPeriodoDeclaracion, 0);
        Composite cTipoDeclaracion = new Composite(cDatosInformante, 0);
        cTipoDeclaracion.setLayout((Layout)new GridLayout(2, false));
        this.lblTipoDeclaracion = new Label(cTipoDeclaracion, 0);
        this.lblTipoDeclaracion.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblTipoDeclaracion.setFont(SWTResourceManager.getBoldFont((Font)this.lblTipoDeclaracion.getFont()));
        this.lblTipoDeclaracion.setText("Tipo de declaraci\u00f3n:");
        this.cvTipoDeclaracion = new ComboViewer(cTipoDeclaracion, 8);
        this.cvTipoDeclaracion.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoDeclaracion = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoDeclaracion != null) {
                    NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setTipoDeclaracion((String)tipoDeclaracion.getValor());
                    NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setDescripcionTipoDeclaracion(tipoDeclaracion.getNombre());
                    NuevoAnexoDatosGenerales.this.modeloValores.cargarTipoSociedadPorTipoDeclaracion((String)tipoDeclaracion.getValor(), NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().getAnio(), NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().getMes());
                    NuevoAnexoDatosGenerales.this.cvTipoSociedad.getCombo().removeAll();
                    NuevoAnexoDatosGenerales.this.cvTipoSociedad.refresh();
                }
            }
        });
        Label lblInfoSociedad = new Label(cDatosInformante, 0);
        GridData gdLblInfoSociedad = new GridData(4, 0x1000000, false, false, 1, 1);
        gdLblInfoSociedad.verticalIndent = 5;
        lblInfoSociedad.setLayoutData((Object)gdLblInfoSociedad);
        lblInfoSociedad.setFont(SWTResourceManager.getBoldFont((Font)lblInfoSociedad.getFont()));
        lblInfoSociedad.setText("Informaci\u00f3n de la Sociedad");
        Composite cInfoSociedad = new Composite(cDatosInformante, 0);
        cInfoSociedad.setLayout((Layout)new GridLayout(3, false));
        Label lblTipoSociedad = new Label(cInfoSociedad, 0);
        lblTipoSociedad.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblTipoSociedad.setText("Tipo de Sociedad:");
        this.cvTipoSociedad = new ComboViewer(cInfoSociedad, 8);
        this.cvTipoSociedad.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoSociedad = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoSociedad != null) {
                    NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setTipoSociedad((String)tipoSociedad.getValor());
                    boolean empresaCotizaBolsaValores = "02".equals(tipoSociedad.getValor());
                    AyudanteControl.habilitar((boolean)empresaCotizaBolsaValores, (Control[])new Control[]{NuevoAnexoDatosGenerales.this.lblPorcentajeAccionario, NuevoAnexoDatosGenerales.this.txtPorcentajeAccionesNoBolsa, NuevoAnexoDatosGenerales.this.lblPorcentaje, NuevoAnexoDatosGenerales.this.lblPorcentajeNegocia, NuevoAnexoDatosGenerales.this.lblPorcentajeNeg});
                    if (!empresaCotizaBolsaValores) {
                        NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setPorcentajeNoCotiza(Double.valueOf(0.0));
                        NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setPorcentajeCotiza(Double.valueOf(0.0));
                        NuevoAnexoDatosGenerales.this.txtPorcentajeAccionesBolsa.setText(NuevoAnexoDatosGenerales.this.obtenerFormatoDecimal(0.0));
                    } else {
                        NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setPorcentajeNoCotiza(null);
                        NuevoAnexoDatosGenerales.this.modeloDatos.getDatosInformante().setPorcentajeCotiza(null);
                        NuevoAnexoDatosGenerales.this.txtPorcentajeAccionesNoBolsa.setText("");
                        NuevoAnexoDatosGenerales.this.txtPorcentajeAccionesBolsa.setText("");
                    }
                }
            }
        });
        Combo cboTipoSociedad = this.cvTipoSociedad.getCombo();
        GridData gdCboTipoSociedad = new GridData(16384, 0x1000000, false, false, 2, 1);
        gdCboTipoSociedad.widthHint = 365;
        cboTipoSociedad.setLayoutData((Object)gdCboTipoSociedad);
        this.lblPorcentajeAccionario = new Label(cInfoSociedad, 64);
        this.lblPorcentajeAccionario.setEnabled(false);
        GridData gdLblPorcentajeAccionario = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblPorcentajeAccionario.widthHint = 160;
        this.lblPorcentajeAccionario.setLayoutData((Object)gdLblPorcentajeAccionario);
        this.lblPorcentajeAccionario.setText("Porcentaje Accionario que no Negocia en Bolsa de Valores:");
        this.txtPorcentajeAccionesNoBolsa = new Text(cInfoSociedad, 133120);
        this.txtPorcentajeAccionesNoBolsa.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Double diferencia = 100.0 - Double.parseDouble(!StringUtil.isNullOrEmpty((String)NuevoAnexoDatosGenerales.this.txtPorcentajeAccionesNoBolsa.getText()) ? NuevoAnexoDatosGenerales.this.txtPorcentajeAccionesNoBolsa.getText() : "0.00");
                NuevoAnexoDatosGenerales.this.txtPorcentajeAccionesBolsa.setText(NuevoAnexoDatosGenerales.this.obtenerFormatoDecimal(diferencia));
            }
        });
        this.txtPorcentajeAccionesNoBolsa.setEnabled(false);
        this.txtPorcentajeAccionesNoBolsa.setTextLimit(9);
        this.lblPorcentaje = new Label(cInfoSociedad, 0);
        this.lblPorcentaje.setEnabled(false);
        this.lblPorcentaje.setText("%");
        this.lblPorcentajeNegocia = new Label(cInfoSociedad, 64);
        this.lblPorcentajeNegocia.setEnabled(false);
        GridData gdLblPorcentajeNegocia = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblPorcentajeNegocia.widthHint = 160;
        gdLblPorcentajeAccionario.widthHint = 160;
        this.lblPorcentajeNegocia.setLayoutData((Object)gdLblPorcentajeNegocia);
        this.lblPorcentajeNegocia.setText("Porcentaje Accionario que negocia en Bolsa de Valores:");
        this.txtPorcentajeAccionesBolsa = new Text(cInfoSociedad, 133120);
        this.txtPorcentajeAccionesBolsa.setEnabled(false);
        this.txtPorcentajeAccionesBolsa.setTextLimit(9);
        this.lblPorcentajeNeg = new Label(cInfoSociedad, 0);
        this.lblPorcentajeNeg.setEnabled(false);
        this.lblPorcentajeNeg.setText("%");
        this.m_bindingContext = this.initDataBindings();
        this.inhabilitarComponentes();
        this.procesarModeloDatos();
    }

    private void inhabilitarComponentes() {
        this.lblTipoDeclaracion.setEnabled(false);
        this.cvTipoDeclaracion.getCombo().setEnabled(false);
    }

    public void setModeloDatos(InformacionNuevoAnexo modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
        final DatosInformante datosInformante = this.modeloDatos.getDatosInformante();
        final ArchivoTemporalAnexo vBase = this.modeloDatos.getVersionBase();
        if (vBase != null) {
            ElementoNombreValor tipoDeclaracion = this.modeloValores.obtenerTipoDeclaracion(datosInformante.getTipoDeclaracion());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoDeclaracion, (Object)tipoDeclaracion);
            ElementoNombreValor tipoSociedad = this.modeloValores.obtenerTipoSociedad(datosInformante.getTipoSociedad());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoSociedad, (Object)tipoSociedad);
            ElementoNombre anio = this.modeloValores.obtenerAnio(datosInformante.getAnio());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvAnio, (Object)anio);
            ElementoNombreValor mes = this.modeloValores.obtenerMes(datosInformante.getMes());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvMes, (Object)mes);
            this.cboMes.setEnabled(datosInformante.isDeclaracionMensual());
        }
        datosInformante.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ResultadoValidacion resultado = datosInformante.validar();
                boolean exitoso = resultado.esEstadoExitoso();
                if (exitoso && vBase != null) {
                    resultado = this.validarExtraVersion(resultado);
                    exitoso = resultado.esEstadoExitoso();
                }
                if (exitoso) {
                    NuevoAnexoDatosGenerales.this.setErrorMessage(null);
                    NuevoAnexoDatosGenerales.this.setMessage(null);
                    NuevoAnexoDatosGenerales.this.setPageComplete(true);
                    return;
                }
                if (resultado.getEstado() == EstadoValidacion.FALLIDO) {
                    NuevoAnexoDatosGenerales.this.setMessage(null);
                    NuevoAnexoDatosGenerales.this.setErrorMessage(resultado.getMensaje());
                    NuevoAnexoDatosGenerales.this.setPageComplete(false);
                } else if (resultado.getEstado() == EstadoValidacion.ADVERTENCIA) {
                    NuevoAnexoDatosGenerales.this.setErrorMessage(null);
                    NuevoAnexoDatosGenerales.this.setMessage(resultado.getMensaje(), 2);
                    NuevoAnexoDatosGenerales.this.setPageComplete(true);
                }
            }

            private ResultadoValidacion validarExtraVersion(ResultadoValidacion resultado) {
                Informante iBase = NuevoAnexoDatosGenerales.this.modeloDatos.getModeloDatosBase();
                if (Integer.parseInt(datosInformante.getAnio()) < Integer.parseInt(iBase.getAnio())) {
                    return resultado.fallarValidacion(String.format("El a\u00f1o especificado es anterior al del anexo seleccionado como versi\u00f3n base (%s)", iBase.getAnio()));
                }
                if (datosInformante.isDeclaracionMensual()) {
                    String mes;
                    String string = mes = StringUtil.isNullOrEmpty((String)iBase.getMes()) ? "00" : iBase.getMes();
                    if (Integer.parseInt(datosInformante.getMes()) <= Integer.parseInt(mes)) {
                        return resultado.fallarValidacion(String.format("El mes especificado es anterior al del anexo seleccionado como versi\u00f3n base (%s)", NuevoAnexoDatosGenerales.this.modeloValores.obtenerMes(iBase.getMes()).getNombre()));
                    }
                    if (datosInformante.getAnio().equals(iBase.getAnio()) && datosInformante.getMes().equals(iBase.getMes())) {
                        return resultado.fallarValidacion(String.format("El a\u00f1o y mes indicados son los mismos que los del anexo seleccionado como versi\u00f3n base (%s/%s)", iBase.getAnio(), iBase.getMes()));
                    }
                } else if (datosInformante.getAnio().equals(iBase.getAnio())) {
                    return resultado.fallarValidacion(String.format("El a\u00f1o indicado es el mismo que el del anexo seleccionado como versi\u00f3n base (%s)", iBase.getAnio()));
                }
                return resultado.pasarValidacion();
            }
        });
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresDatosInformante();
        this.modeloValores.inicializar();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue lblRUCObserveTextObserveWidget = SWTObservables.observeText((Control)this.lblRUC);
        IObservableValue modeloDatosContribuyenterucObserveValue = PojoObservables.observeValue((Object)this.modeloDatos, (String)"contribuyente.ruc");
        bindingContext.bindValue((IObservableValue)lblRUCObserveTextObserveWidget, modeloDatosContribuyenterucObserveValue, null, null);
        ISWTObservableValue lblRazonSocialObserveTextObserveWidget = SWTObservables.observeText((Control)this.lblRazonSocial);
        IObservableValue modeloDatosContribuyenterazonSocialObserveValue = PojoObservables.observeValue((Object)this.modeloDatos, (String)"contribuyente.razonSocial");
        bindingContext.bindValue((IObservableValue)lblRazonSocialObserveTextObserveWidget, modeloDatosContribuyenterazonSocialObserveValue, null, null);
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoSociedad.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoSociedad.setContentProvider((IContentProvider)listContentProvider);
        IObservableList modeloValoresTiposSociedadObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposSociedad");
        this.cvTipoSociedad.setInput((Object)modeloValoresTiposSociedadObserveList);
        ISWTObservableValue txtPorcentajeAccionesNoBolsaObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtPorcentajeAccionesNoBolsa, (int[])new int[]{24, 16});
        IObservableValue modeloDatosDatosInformanteporcentajeNoCotizaObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"datosInformante.porcentajeNoCotiza");
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new StringToDoubleConverter());
        UpdateValueStrategy strategyOne = new UpdateValueStrategy();
        strategyOne.setConverter((IConverter)new DoubleToStringConverter());
        bindingContext.bindValue((IObservableValue)txtPorcentajeAccionesNoBolsaObserveTextObserveWidget, modeloDatosDatosInformanteporcentajeNoCotizaObserveValue, strategy, strategyOne);
        ISWTObservableValue txtPorcentajeAccionesBolsaObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtPorcentajeAccionesBolsa, (int[])new int[]{24, 16});
        IObservableValue modeloDatosDatosInformanteporcentajeCotizaObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"datosInformante.porcentajeCotiza");
        UpdateValueStrategy strategyPorcentaje = new UpdateValueStrategy();
        strategyPorcentaje.setConverter((IConverter)new StringToDoubleConverter());
        UpdateValueStrategy strategyPorcentajeOne = new UpdateValueStrategy();
        strategyPorcentajeOne.setConverter((IConverter)new DoubleToStringConverter());
        bindingContext.bindValue((IObservableValue)txtPorcentajeAccionesBolsaObserveTextObserveWidget, modeloDatosDatosInformanteporcentajeCotizaObserveValue, strategyPorcentaje, strategyPorcentajeOne);
        ObservableListContentProvider listContentProviderOne = new ObservableListContentProvider();
        IObservableMap observeMapOne = PojoObservables.observeMap((IObservableSet)listContentProviderOne.getKnownElements(), ElementoNombre.class, (String)"etiqueta");
        this.cvAnio.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapOne));
        this.cvAnio.setContentProvider((IContentProvider)listContentProviderOne);
        IObservableList modeloValoresAniosObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"anios");
        this.cvAnio.setInput((Object)modeloValoresAniosObserveList);
        ObservableListContentProvider listContentProviderTwo = new ObservableListContentProvider();
        IObservableMap observeMapTwo = PojoObservables.observeMap((IObservableSet)listContentProviderTwo.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvMes.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapTwo));
        this.cvMes.setContentProvider((IContentProvider)listContentProviderTwo);
        IObservableList modeloValoresMesesObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"meses");
        this.cvMes.setInput((Object)modeloValoresMesesObserveList);
        ObservableListContentProvider listContentProviderTipoDeclaracion = new ObservableListContentProvider();
        IObservableMap observeMapTipoDeclaracion = PojoObservables.observeMap((IObservableSet)listContentProviderTipoDeclaracion.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoDeclaracion.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapTipoDeclaracion));
        this.cvTipoDeclaracion.setContentProvider((IContentProvider)listContentProviderTipoDeclaracion);
        IObservableList modeloTipoDeclaracionObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tipoDeclaracion");
        this.cvTipoDeclaracion.setInput((Object)modeloTipoDeclaracionObserveList);
        SelectObservableValue periodSelObs = new SelectObservableValue();
        periodSelObs.addOption((Object)"Anual", (IObservableValue)SWTObservables.observeSelection((Control)this.btnAnual));
        periodSelObs.addOption((Object)"Mensual", (IObservableValue)SWTObservables.observeSelection((Control)this.btnMensual));
        periodSelObs.addOption((Object)"Anticipada", (IObservableValue)SWTObservables.observeSelection((Control)this.btnAnticipada));
        IObservableValue periodicidadObs = BeansObservables.observeValue((Object)this.modeloDatos, (String)"datosInformante.periodicidad");
        bindingContext.bindValue((IObservableValue)periodSelObs, periodicidadObs);
        return bindingContext;
    }

    private String obtenerFormatoDecimal(Double valor) {
        String decimal = null;
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("#########0.00####");
        decimal = df.format(valor).replace(",", ".");
        return decimal;
    }
}

