/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.asistentes.paginas;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteControl;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.aps.modelo.obj.Beneficiario;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.ModeloValoresParticipacionBeneficiarioFinal;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class ParticipacionBeneficiarioFinal
extends PaginaAsistente
implements VistaModelo<Beneficiario>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private Beneficiario modeloDatos;
    private ModeloValoresParticipacionBeneficiarioFinal modeloValores;
    private boolean editando;
    private Label lblTipoIdBeneficiarioFinal;
    private Label lblIdResidenciaFiscalBeneficiarioFinal;
    private Label lblPrimerNombreBeneficiarioFinal;
    private Label lblSegundoNombreBeneficiarioFinal;
    private Label lblPrimerApellidoBeneficiarioFinal;
    private Label lblSegundoApellidoBeneficiarioFinal;
    private Label lblFechaNacimientoBeneficiarioFinal;
    private Label lblBeneficiarioFinalPorPropiedad;
    private Label lblPorcentajeParticipacionEfectivaPropiedad;
    private Label lblSimboloPorcentajeParticipacionEfectivaPropiedad;
    private Label lblBeneficiarioFinalOtrosMotivosControl;
    private Label lblOtrosRelacionadosControlEntidad;
    private Label lblBeneficiarioFinalPorAdministracion;
    private ComboViewer cvTipoIdBeneficiarioFinal;
    private Text txtIdResidenciaFiscalBeneficiarioFinal;
    private Text txtPrimerNombreBeneficiarioFinal;
    private Text txtSegundoNombreBeneficiarioFinal;
    private Text txtPrimerApellidoBeneficiarioFinal;
    private Text txtSegundoApellidoBeneficiarioFinal;
    private Text txtFechaNacimientoBeneficiarioFinal;
    private ComboViewer cvBeneficiarioFinalPorPropiedad;
    private Text txtPorcentajeParticipacionEfectivaPropiedad;
    private ComboViewer cvBeneficiarioFinalOtrosMotivosControl;
    private Text txtOtrosRelacionadosControlEntidad;
    private ComboViewer cvBeneficiarioFinalPorAdministracion;
    private Combo cmbBeneficiarioFinalPorAdministracion;

    public ParticipacionBeneficiarioFinal(boolean editando) {
        super("ParticipacionBeneficiarioFinal", "Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", "Ingreso de informaci\u00f3n de Beneficiarios Finales.");
        this.editando = editando;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void createControl(Composite parent) {
        Composite cBeneficiarioFinal = new Composite(parent, 0);
        this.setControl((Control)cBeneficiarioFinal);
        cBeneficiarioFinal.setLayout((Layout)new GridLayout(3, false));
        Label lblInfo = new Label(cBeneficiarioFinal, 64);
        GridData gd_lblInfo = new GridData(4, 0x1000000, false, false, 3, 1);
        gd_lblInfo.widthHint = 700;
        lblInfo.setLayoutData((Object)gd_lblInfo);
        lblInfo.setText("Ingrese la identificaci\u00f3n del sujeto para determinar si su informaci\u00f3n general ya se encuentra registrada, de tal manera que no sea necesario volver a ingresarla.");
        this.lblTipoIdBeneficiarioFinal = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblTipoIdBeneficiarioFinal = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblTipoIdBeneficiarioFinal.setLayoutData((Object)gd_lblTipoIdBeneficiarioFinal);
        this.lblTipoIdBeneficiarioFinal.setText("Tipo ID Beneficiario Final:");
        this.cvTipoIdBeneficiarioFinal = new ComboViewer(cBeneficiarioFinal, 8);
        this.cvTipoIdBeneficiarioFinal.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoId = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoId != null) {
                    ParticipacionBeneficiarioFinal.this.modeloDatos.setTipoIdentificacion((String)tipoId.getValor());
                    ParticipacionBeneficiarioFinal.this.modeloDatos.setDescripcionTipoIdentificacion(tipoId.getNombre());
                }
            }
        });
        Combo cmbTipoIdBeneficiarioFinal = this.cvTipoIdBeneficiarioFinal.getCombo();
        GridData gd_cmbTipoIdBeneficiarioFinal = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbTipoIdBeneficiarioFinal.widthHint = 260;
        cmbTipoIdBeneficiarioFinal.setLayoutData((Object)gd_cmbTipoIdBeneficiarioFinal);
        new Label(cBeneficiarioFinal, 0);
        this.lblIdResidenciaFiscalBeneficiarioFinal = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblIdResidenciaFiscalBeneficiarioFinal = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblIdResidenciaFiscalBeneficiarioFinal.setLayoutData((Object)gd_lblIdResidenciaFiscalBeneficiarioFinal);
        this.lblIdResidenciaFiscalBeneficiarioFinal.setText("ID de Residencia Fiscal Beneficiario Final:");
        this.txtIdResidenciaFiscalBeneficiarioFinal = new Text(cBeneficiarioFinal, 2048);
        GridData gd_IdResidenciaFiscalBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_IdResidenciaFiscalBeneficiarioFinal.widthHint = 275;
        this.txtIdResidenciaFiscalBeneficiarioFinal.setLayoutData((Object)gd_IdResidenciaFiscalBeneficiarioFinal);
        this.txtIdResidenciaFiscalBeneficiarioFinal.setTextLimit(20);
        this.txtIdResidenciaFiscalBeneficiarioFinal.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String input = e.text;
                char[] cArray = input.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (!Character.isLetterOrDigit(c) && c != ' ') {
                        e.doit = false;
                        return;
                    }
                    ++n2;
                }
                e.text = input.toUpperCase();
            }
        });
        new Label(cBeneficiarioFinal, 0);
        this.lblPrimerNombreBeneficiarioFinal = new Label(cBeneficiarioFinal, 0);
        this.lblPrimerNombreBeneficiarioFinal.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblPrimerNombreBeneficiarioFinal.setText("Primer Nombre Beneficiario Final:");
        this.txtPrimerNombreBeneficiarioFinal = new Text(cBeneficiarioFinal, 2048);
        GridData gd_txtPrimerNombreBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtPrimerNombreBeneficiarioFinal.widthHint = 275;
        this.txtPrimerNombreBeneficiarioFinal.setLayoutData((Object)gd_txtPrimerNombreBeneficiarioFinal);
        this.txtPrimerNombreBeneficiarioFinal.setTextLimit(50);
        this.txtPrimerNombreBeneficiarioFinal.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newText = event.text;
                if (!newText.matches("[a-zA-Z ]*")) {
                    event.doit = false;
                }
            }
        });
        this.txtPrimerNombreBeneficiarioFinal.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text source = (Text)event.widget;
                String upperText = source.getText().toUpperCase();
                if (!source.getText().equals(upperText)) {
                    source.setText(upperText);
                    source.setSelection(upperText.length());
                }
            }
        });
        new Label(cBeneficiarioFinal, 0);
        this.lblSegundoNombreBeneficiarioFinal = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblSegundoNombreBeneficiarioFinal = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblSegundoNombreBeneficiarioFinal.setLayoutData((Object)gd_lblSegundoNombreBeneficiarioFinal);
        this.lblSegundoNombreBeneficiarioFinal.setText("Segundo Nombre Beneficiario Final:");
        this.txtSegundoNombreBeneficiarioFinal = new Text(cBeneficiarioFinal, 2048);
        GridData gd_txtSegundoNombreBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtSegundoNombreBeneficiarioFinal.widthHint = 275;
        this.txtSegundoNombreBeneficiarioFinal.setLayoutData((Object)gd_txtSegundoNombreBeneficiarioFinal);
        this.txtSegundoNombreBeneficiarioFinal.setTextLimit(50);
        this.txtSegundoNombreBeneficiarioFinal.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newText = event.text;
                if (!newText.matches("[a-zA-Z ]*")) {
                    event.doit = false;
                }
            }
        });
        this.txtSegundoNombreBeneficiarioFinal.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text source = (Text)event.widget;
                String upperText = source.getText().toUpperCase();
                if (!source.getText().equals(upperText)) {
                    source.setText(upperText);
                    source.setSelection(upperText.length());
                }
            }
        });
        Label lblSegundoNombreOpcional = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblSegundoNombreOpcional = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblSegundoNombreOpcional.widthHint = 75;
        lblSegundoNombreOpcional.setLayoutData((Object)gd_lblSegundoNombreOpcional);
        lblSegundoNombreOpcional.setText("Opcional");
        this.lblPrimerApellidoBeneficiarioFinal = new Label(cBeneficiarioFinal, 0);
        this.lblPrimerApellidoBeneficiarioFinal.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblPrimerApellidoBeneficiarioFinal.setText("Primer Apellido Beneficiario Final:");
        this.txtPrimerApellidoBeneficiarioFinal = new Text(cBeneficiarioFinal, 2048);
        GridData gd_txtPrimerApellidoBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtPrimerApellidoBeneficiarioFinal.widthHint = 275;
        this.txtPrimerApellidoBeneficiarioFinal.setLayoutData((Object)gd_txtPrimerApellidoBeneficiarioFinal);
        this.txtPrimerApellidoBeneficiarioFinal.setTextLimit(50);
        this.txtPrimerApellidoBeneficiarioFinal.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newText = event.text;
                if (!newText.matches("[a-zA-Z ]*")) {
                    event.doit = false;
                }
            }
        });
        this.txtPrimerApellidoBeneficiarioFinal.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text source = (Text)event.widget;
                String upperText = source.getText().toUpperCase();
                if (!source.getText().equals(upperText)) {
                    source.setText(upperText);
                    source.setSelection(upperText.length());
                }
            }
        });
        new Label(cBeneficiarioFinal, 0);
        this.lblSegundoApellidoBeneficiarioFinal = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblSegundoApellidoBeneficiarioFinal = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblSegundoApellidoBeneficiarioFinal.setLayoutData((Object)gd_lblSegundoApellidoBeneficiarioFinal);
        this.lblSegundoApellidoBeneficiarioFinal.setText("Segundo Apellido Beneficiario Final:");
        this.txtSegundoApellidoBeneficiarioFinal = new Text(cBeneficiarioFinal, 2048);
        GridData gd_txtSegundoApellidoBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtSegundoApellidoBeneficiarioFinal.widthHint = 275;
        this.txtSegundoApellidoBeneficiarioFinal.setLayoutData((Object)gd_txtSegundoApellidoBeneficiarioFinal);
        this.txtSegundoApellidoBeneficiarioFinal.setTextLimit(50);
        this.txtSegundoApellidoBeneficiarioFinal.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newText = event.text;
                if (!newText.matches("[a-zA-Z ]*")) {
                    event.doit = false;
                }
            }
        });
        this.txtSegundoApellidoBeneficiarioFinal.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text source = (Text)event.widget;
                String upperText = source.getText().toUpperCase();
                if (!source.getText().equals(upperText)) {
                    source.setText(upperText);
                    source.setSelection(upperText.length());
                }
            }
        });
        Label lblSegundoApellidoOpcional = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblSegundoApellidoOpcional = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblSegundoApellidoOpcional.widthHint = 75;
        lblSegundoApellidoOpcional.setLayoutData((Object)gd_lblSegundoApellidoOpcional);
        lblSegundoApellidoOpcional.setText("Opcional");
        this.lblFechaNacimientoBeneficiarioFinal = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblFechaNacimientoBeneficiarioFinal = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblFechaNacimientoBeneficiarioFinal.setLayoutData((Object)gd_lblFechaNacimientoBeneficiarioFinal);
        this.lblFechaNacimientoBeneficiarioFinal.setText("Fecha de Nacimiento:");
        this.txtFechaNacimientoBeneficiarioFinal = new Text(cBeneficiarioFinal, 2048);
        GridData gd_txtFechaNacimientoBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtFechaNacimientoBeneficiarioFinal.widthHint = 100;
        this.txtFechaNacimientoBeneficiarioFinal.setLayoutData((Object)gd_txtFechaNacimientoBeneficiarioFinal);
        this.txtFechaNacimientoBeneficiarioFinal.setTextLimit(10);
        this.txtFechaNacimientoBeneficiarioFinal.setMessage("dd/mm/yyyy");
        new Label(cBeneficiarioFinal, 0);
        this.txtFechaNacimientoBeneficiarioFinal.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int mes;
                int dia;
                String currentText = ((Text)e.getSource()).getText();
                String newText = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end);
                if (!newText.matches("[0-9/]*")) {
                    e.doit = false;
                    return;
                }
                if (e.text.matches("[0-9]") && (newText.length() == 2 || newText.length() == 5) && !newText.endsWith("/")) {
                    e.text = String.valueOf(e.text) + "/";
                }
                if (newText.length() >= 2 && ((dia = Integer.parseInt(newText.substring(0, 2))) < 1 || dia > 31)) {
                    e.doit = false;
                    return;
                }
                if (newText.length() >= 5 && ((mes = Integer.parseInt(newText.substring(3, 5))) < 1 || mes > 12)) {
                    e.doit = false;
                    return;
                }
            }
        });
        this.txtFechaNacimientoBeneficiarioFinal.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String fechaStr = ParticipacionBeneficiarioFinal.this.txtFechaNacimientoBeneficiarioFinal.getText();
                if (!fechaStr.matches("\\d{2}/\\d{2}/\\d{4}")) {
                    this.mostrarError("Formato inv\u00e1lido. Use el formato dd/mm/yyyy");
                    return;
                }
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                    sdf.setLenient(false);
                    Date fecha = sdf.parse(fechaStr);
                    Calendar hoy = Calendar.getInstance();
                    Calendar min = Calendar.getInstance();
                    min.set(1900, 0, 1);
                    if (fecha.before(min.getTime()) || fecha.after(hoy.getTime())) {
                        this.mostrarError("La fecha debe estar entre 01/01/1900 y la fecha actual.");
                    }
                }
                catch (ParseException parseException) {
                    this.mostrarError("Fecha inv\u00e1lida. Use el formato dd/mm/yyyy");
                }
            }

            private void mostrarError(String mensaje) {
                MessageBox messageBox = new MessageBox(ParticipacionBeneficiarioFinal.this.txtFechaNacimientoBeneficiarioFinal.getShell(), 33);
                messageBox.setMessage(mensaje);
                messageBox.open();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ParticipacionBeneficiarioFinal.this.txtFechaNacimientoBeneficiarioFinal.isDisposed()) {
                            ParticipacionBeneficiarioFinal.this.txtFechaNacimientoBeneficiarioFinal.setFocus();
                        }
                    }
                });
            }
        });
        this.lblBeneficiarioFinalPorPropiedad = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblBeneficiarioFinalPorPropiedad = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblBeneficiarioFinalPorPropiedad.setLayoutData((Object)gd_lblBeneficiarioFinalPorPropiedad);
        this.lblBeneficiarioFinalPorPropiedad.setText("Beneficiario Final por propiedad:");
        this.cvBeneficiarioFinalPorPropiedad = new ComboViewer(cBeneficiarioFinal, 8);
        this.cvBeneficiarioFinalPorPropiedad.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor porPropiedad = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (porPropiedad != null) {
                    ParticipacionBeneficiarioFinal.this.modeloDatos.setPorPropiedad((String)porPropiedad.getValor());
                    if ("NO".equals(porPropiedad.getValor())) {
                        AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{ParticipacionBeneficiarioFinal.this.txtPorcentajeParticipacionEfectivaPropiedad, ParticipacionBeneficiarioFinal.this.lblPorcentajeParticipacionEfectivaPropiedad});
                        ParticipacionBeneficiarioFinal.this.modeloDatos.setPorcentajePropiedad("0.00");
                    } else {
                        AyudanteControl.habilitar((boolean)true, (Control[])new Control[]{ParticipacionBeneficiarioFinal.this.txtPorcentajeParticipacionEfectivaPropiedad, ParticipacionBeneficiarioFinal.this.lblPorcentajeParticipacionEfectivaPropiedad});
                    }
                }
            }
        });
        Combo cmbBeneficiarioFinalPorPropiedad = this.cvBeneficiarioFinalPorPropiedad.getCombo();
        GridData gd_cmbBeneficiarioFinalPorPropiedad = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbBeneficiarioFinalPorPropiedad.widthHint = 260;
        cmbBeneficiarioFinalPorPropiedad.setLayoutData((Object)gd_cmbBeneficiarioFinalPorPropiedad);
        new Label(cBeneficiarioFinal, 0);
        this.lblPorcentajeParticipacionEfectivaPropiedad = new Label(cBeneficiarioFinal, 0);
        GridData gd_PorcentajeParticipacionEfectivaPropiedad = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblPorcentajeParticipacionEfectivaPropiedad.setLayoutData((Object)gd_PorcentajeParticipacionEfectivaPropiedad);
        this.lblPorcentajeParticipacionEfectivaPropiedad.setText("Porcentaje de participacion efectiva de propiedad:");
        this.txtPorcentajeParticipacionEfectivaPropiedad = new Text(cBeneficiarioFinal, 133124);
        GridData gd_txtPorcentajeParticipacionEfectivaPropiedad = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtPorcentajeParticipacionEfectivaPropiedad.widthHint = 275;
        this.txtPorcentajeParticipacionEfectivaPropiedad.setLayoutData((Object)gd_txtPorcentajeParticipacionEfectivaPropiedad);
        this.txtPorcentajeParticipacionEfectivaPropiedad.setTextLimit(6);
        this.lblSimboloPorcentajeParticipacionEfectivaPropiedad = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblSimboloPorcentajeParticipacionEfectivaPropiedad = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblSimboloPorcentajeParticipacionEfectivaPropiedad.widthHint = 75;
        this.lblSimboloPorcentajeParticipacionEfectivaPropiedad.setLayoutData((Object)gd_lblSimboloPorcentajeParticipacionEfectivaPropiedad);
        this.lblSimboloPorcentajeParticipacionEfectivaPropiedad.setText("%");
        this.lblBeneficiarioFinalOtrosMotivosControl = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblBeneficiarioFinalOtrosMotivosControl = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblBeneficiarioFinalOtrosMotivosControl.setLayoutData((Object)gd_lblBeneficiarioFinalOtrosMotivosControl);
        this.lblBeneficiarioFinalOtrosMotivosControl.setText("Beneficiario Final por otros motivos de control:");
        this.cvBeneficiarioFinalOtrosMotivosControl = new ComboViewer(cBeneficiarioFinal, 8);
        this.cvBeneficiarioFinalOtrosMotivosControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComboViewer[] cws = new ComboViewer[]{ParticipacionBeneficiarioFinal.this.cvBeneficiarioFinalPorAdministracion};
                Combo[] cbs = new Combo[]{ParticipacionBeneficiarioFinal.this.cmbBeneficiarioFinalPorAdministracion};
                ElementoNombreValor porOtrosMotivos = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (porOtrosMotivos != null) {
                    ParticipacionBeneficiarioFinal.this.modeloDatos.setPorOtrosMotivos((String)porOtrosMotivos.getValor());
                    if ("08".equals(porOtrosMotivos.getValor())) {
                        AyudanteControl.habilitar((boolean)true, (Control[])new Control[]{ParticipacionBeneficiarioFinal.this.txtOtrosRelacionadosControlEntidad, ParticipacionBeneficiarioFinal.this.lblOtrosRelacionadosControlEntidad});
                    } else {
                        AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{ParticipacionBeneficiarioFinal.this.txtOtrosRelacionadosControlEntidad, ParticipacionBeneficiarioFinal.this.lblOtrosRelacionadosControlEntidad});
                        ParticipacionBeneficiarioFinal.this.modeloDatos.setPorOtrosRelacionados("");
                    }
                    if ("NO".equals(ParticipacionBeneficiarioFinal.this.modeloDatos.getPorPropiedad()) && "09".equals(porOtrosMotivos.getValor())) {
                        ElementoNombreValor porAdministracion = ParticipacionBeneficiarioFinal.this.modeloValores.obtenerTipoBeneficiarioFinalPorAdministracion("SI");
                        AyudanteViewer.seleccionarElemento((Viewer)ParticipacionBeneficiarioFinal.this.cvBeneficiarioFinalPorAdministracion, (Object)porAdministracion);
                        ParticipacionBeneficiarioFinal.this.cvBeneficiarioFinalPorAdministracion.refresh();
                        ParticipacionBeneficiarioFinal.this.modeloDatos.setPorAdministracion((String)porAdministracion.getValor());
                        AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{ParticipacionBeneficiarioFinal.this.lblBeneficiarioFinalPorAdministracion});
                        ParticipacionBeneficiarioFinal.this.cvBeneficiarioFinalPorAdministracion.getCombo().setEnabled(false);
                    } else {
                        AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{ParticipacionBeneficiarioFinal.this.lblBeneficiarioFinalPorAdministracion});
                        ParticipacionBeneficiarioFinal.this.habilitarComponentes(cws, cbs, false);
                        ParticipacionBeneficiarioFinal.this.modeloDatos.setPorAdministracion("");
                    }
                }
            }
        });
        Combo cmbBeneficiarioFinalOtrosMotivosControl = this.cvBeneficiarioFinalOtrosMotivosControl.getCombo();
        GridData gd_cmbBeneficiarioFinalOtrosMotivosControl = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbBeneficiarioFinalOtrosMotivosControl.widthHint = 260;
        cmbBeneficiarioFinalOtrosMotivosControl.setLayoutData((Object)gd_cmbBeneficiarioFinalOtrosMotivosControl);
        new Label(cBeneficiarioFinal, 0);
        this.lblOtrosRelacionadosControlEntidad = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblOtrosRelacionadosControlEntidad = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblOtrosRelacionadosControlEntidad.setLayoutData((Object)gd_lblOtrosRelacionadosControlEntidad);
        this.lblOtrosRelacionadosControlEntidad.setText("Otros relacionados al control de la entidad:");
        this.txtOtrosRelacionadosControlEntidad = new Text(cBeneficiarioFinal, 2048);
        GridData gd_txtOtrosRelacionadosControlEntidad = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtOtrosRelacionadosControlEntidad.widthHint = 275;
        this.txtOtrosRelacionadosControlEntidad.setLayoutData((Object)gd_txtOtrosRelacionadosControlEntidad);
        this.txtOtrosRelacionadosControlEntidad.setTextLimit(50);
        this.txtOtrosRelacionadosControlEntidad.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String upperCaseInput;
                String input = ParticipacionBeneficiarioFinal.this.txtOtrosRelacionadosControlEntidad.getText();
                if (!input.equals(upperCaseInput = input.toUpperCase())) {
                    ParticipacionBeneficiarioFinal.this.txtOtrosRelacionadosControlEntidad.setText(upperCaseInput);
                    ParticipacionBeneficiarioFinal.this.txtOtrosRelacionadosControlEntidad.setSelection(upperCaseInput.length());
                }
            }
        });
        new Label(cBeneficiarioFinal, 0);
        this.lblBeneficiarioFinalPorAdministracion = new Label(cBeneficiarioFinal, 0);
        GridData gd_lblBeneficiarioFinalPorAdministracion = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblBeneficiarioFinalPorAdministracion.setLayoutData((Object)gd_lblBeneficiarioFinalPorAdministracion);
        this.lblBeneficiarioFinalPorAdministracion.setText("Beneficiario Final por administracion:");
        this.cvBeneficiarioFinalPorAdministracion = new ComboViewer(cBeneficiarioFinal, 8);
        this.cvBeneficiarioFinalPorAdministracion.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor porAdministracion = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (porAdministracion != null) {
                    ParticipacionBeneficiarioFinal.this.modeloDatos.setPorAdministracion((String)porAdministracion.getValor());
                }
            }
        });
        this.cmbBeneficiarioFinalPorAdministracion = this.cvBeneficiarioFinalPorAdministracion.getCombo();
        GridData gd_cmbBeneficiarioFinalPorAdministracion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbBeneficiarioFinalPorAdministracion.widthHint = 260;
        this.cmbBeneficiarioFinalPorAdministracion.setLayoutData((Object)gd_cmbBeneficiarioFinalPorAdministracion);
        new Label(cBeneficiarioFinal, 0);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
    }

    private void habilitarComponentes(ComboViewer[] cws, Combo[] cbs, boolean habilita) {
        ComboViewer[] comboViewerArray = cws;
        int n = cws.length;
        int n2 = 0;
        while (n2 < n) {
            ComboViewer cw = comboViewerArray[n2];
            cw.setSelection(null, !habilita);
            ++n2;
        }
        comboViewerArray = cbs;
        n = cbs.length;
        n2 = 0;
        while (n2 < n) {
            ComboViewer cb = comboViewerArray[n2];
            cb.setEnabled(habilita);
            ++n2;
        }
    }

    public void setModeloDatos(Beneficiario modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)new ListenerValidacionModeloPaginaAsistente((InformacionValidable)this.modeloDatos, (PaginaAsistente)this));
        if (this.editando) {
            ElementoNombreValor tipoIdentificacion = this.modeloValores.obtenerTipoIdentificacionPorTipo(this.modeloDatos.getTipoIdentificacion());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoIdBeneficiarioFinal, (Object)tipoIdentificacion);
            ElementoNombreValor porPropiedad = this.modeloValores.obtenerTipoBeneficiarioFinalPorPropiedad(this.modeloDatos.getPorPropiedad());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvBeneficiarioFinalPorPropiedad, (Object)porPropiedad);
            ElementoNombreValor otrosMotivos = this.modeloValores.obtenerTipoBeneficiarioFinalPorControl(this.modeloDatos.getPorOtrosMotivos());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvBeneficiarioFinalOtrosMotivosControl, (Object)otrosMotivos);
            ElementoNombreValor porAdministracion = this.modeloValores.obtenerTipoBeneficiarioFinalPorAdministracion(this.modeloDatos.getPorAdministracion());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvBeneficiarioFinalPorAdministracion, (Object)porAdministracion);
        }
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresParticipacionBeneficiarioFinal();
        this.modeloValores.inicializar();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProviderTipoIdBeneficiario = new ObservableListContentProvider();
        IObservableMap observeMapTipoIdBeneficiario = PojoObservables.observeMap((IObservableSet)listContentProviderTipoIdBeneficiario.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoIdBeneficiarioFinal.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapTipoIdBeneficiario));
        this.cvTipoIdBeneficiarioFinal.setContentProvider((IContentProvider)listContentProviderTipoIdBeneficiario);
        IObservableList modeloValoresTipoIdBeneficiarioObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposIdentificacion");
        this.cvTipoIdBeneficiarioFinal.setInput((Object)modeloValoresTipoIdBeneficiarioObserveList);
        ISWTObservableValue txtIdResidenciaBeneficiarioObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtIdResidenciaFiscalBeneficiarioFinal, (int[])new int[]{24, 16});
        IObservableValue modeloDatosIdResidenciaBeneficiarioObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"numeroIdentificacion");
        bindingContext.bindValue((IObservableValue)txtIdResidenciaBeneficiarioObserveTextObserveWidget, modeloDatosIdResidenciaBeneficiarioObserveValue, null, null);
        ISWTObservableValue txtPrimerNombreObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtPrimerNombreBeneficiarioFinal, (int[])new int[]{24, 16});
        IObservableValue modeloDatosPrimerNombreObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"primerNombre");
        bindingContext.bindValue((IObservableValue)txtPrimerNombreObserveTextObserveWidget, modeloDatosPrimerNombreObserveValue, null, null);
        ISWTObservableValue txtSegundoNombreObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtSegundoNombreBeneficiarioFinal, (int[])new int[]{24, 16});
        IObservableValue modeloDatosSegundoNombreObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"segundoNombre");
        bindingContext.bindValue((IObservableValue)txtSegundoNombreObserveTextObserveWidget, modeloDatosSegundoNombreObserveValue, null, null);
        ISWTObservableValue txtPrimerApellidoObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtPrimerApellidoBeneficiarioFinal, (int[])new int[]{24, 16});
        IObservableValue modeloDatosPrimerApellidoObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"primerApellido");
        bindingContext.bindValue((IObservableValue)txtPrimerApellidoObserveTextObserveWidget, modeloDatosPrimerApellidoObserveValue, null, null);
        ISWTObservableValue txtSegundoApellidoObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtSegundoApellidoBeneficiarioFinal, (int[])new int[]{24, 16});
        IObservableValue modeloDatosSegundoApellidoObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"segundoApellido");
        bindingContext.bindValue((IObservableValue)txtSegundoApellidoObserveTextObserveWidget, modeloDatosSegundoApellidoObserveValue, null, null);
        ISWTObservableValue txtFechaNacimientoBeneficiarioFinalObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtFechaNacimientoBeneficiarioFinal, (int[])new int[]{24, 16});
        IObservableValue modeloDatosFechaNacimientoBeneficiarioObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"fechaNacimiento");
        bindingContext.bindValue((IObservableValue)txtFechaNacimientoBeneficiarioFinalObserveTextObserveWidget, modeloDatosFechaNacimientoBeneficiarioObserveValue, null, null);
        ObservableListContentProvider listContentProviderBeneficiarioFinalPorPropiedad = new ObservableListContentProvider();
        IObservableMap observeMapBeneficiarioFinalPorPropiedad = PojoObservables.observeMap((IObservableSet)listContentProviderBeneficiarioFinalPorPropiedad.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvBeneficiarioFinalPorPropiedad.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapBeneficiarioFinalPorPropiedad));
        this.cvBeneficiarioFinalPorPropiedad.setContentProvider((IContentProvider)listContentProviderBeneficiarioFinalPorPropiedad);
        IObservableList modeloValoresBeneficiarioFinalPorPropiedadObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposBeneficiarioFinalPorPropiedad");
        this.cvBeneficiarioFinalPorPropiedad.setInput((Object)modeloValoresBeneficiarioFinalPorPropiedadObserveList);
        ISWTObservableValue txtPorcentajeParticipacionPropiedadObserveWidget = SWTObservables.observeText((Control)this.txtPorcentajeParticipacionEfectivaPropiedad, (int[])new int[]{24, 16});
        IObservableValue modelPorcentajeParticipacionPropiedadObservable = BeansObservables.observeValue((Object)this.modeloDatos, (String)"porcentajePropiedad");
        bindingContext.bindValue((IObservableValue)txtPorcentajeParticipacionPropiedadObserveWidget, modelPorcentajeParticipacionPropiedadObservable, null, null);
        ObservableListContentProvider listContentProviderBeneficiarioFinalPorControl = new ObservableListContentProvider();
        IObservableMap observeMapBeneficiarioFinalPorControl = PojoObservables.observeMap((IObservableSet)listContentProviderBeneficiarioFinalPorControl.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvBeneficiarioFinalOtrosMotivosControl.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapBeneficiarioFinalPorControl));
        this.cvBeneficiarioFinalOtrosMotivosControl.setContentProvider((IContentProvider)listContentProviderBeneficiarioFinalPorControl);
        IObservableList modeloValoresBeneficiarioFinalPorControlObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposBeneficiarioFinalPorControl");
        this.cvBeneficiarioFinalOtrosMotivosControl.setInput((Object)modeloValoresBeneficiarioFinalPorControlObserveList);
        ISWTObservableValue txtOtrosRelacionadosControlEntidadObserveWidget = SWTObservables.observeText((Control)this.txtOtrosRelacionadosControlEntidad, (int[])new int[]{24, 16});
        IObservableValue modelOtrosRelacionadosControlEntidadObservable = BeansObservables.observeValue((Object)this.modeloDatos, (String)"porOtrosRelacionados");
        bindingContext.bindValue((IObservableValue)txtOtrosRelacionadosControlEntidadObserveWidget, modelOtrosRelacionadosControlEntidadObservable, null, null);
        ObservableListContentProvider listContentProviderBeneficiarioFinalPorAdministracion = new ObservableListContentProvider();
        IObservableMap observeMapBeneficiarioFinalPorAdministracion = PojoObservables.observeMap((IObservableSet)listContentProviderBeneficiarioFinalPorAdministracion.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvBeneficiarioFinalPorAdministracion.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapBeneficiarioFinalPorAdministracion));
        this.cvBeneficiarioFinalPorAdministracion.setContentProvider((IContentProvider)listContentProviderBeneficiarioFinalPorAdministracion);
        IObservableList modeloValoresBeneficiarioFinalPorAdministracionObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposBeneficiarioFinalPorAdministracion");
        this.cvBeneficiarioFinalPorAdministracion.setInput((Object)modeloValoresBeneficiarioFinalPorAdministracionObserveList);
        return bindingContext;
    }
}

