/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.asistentes.paginas;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteControl;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.aps.modelo.obj.DatosIdentificacion;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.ModeloValoresParticipacionIdentificacion;
import ec.gob.sri.dimm.aps.ui.paginas.util.UtilValidacion;
import ec.gob.sri.dimm.aps.ui.recursos.Mensajes;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class ParticipacionIdentificacion
extends PaginaAsistente
implements VistaModelo<DatosIdentificacion>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private DatosIdentificacion modeloDatos;
    private ModeloValoresParticipacionIdentificacion modeloValores;
    private String tipoDeclaracion;
    private String tipoSociedad;
    private String anio;
    private String mes;
    private ComboViewer cvTipoIdentificacion;
    private ComboViewer cvTipoSujeto;
    private Combo cboTipoSujeto;
    private Label lblTipoSujeto;
    private Label lblPrimerNombre;
    private Label lblSegundoNombre;
    private Label lblSegundoNombreOpcional;
    private Label lblPrimerApellido;
    private Label lblSegundoApellido;
    private Label lblSegundoApellidoOpcional;
    private Label lblRazonSocial;
    private Text txtIdentificacion;
    private Text txtPrimerNombre;
    private Text txtSegundoNombre;
    private Text txtPrimerApellido;
    private Text txtSegundoApellido;
    private Text txtRazonSocial;
    private boolean editando;

    public ParticipacionIdentificacion(String tipoDeclaracion, String tipoSociedad, String anio, String mes, boolean editando) {
        super("ParticipacionIdentificacion", "Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", "Ingrese la identificaci\u00f3n del sujeto relacionado.");
        this.tipoDeclaracion = tipoDeclaracion;
        this.tipoSociedad = tipoSociedad;
        this.anio = anio;
        this.mes = mes;
        this.editando = editando;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void createControl(Composite parent) {
        this.modeloDatos.setAnio(this.anio);
        this.modeloDatos.setMes(this.mes);
        Composite cIdentificacion = new Composite(parent, 0);
        this.setControl((Control)cIdentificacion);
        cIdentificacion.setLayout((Layout)new GridLayout(3, false));
        Label lblInfo = new Label(cIdentificacion, 64);
        GridData gd_lblInfo = new GridData(4, 0x1000000, false, false, 3, 1);
        gd_lblInfo.widthHint = 700;
        lblInfo.setLayoutData((Object)gd_lblInfo);
        lblInfo.setText("Ingrese la identificaci\u00f3n del sujeto para determinar si su informaci\u00f3n general ya se encuentra registrada, de tal manera que no sea necesario volver a ingresarla.");
        this.lblTipoSujeto = new Label(cIdentificacion, 0);
        GridData gd_lblTipoSujeto = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblTipoSujeto.setLayoutData((Object)gd_lblTipoSujeto);
        this.lblTipoSujeto.setText("Tipo de Sujeto:");
        this.cvTipoSujeto = new ComboViewer(cIdentificacion, 8);
        this.cvTipoSujeto.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoSujeto = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoSujeto != null) {
                    ParticipacionIdentificacion.this.modeloDatos.setTipoSujeto((String)tipoSujeto.getValor());
                    ParticipacionIdentificacion.this.modeloDatos.setDescripcionTipoSujeto(tipoSujeto.getNombre());
                    ParticipacionIdentificacion.this.modeloValores.cargarTipoIdentificacionPorTipoSujeto((String)tipoSujeto.getValor());
                    ParticipacionIdentificacion.this.cvTipoIdentificacion.refresh();
                    if (((String)tipoSujeto.getValor()).equals("01")) {
                        AyudanteControl.habilitar((boolean)true, (Control[])new Control[]{ParticipacionIdentificacion.this.txtPrimerNombre, ParticipacionIdentificacion.this.txtSegundoNombre, ParticipacionIdentificacion.this.txtPrimerApellido, ParticipacionIdentificacion.this.txtSegundoApellido, ParticipacionIdentificacion.this.lblPrimerNombre, ParticipacionIdentificacion.this.lblSegundoNombre, ParticipacionIdentificacion.this.lblPrimerApellido, ParticipacionIdentificacion.this.lblSegundoApellido, ParticipacionIdentificacion.this.lblSegundoNombreOpcional, ParticipacionIdentificacion.this.lblSegundoApellidoOpcional});
                        AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{ParticipacionIdentificacion.this.txtRazonSocial, ParticipacionIdentificacion.this.lblRazonSocial});
                        ParticipacionIdentificacion.this.modeloDatos.setRazonSocial("");
                    }
                    if (((String)tipoSujeto.getValor()).equals("02")) {
                        AyudanteControl.habilitar((boolean)true, (Control[])new Control[]{ParticipacionIdentificacion.this.txtRazonSocial, ParticipacionIdentificacion.this.lblRazonSocial});
                        AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{ParticipacionIdentificacion.this.txtPrimerNombre, ParticipacionIdentificacion.this.txtSegundoNombre, ParticipacionIdentificacion.this.txtPrimerApellido, ParticipacionIdentificacion.this.txtSegundoApellido, ParticipacionIdentificacion.this.lblPrimerNombre, ParticipacionIdentificacion.this.lblSegundoNombre, ParticipacionIdentificacion.this.lblPrimerApellido, ParticipacionIdentificacion.this.lblSegundoApellido, ParticipacionIdentificacion.this.lblSegundoNombreOpcional, ParticipacionIdentificacion.this.lblSegundoApellidoOpcional});
                        ParticipacionIdentificacion.this.modeloDatos.setPrimerNombre("");
                        ParticipacionIdentificacion.this.modeloDatos.setSegundoNombre("");
                        ParticipacionIdentificacion.this.modeloDatos.setPrimerApellido("");
                        ParticipacionIdentificacion.this.modeloDatos.setSegundoApellido("");
                    }
                }
            }
        });
        this.cboTipoSujeto = this.cvTipoSujeto.getCombo();
        GridData gd_cboTipoSujeto = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cboTipoSujeto.widthHint = 250;
        this.cboTipoSujeto.setLayoutData((Object)gd_cboTipoSujeto);
        new Label(cIdentificacion, 0);
        Label lblTipoIdentificacin = new Label(cIdentificacion, 0);
        GridData gd_lblTipoIdentificacin = new GridData(4, 0x1000000, false, false, 1, 1);
        lblTipoIdentificacin.setLayoutData((Object)gd_lblTipoIdentificacin);
        lblTipoIdentificacin.setText("Tipo de Identificaci\u00f3n:");
        this.cvTipoIdentificacion = new ComboViewer(cIdentificacion, 8);
        this.cvTipoIdentificacion.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoIdentificacion = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoIdentificacion != null) {
                    String valorTipoIdentificacion = (String)tipoIdentificacion.getValor();
                    ParticipacionIdentificacion.this.modeloDatos.setTipoIdentificacion(valorTipoIdentificacion);
                    ParticipacionIdentificacion.this.modeloDatos.setDescripcionTipoIdentificacion(tipoIdentificacion.getNombre());
                }
            }
        });
        Combo cboTipoIdentificacion = this.cvTipoIdentificacion.getCombo();
        GridData gd_cboTipoIdentificacion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cboTipoIdentificacion.widthHint = 250;
        cboTipoIdentificacion.setLayoutData((Object)gd_cboTipoIdentificacion);
        Link link = new Link(cIdentificacion, 0);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParticipacionIdentificacion.this.mostrarInformacion(String.format(Mensajes.ParticipacionIdentificacion_AyudaIdentificacion, new Object[0]));
            }
        });
        GridData gd_link = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_link.widthHint = 200;
        link.setLayoutData((Object)gd_link);
        link.setText("<a>M\u00e1s informaci\u00f3n...</a>");
        Label lblIdentificacin = new Label(cIdentificacion, 0);
        lblIdentificacin.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblIdentificacin.setText("Identificaci\u00f3n:");
        this.txtIdentificacion = new Text(cIdentificacion, 2048);
        GridData gd_txtIdentificacion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtIdentificacion.widthHint = 125;
        this.txtIdentificacion.setLayoutData((Object)gd_txtIdentificacion);
        this.txtIdentificacion.setTextLimit(20);
        this.txtIdentificacion.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                char[] cArray = e.text.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char character = cArray[n2];
                    if (!Character.isLetterOrDigit(character)) {
                        e.doit = false;
                        return;
                    }
                    if (Character.isLetter(character)) {
                        e.text = e.text.toUpperCase();
                    }
                    ++n2;
                }
            }
        });
        new Label(cIdentificacion, 0);
        this.lblPrimerNombre = new Label(cIdentificacion, 0);
        this.lblPrimerNombre.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblPrimerNombre.setText("Primer Nombre:");
        this.txtPrimerNombre = new Text(cIdentificacion, 2048);
        GridData gd_txtPrimerNombre = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtPrimerNombre.widthHint = 125;
        this.txtPrimerNombre.setLayoutData((Object)gd_txtPrimerNombre);
        this.txtPrimerNombre.setTextLimit(50);
        this.txtPrimerNombre.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[a-zA-Z ]*")) {
                    e.doit = false;
                    return;
                }
                e.text = e.text.toUpperCase();
            }
        });
        new Label(cIdentificacion, 0);
        this.lblSegundoNombre = new Label(cIdentificacion, 0);
        GridData gd_lblSegundoNombre = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblSegundoNombre.setLayoutData((Object)gd_lblSegundoNombre);
        this.lblSegundoNombre.setText("Segundo Nombre:");
        this.txtSegundoNombre = new Text(cIdentificacion, 2048);
        GridData gd_txtSegundoNombre = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtSegundoNombre.widthHint = 125;
        this.txtSegundoNombre.setLayoutData((Object)gd_txtSegundoNombre);
        this.txtSegundoNombre.setTextLimit(50);
        this.txtSegundoNombre.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[a-zA-Z ]*")) {
                    e.doit = false;
                    return;
                }
                e.text = e.text.toUpperCase();
            }
        });
        this.lblSegundoNombreOpcional = new Label(cIdentificacion, 0);
        GridData gd_lblSegundoNombreOpcional = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.lblSegundoNombreOpcional.setLayoutData((Object)gd_lblSegundoNombreOpcional);
        this.lblSegundoNombreOpcional.setText("Opcional");
        this.lblPrimerApellido = new Label(cIdentificacion, 0);
        this.lblPrimerApellido.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblPrimerApellido.setText("Primer Apellido:");
        this.txtPrimerApellido = new Text(cIdentificacion, 2048);
        GridData gd_txtPrimerApellido = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtPrimerApellido.widthHint = 125;
        this.txtPrimerApellido.setLayoutData((Object)gd_txtPrimerApellido);
        this.txtPrimerApellido.setTextLimit(50);
        this.txtPrimerApellido.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[a-zA-Z ]*")) {
                    e.doit = false;
                    return;
                }
                e.text = e.text.toUpperCase();
            }
        });
        new Label(cIdentificacion, 0);
        this.lblSegundoApellido = new Label(cIdentificacion, 0);
        GridData gd_lblSegundoApellido = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblSegundoApellido.setLayoutData((Object)gd_lblSegundoApellido);
        this.lblSegundoApellido.setText("Segundo Apellido:");
        this.txtSegundoApellido = new Text(cIdentificacion, 2048);
        GridData gd_txtSegundoApellido = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtSegundoApellido.widthHint = 125;
        this.txtSegundoApellido.setLayoutData((Object)gd_txtSegundoApellido);
        this.txtSegundoApellido.setTextLimit(50);
        this.txtSegundoApellido.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[a-zA-Z ]*")) {
                    e.doit = false;
                    return;
                }
                e.text = e.text.toUpperCase();
            }
        });
        this.lblSegundoApellidoOpcional = new Label(cIdentificacion, 0);
        GridData gd_lblSegundoApellidoOpcional = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.lblSegundoApellidoOpcional.setLayoutData((Object)gd_lblSegundoApellidoOpcional);
        this.lblSegundoApellidoOpcional.setText("Opcional");
        this.lblRazonSocial = new Label(cIdentificacion, 0);
        GridData gd_lblRazonSocial = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblRazonSocial.setLayoutData((Object)gd_lblRazonSocial);
        this.lblRazonSocial.setText("Raz\u00f3n Social:");
        this.txtRazonSocial = new Text(cIdentificacion, 2048);
        GridData gd_txtRazonSocial = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtRazonSocial.widthHint = 300;
        this.txtRazonSocial.setLayoutData((Object)gd_txtRazonSocial);
        this.txtRazonSocial.setTextLimit(200);
        this.txtRazonSocial.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[a-zA-Z0-9 ]*")) {
                    e.doit = false;
                    return;
                }
                e.text = e.text.toUpperCase();
            }
        });
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
    }

    public void setModeloDatos(DatosIdentificacion modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)new ListenerValidacionModeloPaginaAsistente((InformacionValidable)this.modeloDatos, (PaginaAsistente)this));
        boolean esPeriodoDesde2024 = UtilValidacion.esAnexoDesdePeriodo2024(this.anio, this.mes);
        if (!esPeriodoDesde2024) {
            AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{this.lblTipoSujeto, this.lblPrimerNombre, this.lblSegundoNombre, this.lblSegundoNombreOpcional, this.lblPrimerApellido, this.lblSegundoApellido, this.lblSegundoApellidoOpcional});
            AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{this.txtPrimerNombre, this.txtSegundoNombre, this.txtPrimerApellido, this.txtSegundoApellido});
            this.cboTipoSujeto.setEnabled(false);
        }
        if (this.editando) {
            ElementoNombreValor tipoIdentificacion = this.modeloValores.obtenerTipoIdentificacion(this.modeloDatos.getTipoIdentificacion());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoIdentificacion, (Object)tipoIdentificacion);
            ElementoNombreValor tipoSujeto = this.modeloValores.obtenerTipoSujeto(this.modeloDatos.getTipoSujeto());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoSujeto, (Object)tipoSujeto);
        }
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresParticipacionIdentificacion(this.tipoDeclaracion, this.tipoSociedad, this.anio, this.mes);
        this.modeloValores.inicializar();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProviderTipoSujeto = new ObservableListContentProvider();
        IObservableMap observeMapTipoSujeto = PojoObservables.observeMap((IObservableSet)listContentProviderTipoSujeto.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoSujeto.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapTipoSujeto));
        this.cvTipoSujeto.setContentProvider((IContentProvider)listContentProviderTipoSujeto);
        IObservableList modeloValoresTipoSujetoObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposSujeto");
        this.cvTipoSujeto.setInput((Object)modeloValoresTipoSujetoObserveList);
        ISWTObservableValue txtIdentificacionObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtIdentificacion, (int[])new int[]{24, 16});
        IObservableValue modeloDatosIdentificacionObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"identificacion");
        bindingContext.bindValue((IObservableValue)txtIdentificacionObserveTextObserveWidget, modeloDatosIdentificacionObserveValue, null, null);
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoIdentificacion.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoIdentificacion.setContentProvider((IContentProvider)listContentProvider);
        IObservableList modeloValoresTiposIdentificacionObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposIdentificacion");
        this.cvTipoIdentificacion.setInput((Object)modeloValoresTiposIdentificacionObserveList);
        ISWTObservableValue txtPrimerNombreObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtPrimerNombre, (int[])new int[]{24, 16});
        IObservableValue modeloDatosPrimerNombreObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"primerNombre");
        bindingContext.bindValue((IObservableValue)txtPrimerNombreObserveTextObserveWidget, modeloDatosPrimerNombreObserveValue, null, null);
        ISWTObservableValue txtSegundoNombreObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtSegundoNombre, (int[])new int[]{24, 16});
        IObservableValue modeloDatosSegundoNombreObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"segundoNombre");
        bindingContext.bindValue((IObservableValue)txtSegundoNombreObserveTextObserveWidget, modeloDatosSegundoNombreObserveValue, null, null);
        ISWTObservableValue txtPrimerApellidoObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtPrimerApellido, (int[])new int[]{24, 16});
        IObservableValue modeloDatosPrimerApellidoObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"primerApellido");
        bindingContext.bindValue((IObservableValue)txtPrimerApellidoObserveTextObserveWidget, modeloDatosPrimerApellidoObserveValue, null, null);
        ISWTObservableValue txtSegundoApellidoObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtSegundoApellido, (int[])new int[]{24, 16});
        IObservableValue modeloDatosSegundoApellidoObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"segundoApellido");
        bindingContext.bindValue((IObservableValue)txtSegundoApellidoObserveTextObserveWidget, modeloDatosSegundoApellidoObserveValue, null, null);
        ISWTObservableValue txtRazonSocialObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtRazonSocial, (int[])new int[]{24, 16});
        IObservableValue modeloDatosRazonSocialObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"razonSocial");
        bindingContext.bindValue((IObservableValue)txtRazonSocialObserveTextObserveWidget, modeloDatosRazonSocialObserveValue, null, null);
        return bindingContext;
    }
}

