/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.asistentes.paginas;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidableContexto;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaDatosReenlazables;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteControl;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.ModeloValoresParticipacionInfo;
import ec.gob.sri.dimm.aps.ui.Constantes;
import ec.gob.sri.dimm.aps.ui.paginas.util.AdministradorTotalesParticipaciones;
import ec.gob.sri.dimm.aps.ui.paginas.util.UtilValidacion;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class ParticipacionInfoParticipacion
extends PaginaAsistente
implements VistaModelo<Participacion>,
VistaValoresPropios,
VistaDatosReenlazables {
    private DataBindingContext m_bindingContext;
    private static final String MENSAJE_PARTICIPACION_EXCEDE_LIMITE = "El porcentaje de participaci\u00f3n ingresado supera la sumatoria del 100% de participaci\u00f3n accionaria, por favor verifique la informaci\u00f3n.";
    private boolean enlaceInicialRealizado;
    private String tipoSociedadPadre;
    private BigDecimal diferenciaParticipacion;
    private boolean editando;
    private boolean ultimaPagina;
    private BigDecimal participacionOriginal;
    private AdministradorTotalesParticipaciones adminTotales;
    private SujetoRelacionado sujetoPadre;
    private Participacion modeloDatos;
    private ModeloValoresParticipacionInfo modeloValores;
    private Text txtPorcentajeParticipacion;
    private Label lblValorDenominacion;
    private Label lblValorTipoIdentificacion;
    private Label lblValorIdentificacion;
    private ComboViewer cvTipoRelacionSujeto;
    private Label lblPorcentajeDeParticipacin;
    private Label lblSimboloPorcentaje;
    private Label lblEsBeneficiarioFinal;
    private ComboViewer cvEsBeneficiarioFinal;
    private Combo cboEsBeneficiarioFinal;
    private String tipoDeclaracion;
    private String anio;
    private String mes;

    public ParticipacionInfoParticipacion(String anio, String mes, String tipoDeclaracion, String tipoSociedadPadre, SujetoRelacionado sujetoPadre, AdministradorTotalesParticipaciones adminTotales, boolean editando) {
        super("ParticipacionInfoParticipacion", "Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", "Ingrese la informaci\u00f3n de participaci\u00f3n relacionada con el sujeto.");
        this.tipoDeclaracion = tipoDeclaracion;
        this.anio = anio;
        this.mes = mes;
        this.tipoSociedadPadre = tipoSociedadPadre;
        this.sujetoPadre = sujetoPadre;
        this.editando = editando;
        this.adminTotales = adminTotales;
    }

    public void setUltimaPagina(boolean ultimaPagina) {
        this.ultimaPagina = ultimaPagina;
    }

    public boolean canFlipToNextPage() {
        return this.ultimaPagina ? false : this.isPageComplete();
    }

    public void createControl(Composite parent) {
        Composite cUbicacion = new Composite(parent, 0);
        this.setControl((Control)cUbicacion);
        cUbicacion.setLayout((Layout)new GridLayout(1, false));
        Composite cSujeto = new Composite(cUbicacion, 0);
        GridLayout gl_cSujeto = new GridLayout(2, false);
        gl_cSujeto.verticalSpacing = 0;
        gl_cSujeto.marginWidth = 0;
        gl_cSujeto.marginHeight = 0;
        cSujeto.setLayout((Layout)gl_cSujeto);
        cSujeto.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.lblValorDenominacion = new Label(cSujeto, 64);
        this.lblValorDenominacion.setFont(SWTResourceManager.getBoldFont((Font)this.lblValorDenominacion.getFont()));
        GridData gd_lblValorDenominacion = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_lblValorDenominacion.widthHint = 569;
        this.lblValorDenominacion.setLayoutData((Object)gd_lblValorDenominacion);
        this.lblValorDenominacion.setText("EMPRESA XYZ CIA. LTDA.");
        this.lblValorTipoIdentificacion = new Label(cSujeto, 0);
        this.lblValorTipoIdentificacion.setFont(SWTResourceManager.getBoldFont((Font)this.lblValorTipoIdentificacion.getFont()));
        GridData gd_lblValorTipoIdentificacion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblValorTipoIdentificacion.widthHint = 180;
        this.lblValorTipoIdentificacion.setLayoutData((Object)gd_lblValorTipoIdentificacion);
        this.lblValorTipoIdentificacion.setText("IDENTIFICACION DEL EXTERIOR");
        this.lblValorIdentificacion = new Label(cSujeto, 0);
        this.lblValorIdentificacion.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblValorIdentificacion.setFont(SWTResourceManager.getBoldFont((Font)this.lblValorIdentificacion.getFont()));
        this.lblValorIdentificacion.setText("1700000001001");
        Label lblContacto = new Label(cUbicacion, 0);
        GridData gd_lblContacto = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblContacto.verticalIndent = 10;
        lblContacto.setLayoutData((Object)gd_lblContacto);
        lblContacto.setFont(SWTResourceManager.getBoldFont((Font)lblContacto.getFont()));
        lblContacto.setText("Informaci\u00f3n de Participaci\u00f3n");
        Composite cInfoParticipacion = new Composite(cUbicacion, 0);
        cInfoParticipacion.setLayout((Layout)new GridLayout(3, false));
        Label lblTipoDeRelacin = new Label(cInfoParticipacion, 0);
        lblTipoDeRelacin.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblTipoDeRelacin.setText("Tipo de Relaci\u00f3n del Sujeto:");
        this.cvTipoRelacionSujeto = new ComboViewer(cInfoParticipacion, 8);
        this.cvTipoRelacionSujeto.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoRelacionSujeto = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                boolean tieneTipoRelacion = tipoRelacionSujeto != null;
                String tipoRelacion = tieneTipoRelacion ? (String)tipoRelacionSujeto.getValor() : null;
                ParticipacionInfoParticipacion.this.modeloDatos.setTipoDeRelacion(tieneTipoRelacion ? tipoRelacion : null);
                ParticipacionInfoParticipacion.this.modeloDatos.setDescripcionTipoDeRelacion(tieneTipoRelacion ? tipoRelacionSujeto.getNombre() : null);
                if (tieneTipoRelacion) {
                    ParticipacionInfoParticipacion.this.determinarDiferenciaParticipacion();
                    if (UtilValidacion.esAnexoDesdePeriodo2024(ParticipacionInfoParticipacion.this.anio, ParticipacionInfoParticipacion.this.mes)) {
                        boolean tienePorcentajeParticipacion;
                        if ("03".equals(ParticipacionInfoParticipacion.this.tipoSociedadPadre) || "10".equals(ParticipacionInfoParticipacion.this.tipoSociedadPadre)) {
                            tienePorcentajeParticipacion = !"04".equals(tipoRelacion) && !"12".equals(tipoRelacion) && !"13".equals(tipoRelacion) && !"14".equals(tipoRelacion);
                            AyudanteControl.habilitar((boolean)tienePorcentajeParticipacion, (Control[])new Control[]{ParticipacionInfoParticipacion.this.lblPorcentajeDeParticipacin, ParticipacionInfoParticipacion.this.txtPorcentajeParticipacion, ParticipacionInfoParticipacion.this.lblSimboloPorcentaje});
                            if (!tienePorcentajeParticipacion) {
                                ParticipacionInfoParticipacion.this.modeloDatos.setPorcentajeParticipacion("0.0");
                            }
                        }
                        if ("01".equals(ParticipacionInfoParticipacion.this.tipoSociedadPadre) || "02".equals(ParticipacionInfoParticipacion.this.tipoSociedadPadre)) {
                            tienePorcentajeParticipacion = !"04".equals(tipoRelacion) && !"05".equals(tipoRelacion) && !"09".equals(tipoRelacion) && !"11".equals(tipoRelacion);
                            AyudanteControl.habilitar((boolean)tienePorcentajeParticipacion, (Control[])new Control[]{ParticipacionInfoParticipacion.this.lblPorcentajeDeParticipacin, ParticipacionInfoParticipacion.this.txtPorcentajeParticipacion, ParticipacionInfoParticipacion.this.lblSimboloPorcentaje});
                            if (!tienePorcentajeParticipacion) {
                                ParticipacionInfoParticipacion.this.modeloDatos.setPorcentajeParticipacion("0.0");
                            }
                        }
                        if ("04".equals(ParticipacionInfoParticipacion.this.tipoSociedadPadre)) {
                            tienePorcentajeParticipacion = !"04".equals(tipoRelacion) && !"05".equals(tipoRelacion) && !"08".equals(tipoRelacion) && !"09".equals(tipoRelacion) && !"11".equals(tipoRelacion);
                            AyudanteControl.habilitar((boolean)tienePorcentajeParticipacion, (Control[])new Control[]{ParticipacionInfoParticipacion.this.lblPorcentajeDeParticipacin, ParticipacionInfoParticipacion.this.txtPorcentajeParticipacion, ParticipacionInfoParticipacion.this.lblSimboloPorcentaje});
                            if (!tienePorcentajeParticipacion) {
                                ParticipacionInfoParticipacion.this.modeloDatos.setPorcentajeParticipacion("0.0");
                            }
                        }
                        if ("07".equals(ParticipacionInfoParticipacion.this.tipoSociedadPadre)) {
                            tienePorcentajeParticipacion = !"05".equals(tipoRelacion) && !"09".equals(tipoRelacion) && !"11".equals(tipoRelacion);
                            AyudanteControl.habilitar((boolean)tienePorcentajeParticipacion, (Control[])new Control[]{ParticipacionInfoParticipacion.this.lblPorcentajeDeParticipacin, ParticipacionInfoParticipacion.this.txtPorcentajeParticipacion, ParticipacionInfoParticipacion.this.lblSimboloPorcentaje});
                            if (!tienePorcentajeParticipacion) {
                                ParticipacionInfoParticipacion.this.modeloDatos.setPorcentajeParticipacion("0.0");
                            }
                        }
                        if ("05".equals(ParticipacionInfoParticipacion.this.tipoSociedadPadre) || "06".equals(ParticipacionInfoParticipacion.this.tipoSociedadPadre)) {
                            tienePorcentajeParticipacion = !"04".equals(tipoRelacion) && !"05".equals(tipoRelacion) && !"09".equals(tipoRelacion) && !"11".equals(tipoRelacion);
                            AyudanteControl.habilitar((boolean)tienePorcentajeParticipacion, (Control[])new Control[]{ParticipacionInfoParticipacion.this.lblPorcentajeDeParticipacin, ParticipacionInfoParticipacion.this.txtPorcentajeParticipacion, ParticipacionInfoParticipacion.this.lblSimboloPorcentaje});
                            if (!tienePorcentajeParticipacion) {
                                ParticipacionInfoParticipacion.this.modeloDatos.setPorcentajeParticipacion("0.0");
                            }
                        }
                    } else {
                        boolean tienePorcentajeParticipacion = !"04".equals(tipoRelacion) && !"05".equals(tipoRelacion) && !"09".equals(tipoRelacion);
                        AyudanteControl.habilitar((boolean)tienePorcentajeParticipacion, (Control[])new Control[]{ParticipacionInfoParticipacion.this.lblPorcentajeDeParticipacin, ParticipacionInfoParticipacion.this.txtPorcentajeParticipacion, ParticipacionInfoParticipacion.this.lblSimboloPorcentaje});
                        if (!tienePorcentajeParticipacion) {
                            ParticipacionInfoParticipacion.this.modeloDatos.setPorcentajeParticipacion("0.0");
                        }
                    }
                } else {
                    AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{ParticipacionInfoParticipacion.this.lblPorcentajeDeParticipacin, ParticipacionInfoParticipacion.this.txtPorcentajeParticipacion, ParticipacionInfoParticipacion.this.lblSimboloPorcentaje});
                }
            }
        });
        Combo cboTipoRelacionSujeto = this.cvTipoRelacionSujeto.getCombo();
        cboTipoRelacionSujeto.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.lblPorcentajeDeParticipacin = new Label(cInfoParticipacion, 0);
        this.lblPorcentajeDeParticipacin.setEnabled(false);
        GridData gd_lblPorcentajeDeParticipacin = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPorcentajeDeParticipacin.widthHint = 175;
        this.lblPorcentajeDeParticipacin.setLayoutData((Object)gd_lblPorcentajeDeParticipacin);
        this.lblPorcentajeDeParticipacin.setText("Porcentaje de Participaci\u00f3n:");
        this.txtPorcentajeParticipacion = new Text(cInfoParticipacion, 133120);
        this.txtPorcentajeParticipacion.setEnabled(false);
        this.txtPorcentajeParticipacion.setTextLimit(9);
        GridData gd_txtPorcentajeParticipacion = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtPorcentajeParticipacion.widthHint = 60;
        this.txtPorcentajeParticipacion.setLayoutData((Object)gd_txtPorcentajeParticipacion);
        this.lblSimboloPorcentaje = new Label(cInfoParticipacion, 0);
        this.lblSimboloPorcentaje.setEnabled(false);
        GridData gd_lblSimboloPorcentaje = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblSimboloPorcentaje.widthHint = 200;
        this.lblSimboloPorcentaje.setLayoutData((Object)gd_lblSimboloPorcentaje);
        this.lblSimboloPorcentaje.setText("%");
        this.lblEsBeneficiarioFinal = new Label(cInfoParticipacion, 0);
        GridData gd_lblEsBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblEsBeneficiarioFinal.widthHint = 175;
        this.lblEsBeneficiarioFinal.setLayoutData((Object)gd_lblEsBeneficiarioFinal);
        this.lblEsBeneficiarioFinal.setText("\u00bfEs Beneficiario Final?");
        this.cvEsBeneficiarioFinal = new ComboViewer(cInfoParticipacion, 8);
        this.cvEsBeneficiarioFinal.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor beneficiarioFinal = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (beneficiarioFinal != null) {
                    ParticipacionInfoParticipacion.this.modeloDatos.setEsBeneficiarioFinal((String)beneficiarioFinal.getValor());
                }
            }
        });
        this.cboEsBeneficiarioFinal = this.cvEsBeneficiarioFinal.getCombo();
        this.cboEsBeneficiarioFinal.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.habilitarEsBeneficiario();
        this.m_bindingContext = this.initDataBindings();
        this.enlaceInicialRealizado = true;
        this.procesarModeloDatos();
    }

    private void habilitarEsBeneficiario() {
        boolean esPeriodoDesde2024 = UtilValidacion.esAnexoDesdePeriodo2024(this.anio, this.mes);
        if (esPeriodoDesde2024) {
            this.modeloValores.cargarEsBeneficiarioPorTipoSujeto(this.modeloDatos.getSujeto().getTipoSujeto());
        }
    }

    private void habilitarComponentes(ComboViewer[] cws, Combo[] cbs, boolean habilita) {
        ComboViewer[] comboViewerArray = cws;
        int n = cws.length;
        int n2 = 0;
        while (n2 < n) {
            ComboViewer cw = comboViewerArray[n2];
            cw.setSelection(null, !habilita);
            ++n2;
        }
        comboViewerArray = cbs;
        n = cbs.length;
        n2 = 0;
        while (n2 < n) {
            ComboViewer cb = comboViewerArray[n2];
            cb.setEnabled(habilita);
            ++n2;
        }
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresParticipacionInfo(this.anio, this.mes, this.tipoDeclaracion, this.tipoSociedadPadre);
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(Participacion modeloDatos) {
        this.modeloDatos = modeloDatos;
        this.determinarDiferenciaParticipacion();
        if (this.editando) {
            this.participacionOriginal = new BigDecimal(modeloDatos.getPorcentajeParticipacion());
        }
    }

    private void determinarDiferenciaParticipacion() {
        String tipoRelacion = this.modeloDatos.getTipoDeRelacion();
        if ("03".equals(this.tipoSociedadPadre)) {
            if ("07".equals(tipoRelacion)) {
                this.diferenciaParticipacion = Constantes.CIEN.subtract(this.adminTotales.getSumaBeneficiariosRaw());
                return;
            }
            if ("06".equals(tipoRelacion)) {
                this.diferenciaParticipacion = Constantes.CIEN.subtract(this.adminTotales.getSumaConstituyentesRaw());
                return;
            }
        } else if (("04".equals(this.tipoSociedadPadre) || "05".equals(this.tipoSociedadPadre) || "06".equals(this.tipoSociedadPadre)) && "08".equals(tipoRelacion)) {
            this.diferenciaParticipacion = Constantes.CIEN.subtract(this.adminTotales.getSumaSociosFundadoresRaw());
            return;
        }
        this.diferenciaParticipacion = Constantes.CIEN.subtract(this.adminTotales.getSumaParticipacionesRaw());
    }

    public void procesarModeloDatos() {
        ContextoValidacion contextoValidacion = new ContextoValidacion().agregar("tipoSociedadPadre", (Object)this.tipoSociedadPadre);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)new ListenerValidacionModeloPaginaAsistente((InformacionValidableContexto)this.modeloDatos, contextoValidacion, this){
            private boolean cambioTipoRelacion;
            {
                this.cambioTipoRelacion = false;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                super.propertyChange(evt);
                if ("tipoDeRelacion".equals(evt.getPropertyName())) {
                    this.cambioTipoRelacion = true;
                }
            }

            public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                List participaciones = ParticipacionInfoParticipacion.this.sujetoPadre.getParticipaciones();
                for (Participacion p : participaciones) {
                    SujetoRelacionado sujetoParticipacion = p.getSujeto();
                    if (!this.cambioTipoRelacion || !sujetoParticipacion.getTipoIdentificacion().equals(ParticipacionInfoParticipacion.this.modeloDatos.getSujeto().getTipoIdentificacion()) || !sujetoParticipacion.getIdentificacion().equals(ParticipacionInfoParticipacion.this.modeloDatos.getSujeto().getIdentificacion()) || !p.getTipoDeRelacion().equals(ParticipacionInfoParticipacion.this.modeloDatos.getTipoDeRelacion())) continue;
                    resultado.fallarValidacion(String.format("El sujeto '%s' [%s, %s] ya participa como %s del sujeto '%s' [%s, %s].", sujetoParticipacion.getDenominacion(), sujetoParticipacion.getDescripcionTipoIdentificacion(), sujetoParticipacion.getIdentificacion(), p.getDescripcionTipoDeRelacion(), ParticipacionInfoParticipacion.this.sujetoPadre.getDenominacion(), ParticipacionInfoParticipacion.this.sujetoPadre.getDescripcionTipoIdentificacion(), ParticipacionInfoParticipacion.this.sujetoPadre.getIdentificacion()));
                    return;
                }
                BigDecimal bdParticipacion = new BigDecimal(ParticipacionInfoParticipacion.this.modeloDatos.getPorcentajeParticipacion());
                if (bdParticipacion.compareTo(BigDecimal.ZERO) != 0 && !ParticipacionInfoParticipacion.this.modeloDatos.getTipoDeRelacion().equals("06") && !ParticipacionInfoParticipacion.this.modeloDatos.getTipoDeRelacion().equals("07")) {
                    if (ParticipacionInfoParticipacion.this.editando) {
                        if (ParticipacionInfoParticipacion.this.diferenciaParticipacion.compareTo(bdParticipacion.subtract(ParticipacionInfoParticipacion.this.participacionOriginal)) < 0) {
                            resultado.fallarValidacion(ParticipacionInfoParticipacion.MENSAJE_PARTICIPACION_EXCEDE_LIMITE);
                            return;
                        }
                    } else if (ParticipacionInfoParticipacion.this.diferenciaParticipacion.compareTo(bdParticipacion) < 0) {
                        resultado.fallarValidacion(ParticipacionInfoParticipacion.MENSAJE_PARTICIPACION_EXCEDE_LIMITE);
                        return;
                    }
                }
                resultado.pasarValidacion();
            }
        });
        boolean esPeriodoDesde2024 = UtilValidacion.esAnexoDesdePeriodo2024(this.anio, this.mes);
        if (esPeriodoDesde2024) {
            ElementoNombreValor esBeneficiario;
            if (this.modeloDatos.getSujeto().getTipoSujeto().equals("02")) {
                this.modeloDatos.setEsBeneficiarioFinal("NA");
                esBeneficiario = this.modeloValores.obtenerEsBeneficiarioFinal("NA");
                AyudanteViewer.seleccionarElemento((Viewer)this.cvEsBeneficiarioFinal, (Object)esBeneficiario);
                this.cboEsBeneficiarioFinal.setEnabled(false);
            }
            if (this.modeloDatos.getSujeto().getTipoSujeto().equals("01") && this.tipoSociedadPadre.equals("03")) {
                this.modeloDatos.setEsBeneficiarioFinal("SI");
                esBeneficiario = this.modeloValores.obtenerEsBeneficiarioFinal("SI");
                AyudanteViewer.seleccionarElemento((Viewer)this.cvEsBeneficiarioFinal, (Object)esBeneficiario);
                this.cboEsBeneficiarioFinal.setEnabled(false);
            }
        } else {
            this.lblEsBeneficiarioFinal.setEnabled(false);
            this.cboEsBeneficiarioFinal.setEnabled(false);
        }
        if (this.editando) {
            ElementoNombreValor tipoRelacion = this.modeloValores.obtenerTipoRelacion(this.modeloDatos.getTipoDeRelacion());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoRelacionSujeto, (Object)tipoRelacion);
            ElementoNombreValor esBeneficiarioFinal = this.modeloValores.obtenerEsBeneficiarioFinal(this.modeloDatos.getEsBeneficiarioFinal());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvEsBeneficiarioFinal, (Object)esBeneficiarioFinal);
        }
    }

    public void reenlazarDatos() {
        if (this.enlaceInicialRealizado) {
            this.m_bindingContext = this.initDataBindings();
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue lblValorDenominacionObserveTextObserveWidget = SWTObservables.observeText((Control)this.lblValorDenominacion);
        IObservableValue modeloDatosSujetodenominacionObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"sujeto.denominacion");
        bindingContext.bindValue((IObservableValue)lblValorDenominacionObserveTextObserveWidget, modeloDatosSujetodenominacionObserveValue, null, null);
        ISWTObservableValue lblValorTipoIdentificacionObserveTextObserveWidget = SWTObservables.observeText((Control)this.lblValorTipoIdentificacion);
        IObservableValue modeloDatosSujetodescripcionTipoIdentificacionObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"sujeto.descripcionTipoIdentificacion");
        bindingContext.bindValue((IObservableValue)lblValorTipoIdentificacionObserveTextObserveWidget, modeloDatosSujetodescripcionTipoIdentificacionObserveValue, null, null);
        ISWTObservableValue lblValorIdentificacionObserveTextObserveWidget = SWTObservables.observeText((Control)this.lblValorIdentificacion);
        IObservableValue modeloDatosSujetoidentificacionObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"sujeto.identificacion");
        bindingContext.bindValue((IObservableValue)lblValorIdentificacionObserveTextObserveWidget, modeloDatosSujetoidentificacionObserveValue, null, null);
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoRelacionSujeto.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoRelacionSujeto.setContentProvider((IContentProvider)listContentProvider);
        IObservableList modeloValoresTiposRelacionObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposRelacion");
        this.cvTipoRelacionSujeto.setInput((Object)modeloValoresTiposRelacionObserveList);
        ObservableListContentProvider listContentProviderBeneficiario = new ObservableListContentProvider();
        IObservableMap observeMapBeneficiario = PojoObservables.observeMap((IObservableSet)listContentProviderBeneficiario.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvEsBeneficiarioFinal.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapBeneficiario));
        this.cvEsBeneficiarioFinal.setContentProvider((IContentProvider)listContentProviderBeneficiario);
        IObservableList modeloValoresBeneficiarioObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"beneficiarioFinal");
        this.cvEsBeneficiarioFinal.setInput((Object)modeloValoresBeneficiarioObserveList);
        ISWTObservableValue txtPorcentajeParticipacionObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtPorcentajeParticipacion, (int[])new int[]{24, 16});
        IObservableValue modeloDatosPorcentajeParticipacionObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"porcentajeParticipacion");
        bindingContext.bindValue((IObservableValue)txtPorcentajeParticipacionObserveTextObserveWidget, modeloDatosPorcentajeParticipacionObserveValue, null, null);
        return bindingContext;
    }
}

