/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.asistentes.paginas;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaDatosReenlazables;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteControl;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.aps.modelo.obj.UbicacionBeneficiarioFinal;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.ModeloValoresParticipacionUbicacion;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class ParticipacionUbicacionBeneficiarioFinal
extends PaginaAsistente
implements VistaModelo<UbicacionBeneficiarioFinal>,
VistaValoresPropios,
VistaDatosReenlazables {
    private DataBindingContext m_bindingContext;
    private UbicacionBeneficiarioFinal modeloDatos;
    private ModeloValoresParticipacionUbicacion modeloValoresUbicacion;
    private boolean editando;
    private Label lblNacionalidadUno;
    private Label lblNacionalidadDos;
    private Label lblNacionalidadTres;
    private Label lblResidenciaFiscal;
    private Label lblEstadoJurisdiccion;
    private Label lblProvincia;
    private Label lblCiudad;
    private Label lblCanton;
    private Label lblParroquia;
    private Label lblCalle;
    private Label lblNumero;
    private Label lblInterseccion;
    private Label lblCodigoPostal;
    private Label lblReferencia;
    private Combo cmbNacionalidadUno;
    private ComboViewer cvNacionalidadUno;
    private Combo cmbNacionalidadDos;
    private ComboViewer cvNacionalidadDos;
    private Combo cmbNacionalidadTres;
    private ComboViewer cvNacionalidadTres;
    private ComboViewer cvResidenciaFiscal;
    private Text txtEstadoJurisdiccion;
    private ComboViewer cvProvincia;
    private Combo cmbProvincia;
    private Text txtCiudad;
    private ComboViewer cvCanton;
    private Combo cmbCanton;
    private ComboViewer cvParroquia;
    private Combo cmbParroquia;
    private Text txtCalle;
    private Text txtNumero;
    private Text txtInterseccion;
    private Text txtCodigoPostal;
    private Text txtReferencia;
    private boolean enlaceInicialRealizado;
    private String tipoDeclaracion;
    private String tipoSociedad;

    public ParticipacionUbicacionBeneficiarioFinal(String tipoDeclaracion, String tipoSociedad, boolean editando) {
        super("ParticipacionUbicacionBeneficiarioFinal", "Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", "Ingreso de informaci\u00f3n de Beneficiarios Finales.");
        this.tipoDeclaracion = tipoDeclaracion;
        this.tipoSociedad = tipoSociedad;
        this.editando = editando;
    }

    public void createControl(Composite parent) {
        Composite cUbicacionBeneficiarioFinal = new Composite(parent, 0);
        this.setControl((Control)cUbicacionBeneficiarioFinal);
        cUbicacionBeneficiarioFinal.setLayout((Layout)new GridLayout(3, false));
        Label lblInfo = new Label(cUbicacionBeneficiarioFinal, 64);
        GridData gd_lblInfo = new GridData(4, 0x1000000, false, false, 3, 1);
        gd_lblInfo.widthHint = 700;
        lblInfo.setLayoutData((Object)gd_lblInfo);
        lblInfo.setText("Ingrese la identificaci\u00f3n del sujeto para determinar si su informaci\u00f3n general ya se encuentra registrada, de tal manera que no sea necesario volver a ingresarla.");
        this.lblNacionalidadUno = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblNacionalidadUno = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblNacionalidadUno.setLayoutData((Object)gd_lblNacionalidadUno);
        this.lblNacionalidadUno.setText("Nacionalidad Uno:");
        this.cvNacionalidadUno = new ComboViewer(cUbicacionBeneficiarioFinal, 8);
        this.cvNacionalidadUno.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor nacionalidadUno = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (nacionalidadUno != null) {
                    ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setNacionalidadUno((String)nacionalidadUno.getValor());
                }
            }
        });
        this.cmbNacionalidadUno = this.cvNacionalidadUno.getCombo();
        GridData gd_cmbNacionalidadUno = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbNacionalidadUno.widthHint = 260;
        this.cmbNacionalidadUno.setLayoutData((Object)gd_cmbNacionalidadUno);
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblNacionalidadDos = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblNacionalidadDos = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblNacionalidadDos.setLayoutData((Object)gd_lblNacionalidadDos);
        this.lblNacionalidadDos.setText("Nacionalidad Dos:");
        this.cvNacionalidadDos = new ComboViewer(cUbicacionBeneficiarioFinal, 8);
        this.cvNacionalidadDos.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor nacionalidadDos = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (nacionalidadDos != null) {
                    ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setNacionalidadDos((String)nacionalidadDos.getValor());
                }
            }
        });
        this.cmbNacionalidadDos = this.cvNacionalidadDos.getCombo();
        GridData gd_cmbNacionalidadDos = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbNacionalidadDos.widthHint = 260;
        this.cmbNacionalidadDos.setLayoutData((Object)gd_cmbNacionalidadDos);
        Label lblOpcionalDos = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblOpcionalDos = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblOpcionalDos.widthHint = 75;
        lblOpcionalDos.setLayoutData((Object)gd_lblOpcionalDos);
        lblOpcionalDos.setText("Opcional");
        this.lblNacionalidadTres = new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblNacionalidadTres.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblNacionalidadTres.setText("Nacionalidad Tres:");
        this.cvNacionalidadTres = new ComboViewer(cUbicacionBeneficiarioFinal, 8);
        this.cvNacionalidadTres.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor nacionalidadTres = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (nacionalidadTres != null) {
                    ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setNacionalidadTres((String)nacionalidadTres.getValor());
                }
            }
        });
        this.cmbNacionalidadTres = this.cvNacionalidadTres.getCombo();
        GridData gd_cmbNacionalidadTres = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbNacionalidadTres.widthHint = 260;
        this.cmbNacionalidadTres.setLayoutData((Object)gd_cmbNacionalidadTres);
        ISelectionChangedListener validarNacionalidad = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String nacionalidadUno = this.getSelectedText(ParticipacionUbicacionBeneficiarioFinal.this.cvNacionalidadUno);
                String nacionalidadDos = this.getSelectedText(ParticipacionUbicacionBeneficiarioFinal.this.cvNacionalidadDos);
                String nacionalidadTres = this.getSelectedText(ParticipacionUbicacionBeneficiarioFinal.this.cvNacionalidadTres);
                if (nacionalidadUno != null && nacionalidadUno.equals(nacionalidadDos) || nacionalidadUno != null && nacionalidadUno.equals(nacionalidadTres) || nacionalidadDos != null && nacionalidadDos.equals(nacionalidadTres)) {
                    MessageBox messageBox = new MessageBox(ParticipacionUbicacionBeneficiarioFinal.this.cmbNacionalidadUno.getShell(), 33);
                    messageBox.setMessage("La nacionalidad seleccionada ya se encuentra registrada, por favor seleccione otra nacionalidad.");
                    messageBox.open();
                    if (event.getSelectionProvider() == ParticipacionUbicacionBeneficiarioFinal.this.cvNacionalidadUno) {
                        ParticipacionUbicacionBeneficiarioFinal.this.cmbNacionalidadUno.deselectAll();
                        ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setNacionalidadUno("");
                    } else if (event.getSelectionProvider() == ParticipacionUbicacionBeneficiarioFinal.this.cvNacionalidadDos) {
                        ParticipacionUbicacionBeneficiarioFinal.this.cmbNacionalidadDos.deselectAll();
                        ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setNacionalidadDos("");
                    } else if (event.getSelectionProvider() == ParticipacionUbicacionBeneficiarioFinal.this.cvNacionalidadTres) {
                        ParticipacionUbicacionBeneficiarioFinal.this.cmbNacionalidadTres.deselectAll();
                        ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setNacionalidadTres("");
                    }
                }
            }

            private String getSelectedText(ComboViewer cv) {
                IStructuredSelection sel = (IStructuredSelection)cv.getSelection();
                if (sel.isEmpty()) {
                    return null;
                }
                return sel.getFirstElement().toString();
            }
        };
        this.cvNacionalidadUno.addSelectionChangedListener(validarNacionalidad);
        this.cvNacionalidadDos.addSelectionChangedListener(validarNacionalidad);
        this.cvNacionalidadTres.addSelectionChangedListener(validarNacionalidad);
        Label lblOpcionalTres = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblOpcionalTres = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblOpcionalTres.setLayoutData((Object)gd_lblOpcionalTres);
        lblOpcionalTres.setText("Opcional");
        this.lblResidenciaFiscal = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblSegundoNombreBeneficiarioFinal = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblResidenciaFiscal.setLayoutData((Object)gd_lblSegundoNombreBeneficiarioFinal);
        this.lblResidenciaFiscal.setText("Residencia Fiscal:");
        this.cvResidenciaFiscal = new ComboViewer(cUbicacionBeneficiarioFinal, 8);
        this.cvResidenciaFiscal.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComboViewer[] cws = new ComboViewer[]{ParticipacionUbicacionBeneficiarioFinal.this.cvProvincia, ParticipacionUbicacionBeneficiarioFinal.this.cvCanton, ParticipacionUbicacionBeneficiarioFinal.this.cvParroquia};
                Combo[] cbs = new Combo[]{ParticipacionUbicacionBeneficiarioFinal.this.cmbProvincia, ParticipacionUbicacionBeneficiarioFinal.this.cmbCanton, ParticipacionUbicacionBeneficiarioFinal.this.cmbParroquia};
                ElementoNombreValor residenciaFiscal = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (residenciaFiscal != null) {
                    ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setResidenciaFiscal((String)residenciaFiscal.getValor());
                    if (((String)residenciaFiscal.getValor()).equals("593")) {
                        ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setJurisdiccion("");
                        ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setCiudad("");
                        AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{ParticipacionUbicacionBeneficiarioFinal.this.txtEstadoJurisdiccion, ParticipacionUbicacionBeneficiarioFinal.this.lblEstadoJurisdiccion, ParticipacionUbicacionBeneficiarioFinal.this.txtCiudad, ParticipacionUbicacionBeneficiarioFinal.this.lblCiudad});
                        AyudanteControl.habilitar((boolean)true, (Control[])new Control[]{ParticipacionUbicacionBeneficiarioFinal.this.lblProvincia, ParticipacionUbicacionBeneficiarioFinal.this.lblCanton, ParticipacionUbicacionBeneficiarioFinal.this.lblParroquia, ParticipacionUbicacionBeneficiarioFinal.this.lblCalle, ParticipacionUbicacionBeneficiarioFinal.this.lblNumero, ParticipacionUbicacionBeneficiarioFinal.this.lblInterseccion, ParticipacionUbicacionBeneficiarioFinal.this.lblCodigoPostal, ParticipacionUbicacionBeneficiarioFinal.this.lblReferencia});
                        AyudanteControl.habilitar((boolean)true, (Control[])new Control[]{ParticipacionUbicacionBeneficiarioFinal.this.txtCalle, ParticipacionUbicacionBeneficiarioFinal.this.txtNumero, ParticipacionUbicacionBeneficiarioFinal.this.txtInterseccion, ParticipacionUbicacionBeneficiarioFinal.this.txtCodigoPostal, ParticipacionUbicacionBeneficiarioFinal.this.txtReferencia});
                        ParticipacionUbicacionBeneficiarioFinal.this.habilitarComponentes(cws, cbs, true);
                    } else {
                        ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setProvincia("");
                        ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setCanton("");
                        ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setParroquia("");
                        AyudanteControl.habilitar((boolean)true, (Control[])new Control[]{ParticipacionUbicacionBeneficiarioFinal.this.lblEstadoJurisdiccion, ParticipacionUbicacionBeneficiarioFinal.this.lblCiudad, ParticipacionUbicacionBeneficiarioFinal.this.lblCalle, ParticipacionUbicacionBeneficiarioFinal.this.lblNumero, ParticipacionUbicacionBeneficiarioFinal.this.lblInterseccion, ParticipacionUbicacionBeneficiarioFinal.this.lblCodigoPostal, ParticipacionUbicacionBeneficiarioFinal.this.lblReferencia});
                        AyudanteControl.habilitar((boolean)true, (Control[])new Control[]{ParticipacionUbicacionBeneficiarioFinal.this.txtEstadoJurisdiccion, ParticipacionUbicacionBeneficiarioFinal.this.txtCiudad, ParticipacionUbicacionBeneficiarioFinal.this.txtCalle, ParticipacionUbicacionBeneficiarioFinal.this.txtNumero, ParticipacionUbicacionBeneficiarioFinal.this.txtInterseccion, ParticipacionUbicacionBeneficiarioFinal.this.txtCodigoPostal, ParticipacionUbicacionBeneficiarioFinal.this.txtReferencia});
                        AyudanteControl.habilitar((boolean)false, (Control[])new Control[]{ParticipacionUbicacionBeneficiarioFinal.this.lblProvincia, ParticipacionUbicacionBeneficiarioFinal.this.lblCanton, ParticipacionUbicacionBeneficiarioFinal.this.lblParroquia});
                        ParticipacionUbicacionBeneficiarioFinal.this.habilitarComponentes(cws, cbs, false);
                    }
                }
            }
        });
        Combo cmbResidenciaFiscal = this.cvResidenciaFiscal.getCombo();
        GridData gd_cmbResidenciaFiscal = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbResidenciaFiscal.widthHint = 260;
        cmbResidenciaFiscal.setLayoutData((Object)gd_cmbResidenciaFiscal);
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblEstadoJurisdiccion = new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblEstadoJurisdiccion.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblEstadoJurisdiccion.setText("Estado/Jurisdicci\u00f3n:");
        this.txtEstadoJurisdiccion = new Text(cUbicacionBeneficiarioFinal, 2048);
        GridData gd_NacionalidadUno = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_NacionalidadUno.widthHint = 275;
        this.txtEstadoJurisdiccion.setLayoutData((Object)gd_NacionalidadUno);
        this.txtEstadoJurisdiccion.setTextLimit(20);
        this.txtEstadoJurisdiccion.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newText = event.text;
                if (!newText.matches("[a-zA-Z ]*")) {
                    event.doit = false;
                }
            }
        });
        this.txtEstadoJurisdiccion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text source = (Text)event.widget;
                String upperText = source.getText().toUpperCase();
                if (!source.getText().equals(upperText)) {
                    source.setText(upperText);
                    source.setSelection(upperText.length());
                }
            }
        });
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblProvincia = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblSegundoApellidoBeneficiarioFinal = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblProvincia.setLayoutData((Object)gd_lblSegundoApellidoBeneficiarioFinal);
        this.lblProvincia.setText("Provincia:");
        this.cvProvincia = new ComboViewer(cUbicacionBeneficiarioFinal, 8);
        this.cvProvincia.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor provincia = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (provincia != null) {
                    ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setProvincia((String)provincia.getValor());
                    ParticipacionUbicacionBeneficiarioFinal.this.modeloValoresUbicacion.cargarCantones((String)provincia.getValor());
                    ParticipacionUbicacionBeneficiarioFinal.this.cvCanton.refresh();
                }
            }
        });
        this.cmbProvincia = this.cvProvincia.getCombo();
        GridData gd_cmbProvincia = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbProvincia.widthHint = 260;
        this.cmbProvincia.setLayoutData((Object)gd_cmbProvincia);
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblCiudad = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblFechaNacimientoBeneficiarioFinal = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblCiudad.setLayoutData((Object)gd_lblFechaNacimientoBeneficiarioFinal);
        this.lblCiudad.setText("Ciudad:");
        this.txtCiudad = new Text(cUbicacionBeneficiarioFinal, 2048);
        GridData gd_NacionalidadDos = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_NacionalidadDos.widthHint = 275;
        this.txtCiudad.setLayoutData((Object)gd_NacionalidadDos);
        this.txtCiudad.setTextLimit(20);
        this.txtCiudad.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newText = event.text;
                if (!newText.matches("[a-zA-Z ]*")) {
                    event.doit = false;
                }
            }
        });
        this.txtCiudad.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text source = (Text)event.widget;
                String upperText = source.getText().toUpperCase();
                if (!source.getText().equals(upperText)) {
                    source.setText(upperText);
                    source.setSelection(upperText.length());
                }
            }
        });
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblCanton = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblBeneficiarioFinalPorPropiedad = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblCanton.setLayoutData((Object)gd_lblBeneficiarioFinalPorPropiedad);
        this.lblCanton.setText("Cant\u00f3n:");
        this.cvCanton = new ComboViewer(cUbicacionBeneficiarioFinal, 8);
        this.cvCanton.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor canton = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (canton != null) {
                    ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setCanton((String)canton.getValor());
                    ParticipacionUbicacionBeneficiarioFinal.this.modeloValoresUbicacion.cargarParroquias((String)canton.getValor());
                    ParticipacionUbicacionBeneficiarioFinal.this.cvParroquia.refresh();
                }
            }
        });
        this.cmbCanton = this.cvCanton.getCombo();
        GridData gd_cmbCanton = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbCanton.widthHint = 260;
        this.cmbCanton.setLayoutData((Object)gd_cmbCanton);
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblParroquia = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_PorcentajeParticipacionEfectivaPropiedad = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblParroquia.setLayoutData((Object)gd_PorcentajeParticipacionEfectivaPropiedad);
        this.lblParroquia.setText("Parroquia:");
        this.cvParroquia = new ComboViewer(cUbicacionBeneficiarioFinal, 8);
        this.cvParroquia.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor parroquia = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (parroquia != null) {
                    ParticipacionUbicacionBeneficiarioFinal.this.modeloDatos.setParroquia((String)parroquia.getValor());
                }
            }
        });
        this.cmbParroquia = this.cvParroquia.getCombo();
        GridData gd_cmbParroquia = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbParroquia.widthHint = 260;
        this.cmbParroquia.setLayoutData((Object)gd_cmbParroquia);
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblCalle = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblSimboloPorcentajeParticipacionEfectivaPropiedad = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.lblCalle.setLayoutData((Object)gd_lblSimboloPorcentajeParticipacionEfectivaPropiedad);
        this.lblCalle.setText("Calle");
        this.txtCalle = new Text(cUbicacionBeneficiarioFinal, 2048);
        GridData gd_txtPrimerNombreBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtPrimerNombreBeneficiarioFinal.widthHint = 275;
        this.txtCalle.setLayoutData((Object)gd_txtPrimerNombreBeneficiarioFinal);
        this.txtCalle.setTextLimit(50);
        this.txtCalle.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newText = event.text;
                if (!newText.matches("[a-zA-Z0-9 ]*")) {
                    event.doit = false;
                }
            }
        });
        this.txtCalle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text source = (Text)event.widget;
                String upperText = source.getText().toUpperCase();
                if (!source.getText().equals(upperText)) {
                    source.setText(upperText);
                    source.setSelection(upperText.length());
                }
            }
        });
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblNumero = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblBeneficiarioFinalOtrosMotivosControl = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblNumero.setLayoutData((Object)gd_lblBeneficiarioFinalOtrosMotivosControl);
        this.lblNumero.setText("Numero:");
        this.txtNumero = new Text(cUbicacionBeneficiarioFinal, 2048);
        GridData gd_txtSegundoNombreBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtSegundoNombreBeneficiarioFinal.widthHint = 275;
        this.txtNumero.setLayoutData((Object)gd_txtSegundoNombreBeneficiarioFinal);
        this.txtNumero.setTextLimit(50);
        this.txtNumero.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newText = event.text;
                if (!newText.matches("[a-zA-Z0-9 ]*")) {
                    event.doit = false;
                }
            }
        });
        this.txtNumero.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text source = (Text)event.widget;
                String upperText = source.getText().toUpperCase();
                if (!source.getText().equals(upperText)) {
                    source.setText(upperText);
                    source.setSelection(upperText.length());
                }
            }
        });
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblInterseccion = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblOtrosRelacionadosControlEntidad = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblInterseccion.setLayoutData((Object)gd_lblOtrosRelacionadosControlEntidad);
        this.lblInterseccion.setText("Intersecci\u00f3n:");
        this.txtInterseccion = new Text(cUbicacionBeneficiarioFinal, 2048);
        GridData gd_txtPrimerApellidoBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtPrimerApellidoBeneficiarioFinal.widthHint = 275;
        this.txtInterseccion.setLayoutData((Object)gd_txtPrimerApellidoBeneficiarioFinal);
        this.txtInterseccion.setTextLimit(50);
        this.txtInterseccion.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newText = event.text;
                if (!newText.matches("[a-zA-Z0-9 ]*")) {
                    event.doit = false;
                }
            }
        });
        this.txtInterseccion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text source = (Text)event.widget;
                String upperText = source.getText().toUpperCase();
                if (!source.getText().equals(upperText)) {
                    source.setText(upperText);
                    source.setSelection(upperText.length());
                }
            }
        });
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblCodigoPostal = new Label(cUbicacionBeneficiarioFinal, 0);
        GridData gd_lblBeneficiarioFinalPorAdministracion = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblCodigoPostal.setLayoutData((Object)gd_lblBeneficiarioFinalPorAdministracion);
        this.lblCodigoPostal.setText("C\u00f3digo Postal:");
        this.txtCodigoPostal = new Text(cUbicacionBeneficiarioFinal, 2048);
        GridData gd_txtSegundoApellidoBeneficiarioFinal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtSegundoApellidoBeneficiarioFinal.widthHint = 275;
        this.txtCodigoPostal.setLayoutData((Object)gd_txtSegundoApellidoBeneficiarioFinal);
        this.txtCodigoPostal.setTextLimit(50);
        this.txtCodigoPostal.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String oldText = ParticipacionUbicacionBeneficiarioFinal.this.txtCodigoPostal.getText();
                String newText = String.valueOf(oldText.substring(0, event.start)) + event.text + oldText.substring(event.end);
                if (!newText.matches("\\d*")) {
                    event.doit = false;
                }
            }
        });
        new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblReferencia = new Label(cUbicacionBeneficiarioFinal, 0);
        this.lblReferencia.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblReferencia.setText("Referencia:");
        this.txtReferencia = new Text(cUbicacionBeneficiarioFinal, 2048);
        GridData gd_txtPorcentajeParticipacionEfectivaPropiedad = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtPorcentajeParticipacionEfectivaPropiedad.widthHint = 275;
        this.txtReferencia.setLayoutData((Object)gd_txtPorcentajeParticipacionEfectivaPropiedad);
        this.txtReferencia.setTextLimit(50);
        this.txtReferencia.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newText = event.text;
                if (!newText.matches("[a-zA-Z0-9 ]*")) {
                    event.doit = false;
                }
            }
        });
        this.txtReferencia.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text source = (Text)event.widget;
                String upperText = source.getText().toUpperCase();
                if (!source.getText().equals(upperText)) {
                    source.setText(upperText);
                    source.setSelection(upperText.length());
                }
            }
        });
        this.habilitarTodosComponentes();
        this.m_bindingContext = this.initDataBindings();
        this.enlaceInicialRealizado = true;
        this.procesarModeloDatos();
    }

    private void habilitarTodosComponentes() {
        ComboViewer[] allCws = new ComboViewer[]{this.cvProvincia, this.cvCanton, this.cvParroquia};
        Combo[] allCbs = new Combo[]{this.cmbProvincia, this.cmbCanton, this.cmbParroquia};
        this.habilitarComponentes(allCws, allCbs, false);
        AyudanteControl.habilitarExtendido((boolean)false, (Control[])new Control[]{this.lblEstadoJurisdiccion, this.lblProvincia, this.lblCiudad, this.lblCanton, this.lblParroquia, this.lblCalle, this.lblNumero, this.lblInterseccion, this.lblCodigoPostal, this.lblReferencia});
        AyudanteControl.habilitarExtendido((boolean)false, (Control[])new Control[]{this.txtEstadoJurisdiccion, this.txtCiudad, this.txtCalle, this.txtNumero, this.txtInterseccion, this.txtCodigoPostal, this.txtReferencia});
    }

    private void habilitarComponentes(ComboViewer[] cws, Combo[] cbs, boolean habilita) {
        ComboViewer[] comboViewerArray = cws;
        int n = cws.length;
        int n2 = 0;
        while (n2 < n) {
            ComboViewer cw = comboViewerArray[n2];
            cw.setSelection(null, !habilita);
            ++n2;
        }
        comboViewerArray = cbs;
        n = cbs.length;
        n2 = 0;
        while (n2 < n) {
            ComboViewer cb = comboViewerArray[n2];
            cb.setEnabled(habilita);
            ++n2;
        }
    }

    public void reenlazarDatos() {
        if (this.enlaceInicialRealizado) {
            this.m_bindingContext = this.initDataBindings();
        }
    }

    public void setModeloDatos(UbicacionBeneficiarioFinal modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)new ListenerValidacionModeloPaginaAsistente((InformacionValidable)this.modeloDatos, (PaginaAsistente)this));
        if (this.editando) {
            ElementoNombreValor nacionalidadUno = this.modeloValoresUbicacion.obtenerPais(this.modeloDatos.getNacionalidadUno());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvNacionalidadUno, (Object)nacionalidadUno);
            ElementoNombreValor nacionalidadDos = this.modeloValoresUbicacion.obtenerPais(this.modeloDatos.getNacionalidadDos());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvNacionalidadDos, (Object)nacionalidadDos);
            ElementoNombreValor nacionalidadTres = this.modeloValoresUbicacion.obtenerPais(this.modeloDatos.getNacionalidadTres());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvNacionalidadTres, (Object)nacionalidadTres);
            ElementoNombreValor residenciaFiscal = this.modeloValoresUbicacion.obtenerPais(this.modeloDatos.getResidenciaFiscal());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvResidenciaFiscal, (Object)residenciaFiscal);
            ElementoNombreValor provincia = this.modeloValoresUbicacion.obtenerProvincia(this.modeloDatos.getProvincia());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvProvincia, (Object)provincia);
            ElementoNombreValor canton = this.modeloValoresUbicacion.obtenerCanton(this.modeloDatos.getProvincia(), this.modeloDatos.getCanton());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvCanton, (Object)canton);
            ElementoNombreValor parroquia = this.modeloValoresUbicacion.obtenerParroquia(this.modeloDatos.getCanton(), this.modeloDatos.getParroquia());
            AyudanteViewer.seleccionarElemento((Viewer)this.cvParroquia, (Object)parroquia);
        }
    }

    public void inicializarModeloValores() {
        this.modeloValoresUbicacion = new ModeloValoresParticipacionUbicacion(this.tipoDeclaracion, this.tipoSociedad, null, null);
        this.modeloValoresUbicacion.inicializar();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProviderNacionalidadUno = new ObservableListContentProvider();
        IObservableMap observeMapNacionalidadUno = PojoObservables.observeMap((IObservableSet)listContentProviderNacionalidadUno.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvNacionalidadUno.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapNacionalidadUno));
        this.cvNacionalidadUno.setContentProvider((IContentProvider)listContentProviderNacionalidadUno);
        IObservableList modeloNacionalidadUnoObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValoresUbicacion, (String)"paises");
        this.cvNacionalidadUno.setInput((Object)modeloNacionalidadUnoObserveList);
        ObservableListContentProvider listContentProviderNacionalidadDos = new ObservableListContentProvider();
        IObservableMap observeMapNacionalidadDos = PojoObservables.observeMap((IObservableSet)listContentProviderNacionalidadDos.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvNacionalidadDos.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapNacionalidadDos));
        this.cvNacionalidadDos.setContentProvider((IContentProvider)listContentProviderNacionalidadDos);
        IObservableList modeloNacionalidadDosObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValoresUbicacion, (String)"paises");
        this.cvNacionalidadDos.setInput((Object)modeloNacionalidadDosObserveList);
        ObservableListContentProvider listContentProviderNacionalidadTres = new ObservableListContentProvider();
        IObservableMap observeMapNacionalidadTres = PojoObservables.observeMap((IObservableSet)listContentProviderNacionalidadTres.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvNacionalidadTres.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapNacionalidadTres));
        this.cvNacionalidadTres.setContentProvider((IContentProvider)listContentProviderNacionalidadTres);
        IObservableList modeloNacionalidadTresObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValoresUbicacion, (String)"paises");
        this.cvNacionalidadTres.setInput((Object)modeloNacionalidadTresObserveList);
        ObservableListContentProvider listContentProviderResidenciaFiscal = new ObservableListContentProvider();
        IObservableMap observeMapResidenciaFiscal = PojoObservables.observeMap((IObservableSet)listContentProviderResidenciaFiscal.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvResidenciaFiscal.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapResidenciaFiscal));
        this.cvResidenciaFiscal.setContentProvider((IContentProvider)listContentProviderResidenciaFiscal);
        IObservableList modeloResidenciaFiscalObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValoresUbicacion, (String)"paises");
        this.cvResidenciaFiscal.setInput((Object)modeloResidenciaFiscalObserveList);
        ISWTObservableValue txtEstadoJurisdiccionObserveWidget = SWTObservables.observeText((Control)this.txtEstadoJurisdiccion, (int[])new int[]{24, 16});
        IObservableValue modeloEstadoJurisdiccionObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"jurisdiccion");
        bindingContext.bindValue((IObservableValue)txtEstadoJurisdiccionObserveWidget, modeloEstadoJurisdiccionObserveValue, null, null);
        ObservableListContentProvider listContentProviderProvincias = new ObservableListContentProvider();
        IObservableMap observeMapProvincias = PojoObservables.observeMap((IObservableSet)listContentProviderProvincias.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvProvincia.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapProvincias));
        this.cvProvincia.setContentProvider((IContentProvider)listContentProviderProvincias);
        IObservableList modeloProvinciasObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValoresUbicacion, (String)"provincias");
        this.cvProvincia.setInput((Object)modeloProvinciasObserveList);
        ISWTObservableValue txtCiudadObserveWidget = SWTObservables.observeText((Control)this.txtCiudad, (int[])new int[]{24, 16});
        IObservableValue modeloCiudadObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"ciudad");
        bindingContext.bindValue((IObservableValue)txtCiudadObserveWidget, modeloCiudadObserveValue, null, null);
        ObservableListContentProvider listContentProviderCantones = new ObservableListContentProvider();
        IObservableMap observeMapCantones = PojoObservables.observeMap((IObservableSet)listContentProviderCantones.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvCanton.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapCantones));
        this.cvCanton.setContentProvider((IContentProvider)listContentProviderCantones);
        IObservableList modeloCantonesObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValoresUbicacion, (String)"cantones");
        this.cvCanton.setInput((Object)modeloCantonesObserveList);
        ObservableListContentProvider listContentProviderParroquias = new ObservableListContentProvider();
        IObservableMap observeMapParroquias = PojoObservables.observeMap((IObservableSet)listContentProviderParroquias.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvParroquia.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMapParroquias));
        this.cvParroquia.setContentProvider((IContentProvider)listContentProviderParroquias);
        IObservableList modeloParroquiasObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValoresUbicacion, (String)"parroquias");
        this.cvParroquia.setInput((Object)modeloParroquiasObserveList);
        ISWTObservableValue txtCalleObserveWidget = SWTObservables.observeText((Control)this.txtCalle, (int[])new int[]{24, 16});
        IObservableValue modeloCalleObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"calle");
        bindingContext.bindValue((IObservableValue)txtCalleObserveWidget, modeloCalleObserveValue, null, null);
        ISWTObservableValue txtNumeroObserveWidget = SWTObservables.observeText((Control)this.txtNumero, (int[])new int[]{24, 16});
        IObservableValue modeloNumeroObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"numero");
        bindingContext.bindValue((IObservableValue)txtNumeroObserveWidget, modeloNumeroObserveValue, null, null);
        ISWTObservableValue txtInterseccionObserveWidget = SWTObservables.observeText((Control)this.txtInterseccion, (int[])new int[]{24, 16});
        IObservableValue modeloInterseccionObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"interseccion");
        bindingContext.bindValue((IObservableValue)txtInterseccionObserveWidget, modeloInterseccionObserveValue, null, null);
        ISWTObservableValue txtCodigoPostalObserveWidget = SWTObservables.observeText((Control)this.txtCodigoPostal, (int[])new int[]{24, 16});
        IObservableValue modeloCodigoPostalObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"codigoPostal");
        bindingContext.bindValue((IObservableValue)txtCodigoPostalObserveWidget, modeloCodigoPostalObserveValue, null, null);
        ISWTObservableValue txtReferenciaObserveWidget = SWTObservables.observeText((Control)this.txtReferencia, (int[])new int[]{24, 16});
        IObservableValue modeloReferenciaObservable = BeansObservables.observeValue((Object)this.modeloDatos, (String)"referencia");
        bindingContext.bindValue((IObservableValue)txtReferenciaObserveWidget, modeloReferenciaObservable, null, null);
        return bindingContext;
    }
}

