/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.editores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.persistencia.AdministradorPersistencia;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoMensajes;
import ec.gob.sri.dimm.api.ui.editores.EditorBase;
import ec.gob.sri.dimm.aps.modelo.impl.AdministradorModeloAPS;
import ec.gob.sri.dimm.aps.modelo.obj.Informante;
import ec.gob.sri.dimm.aps.modelo.talonresumen.TalonResumenAPS;
import ec.gob.sri.dimm.aps.ui.editores.InputEditorAPS;
import ec.gob.sri.dimm.aps.ui.editores.InputEditorErroresInformacionAPS;
import ec.gob.sri.dimm.aps.ui.editores.InputEditorTalonAPS;
import ec.gob.sri.dimm.aps.ui.operaciones.OperacionValidacionAnexo;
import ec.gob.sri.dimm.aps.ui.paginas.PaginaBeneficiario;
import ec.gob.sri.dimm.aps.ui.paginas.PaginaPrincipal;
import ec.gob.sri.dimm.aps.ui.paginas.util.UtilValidacion;
import ec.gob.sri.dimm.aps.ui.recursos.Mensajes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.w3c.dom.Document;

public class EditorAPS
extends EditorBase<Informante, InputEditorAPS> {
    public static final String ID = "ec.gob.sri.dimm.aps.ui.editores.EditorAPS";
    private static final String PAG_PRINCIPAL = "p_PaginaPrincipal";
    private static final String PAG_BENEFICIARIO = "p_Beneficiario";
    private boolean puedeGenerarTalon = false;

    protected void addPages() {
        boolean esPeriodoDesde2024 = UtilValidacion.esAnexoDesdePeriodo2024(((Informante)this.modeloDatos).getAnio(), ((Informante)this.modeloDatos).getMes());
        PaginaPrincipal pPrincipal = new PaginaPrincipal(this, PAG_PRINCIPAL, "Participaciones", ((InputEditorAPS)this.datosInput).getAdminDatosAuxiliares());
        pPrincipal.setModeloDatos((Informante)this.modeloDatos);
        PaginaBeneficiario pBeneficiario = new PaginaBeneficiario(this, PAG_BENEFICIARIO, "Beneficiarios", ((InputEditorAPS)this.datosInput).getAdminDatosAuxiliares());
        pBeneficiario.setModeloDatos((Informante)this.modeloDatos);
        try {
            if (esPeriodoDesde2024) {
                if (((Informante)this.modeloDatos).getTipoDeclaracion().equals("02") && (((Informante)this.modeloDatos).getTipoSociedad().equals("08") || ((Informante)this.modeloDatos).getTipoSociedad().equals("09"))) {
                    this.addPage((IFormPage)pBeneficiario);
                    this.setActivePage(PAG_BENEFICIARIO);
                } else {
                    this.addPage((IFormPage)pPrincipal);
                    this.setActivePage(PAG_PRINCIPAL);
                    this.addPage((IFormPage)pBeneficiario);
                }
            } else {
                this.addPage((IFormPage)pPrincipal);
                this.setActivePage(PAG_PRINCIPAL);
            }
        }
        catch (PartInitException e) {
            PluginLogger.logError((String)"Error al inicializar el editor.", (String)"dimm-aps-ui", (Exception)((Object)e));
        }
    }

    protected List<Action> crearAccionesGenerales() {
        ArrayList<Action> acciones = new ArrayList<Action>();
        acciones.add(new Action("Generar XML"){

            public void run() {
                if (((Informante)EditorAPS.this.modeloDatos).getBeneficiarios().size() == 0 && UtilValidacion.esAnexoDesdePeriodo2024(((Informante)EditorAPS.this.modeloDatos).getAnio(), ((Informante)EditorAPS.this.modeloDatos).getMes())) {
                    EditorAPS.this.mostrarInformacion(String.format(Mensajes.ParticipacionNoExistenBeneficiarios, new Object[0]));
                    return;
                }
                AdministradorModeloAPS adminModelo = new AdministradorModeloAPS();
                String rutaTemporalXML = AdministradorPersistencia.generarRutaArchivoXMLTemporal();
                File archivoXMLTemporal = new File(rutaTemporalXML);
                System.out.println("Tipo sociedad: " + ((Informante)EditorAPS.this.modeloDatos).getTipoSociedad());
                System.out.println("Tipo declaracion: " + ((Informante)EditorAPS.this.modeloDatos).getTipoDeclaracion());
                Document documentoFinal = adminModelo.exportar((Informante)EditorAPS.this.modeloDatos);
                AdministradorPersistencia.generarXML((String)rutaTemporalXML, (Document)documentoFinal);
                ProgressMonitorDialog pmValidar = new ProgressMonitorDialog(EditorAPS.this.getSite().getShell());
                OperacionValidacionAnexo operacionValidacion = new OperacionValidacionAnexo(archivoXMLTemporal);
                try {
                    pmValidar.run(true, false, (IRunnableWithProgress)operacionValidacion);
                }
                catch (InvocationTargetException e) {
                    PluginLogger.logError((String)"Error inesperado al validar el anexo.", (String)"dimm-aps-ui", (Exception)e);
                    EditorAPS.this.mostrarError("Se ha producido un error al validar el anexo: " + e.getMessage());
                    return;
                }
                catch (InterruptedException e) {
                    PluginLogger.logError((String)"Proceso de validacion interrumpido.", (String)"dimm-aps-ui", (Exception)e);
                    EditorAPS.this.mostrarError(e.getMessage());
                    return;
                }
                ResultadoValidacion resultadoEsquema = operacionValidacion.getResultadoValidacionEsquema();
                if (resultadoEsquema != null && (resultadoEsquema.tieneVariosErrores() || resultadoEsquema.tieneVariasAdvertencias())) {
                    DialogoMensajes mensajesEsquema = new DialogoMensajes(EditorAPS.this.getSite(), "Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", resultadoEsquema.getMensajes());
                    mensajesEsquema.open();
                    return;
                }
                File archivoErroresValidacion = operacionValidacion.getArchivoErroresInformacion();
                if (archivoErroresValidacion != null) {
                    InputEditorErroresInformacionAPS datosInput = new InputEditorErroresInformacionAPS(archivoErroresValidacion, archivoXMLTemporal);
                    try {
                        EditorAPS.this.getSite().getPage().openEditor((IEditorInput)datosInput, "ec.gob.sri.dimm.aps.ui.editores.EditorErroresInformacionAPS");
                    }
                    catch (PartInitException e) {
                        EditorAPS.this.mostrarError("Se ha producido un problema al abrir el visor de errores de validaci\u00f3n: " + e.getMessage());
                        PluginLogger.logError((String)"Error al mostrar errores de validacion de informacion", (String)"dimm-aps-ui", (Exception)((Object)e));
                    }
                    return;
                }
                archivoXMLTemporal.delete();
                FileDialog saveDialog = new FileDialog(EditorAPS.this.getEditorSite().getShell(), 8192);
                saveDialog.setFilterNames(new String[]{"Archivos XML"});
                saveDialog.setFilterExtensions(new String[]{"*.xml"});
                saveDialog.setText("Guardar");
                Calendar c = Calendar.getInstance();
                saveDialog.setFileName("APS-" + c.get(5) + "-" + (c.get(2) + 1) + "-" + c.get(1) + ".xml");
                String rutaFinal = saveDialog.open();
                if (!StringUtil.isNullOrEmpty((String)rutaFinal)) {
                    File archivoFinal;
                    String extension = "";
                    if (!rutaFinal.toUpperCase().endsWith(".XML")) {
                        extension = ".xml";
                    }
                    if ((archivoFinal = new File(String.valueOf(rutaFinal) + extension)).exists()) {
                        if (EditorAPS.this.mostrarConfirmacion("El archivo ya existe. \u00bfDesea sobreescribirlo?")) {
                            archivoFinal.delete();
                        } else {
                            EditorAPS.this.mostrarInformacion("Exportaci\u00f3n cancelada.");
                            return;
                        }
                    }
                    AdministradorPersistencia.generarXML((String)archivoFinal.getAbsolutePath(), (Document)documentoFinal);
                    EditorAPS.this.mostrarInformacion("Archivo generado exitosamente.");
                    EditorAPS.this.puedeGenerarTalon = true;
                }
            }
        });
        acciones.add(new Action("Tal\u00f3n Resumen"){

            public void run() {
                block8: {
                    if (EditorAPS.this.puedeGenerarTalon) {
                        TalonResumenAPS talonResumen = new TalonResumenAPS();
                        try {
                            File archivoTalonResumen = talonResumen.generarTalonResumen((Informante)EditorAPS.this.modeloDatos);
                            if (archivoTalonResumen == null) {
                                EditorAPS.this.mostrarError("Se ha producido un error al procesar el tal\u00f3 resumen.");
                                break block8;
                            }
                            try {
                                InputEditorTalonAPS datosInput = new InputEditorTalonAPS(archivoTalonResumen);
                                EditorAPS.this.getSite().getPage().openEditor((IEditorInput)datosInput, "ec.gob.sri.dimm.aps.ui.editores.EditorTalonAPS");
                            }
                            catch (PartInitException e) {
                                EditorAPS.this.mostrarError("Se ha producido un error al abrir el tal\u00f3n de resumen: " + e.getMessage());
                            }
                        }
                        catch (FileNotFoundException e1) {
                            EditorAPS.this.mostrarError("Se ha producido un error al abrir el tal\u00f3n de resumen: " + e1.getMessage());
                        }
                        catch (IOException e1) {
                            EditorAPS.this.mostrarError("Se ha producido un error al abrir el tal\u00f3n de resumen: " + e1.getMessage());
                        }
                    } else {
                        EditorAPS.this.mostrarError("No se puede generar el Tal\u00f3n de Resumen sin haber exportado previamente el Archivo XML");
                    }
                }
            }
        });
        return acciones;
    }

    public AdministradorPersistencia<Informante> obtenerAdministradorPersistencia() {
        if (this.administradorPersistencia == null) {
            this.administradorPersistencia = new AdministradorPersistencia(((Informante)this.modeloDatos).getIdentificacion(), ((Informante)this.modeloDatos).getAnio(), ((Informante)this.modeloDatos).getMes());
        }
        return this.administradorPersistencia;
    }
}

