/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.editores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.aps.ui.editores.InputEditorErroresInformacionAPS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import swing2swt.layout.BorderLayout;

public class EditorErroresInformacionAPS
extends EditorPart {
    public static final String ID = "ec.gob.sri.dimm.aps.ui.editores.EditorErroresInformacionAPS";
    private File archivoErrores;
    private File archivoAnexo;
    private Text txtErroresInfo;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new BorderLayout(0, 0));
        ToolBar tbErroresInfo = new ToolBar(container, 0x820000);
        tbErroresInfo.setLayoutData((Object)"North");
        ToolItem tiGuardar = new ToolItem(tbErroresInfo, 0);
        tiGuardar.setImage(ResourceManager.getPluginImage((String)"org.eclipse.ui", (String)"/icons/full/etool16/save_edit.gif"));
        tiGuardar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialogoGuardarErrores = new FileDialog(EditorErroresInformacionAPS.this.getSite().getShell(), 8192);
                dialogoGuardarErrores.setText("Guardar archivo de errores de informaci\u00f3n");
                dialogoGuardarErrores.setFilterNames(new String[]{"Documento de Texto"});
                dialogoGuardarErrores.setFilterExtensions(new String[]{"*.txt"});
                String rutaArchivo = dialogoGuardarErrores.open();
                if (!StringUtil.isNullOrEmpty((String)rutaArchivo)) {
                    FileInputStream inStream = null;
                    FileOutputStream outStream = null;
                    try {
                        int length;
                        File destino = new File(rutaArchivo);
                        if (destino.exists()) {
                            if (!MessageDialog.openQuestion((Shell)EditorErroresInformacionAPS.this.getSite().getShell(), (String)"Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", (String)String.format("El archivo %s ya existe.%n%n\u00bfDesea reemplazarlo?", destino.getAbsoluteFile()))) {
                                return;
                            }
                            if (!destino.delete()) {
                                MessageDialog.openError((Shell)EditorErroresInformacionAPS.this.getSite().getShell(), (String)"Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", (String)"No se ha podido eliminar el archivo existente.");
                            }
                        }
                        inStream = new FileInputStream(EditorErroresInformacionAPS.this.archivoErrores);
                        outStream = new FileOutputStream(destino);
                        byte[] buffer = new byte[1024];
                        while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                            ((OutputStream)outStream).write(buffer, 0, length);
                        }
                        ((InputStream)inStream).close();
                        ((OutputStream)outStream).close();
                        MessageDialog.openInformation((Shell)EditorErroresInformacionAPS.this.getSite().getShell(), (String)"Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", (String)"Archivo guardado correctamente.");
                    }
                    catch (IOException ex) {
                        PluginLogger.logError((String)"Error al guardar archivo de errores", (String)"dimm-aps-ui", (Exception)ex);
                        MessageDialog.openError((Shell)EditorErroresInformacionAPS.this.getSite().getShell(), (String)"Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", (String)"Se ha producido un error al guardar el archivo de errores de validaci\u00f3n de informaci\u00f3n del anexo.");
                    }
                }
            }
        });
        tiGuardar.setText("Guardar");
        Composite cErroresInfo = new Composite(container, 0);
        cErroresInfo.setLayoutData((Object)"Center");
        cErroresInfo.setLayout((Layout)new BorderLayout(0, 5));
        this.txtErroresInfo = new Text(cErroresInfo, 2818);
        this.txtErroresInfo.setBackground(SWTResourceManager.getColor((int)1));
        this.txtErroresInfo.setEditable(false);
        this.txtErroresInfo.setLayoutData((Object)"Center");
        this.txtErroresInfo.setText(this.cargarDatosArchivoErrores());
        Composite cAnexoInfo = new Composite(cErroresInfo, 0);
        cAnexoInfo.setLayoutData((Object)"North");
        FillLayout fl_cAnexoInfo = new FillLayout(512);
        fl_cAnexoInfo.marginWidth = 5;
        fl_cAnexoInfo.marginHeight = 5;
        fl_cAnexoInfo.spacing = 3;
        cAnexoInfo.setLayout((Layout)fl_cAnexoInfo);
        Label lblAnexoValidado = new Label(cAnexoInfo, 0);
        lblAnexoValidado.setText("Anexo Validado:");
        Label lblRutaAnexoValidado = new Label(cAnexoInfo, 0);
        lblRutaAnexoValidado.setFont(SWTResourceManager.getBoldFont((Font)lblRutaAnexoValidado.getFont()));
        lblRutaAnexoValidado.setText(this.archivoAnexo.getAbsolutePath());
    }

    private String cargarDatosArchivoErrores() {
        StringBuilder sb;
        block9: {
            sb = new StringBuilder();
            Scanner scanner = null;
            try {
                try {
                    scanner = new Scanner(this.archivoErrores);
                    while (scanner.hasNextLine()) {
                        sb.append(String.format("%s%n", scanner.nextLine()));
                    }
                }
                catch (FileNotFoundException e) {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", (String)"Se ha producido un error al leer el archivo de errores de informaci\u00f3n.");
                    PluginLogger.logError((String)"Error al leer archivo de errores de informacion.", (String)"dimm-aps-ui", (Exception)e);
                    if (scanner != null) {
                        scanner.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (scanner != null) {
                    scanner.close();
                }
                throw throwable;
            }
            if (scanner != null) {
                scanner.close();
            }
        }
        return sb.toString();
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        InputEditorErroresInformacionAPS inputTalon = (InputEditorErroresInformacionAPS)input;
        this.archivoErrores = inputTalon.getArchivoErrores();
        this.archivoAnexo = inputTalon.getArchivoAnexo();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

