/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.menu;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoMensajes;
import ec.gob.sri.dimm.aps.ui.asistentes.AsistenteValidarAPS;
import ec.gob.sri.dimm.aps.ui.editores.InputEditorErroresInformacionAPS;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class ValidarAPSHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
        AsistenteValidarAPS asistente = new AsistenteValidarAPS();
        WizardDialog dialogoAsistenteValidar = new WizardDialog(shell, (IWizard)asistente);
        dialogoAsistenteValidar.setTitle("Validar Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)");
        if (dialogoAsistenteValidar.open() == 0) {
            ResultadoValidacion resultadoEsquema = asistente.getResultadoValidacion();
            File archivoErroresValidacion = asistente.getArchivoErroresInformacion();
            if (resultadoEsquema != null && (resultadoEsquema.tieneVariosErrores() || resultadoEsquema.tieneVariasAdvertencias())) {
                DialogoMensajes mensajesEsquema = new DialogoMensajes(shell, "Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", resultadoEsquema.getMensajes());
                mensajesEsquema.open();
                return null;
            }
            if (archivoErroresValidacion != null) {
                InputEditorErroresInformacionAPS datosInput = new InputEditorErroresInformacionAPS(archivoErroresValidacion, asistente.getArchivoAnexo());
                try {
                    IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                    IWorkbenchPage page = window.getActivePage();
                    page.openEditor((IEditorInput)datosInput, "ec.gob.sri.dimm.aps.ui.editores.EditorErroresInformacionAPS");
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)shell, (String)"Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", (String)("Se ha producido un error al abrir el visor de errores de validaci\u00f3n: " + e.getMessage()));
                    PluginLogger.logError((String)"Error al mostrar errores de validacion de informacion", (String)"dimm-aps-ui", (Exception)((Object)e));
                }
                return null;
            }
            MessageDialog.openInformation((Shell)shell, (String)"Reporte de Beneficiarios Finales y de Composici\u00f3n Societaria (REBEFICS)", (String)String.format("La informaci\u00f3n del archivo se valid\u00f3 completamente.%n%nNo se encontraron problemas.", new Object[0]));
            return null;
        }
        return null;
    }
}

