/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.operaciones;

import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.AdministradorPersistencia;
import ec.gob.sri.dimm.api.modelo.persistencia.ArchivoTemporalAnexo;
import ec.gob.sri.dimm.aps.modelo.obj.AdaptadorInformanteSujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.Beneficiario;
import ec.gob.sri.dimm.aps.modelo.obj.Informante;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.ui.editores.InputEditorAPS;
import ec.gob.sri.dimm.aps.ui.paginas.util.AdministradorDatosAuxiliares;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class OperacionEdicionAnexo
implements IRunnableWithProgress {
    private InputEditorAPS datosInputEditarAPS = null;
    private ArchivoTemporalAnexo archivoAnexo;

    public OperacionEdicionAnexo(ArchivoTemporalAnexo archivoAnexo) {
        this.archivoAnexo = archivoAnexo;
    }

    public InputEditorAPS getDatosInputEditarAPS() {
        return this.datosInputEditarAPS;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        AdministradorPersistencia administradorPersistencia = new AdministradorPersistencia();
        Informante modeloDatos = (Informante)administradorPersistencia.desSerializarObjeto(this.archivoAnexo, Informante.class);
        if (modeloDatos == null) {
            throw new InterruptedException("No ha sido posible recuperar los datos del archivo seleccionado.");
        }
        HashMap<String, SujetoRelacionado> cacheSujetos = new HashMap<String, SujetoRelacionado>();
        this.extraerSujetos(cacheSujetos, modeloDatos.getParticipaciones());
        this.asegurarInformanteCacheSujetos(cacheSujetos, modeloDatos);
        HashMap<String, List<Participacion>> participacionesPorSujeto = new HashMap<String, List<Participacion>>();
        AdministradorDatosAuxiliares.determinarParticipacionesPorSujeto(participacionesPorSujeto, cacheSujetos);
        HashMap<String, List<Beneficiario>> beneficiarios = new HashMap<String, List<Beneficiario>>();
        AdministradorDatosAuxiliares adminDatos = new AdministradorDatosAuxiliares(cacheSujetos, participacionesPorSujeto, beneficiarios, modeloDatos.getTipoSociedad());
        this.datosInputEditarAPS = new InputEditorAPS(modeloDatos.getIdentificacion(), modeloDatos.getAnio(), modeloDatos.getMes(), modeloDatos.getRazonSocial());
        this.datosInputEditarAPS.setModeloDatos((RaizModelo)modeloDatos);
        this.datosInputEditarAPS.setAdminDatosAuxiliares(adminDatos);
    }

    private void asegurarInformanteCacheSujetos(Map<String, SujetoRelacionado> cacheSujetos, Informante modeloDatos) {
        if (!cacheSujetos.containsKey(modeloDatos.getIdentificacion())) {
            AdaptadorInformanteSujetoRelacionado sujetoInformante = new AdaptadorInformanteSujetoRelacionado(modeloDatos);
            sujetoInformante.setBeneficiariosFinales(modeloDatos.getBeneficiarios());
            cacheSujetos.put(modeloDatos.getIdentificacion(), (SujetoRelacionado)sujetoInformante);
        }
    }

    private void extraerSujetos(Map<String, SujetoRelacionado> cacheSujetos, List<Participacion> participaciones) {
        for (Participacion participacion : participaciones) {
            SujetoRelacionado sujeto = participacion.getSujeto();
            if (cacheSujetos.containsKey(sujeto.getIdentificacion())) continue;
            cacheSujetos.put(sujeto.getIdentificacion(), sujeto);
            List participacionesSujeto = sujeto.getParticipaciones();
            if (participacionesSujeto == null || participacionesSujeto.isEmpty()) continue;
            this.extraerSujetos(cacheSujetos, participacionesSujeto);
        }
    }
}

