/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.operaciones;

import com.ibm.icu.text.SimpleDateFormat;
import ec.gob.sri.anexo.validacion.modelo.ContextoErrores;
import ec.gob.sri.anexo.validacion.modelo.ErrorDetalleAnexoValidacion;
import ec.gob.sri.anexo.validacion.modelo.ErrorValidacion;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.aps.validacion.ValidacionAPS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class OperacionValidacionAnexo
implements IRunnableWithProgress {
    private File archivoXML;
    private File archivoErroresInformacion = null;
    private ResultadoValidacion resultadoValidacionEsquema = null;

    public OperacionValidacionAnexo(File archivoXML) {
        this.archivoXML = archivoXML;
    }

    public File getArchivoErroresInformacion() {
        return this.archivoErroresInformacion;
    }

    public ResultadoValidacion getResultadoValidacionEsquema() {
        return this.resultadoValidacionEsquema;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Preparando la validaci\u00f3n", -1);
        Thread.sleep(1000L);
        monitor.setTaskName("Aplicando validaci\u00f3n de esquema");
        Thread.sleep(500L);
        ResultadoValidacion resultado = null;
        try {
            resultado = ValidacionAPS.validarEsquema((File)this.archivoXML);
        }
        catch (FileNotFoundException e) {
            monitor.done();
            PluginLogger.logError((String)"Archivo no existente.", (String)"dimm-aps-ui", (Exception)e);
            throw new InterruptedException("El archivo '" + this.archivoXML.getAbsolutePath() + "' no existe.");
        }
        if (resultado != null && (resultado.tieneVariosErrores() || resultado.tieneVariasAdvertencias())) {
            this.resultadoValidacionEsquema = resultado;
            monitor.done();
            return;
        }
        monitor.setTaskName("Validando la integridad de la informaci\u00f3n");
        Thread.sleep(500L);
        ValidacionAPS validacionAPS = new ValidacionAPS(this.archivoXML);
        ContextoErrores ctxErrores = validacionAPS.validarInformacion();
        if (ctxErrores.isHasErrors()) {
            String tempHome = System.getProperty("java.io.tmpdir");
            File archivoSalida = new File(String.format("%sAPS_%s.txt", tempHome, new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date())));
            try {
                PrintWriter writer = new PrintWriter(archivoSalida);
                writer.format("ARCHIVO VALIDADO: %s", this.archivoXML.getAbsolutePath());
                writer.println();
                writer.println("ADVERTENCIAS:");
                for (Object key : ctxErrores.getWarningsAcumulados()) {
                    writer.println(key.getDescripcion());
                }
                writer.println();
                writer.println("ERRORES:");
                for (Object key : ctxErrores.getErroresAcumulados().keySet()) {
                    writer.println(key);
                    for (ErrorValidacion error : ((ErrorDetalleAnexoValidacion)ctxErrores.getErroresAcumulados().get(key)).getListaErrores()) {
                        writer.println(error.getDescripcion());
                    }
                }
                writer.flush();
                writer.close();
                this.archivoErroresInformacion = archivoSalida;
            }
            catch (FileNotFoundException e) {
                monitor.done();
                PluginLogger.logError((String)"Error al escribir el archivo de errores", (String)"dimm-aps-ui", (Exception)e);
                throw new InterruptedException("No se puede escribir el archivo de errores.");
            }
        }
        monitor.done();
    }
}

