/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.paginas.util;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.MensajeValidacion;
import ec.gob.sri.dimm.aps.modelo.obj.AdaptadorInformanteSujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.Beneficiario;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.ui.Portador;
import ec.gob.sri.dimm.aps.modelo.obj.ui.SujetoProblemas;
import ec.gob.sri.dimm.aps.modelo.obj.ui.TipoProblema;
import ec.gob.sri.dimm.aps.ui.Constantes;
import ec.gob.sri.dimm.aps.ui.paginas.util.UtilValidacion;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdministradorDatosAuxiliares
extends ObjetoModelo {
    private static final long serialVersionUID = 3067452503271600832L;
    private static final String M_SUJETO_NO_TIENE_ADMINISTRADORES = "El sujeto no tiene registrado ning\u00fan ADMINISTRADOR.";
    private static final String M_SUJETO_NO_TIENE_MIEMBROS_DIRECTORIO = "El sujeto no tiene registrado ning\u00fan MIEMBRO DE DIRECTORIO.";
    private static final String M_SUJETO_NO_TIENE_APODERADO_GENERAL = "El sujeto no tiene registrado ning\u00fan APODERADO GENERAL.";
    private static final String M_SUJETO_NO_TIENE_PARTICIPES = "El sujeto no tiene registrado ning\u00fan PARTICIPE.";
    private Deque<SujetoRelacionado> historialSujetos = new ArrayDeque<SujetoRelacionado>();
    private Map<String, SujetoRelacionado> cacheSujetos;
    private Map<String, SujetoProblemas> sujetosIncompletos = new HashMap<String, SujetoProblemas>();
    private Map<String, List<MensajeValidacion>> mensajesProblemas = new HashMap<String, List<MensajeValidacion>>();
    private Map<String, List<Participacion>> participacionesPorSujeto;
    private Map<String, List<Beneficiario>> beneficiarios;
    private String tipoSociedadInformante;

    public AdministradorDatosAuxiliares() {
        this.cacheSujetos = new HashMap<String, SujetoRelacionado>();
        this.participacionesPorSujeto = new HashMap<String, List<Participacion>>();
        this.beneficiarios = new HashMap<String, List<Beneficiario>>();
    }

    public AdministradorDatosAuxiliares(Map<String, SujetoRelacionado> cacheSujetos, Map<String, List<Participacion>> participacionesPorSujeto, Map<String, List<Beneficiario>> beneficiarios, String tipoSociedadInformante) {
        this.cacheSujetos = cacheSujetos;
        this.participacionesPorSujeto = participacionesPorSujeto;
        this.beneficiarios = beneficiarios;
        this.tipoSociedadInformante = tipoSociedadInformante;
        this.determinarSujetosIncompletos();
    }

    public List<SujetoRelacionado> getListaHistorialSujetos() {
        return new ArrayList<SujetoRelacionado>(this.historialSujetos);
    }

    public Deque<SujetoRelacionado> getHistorialSujetos() {
        return this.historialSujetos;
    }

    public Map<String, SujetoRelacionado> getCacheSujetos() {
        return this.cacheSujetos;
    }

    public List<SujetoProblemas> getListaSujetosIncompletos() {
        return new ArrayList<SujetoProblemas>(this.sujetosIncompletos.values());
    }

    public Map<String, SujetoProblemas> getSujetosIncompletos() {
        return this.sujetosIncompletos;
    }

    public List<MensajeValidacion> obtenerMensajesProblemasSujetos(String idSujeto) {
        List<MensajeValidacion> mensajesProblemasSujeto = this.mensajesProblemas.get(idSujeto);
        if (mensajesProblemasSujeto == null) {
            mensajesProblemasSujeto = new ArrayList<MensajeValidacion>();
            this.mensajesProblemas.put(idSujeto, mensajesProblemasSujeto);
        }
        return mensajesProblemasSujeto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verificarSujetoIncompleto(SujetoRelacionado sujeto) {
        boolean esInformante = sujeto instanceof AdaptadorInformanteSujetoRelacionado;
        String identificacionSujeto = sujeto.getIdentificacion();
        List<MensajeValidacion> mensajesProblemasSujeto = this.obtenerMensajesProblemasSujetos(identificacionSujeto);
        mensajesProblemasSujeto.clear();
        if (!esInformante && (!"E".equals(sujeto.getTipoIdentificacion()) || "00".equals(sujeto.getTipoSociedadExtranjera()) || sujeto.isSociedadExtranjeraPublica())) return false;
        boolean sujetoUtilizado = this.tieneSujetoParticipacionesAsociadas(identificacionSujeto);
        boolean sujetoVacio = sujeto.getParticipaciones().isEmpty();
        if (sujetoVacio && (sujetoUtilizado || esInformante)) {
            if (!sujetoVacio) return false;
            if (Integer.valueOf(sujeto.getPeriodo()) >= 2022) {
                if (!sujeto.isMenorDiezPorciento()) {
                    if (this.tipoSociedadInformante == null) {
                        mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ninguna participaci\u00f3n o sujeto relacionado asociado."));
                        return this.registrarSujetoIncompleto(identificacionSujeto, sujeto, TipoProblema.ERROR);
                    }
                    if (this.tipoSociedadInformante.equals("10")) return false;
                    mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ninguna participaci\u00f3n o sujeto relacionado asociado."));
                    return this.registrarSujetoIncompleto(identificacionSujeto, sujeto, TipoProblema.ERROR);
                }
                if (this.sujetosIncompletos.remove(identificacionSujeto) == null) return false;
                return true;
            }
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ninguna participaci\u00f3n o sujeto relacionado asociado."));
            return this.registrarSujetoIncompleto(identificacionSujeto, sujeto, TipoProblema.ERROR);
        }
        Portador tipoProblema = new Portador((Object)TipoProblema.ERROR);
        if (this.tieneSujetoProblemas(sujeto, esInformante, mensajesProblemasSujeto, (Portador<TipoProblema>)tipoProblema)) {
            return this.registrarSujetoIncompleto(identificacionSujeto, sujeto, (TipoProblema)tipoProblema.valor);
        }
        if (this.sujetosIncompletos.remove(identificacionSujeto) == null) return false;
        return true;
    }

    public void registrarParticipacionPorSujeto(Participacion participacion) {
        String idSujeto = participacion.getSujeto().getIdentificacion();
        List<Participacion> participacionesDelSujeto = this.participacionesPorSujeto.get(idSujeto);
        if (participacionesDelSujeto == null) {
            participacionesDelSujeto = new ArrayList<Participacion>();
            this.participacionesPorSujeto.put(idSujeto, participacionesDelSujeto);
        }
        if (!participacionesDelSujeto.contains(participacion)) {
            participacionesDelSujeto.add(participacion);
        }
    }

    public boolean quitarParticipacionPorSujeto(Participacion participacion) {
        String idSujeto = participacion.getSujeto().getIdentificacion();
        List<Participacion> participacionesDelSujeto = this.participacionesPorSujeto.get(idSujeto);
        if (participacionesDelSujeto == null || participacionesDelSujeto.isEmpty()) {
            return false;
        }
        participacionesDelSujeto.remove(participacion);
        return !participacionesDelSujeto.isEmpty();
    }

    public boolean quitarBeneficiarioFinal(Beneficiario beneficiario) {
        String idBeneficiarioFinal = beneficiario.getNumeroIdentificacion();
        System.out.println(idBeneficiarioFinal);
        return true;
    }

    public void registrarBeneficiario(Beneficiario beneficiario) {
        String idBeneficiario = beneficiario.getNumeroIdentificacion();
        ArrayList<Beneficiario> listaBeneficiarios = new ArrayList<Beneficiario>();
        listaBeneficiarios.add(beneficiario);
        System.out.println("Se agrega el Beneficiario Final: " + idBeneficiario);
        this.beneficiarios.put(idBeneficiario, listaBeneficiarios);
    }

    public boolean quitarBeneficiario(Beneficiario beneficiario) {
        String idBeneficiarioFinal = beneficiario.getNumeroIdentificacion();
        System.out.println("Se elimina el Beneficiario Final: " + idBeneficiarioFinal);
        this.beneficiarios.remove(beneficiario);
        return true;
    }

    public boolean tieneSujetoParticipacionesAsociadas(String idSujeto) {
        List<Participacion> participacionesDelSujeto = this.participacionesPorSujeto.get(idSujeto);
        return participacionesDelSujeto != null && !participacionesDelSujeto.isEmpty();
    }

    public List<Participacion> obtenerParticipacionesPorSujeto(String idSujeto) {
        return this.participacionesPorSujeto.get(idSujeto);
    }

    private void determinarSujetosIncompletos() {
        for (SujetoRelacionado sujeto : this.cacheSujetos.values()) {
            this.verificarSujetoIncompleto(sujeto);
        }
    }

    private boolean tieneSujetoProblemas(SujetoRelacionado sujeto, boolean esInformante, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        String tipoSociedad;
        boolean consistente = true;
        boolean sumaCorrecta = true;
        boolean sumaCorrectaSR06 = true;
        boolean sumaCorrectaSR07 = true;
        int anioPeriodo = 0;
        anioPeriodo = sujeto.getPeriodo() == null ? Integer.valueOf(((AdaptadorInformanteSujetoRelacionado)sujeto).getInformante().getAnio()).intValue() : Integer.valueOf(sujeto.getPeriodo()).intValue();
        String string = tipoSociedad = esInformante ? ((AdaptadorInformanteSujetoRelacionado)sujeto).getInformante().getTipoSociedad() : sujeto.getTipoSociedadExtranjera();
        if (UtilValidacion.esAnexoDesdePeriodo2024(sujeto.getPeriodo(), sujeto.getMes())) {
            if ("03".equals(tipoSociedad)) {
                consistente = this.esSociedadFideicomisoConsistente(sujeto, mensajesProblemasSujeto, tipoProblema);
            }
            if ("01".equals(tipoSociedad) || "02".equals(tipoSociedad)) {
                consistente = this.esSociedadGeneralOSociedadCotizaConsistente(sujeto, mensajesProblemasSujeto, tipoProblema);
            }
            if ("04".equals(tipoSociedad)) {
                consistente = this.esSociedadSinFinesLucroConsistente(sujeto, mensajesProblemasSujeto, tipoProblema);
            }
            if ("07".equals(tipoSociedad)) {
                consistente = this.esSociedadFondosInversionComplemteariosOtrosConsistente(sujeto, mensajesProblemasSujeto, tipoProblema);
            }
            if ("05".equals(tipoSociedad) || "06".equals(tipoSociedad)) {
                consistente = this.esSociedadPopularSolidarioConsistente(sujeto, mensajesProblemasSujeto, tipoProblema);
            }
            if ("02".equals(tipoSociedad)) {
                sumaCorrecta = this.verificarSumaPorcentaje(sujeto, mensajesProblemasSujeto, tipoProblema, false);
            } else if ("01".equals(tipoSociedad) || "07".equals(tipoSociedad)) {
                sumaCorrecta = this.verificarSumaPorcentaje(sujeto, mensajesProblemasSujeto, tipoProblema, true);
            } else if ("03".equals(tipoSociedad)) {
                sumaCorrectaSR06 = this.verificarSumaPorcentajeTipoRelacionado06(sujeto, mensajesProblemasSujeto, tipoProblema, true);
                sumaCorrectaSR07 = this.verificarSumaPorcentajeTipoRelacionado07(sujeto, mensajesProblemasSujeto, tipoProblema, true);
            } else if ("06".equals(tipoSociedad) || "05".equals(tipoSociedad)) {
                sumaCorrecta = this.verificarSumaPorcentaje(sujeto, mensajesProblemasSujeto, tipoProblema, false);
            }
        } else {
            if ("01".equals(tipoSociedad)) {
                consistente = this.esSociedadGeneralConsistente(sujeto, mensajesProblemasSujeto, tipoProblema);
            } else if ("02".equals(tipoSociedad)) {
                consistente = this.esSociedadCotizaBolsaConsistente(sujeto, mensajesProblemasSujeto, tipoProblema);
            } else if ("03".equals(tipoSociedad)) {
                consistente = this.esFideicomisoConsistente(sujeto, mensajesProblemasSujeto, tipoProblema);
            } else if ("04".equals(tipoSociedad) || "05".equals(tipoSociedad) || "06".equals(tipoSociedad)) {
                consistente = this.esSinFinLucroSEconomicoPSSFinancieroPSConsistente(sujeto, mensajesProblemasSujeto, tipoProblema);
            } else if ("07".equals(tipoSociedad)) {
                consistente = this.esFondoInversionConsistente(sujeto, mensajesProblemasSujeto, tipoProblema);
            }
            sumaCorrecta = "01".equals(tipoSociedad) ? this.verificarSumaSociedadGeneral(sujeto, mensajesProblemasSujeto, tipoProblema, anioPeriodo) : ("02".equals(tipoSociedad) ? this.verificarSumaPorcentajeNoCotizaBolsa(sujeto, mensajesProblemasSujeto, tipoProblema) : ("03".equals(tipoSociedad) ? this.verificarSumaFideicomisos(sujeto, mensajesProblemasSujeto, tipoProblema, anioPeriodo) : ("07".equals(tipoSociedad) ? this.verificarSumaFondoInversion(sujeto, mensajesProblemasSujeto, tipoProblema, anioPeriodo) : this.verificarSumaSinFinLucroSocEconFinPopularSolidario(sujeto, mensajesProblemasSujeto, tipoProblema))));
        }
        return !consistente || !sumaCorrecta || !sumaCorrectaSR06 || !sumaCorrectaSR07;
    }

    private boolean verificarSumaPorcentajeTipoRelacionado07(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema, boolean debeSerCien) {
        boolean porcentajeCorrecto = true;
        BigDecimal sumatoria = BigDecimal.ZERO;
        for (Participacion p : sujeto.getParticipaciones()) {
            if (!p.getTipoDeRelacion().equals("07") || !debeSerCien || (sumatoria = new BigDecimal(p.getPorcentajeParticipacion())).compareTo(Constantes.CIEN) >= 0) continue;
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La participacion con identificacion " + p.getSujeto().getIdentificacion() + " con sujero relacionado BENEFICIARIO O FIDEICOMISARIO, debe alcanzar el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            porcentajeCorrecto = false;
        }
        return porcentajeCorrecto;
    }

    private boolean verificarSumaPorcentajeTipoRelacionado06(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema, boolean debeSerCien) {
        boolean porcentajeCorrecto = true;
        BigDecimal sumatoria = BigDecimal.ZERO;
        for (Participacion p : sujeto.getParticipaciones()) {
            if (!p.getTipoDeRelacion().equals("06") || !debeSerCien || (sumatoria = new BigDecimal(p.getPorcentajeParticipacion())).compareTo(Constantes.CIEN) >= 0) continue;
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La participacion con identificacion " + p.getSujeto().getIdentificacion() + " con sujero relacionado CONSTITUYENTE O FIDEICOMITENTE, debe alcanzar el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            porcentajeCorrecto = false;
        }
        return porcentajeCorrecto;
    }

    private boolean esSociedadPopularSolidarioConsistente(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        boolean tieneMiembrosDirectorio = false;
        boolean tieneAdministradores = false;
        boolean tieneTitularesDerecho = false;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            if ("05".equals(tipoRelacion)) {
                tieneAdministradores = true;
                continue;
            }
            if ("04".equals(tipoRelacion)) {
                tieneMiembrosDirectorio = true;
                continue;
            }
            if (!"10".equals(tipoRelacion)) continue;
            tieneTitularesDerecho = true;
        }
        if (!tieneAdministradores) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_ADMINISTRADORES));
        }
        if (!tieneTitularesDerecho) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan TITULARES DE DERECHO."));
        }
        if (!tieneMiembrosDirectorio) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_MIEMBROS_DIRECTORIO));
        }
        if (!(tieneAdministradores && tieneTitularesDerecho && tieneMiembrosDirectorio)) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        return tieneAdministradores && tieneTitularesDerecho && tieneMiembrosDirectorio;
    }

    private boolean verificarSumaPorcentaje(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema, boolean debeSerCien) {
        BigDecimal sumatoria = BigDecimal.ZERO;
        boolean esPropietarioExterior = false;
        for (Participacion p : sujeto.getParticipaciones()) {
            ObjetoModelo propietario = p.getPropietario();
            SujetoRelacionado sujetoPropietario = (SujetoRelacionado)propietario;
            if (sujetoPropietario.getTipoIdentificacion().equals("E")) {
                esPropietarioExterior = true;
            }
            sumatoria = sumatoria.add(new BigDecimal(p.getPorcentajeParticipacion()));
        }
        if (debeSerCien && sumatoria.compareTo(Constantes.CIEN) < 0 && !esPropietarioExterior) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los sujetos relacionados debe alcanzar el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        if (sumatoria.compareTo(BigDecimal.ZERO) <= 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los sujetos relacionados debe ser MAYOR A CERO"));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        if (sumatoria.compareTo(Constantes.CIEN) > 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los sujetos relacionados excede el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        return true;
    }

    private boolean esSociedadFondosInversionComplemteariosOtrosConsistente(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        boolean tieneAdministradores = false;
        boolean tieneTitularesDerecho = false;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            if ("05".equals(tipoRelacion)) {
                tieneAdministradores = true;
                continue;
            }
            if (!"10".equals(tipoRelacion)) continue;
            tieneTitularesDerecho = true;
        }
        if (!tieneAdministradores) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_ADMINISTRADORES));
        }
        if (!tieneTitularesDerecho) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan TITULAR DE DERECHO."));
        }
        if (!tieneAdministradores || !tieneTitularesDerecho) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        return tieneAdministradores && tieneTitularesDerecho;
    }

    private boolean esSociedadSinFinesLucroConsistente(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        boolean tieneAdministradores = false;
        boolean tieneSocioFundador = false;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            if ("05".equals(tipoRelacion)) {
                tieneAdministradores = true;
                continue;
            }
            if (!"08".equals(tipoRelacion)) continue;
            tieneSocioFundador = true;
        }
        if (!tieneAdministradores) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_ADMINISTRADORES));
        }
        if (!tieneSocioFundador) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan SOCIO FUNDADOR."));
        }
        if (!tieneAdministradores || !tieneSocioFundador) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        return tieneAdministradores && tieneSocioFundador;
    }

    private boolean esSociedadGeneralOSociedadCotizaConsistente(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        boolean tieneAdministradores = false;
        boolean tieneTitularesDerecho = false;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            if ("05".equals(tipoRelacion)) {
                tieneAdministradores = true;
                continue;
            }
            if (!"10".equals(tipoRelacion)) continue;
            tieneTitularesDerecho = true;
        }
        if (!tieneAdministradores) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_ADMINISTRADORES));
        }
        if (!tieneTitularesDerecho) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan TITULAR DE DERECHO."));
        }
        if (!tieneAdministradores || !tieneTitularesDerecho) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        return tieneAdministradores && tieneTitularesDerecho;
    }

    private boolean esSociedadFideicomisoConsistente(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        boolean tieneConstituyentes = false;
        boolean tieneBeneficiarios = false;
        boolean tieneFiduciarios = false;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            if ("06".equals(tipoRelacion)) {
                tieneConstituyentes = true;
                continue;
            }
            if ("07".equals(tipoRelacion)) {
                tieneBeneficiarios = true;
                continue;
            }
            if (!"12".equals(tipoRelacion)) continue;
            tieneFiduciarios = true;
        }
        if (!tieneConstituyentes) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan CONSTITUYENTE o FIDEICOMITENTE."));
        }
        if (!tieneBeneficiarios) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan BENEFICIARIO O FIDEICOMISARIO."));
        }
        if (!tieneFiduciarios) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan FIDUCIARIO."));
        }
        if (!(tieneConstituyentes && tieneBeneficiarios && tieneFiduciarios)) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        return tieneConstituyentes && tieneBeneficiarios && tieneFiduciarios;
    }

    private boolean verificarSumaSociedadGeneral(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema, int anioPeriodo) {
        BigDecimal sumatoria = BigDecimal.ZERO;
        for (Participacion p : sujeto.getParticipaciones()) {
            sumatoria = sumatoria.add(new BigDecimal(p.getPorcentajeParticipacion()));
            System.out.println("SOCIEDAD GENERAL: Identificacion Participacion Sujeto Relacionado: " + p.getSujeto().getIdentificacion());
        }
        if (sumatoria.compareTo(BigDecimal.ZERO) <= 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los sujetos relacionados debe ser MAYOR A CERO"));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        if (anioPeriodo < 2022 && sumatoria.compareTo(Constantes.CIEN) < 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los sujetos relacionados debe alcanzar el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        if (sumatoria.compareTo(Constantes.CIEN) > 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los sujetos relacionados excede el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        return true;
    }

    private boolean verificarSumaPorcentajeNoCotizaBolsa(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        BigDecimal topeParticipaciones = new BigDecimal(sujeto.getPorcentajeNoCotiza());
        BigDecimal sumatoria = BigDecimal.ZERO;
        for (Participacion p : sujeto.getParticipaciones()) {
            if (!"01".equals(p.getTipoDeRelacion()) && !"02".equals(p.getTipoDeRelacion()) && !"03".equals(p.getTipoDeRelacion())) continue;
            sumatoria = sumatoria.add(new BigDecimal(p.getPorcentajeParticipacion()));
        }
        if (sumatoria.compareTo(topeParticipaciones) < 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones debe alcanzar al menos el " + sujeto.getPorcentajeNoCotiza() + "% indicado como porcentaje accionario que no cotiza en bolsa de valores."));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        if (sumatoria.compareTo(Constantes.CIEN) > 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los sujetos relacionados excede el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        return true;
    }

    private boolean verificarSumaFideicomisos(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema, int anioPeriodo) {
        BigDecimal sumatoriaParticipes = BigDecimal.ZERO;
        BigDecimal sumatoriaBeneficiarios = BigDecimal.ZERO;
        BigDecimal sumatoriaConstituyentes = BigDecimal.ZERO;
        boolean sumaCorrecta = true;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            System.out.println("FIDEICOMISO: Identificacion Participacion Sujeto Relacionado: " + p.getSujeto().getIdentificacion());
            if ("03".equals(tipoRelacion)) {
                sumatoriaParticipes = sumatoriaParticipes.add(new BigDecimal(p.getPorcentajeParticipacion()));
                continue;
            }
            if ("07".equals(tipoRelacion)) {
                sumatoriaBeneficiarios = sumatoriaBeneficiarios.add(new BigDecimal(p.getPorcentajeParticipacion()));
                continue;
            }
            if (!"06".equals(tipoRelacion)) continue;
            sumatoriaConstituyentes = sumatoriaConstituyentes.add(new BigDecimal(p.getPorcentajeParticipacion()));
        }
        if (sumatoriaParticipes.compareTo(BigDecimal.ZERO) < 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los PARTICIPES no puede ser MENOR A CERO"));
            tipoProblema.valor = TipoProblema.ERROR;
            sumaCorrecta = false;
        }
        if (sumatoriaParticipes.compareTo(Constantes.CIEN) > 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los PARTICIPES excede el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            sumaCorrecta = false;
        }
        if (anioPeriodo < 2022 && sumatoriaParticipes.compareTo(Constantes.CIEN) < 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los PARTICIPES debe alcanzar el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            sumaCorrecta = false;
        }
        if (sumatoriaBeneficiarios.compareTo(BigDecimal.ZERO) <= 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los BENEFICIARIOS debe ser MAYOR A CERO"));
            tipoProblema.valor = TipoProblema.ERROR;
            sumaCorrecta = false;
        }
        if (sumatoriaBeneficiarios.compareTo(Constantes.CIEN) > 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los BENEFICIARIOS excede el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            sumaCorrecta = false;
        }
        if (anioPeriodo < 2022 && sumatoriaBeneficiarios.compareTo(Constantes.CIEN) < 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los BENEFICIARIOS debe alcanzar el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            sumaCorrecta = false;
        }
        if (sumatoriaConstituyentes.compareTo(BigDecimal.ZERO) <= 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los CONSTITUYENTES debe ser MAYOR A CERO"));
            tipoProblema.valor = TipoProblema.ERROR;
            sumaCorrecta = false;
        }
        if (sumatoriaConstituyentes.compareTo(Constantes.CIEN) > 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los CONSTITUYENTES excede el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            sumaCorrecta = false;
        }
        if (anioPeriodo < 2022 && sumatoriaConstituyentes.compareTo(Constantes.CIEN) < 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los CONSTITUYENTES debe alcanzar el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            sumaCorrecta = false;
        }
        return sumaCorrecta;
    }

    private boolean verificarSumaFondoInversion(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema, int anioPeriodo) {
        BigDecimal sumatoria = BigDecimal.ZERO;
        boolean tieneParticipes = false;
        for (Participacion p : sujeto.getParticipaciones()) {
            if (!"03".equals(p.getTipoDeRelacion())) continue;
            sumatoria = sumatoria.add(new BigDecimal(p.getPorcentajeParticipacion()));
            tieneParticipes = true;
        }
        if (tieneParticipes && sumatoria.compareTo(BigDecimal.ZERO) <= 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los PARTICIPES debe ser MAYOR A CERO"));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        if (sumatoria.compareTo(Constantes.CIEN) > 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los PARTICIPES excede el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        if (anioPeriodo < 2022 && sumatoria.compareTo(Constantes.CIEN) < 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los PARTICIPES debe alcanzar el 100%"));
            tipoProblema.valor = TipoProblema.ERROR;
            return false;
        }
        return true;
    }

    private boolean verificarSumaSinFinLucroSocEconFinPopularSolidario(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        BigDecimal sumatoriaParticipes = BigDecimal.ZERO;
        BigDecimal sumatoriaSocioFundador = BigDecimal.ZERO;
        boolean sumaCorrecta = true;
        for (Participacion p : sujeto.getParticipaciones()) {
            if ("03".equals(p.getTipoDeRelacion())) {
                sumatoriaParticipes = sumatoriaParticipes.add(new BigDecimal(p.getPorcentajeParticipacion()));
                continue;
            }
            if (!"08".equals(p.getTipoDeRelacion())) continue;
            sumatoriaSocioFundador = sumatoriaSocioFundador.add(new BigDecimal(p.getPorcentajeParticipacion()));
        }
        if (sumatoriaParticipes.compareTo(BigDecimal.ZERO) < 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los PARTICIPES no puede ser MENOR A CERO"));
            sumaCorrecta = false;
        }
        if (sumatoriaParticipes.compareTo(Constantes.CIEN) > 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los PARTICIPES excede el 100%"));
            sumaCorrecta = false;
        }
        if (sumatoriaSocioFundador.compareTo(BigDecimal.ZERO) < 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los SOCIOS FUNDADORES no puede ser MENOR A CERO"));
            sumaCorrecta = false;
        }
        if (sumatoriaSocioFundador.compareTo(Constantes.CIEN) > 0) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "La suma de las participaciones de los SOCIOS FUNDADORES excede el 100%"));
            sumaCorrecta = false;
        }
        if (!sumaCorrecta) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        return sumaCorrecta;
    }

    private boolean esSociedadGeneralConsistente(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        boolean tieneMiembrosDirectorio = false;
        boolean tieneAdministradores = false;
        boolean tieneAccionistasSociosParticipes = false;
        boolean tieneRelacionadosExcluyentes = false;
        boolean tieneOtrosRelacionados = false;
        boolean tieneApoderados = false;
        String tipoRelacionExcluyente = null;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            if ("05".equals(tipoRelacion)) {
                tieneAdministradores = true;
                continue;
            }
            if ("04".equals(tipoRelacion)) {
                tieneMiembrosDirectorio = true;
                continue;
            }
            if ("09".equals(tipoRelacion)) {
                tieneApoderados = true;
                continue;
            }
            if ("01".equals(tipoRelacion) || "02".equals(tipoRelacion) || "03".equals(tipoRelacion)) {
                tieneAccionistasSociosParticipes = true;
                if (tipoRelacionExcluyente == null) {
                    tipoRelacionExcluyente = tipoRelacion;
                    continue;
                }
                if (tipoRelacionExcluyente.equals(tipoRelacion)) continue;
                tieneRelacionadosExcluyentes = true;
                continue;
            }
            tieneOtrosRelacionados = true;
        }
        if (!tieneMiembrosDirectorio) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_MIEMBROS_DIRECTORIO));
            tipoProblema.valor = TipoProblema.ADVERTENCIA;
        }
        if (!tieneApoderados) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_APODERADO_GENERAL));
            tipoProblema.valor = TipoProblema.ADVERTENCIA;
        }
        if (!tieneAdministradores) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_ADMINISTRADORES));
        }
        if (!tieneAccionistasSociosParticipes) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan ACCIONISTA, SOCIO o PARTICIPE."));
        }
        if (tieneRelacionadosExcluyentes) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto tiene sujetos relacionados con tipos excluyentes. No puede tener a la vez sujetos de tipo ACCIONISTA, SOCIO o PARTICIPE."));
        }
        if (tieneOtrosRelacionados) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto tiene sujetos relacionados de tipos diferentes a ACCIONISTA, SOCIO, PARTICIPE, ADMINISTRADOR o MIEMBRO DE DIRECTORIO."));
        }
        if (!tieneAdministradores || !tieneAccionistasSociosParticipes || tieneRelacionadosExcluyentes || tieneOtrosRelacionados) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        return !tieneOtrosRelacionados && !tieneRelacionadosExcluyentes && tieneMiembrosDirectorio && tieneAdministradores && tieneAccionistasSociosParticipes;
    }

    private boolean esSociedadCotizaBolsaConsistente(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        boolean tieneAccionistas = false;
        boolean tieneMiembrosDirectorio = false;
        boolean tieneAdministradores = false;
        boolean tieneOtrosRelacionados = false;
        boolean tieneRelacionadosExcluyentes = false;
        boolean tieneApoderados = false;
        boolean tieneAccionistasSociosParticipes = false;
        String tipoRelacionExcluyente = null;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            if ("05".equals(tipoRelacion)) {
                tieneAdministradores = true;
                continue;
            }
            if ("04".equals(tipoRelacion)) {
                tieneMiembrosDirectorio = true;
                continue;
            }
            if ("09".equals(tipoRelacion)) {
                tieneApoderados = true;
                continue;
            }
            if ("01".equals(tipoRelacion) || "02".equals(tipoRelacion) || "03".equals(tipoRelacion)) {
                tieneAccionistasSociosParticipes = true;
                if (tipoRelacionExcluyente == null) {
                    tipoRelacionExcluyente = tipoRelacion;
                    continue;
                }
                if (tipoRelacionExcluyente.equals(tipoRelacion)) continue;
                tieneRelacionadosExcluyentes = true;
                continue;
            }
            tieneOtrosRelacionados = true;
        }
        if (!tieneAdministradores) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_ADMINISTRADORES));
        }
        if (!tieneAccionistasSociosParticipes) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan ACCIONISTA, SOCIO o PARTICIPE."));
        }
        if (tieneRelacionadosExcluyentes) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto tiene sujetos relacionados con tipos excluyentes. No puede tener a la vez sujetos de tipo ACCIONISTA, SOCIO o PARTICIPE."));
        }
        if (tieneOtrosRelacionados) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto tiene sujetos relacionados de tipos diferentes a ACCIONISTA, ADMINISTRADOR o MIEMBRO DE DIRECTORIO."));
        }
        if (!tieneAccionistas || !tieneAdministradores || tieneOtrosRelacionados) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        if (!tieneMiembrosDirectorio) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_MIEMBROS_DIRECTORIO));
            tipoProblema.valor = TipoProblema.ADVERTENCIA;
        }
        if (!tieneApoderados) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_APODERADO_GENERAL));
            tipoProblema.valor = TipoProblema.ADVERTENCIA;
        }
        return !tieneOtrosRelacionados && tieneAccionistas && tieneMiembrosDirectorio && tieneAdministradores && !tieneRelacionadosExcluyentes;
    }

    private boolean esFideicomisoConsistente(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        boolean tieneAdministradores = false;
        boolean tieneConstituyentes = false;
        boolean tieneBeneficiarios = false;
        boolean tieneParticipes = false;
        boolean tieneMiembrosDirectorio = false;
        boolean tieneOtrosRelacionados = false;
        boolean tieneApoderados = false;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            if ("05".equals(tipoRelacion)) {
                tieneAdministradores = true;
                continue;
            }
            if ("06".equals(tipoRelacion)) {
                tieneConstituyentes = true;
                continue;
            }
            if ("07".equals(tipoRelacion)) {
                tieneBeneficiarios = true;
                continue;
            }
            if ("03".equals(tipoRelacion)) {
                tieneParticipes = true;
                continue;
            }
            if ("04".equals(tipoRelacion)) {
                tieneMiembrosDirectorio = true;
                continue;
            }
            if ("09".equals(tipoRelacion)) {
                tieneApoderados = true;
                continue;
            }
            tieneOtrosRelacionados = true;
        }
        if (!tieneParticipes) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_PARTICIPES));
        }
        if (!tieneMiembrosDirectorio) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_MIEMBROS_DIRECTORIO));
        }
        if (!tieneApoderados) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_APODERADO_GENERAL));
        }
        if (!(tieneParticipes && tieneMiembrosDirectorio && tieneApoderados)) {
            tipoProblema.valor = TipoProblema.ADVERTENCIA;
        }
        if (!tieneAdministradores) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_ADMINISTRADORES));
        }
        if (!tieneConstituyentes) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan CONSTITUYENTE."));
        }
        if (!tieneBeneficiarios) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan BENEFICIARIO."));
        }
        if (tieneOtrosRelacionados) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto tiene sujetos relacionados de tipos diferentes a ADMINISTRADOR, CONSTITUYENTE, BENEFICIARIO, PARTICIPE y MIEMBRO DE DIRECTORIO."));
        }
        if (!tieneAdministradores || !tieneConstituyentes || !tieneBeneficiarios || tieneOtrosRelacionados) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        return !tieneOtrosRelacionados && tieneAdministradores && tieneConstituyentes && tieneBeneficiarios && tieneParticipes && tieneMiembrosDirectorio;
    }

    private boolean esSinFinLucroSEconomicoPSSFinancieroPSConsistente(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        boolean tieneSociosFundadores = false;
        boolean tieneMiembrosDirectorio = false;
        boolean tieneAdministradores = false;
        boolean tieneParticipes = false;
        boolean tieneOtrosRelacionados = false;
        boolean tieneApoderados = false;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            if ("08".equals(tipoRelacion)) {
                tieneSociosFundadores = true;
                continue;
            }
            if ("04".equals(tipoRelacion)) {
                tieneMiembrosDirectorio = true;
                continue;
            }
            if ("05".equals(tipoRelacion)) {
                tieneAdministradores = true;
                continue;
            }
            if ("03".equals(tipoRelacion)) {
                tieneParticipes = true;
                continue;
            }
            if ("09".equals(tipoRelacion)) {
                tieneApoderados = true;
                continue;
            }
            tieneOtrosRelacionados = true;
        }
        if (!tieneParticipes) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_PARTICIPES));
        }
        if (!tieneMiembrosDirectorio) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_MIEMBROS_DIRECTORIO));
        }
        if (!tieneApoderados) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_APODERADO_GENERAL));
        }
        if (!tieneParticipes || !tieneMiembrosDirectorio) {
            tipoProblema.valor = TipoProblema.ADVERTENCIA;
        }
        if (!tieneSociosFundadores) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto no tiene registrado ning\u00fan SOCIO FUNDADOR."));
        }
        if (!tieneAdministradores) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_ADMINISTRADORES));
        }
        if (tieneOtrosRelacionados) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto tiene sujetos relacionados de tipos diferentes a SOCIO FUNDADOR, MIEMBRO DE DIRECTORIO, ADMINISTRADOR y PARTICIPE."));
        }
        if (!tieneAdministradores || tieneOtrosRelacionados || !tieneSociosFundadores) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        return !tieneOtrosRelacionados && tieneSociosFundadores && tieneMiembrosDirectorio && tieneAdministradores && tieneParticipes;
    }

    private boolean esFondoInversionConsistente(SujetoRelacionado sujeto, List<MensajeValidacion> mensajesProblemasSujeto, Portador<TipoProblema> tipoProblema) {
        boolean tieneParticipes = false;
        boolean tieneAdministradores = false;
        boolean tieneOtrosRelacionados = false;
        boolean tieneApoderados = false;
        for (Participacion p : sujeto.getParticipaciones()) {
            String tipoRelacion = p.getTipoDeRelacion();
            if ("03".equals(tipoRelacion)) {
                tieneParticipes = true;
                continue;
            }
            if ("05".equals(tipoRelacion)) {
                tieneAdministradores = true;
                continue;
            }
            if ("09".equals(tipoRelacion)) {
                tieneApoderados = true;
                continue;
            }
            tieneOtrosRelacionados = true;
        }
        if (!tieneAdministradores) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_ADMINISTRADORES));
        }
        if (!tieneParticipes) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, M_SUJETO_NO_TIENE_PARTICIPES));
        }
        if (!tieneApoderados) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ADVERTENCIA, M_SUJETO_NO_TIENE_APODERADO_GENERAL));
        }
        if (tieneOtrosRelacionados) {
            mensajesProblemasSujeto.add(new MensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "El sujeto tiene sujetos relacionados de tipos diferentes a PARTICIPE y ADMINISTRADOR."));
        }
        if (!tieneAdministradores || tieneOtrosRelacionados || !tieneParticipes) {
            tipoProblema.valor = TipoProblema.ERROR;
        }
        return !tieneOtrosRelacionados && tieneAdministradores && tieneParticipes;
    }

    private boolean registrarSujetoIncompleto(String identificacionSujeto, SujetoRelacionado sujeto, TipoProblema tipoProblema) {
        if (this.sujetosIncompletos.containsKey(identificacionSujeto)) {
            SujetoProblemas sujetoProblemas = this.sujetosIncompletos.get(identificacionSujeto);
            sujetoProblemas.setTipoProblema(tipoProblema);
        } else {
            SujetoProblemas sujetoProblemas = new SujetoProblemas();
            sujetoProblemas.setTipoProblema(tipoProblema);
            sujetoProblemas.setSujeto(sujeto);
            this.sujetosIncompletos.put(identificacionSujeto, sujetoProblemas);
        }
        return true;
    }

    public void actualizarIdentificacionSujeto(String idAnterior, String idNueva) {
        Object value = this.cacheSujetos.remove(idAnterior);
        this.cacheSujetos.put(idNueva, (SujetoRelacionado)value);
        value = this.sujetosIncompletos.remove(idAnterior);
        this.sujetosIncompletos.put(idNueva, (SujetoProblemas)value);
        value = this.mensajesProblemas.remove(idAnterior);
        this.mensajesProblemas.put(idNueva, (List)value);
        value = this.participacionesPorSujeto.remove(idAnterior);
        this.participacionesPorSujeto.put(idNueva, (List)value);
    }

    public Boolean eliminarMensajesProblemas(String idSujeto) {
        if (this.sujetosIncompletos.remove(idSujeto) != null) {
            return true;
        }
        return false;
    }

    public static void determinarParticipacionesPorSujeto(Map<String, List<Participacion>> participacionesPorSujeto, Map<String, SujetoRelacionado> cacheSujetos) {
        for (SujetoRelacionado sujeto : cacheSujetos.values()) {
            List participacionesDelSujeto = sujeto.getParticipaciones();
            if (participacionesDelSujeto == null || participacionesDelSujeto.isEmpty()) continue;
            for (Participacion participacionSujeto : participacionesDelSujeto) {
                String idSujeto = participacionSujeto.getSujeto().getIdentificacion();
                List<Participacion> participacionesAsociadasSujeto = participacionesPorSujeto.get(idSujeto);
                if (participacionesAsociadasSujeto == null) {
                    participacionesAsociadasSujeto = new ArrayList<Participacion>();
                    participacionesPorSujeto.put(idSujeto, participacionesAsociadasSujeto);
                }
                if (participacionesAsociadasSujeto.contains(participacionSujeto)) continue;
                participacionesAsociadasSujeto.add(participacionSujeto);
            }
        }
    }
}

