/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.ui.paginas.util;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.ui.paginas.util.OperacionParticipacion;
import java.math.BigDecimal;
import java.security.InvalidParameterException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public class AdministradorTotalesParticipaciones
extends ObjetoModelo {
    private static final long serialVersionUID = 7604618652260776944L;
    private static final NumberFormat formato;
    public static final String C_SUMA_PARTICIPACIONES = "sumaParticipaciones";
    public static final String C_SUMA_CONSTITUYENTES = "sumaConstituyentes";
    public static final String C_SUMA_BENEFICIARIOS = "sumaBeneficiarios";
    public static final String C_SUMA_SOCIOS_FUNDADORES = "sumaSociosFundadores";
    private BigDecimal sumaParticipaciones = BigDecimal.ZERO;
    private BigDecimal sumaConstituyentes = BigDecimal.ZERO;
    private BigDecimal sumaBeneficiarios = BigDecimal.ZERO;
    private BigDecimal sumaSociosFundadores = BigDecimal.ZERO;

    static {
        DecimalFormatSymbols simbolosDecimales = new DecimalFormatSymbols();
        simbolosDecimales.setDecimalSeparator('.');
        formato = new DecimalFormat("0.00", simbolosDecimales);
    }

    public String getSumaParticipaciones() {
        return String.valueOf(formato.format(this.sumaParticipaciones)) + " %";
    }

    public BigDecimal getSumaParticipacionesRaw() {
        return this.sumaParticipaciones;
    }

    public String getSumaConstituyentes() {
        return String.valueOf(formato.format(this.sumaConstituyentes)) + " %";
    }

    public BigDecimal getSumaConstituyentesRaw() {
        return this.sumaConstituyentes;
    }

    public String getSumaBeneficiarios() {
        return String.valueOf(formato.format(this.sumaBeneficiarios)) + " %";
    }

    public BigDecimal getSumaBeneficiariosRaw() {
        return this.sumaBeneficiarios;
    }

    public String getSumaSociosFundadores() {
        return String.valueOf(formato.format(this.sumaSociosFundadores)) + " %";
    }

    public BigDecimal getSumaSociosFundadoresRaw() {
        return this.sumaSociosFundadores;
    }

    private void sumarParticipacion(String porcentajeParticipacion) {
        BigDecimal oldValue = this.sumaParticipaciones;
        this.sumaParticipaciones = this.sumaParticipaciones.add(new BigDecimal(porcentajeParticipacion));
        this.firePropertyChange(C_SUMA_PARTICIPACIONES, oldValue, this.sumaParticipaciones);
    }

    private void restarParticipacion(String porcentajeParticipacion) {
        BigDecimal oldValue = this.sumaParticipaciones;
        this.sumaParticipaciones = this.sumaParticipaciones.subtract(new BigDecimal(porcentajeParticipacion));
        this.firePropertyChange(C_SUMA_PARTICIPACIONES, oldValue, this.sumaParticipaciones);
    }

    public void restablecerSumaParticipaciones() {
        BigDecimal oldValue = this.sumaParticipaciones;
        this.sumaParticipaciones = BigDecimal.ZERO;
        this.firePropertyChange(C_SUMA_PARTICIPACIONES, oldValue, this.sumaParticipaciones);
    }

    private void sumarBeneficiario(String porcentajeParticipacion) {
        BigDecimal oldValue = this.sumaBeneficiarios;
        this.sumaBeneficiarios = this.sumaBeneficiarios.add(new BigDecimal(porcentajeParticipacion));
        this.firePropertyChange(C_SUMA_BENEFICIARIOS, oldValue, this.sumaBeneficiarios);
    }

    private void restarBeneficiario(String porcentajeParticipacion) {
        BigDecimal oldValue = this.sumaBeneficiarios;
        this.sumaBeneficiarios = this.sumaBeneficiarios.subtract(new BigDecimal(porcentajeParticipacion));
        this.firePropertyChange(C_SUMA_BENEFICIARIOS, oldValue, this.sumaBeneficiarios);
    }

    public void restablecerSumaBeneficiarios() {
        BigDecimal oldValue = this.sumaBeneficiarios;
        this.sumaBeneficiarios = BigDecimal.ZERO;
        this.firePropertyChange(C_SUMA_BENEFICIARIOS, oldValue, this.sumaBeneficiarios);
    }

    private void sumarConstituyente(String porcentajeParticipacion) {
        BigDecimal oldValue = this.sumaConstituyentes;
        this.sumaConstituyentes = this.sumaConstituyentes.add(new BigDecimal(porcentajeParticipacion));
        this.firePropertyChange(C_SUMA_CONSTITUYENTES, oldValue, this.sumaConstituyentes);
    }

    private void restarConstituyente(String porcentajeParticipacion) {
        BigDecimal oldValue = this.sumaConstituyentes;
        this.sumaConstituyentes = this.sumaConstituyentes.subtract(new BigDecimal(porcentajeParticipacion));
        this.firePropertyChange(C_SUMA_CONSTITUYENTES, oldValue, this.sumaConstituyentes);
    }

    public void restablecerSumaConstituyentes() {
        BigDecimal oldValue = this.sumaConstituyentes;
        this.sumaConstituyentes = BigDecimal.ZERO;
        this.firePropertyChange(C_SUMA_CONSTITUYENTES, oldValue, this.sumaConstituyentes);
    }

    private void sumarSocioFundador(String porcentajeParticipacion) {
        BigDecimal oldValue = this.sumaSociosFundadores;
        this.sumaSociosFundadores = this.sumaSociosFundadores.add(new BigDecimal(porcentajeParticipacion));
        this.firePropertyChange(C_SUMA_SOCIOS_FUNDADORES, oldValue, this.sumaSociosFundadores);
    }

    private void restarSocioFundador(String porcentajeParticipacion) {
        BigDecimal oldValue = this.sumaSociosFundadores;
        this.sumaSociosFundadores = this.sumaSociosFundadores.subtract(new BigDecimal(porcentajeParticipacion));
        this.firePropertyChange(C_SUMA_SOCIOS_FUNDADORES, oldValue, this.sumaSociosFundadores);
    }

    public void restablecerSumaSociosFundadores() {
        BigDecimal oldValue = this.sumaSociosFundadores;
        this.sumaSociosFundadores = BigDecimal.ZERO;
        this.firePropertyChange(C_SUMA_SOCIOS_FUNDADORES, oldValue, this.sumaSociosFundadores);
    }

    public void procesarParticipacion(Participacion participacion, String tipoSociedadPadre, OperacionParticipacion operacion, String porcentajeParticipacionAnterior) throws InvalidParameterException {
        boolean restar;
        if (operacion == OperacionParticipacion.ACTUALIZAR && StringUtil.isNullOrEmpty((String)porcentajeParticipacionAnterior)) {
            throw new InvalidParameterException("Para una operacion de actualizacion, el parametro 'porcentajeParticipacionAnterior' no debe ser null.");
        }
        boolean sumar = operacion == OperacionParticipacion.AGREGAR || operacion == OperacionParticipacion.ACTUALIZAR;
        boolean bl = restar = operacion == OperacionParticipacion.ELIMINAR || operacion == OperacionParticipacion.ACTUALIZAR;
        if (operacion == OperacionParticipacion.ELIMINAR) {
            porcentajeParticipacionAnterior = participacion.getPorcentajeParticipacion();
        }
        if ("03".equals(tipoSociedadPadre) || "10".equals(tipoSociedadPadre)) {
            String tipoRelacion = participacion.getTipoDeRelacion();
            if ("06".equals(tipoRelacion)) {
                if (restar) {
                    this.restarConstituyente(porcentajeParticipacionAnterior);
                }
                if (sumar) {
                    this.sumarConstituyente(participacion.getPorcentajeParticipacion());
                }
            } else if ("07".equals(tipoRelacion)) {
                if (restar) {
                    this.restarBeneficiario(porcentajeParticipacionAnterior);
                }
                if (sumar) {
                    this.sumarBeneficiario(participacion.getPorcentajeParticipacion());
                }
            } else {
                if (restar) {
                    this.restarParticipacion(porcentajeParticipacionAnterior);
                }
                if (sumar) {
                    this.sumarParticipacion(participacion.getPorcentajeParticipacion());
                }
            }
        } else if ("04".equals(tipoSociedadPadre) || "05".equals(tipoSociedadPadre) || "06".equals(tipoSociedadPadre)) {
            String tipoRelacion = participacion.getTipoDeRelacion();
            if ("03".equals(tipoRelacion) || "10".equals(tipoRelacion)) {
                if (restar) {
                    this.restarParticipacion(porcentajeParticipacionAnterior);
                }
                if (sumar) {
                    this.sumarParticipacion(participacion.getPorcentajeParticipacion());
                }
            } else if ("08".equals(tipoRelacion)) {
                if (restar) {
                    this.restarSocioFundador(porcentajeParticipacionAnterior);
                }
                if (sumar) {
                    this.sumarSocioFundador(participacion.getPorcentajeParticipacion());
                }
            }
        } else {
            if (restar) {
                this.restarParticipacion(porcentajeParticipacionAnterior);
            }
            if (sumar) {
                this.sumarParticipacion(participacion.getPorcentajeParticipacion());
            }
        }
    }
}

