/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.convertidores;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.conversion.Converter;

public class StringToIntegerConverter
extends Converter {
    private static DecimalFormat formato;
    private static final String REGEX_NUMERO_ENTERO = "[0-9]+";

    static {
        DecimalFormatSymbols simbolos = new DecimalFormatSymbols();
        simbolos.setDecimalSeparator('.');
        formato = new DecimalFormat("#", simbolos);
    }

    public StringToIntegerConverter() {
        super(String.class, Integer.TYPE);
    }

    public Object convert(Object fromObject) {
        if (!Pattern.matches(REGEX_NUMERO_ENTERO, fromObject == null ? "" : fromObject.toString())) {
            return null;
        }
        try {
            return fromObject == null ? null : Integer.valueOf(formato.parse((String)fromObject).intValue());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

