/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.modelo.persistencia.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class DIMMObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoaderAlterno;

    public DIMMObjectInputStream(ClassLoader classLoaderAlterno, InputStream in) throws IOException {
        super(in);
        this.classLoaderAlterno = classLoaderAlterno;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> clase;
        try {
            clase = super.resolveClass(desc);
        }
        catch (Exception e) {
            try {
                clase = Class.forName(desc.getName(), true, this.classLoaderAlterno);
            }
            catch (ClassNotFoundException cne) {
                ClassNotFoundException cnex = new ClassNotFoundException("No es posible cargar la clase correspondiente al objeto del modelo.", cne);
                cnex.initCause(e);
                throw cnex;
            }
        }
        return clase;
    }
}

