/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.modelo.validacion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UtilitarioCaracteresRepetidos {
    private String cadenaAValidar;

    public UtilitarioCaracteresRepetidos(String cadenaAValidar) {
        this.cadenaAValidar = cadenaAValidar;
    }

    public boolean existenCaracteresRepetidos() {
        Pattern pattern = Pattern.compile("([\\w])\\1{5}");
        Matcher matcher = pattern.matcher(this.cadenaAValidar);
        return matcher.find();
    }

    public boolean existenDigitosSecuenciales() {
        Pattern pattern = Pattern.compile("012345|123456|234567|345678|456789|([0-9])\u0001\u0001\u0001\u0001\u0001");
        Matcher matcher = pattern.matcher(this.cadenaAValidar);
        return matcher.find();
    }

    public boolean existenDigitos() {
        Pattern pattern = Pattern.compile("\\d");
        Matcher matcher = pattern.matcher(this.cadenaAValidar);
        return matcher.find();
    }

    public boolean validar() {
        boolean existenRepetidosOSecuenciales = this.existenDigitos() ? this.existenCaracteresRepetidos() || this.existenDigitosSecuenciales() : this.existenCaracteresRepetidos();
        return !existenRepetidosOSecuenciales;
    }

    public String getCadenaAValidar() {
        return this.cadenaAValidar;
    }

    public void setCadenaAValidar(String cadenaAValidar) {
        this.cadenaAValidar = cadenaAValidar;
    }
}

