/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.ui.asistentes;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.AdministradorPersistencia;
import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.api.ui.editores.InputEditorModeloBase;
import java.io.File;
import org.eclipse.ui.INewWizard;
import org.w3c.dom.Document;

public abstract class AsistenteImportacion<T extends RaizModelo>
extends AsistenteBase
implements INewWizard {
    protected final String titulo;
    protected final String idEditor;

    protected AsistenteImportacion(String titulo, String idEditor) {
        this.titulo = titulo;
        this.idEditor = idEditor;
    }

    @Override
    public final boolean performFinish() {
        File archivoXML = this.getArchivoXML();
        if (archivoXML != null) {
            boolean anexoValido = this.validarAnexo(archivoXML);
            if (!anexoValido) {
                return true;
            }
            Document documentoXML = null;
            documentoXML = AdministradorPersistencia.obtenerDocumento(archivoXML.getAbsolutePath());
            if (documentoXML == null) {
                this.mostrarError("No ha sido posible cargar o leer el archivo del anexo.");
                return true;
            }
            T modeloImportado = this.obtenerModelo(documentoXML);
            if (modeloImportado == null) {
                this.mostrarError("No ha sido posible importar los datos del anexo.");
                return false;
            }
            InputEditorModeloBase<T> datosInput = this.obtenerInputEditor(modeloImportado);
            if (datosInput == null) {
                this.mostrarError("No ha sido posible obtener la entrada de datos para el editor.");
                return false;
            }
            try {
                this.getActivePage().openEditor(datosInput, this.idEditor);
                return true;
            }
            catch (Exception e) {
                this.mostrarError("Se ha producido un error al abrir el editor: " + e.getMessage());
                PluginLogger.logError("Error al abrir el editor", "ec.gob.sri.dimm.api", e);
                return false;
            }
        }
        return false;
    }

    protected abstract File getArchivoXML();

    protected abstract boolean validarAnexo(File var1);

    protected abstract T obtenerModelo(Document var1);

    protected abstract InputEditorModeloBase<T> obtenerInputEditor(T var1);
}

