/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.ui.dialogos;

import ec.gob.sri.dimm.api.modelo.validacion.MensajeValidacion;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.ResourceManager;
import swing2swt.layout.BorderLayout;

public final class DialogoMensajes
extends DialogoBase {
    private DataBindingContext m_bindingContext;
    private final String titulo;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private List<MensajeValidacion> mensajesError;
    private List<MensajeValidacion> mensajesAdvertencia;
    private ListViewer lvAdvertencias;
    private Button btnClose;
    private StyledText txtErrores;

    public DialogoMensajes(Shell shell, String titulo, List<MensajeValidacion> mensajes) {
        super(shell);
        this.titulo = titulo;
        this.procesarMensajesValidacion(mensajes);
    }

    public DialogoMensajes(IWorkbenchPartSite site, String titulo, List<MensajeValidacion> mensajes) {
        super(site);
        this.titulo = titulo;
        this.procesarMensajesValidacion(mensajes);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new BorderLayout(0, 0));
        ScrolledComposite scrolledComposite = new ScrolledComposite(container, 2816);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite composite = this.formToolkit.createComposite((Composite)scrolledComposite, 0);
        this.formToolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new BorderLayout(0, 0));
        ExpandableComposite xpndblcmpstErrores = this.formToolkit.createExpandableComposite(composite, 512);
        xpndblcmpstErrores.setLayoutData((Object)"Center");
        this.formToolkit.paintBordersFor((Composite)xpndblcmpstErrores);
        xpndblcmpstErrores.setText("Errores");
        xpndblcmpstErrores.setExpanded(true);
        Label label = this.formToolkit.createLabel((Composite)xpndblcmpstErrores, "", 0);
        label.setImage(ResourceManager.getPluginImage("org.eclipse.ui", "/icons/full/obj16/error_tsk.gif"));
        xpndblcmpstErrores.setTextClient((Control)label);
        Composite composite_1 = new Composite((Composite)xpndblcmpstErrores, 0);
        xpndblcmpstErrores.setClient((Control)composite_1);
        this.formToolkit.adapt(composite_1);
        this.formToolkit.paintBordersFor(composite_1);
        composite_1.setLayout((Layout)new FillLayout(256));
        this.txtErrores = new StyledText(composite_1, 2824);
        this.txtErrores.setEditable(false);
        this.formToolkit.adapt((Composite)this.txtErrores);
        this.formToolkit.paintBordersFor((Composite)this.txtErrores);
        ExpandableComposite xpndblcmpstAdvertencias = this.formToolkit.createExpandableComposite(composite, 512);
        xpndblcmpstAdvertencias.setLayoutData((Object)"South");
        this.formToolkit.paintBordersFor((Composite)xpndblcmpstAdvertencias);
        xpndblcmpstAdvertencias.setText("Advertencias");
        xpndblcmpstAdvertencias.setExpanded(true);
        Label label_1 = this.formToolkit.createLabel((Composite)xpndblcmpstAdvertencias, "", 0);
        label_1.setImage(ResourceManager.getPluginImage("org.eclipse.ui", "/icons/full/obj16/warn_tsk.gif"));
        xpndblcmpstAdvertencias.setTextClient((Control)label_1);
        Composite composite_2 = new Composite((Composite)xpndblcmpstAdvertencias, 0);
        xpndblcmpstAdvertencias.setClient((Control)composite_2);
        this.formToolkit.adapt(composite_2);
        this.formToolkit.paintBordersFor(composite_2);
        composite_2.setLayout((Layout)new FillLayout(256));
        this.lvAdvertencias = new ListViewer(composite_2, 2816);
        this.lvAdvertencias.getList();
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        this.setTitle(this.titulo);
        this.agregarErrorTexto();
        return container;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.btnClose = this.createButton(parent, 12, "Cerrar", true);
        this.btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogoMensajes.this.cancelPressed();
            }
        });
        this.m_bindingContext = this.initDataBindings();
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    private void procesarMensajesValidacion(List<MensajeValidacion> mensajes) {
        this.mensajesError = new ArrayList<MensajeValidacion>();
        this.mensajesAdvertencia = new ArrayList<MensajeValidacion>();
        for (MensajeValidacion mensaje : mensajes) {
            switch (mensaje.getNivel()) {
                case ADVERTENCIA: {
                    this.mensajesAdvertencia.add(mensaje);
                    break;
                }
                case ERROR: {
                    this.mensajesError.add(mensaje);
                    break;
                }
            }
        }
    }

    private void agregarErrorTexto() {
        for (MensajeValidacion mensaje : this.mensajesError) {
            this.txtErrores.append(String.valueOf(mensaje.getMensaje()) + System.getProperty("line.separator"));
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), MensajeValidacion.class, (String)"mensaje");
        this.lvAdvertencias.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.lvAdvertencias.setContentProvider((IContentProvider)listContentProvider_1);
        WritableList writableList_1 = new WritableList(this.mensajesAdvertencia, MensajeValidacion.class);
        this.lvAdvertencias.setInput((Object)writableList_1);
        return bindingContext;
    }
}

