/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.ui.editores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.AdministradorPersistencia;
import ec.gob.sri.dimm.api.ui.dialogos.ProveedorCuadrosDialogo;
import ec.gob.sri.dimm.api.ui.editores.InputEditorBase;
import ec.gob.sri.dimm.api.ui.editores.InputEditorModeloBase;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class EditorBase<T extends RaizModelo, V extends InputEditorModeloBase<T>>
extends SharedHeaderFormEditor
implements ProveedorCuadrosDialogo {
    protected V datosInput;
    protected T modeloDatos;
    protected AdministradorPersistencia<T> administradorPersistencia;

    protected abstract void addPages();

    protected abstract List<Action> crearAccionesGenerales();

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.processInput(input);
    }

    protected void setInputWithNotify(IEditorInput input) {
        super.setInputWithNotify(input);
        this.processInput(input);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.processInput(input);
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        super.createHeaderContents(headerForm);
        ScrolledForm forma = headerForm.getForm();
        String sPeriodo = StringUtil.isNullOrEmpty((String)((InputEditorModeloBase)this.datosInput).getPeriodo()) ? ((InputEditorModeloBase)this.datosInput).getAnio() : String.format("%s/%s", ((InputEditorModeloBase)this.datosInput).getPeriodo(), ((InputEditorModeloBase)this.datosInput).getAnio());
        forma.setText(String.format("%s    %s    %s", sPeriodo, ((InputEditorModeloBase)this.datosInput).getRuc().toUpperCase(), ((InputEditorModeloBase)this.datosInput).getRazonSocial().toUpperCase()));
        headerForm.getToolkit().decorateFormHeading(forma.getForm());
        List<Action> acciones = this.crearAccionesGenerales();
        if (acciones != null && !acciones.isEmpty()) {
            IToolBarManager toolbarManager = forma.getToolBarManager();
            for (Action accion : acciones) {
                toolbarManager.add((IAction)accion);
            }
            toolbarManager.update(true);
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public abstract AdministradorPersistencia<T> obtenerAdministradorPersistencia();

    @Override
    public boolean mostrarConfirmacion(String mensaje) {
        return MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)this.getPartName(), (String)mensaje);
    }

    @Override
    public boolean mostrarPregunta(String mensaje) {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)this.getPartName(), (String)mensaje);
    }

    @Override
    public void mostrarError(String mensaje) {
        MessageDialog.openError((Shell)this.getSite().getShell(), (String)this.getPartName(), (String)mensaje);
    }

    @Override
    public void mostrarAdvertencia(String mensaje) {
        MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)this.getPartName(), (String)mensaje);
    }

    @Override
    public void mostrarInformacion(String mensaje) {
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)this.getPartName(), (String)mensaje);
    }

    private void processInput(IEditorInput input) {
        this.datosInput = (InputEditorModeloBase)input;
        this.modeloDatos = ((InputEditorModeloBase)this.datosInput).getModeloDatos();
        this.setPartName(((InputEditorBase)this.datosInput).getName());
        this.obtenerAdministradorPersistencia().serializarObjeto(this.modeloDatos);
    }
}

