/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.rcp.databinding;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.wb.rcp.databinding.Utils;

public final class TreeBeanAdvisor
extends TreeStructureAdvisor {
    private final Class<?> m_beanClass;
    private final Method m_getParentMethod;
    private final Method m_getChildrenMethod;
    private final Method m_hasChildrenMethod;

    public TreeBeanAdvisor(Class<?> beanClass, String parentProperty, String childrenProperty, String hasChildrenProperty) {
        this.m_beanClass = beanClass;
        this.m_getParentMethod = Utils.getMethod(this.m_beanClass, parentProperty);
        this.m_getChildrenMethod = Utils.getMethod(this.m_beanClass, childrenProperty);
        this.m_hasChildrenMethod = Utils.getMethod(this.m_beanClass, hasChildrenProperty);
    }

    public Object getParent(Object element) {
        return Utils.invokeMethod(this.m_getParentMethod, this.m_beanClass, element);
    }

    public Boolean hasChildren(Object element) {
        if (this.m_hasChildrenMethod != null) {
            return (Boolean)Utils.invokeMethod(this.m_hasChildrenMethod, this.m_beanClass, element);
        }
        if (this.m_getChildrenMethod != null) {
            Object children = Utils.invokeMethod(this.m_getChildrenMethod, this.m_beanClass, element);
            if (children == null) {
                return Boolean.FALSE;
            }
            if (children.getClass().isArray()) {
                if (Array.getLength(children) > 0) {
                    return true;
                }
                return false;
            }
            if (children instanceof Collection) {
                Collection collection = (Collection)children;
                return !collection.isEmpty();
            }
        }
        return null;
    }
}

