/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.rcp.databinding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.rcp.databinding.ListenerSupport;
import org.eclipse.wb.rcp.databinding.Utils;

public class TreeObservableLabelProvider
extends LabelProvider {
    private final Class<?> m_beanClass;
    private final Method m_getTextMethod;
    private final Method m_getImageMethod;
    private final IObservableSet m_observable;
    private final ListenerSupport m_listenerSupport;
    private final PropertyChangeListener m_propertiesListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)TreeObservableLabelProvider.this, event.getSource());
            TreeObservableLabelProvider.this.fireLabelProviderChanged(newEvent);
        }
    };
    private final ISetChangeListener m_setListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            for (Object removedElement : event.diff.getRemovals()) {
                if (!Utils.instanceOf(TreeObservableLabelProvider.this.m_beanClass, removedElement)) continue;
                TreeObservableLabelProvider.this.m_listenerSupport.unhookListener(removedElement);
            }
            for (Object addedElement : event.diff.getAdditions()) {
                if (!Utils.instanceOf(TreeObservableLabelProvider.this.m_beanClass, addedElement)) continue;
                TreeObservableLabelProvider.this.m_listenerSupport.hookListener(addedElement);
            }
        }
    };

    public TreeObservableLabelProvider(IObservableSet allElementsObservable, Class<?> beanClass, String textProperty, String imageProperty) {
        this.m_observable = allElementsObservable;
        this.m_beanClass = beanClass;
        this.m_getTextMethod = Utils.getMethod(this.m_beanClass, textProperty);
        this.m_getImageMethod = Utils.getMethod(this.m_beanClass, imageProperty);
        ArrayList<String> properties = new ArrayList<String>();
        if (this.m_getTextMethod != null) {
            properties.add(textProperty);
        }
        if (this.m_getImageMethod != null) {
            properties.add(imageProperty);
        }
        this.m_listenerSupport = new ListenerSupport(this.m_propertiesListener, properties);
        this.m_observable.addSetChangeListener(this.m_setListener);
    }

    public String getText(Object element) {
        Object text = Utils.invokeMethod(this.m_getTextMethod, this.m_beanClass, element);
        return text == null ? null : text.toString();
    }

    public Image getImage(Object element) {
        return (Image)Utils.invokeMethod(this.m_getImageMethod, this.m_beanClass, element);
    }

    public void dispose() {
        this.m_observable.removeSetChangeListener(this.m_setListener);
        this.m_listenerSupport.dispose();
        super.dispose();
    }
}

