/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.validacion;

import ec.gob.sri.anexo.aps.validacion.ValidacionAnexoApsImpl;
import ec.gob.sri.anexo.exceptions.ExcepcionErroresExcedidos;
import ec.gob.sri.anexo.prepersistencia.modelo.RigTmpArchivoDetalle;
import ec.gob.sri.anexo.validacion.modelo.ContextoErrores;
import ec.gob.sri.anexo.validacion.modelo.ErrorDetalleAnexoValidacion;
import ec.gob.sri.anexo.validacion.modelo.ErrorValidacion;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.aps.validacion.esquema.ValidacionEsquemaAPS;
import ec.gob.sri.dimm.data.impl.ConexionBD;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ValidacionAPS {
    private static final String E_APS = "aps";
    private static final String E_ACCIONISTAS = "accionistas";
    private static final String E_ACCIONISTA = "accionista";
    private static final String E_INFO_PARTICIPACION_ACCIONARIA = "infoParticipacionAccionaria";
    private static final String E_UBICACION_RESIDENCIA_FISCAL = "ubicacionResidenciaFiscal";
    private static final String EE_ID_INFORMANTE = "IdInformante";
    private static final String EE_TIPO_SOCIEDAD = "TipoSociedad";
    private static final String EE_PORCENTAJE_NO_COTIZA = "PorcentajeAccionarioNoBolsa";
    private static final String EE_CODIGO_NIVEL = "codigoNivel";
    private static final String EE_TIPO_IDENTIFICACION = "tipoIdentificacion";
    private static final String EE_NUMERO_IDENTIFICACION = "numeroIdentificacion";
    private static final String EE_TIPO_SOCIEDAD_EXTRANJERA = "tipoSociedadExt";
    private static final String EE_SOCIEDAD_PUBLICA_EXTRANJERA = "esSociedadPublicaExt";
    private static final String EE_PORCENTAJE_ACCIONARIO_NO_BOLSA = "porcentajeAccionarioNoBolsaExt";
    private Map<String, String> sociedadesPublicasExtranjeras = new ConcurrentHashMap<String, String>();
    private Map<String, String> sociedadesPrivadasExtranjeras = new ConcurrentHashMap<String, String>();
    private Map<String, String> idsInformantePadreExtPriv = new ConcurrentHashMap<String, String>();
    private Map<String, Integer> codsNivelInformantePadreExtPriv = new ConcurrentHashMap<String, Integer>();
    private Map<String, Integer> socPrivadasExtObligaHijos = new ConcurrentHashMap<String, Integer>();
    private Map<String, String> idsBeneficiariosFinales = new ConcurrentHashMap<String, String>();
    private static final String E_BENEFICIARIOS = "beneficiarios";
    private static final String E_BENEFICIARIO = "beneficiario";
    private XMLStreamReader parserDetalles;
    private boolean tieneMasDetalles = true;
    private boolean cabeceraValidada = false;
    private boolean dentroAccionista = false;
    private boolean dentroBeneficiario = false;

    public ValidacionAPS(File archivoXML) throws IllegalStateException {
        try {
            this.parserDetalles = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(archivoXML));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(archivoXML));
            boolean dentroAccionista = false;
            boolean dentroInformante = false;
            boolean dentroBeneficiario = false;
            String idInformante = null;
            String tipoSociedad = null;
            String porcentajeNoCotizaBolsa = null;
            String identificacionSujeto = null;
            String tipoIdentificacionSujeto = null;
            String tipoSociedadExtranjera = null;
            String valorSujetoPublicoExtranjero = null;
            String porcentajeAccionarioNoBolsa = null;
            int codigoNivel = 0;
            String tipoIdentificacionBeneficiario = null;
            String identificacionBeneficiario = null;
            while (parser.hasNext()) {
                int eventCode = parser.next();
                switch (eventCode) {
                    case 1: {
                        String etiqueta = parser.getLocalName();
                        if (E_APS.equals(etiqueta)) {
                            dentroInformante = true;
                        } else if (E_ACCIONISTAS.equals(etiqueta)) {
                            this.idsInformantePadreExtPriv.put(idInformante, tipoSociedad);
                            this.socPrivadasExtObligaHijos.put(idInformante, 0);
                            this.codsNivelInformantePadreExtPriv.put(idInformante.concat("0"), 0);
                            if ("02".equals(tipoSociedad)) {
                                this.sociedadesPrivadasExtranjeras.put(idInformante, porcentajeNoCotizaBolsa);
                            }
                            dentroInformante = false;
                        } else if (E_BENEFICIARIOS.equals(etiqueta)) {
                            dentroInformante = false;
                        }
                        if (dentroInformante) {
                            if (EE_ID_INFORMANTE.equals(etiqueta)) {
                                idInformante = parser.getElementText();
                                break;
                            }
                            if (EE_TIPO_SOCIEDAD.equals(etiqueta)) {
                                tipoSociedad = parser.getElementText();
                                break;
                            }
                            if (!EE_PORCENTAJE_NO_COTIZA.equals(etiqueta)) break;
                            porcentajeNoCotizaBolsa = parser.getElementText();
                            break;
                        }
                        if (E_ACCIONISTA.equals(etiqueta)) {
                            dentroAccionista = true;
                        } else if (dentroAccionista) {
                            if (EE_TIPO_IDENTIFICACION.equals(etiqueta)) {
                                tipoIdentificacionSujeto = parser.getElementText();
                            } else if (EE_NUMERO_IDENTIFICACION.equals(etiqueta)) {
                                identificacionSujeto = parser.getElementText();
                            } else if (EE_TIPO_SOCIEDAD_EXTRANJERA.equals(etiqueta)) {
                                tipoSociedadExtranjera = parser.getElementText();
                            } else if (EE_SOCIEDAD_PUBLICA_EXTRANJERA.equals(etiqueta)) {
                                valorSujetoPublicoExtranjero = parser.getElementText();
                            } else if (EE_PORCENTAJE_ACCIONARIO_NO_BOLSA.equals(etiqueta)) {
                                porcentajeAccionarioNoBolsa = parser.getElementText();
                            } else if (EE_CODIGO_NIVEL.equals(etiqueta)) {
                                codigoNivel = Integer.parseInt(parser.getElementText());
                            }
                        }
                        if (E_BENEFICIARIO.equals(etiqueta)) {
                            dentroBeneficiario = true;
                            break;
                        }
                        if (!dentroBeneficiario) break;
                        if (EE_TIPO_IDENTIFICACION.equals(etiqueta)) {
                            tipoIdentificacionBeneficiario = parser.getElementText();
                            break;
                        }
                        if (!EE_NUMERO_IDENTIFICACION.equals(etiqueta)) break;
                        identificacionBeneficiario = parser.getElementText();
                        break;
                    }
                    case 2: {
                        String etiqueta = parser.getLocalName();
                        if (E_ACCIONISTA.equals(etiqueta)) {
                            if ("E".equals(tipoIdentificacionSujeto) && !"00".equals(tipoSociedadExtranjera)) {
                                if ("SI".equals(valorSujetoPublicoExtranjero)) {
                                    this.sociedadesPublicasExtranjeras.put(identificacionSujeto, tipoIdentificacionSujeto);
                                } else {
                                    this.idsInformantePadreExtPriv.put(identificacionSujeto, tipoSociedadExtranjera);
                                    this.socPrivadasExtObligaHijos.put(identificacionSujeto, codigoNivel);
                                    this.codsNivelInformantePadreExtPriv.put(identificacionSujeto.concat(String.valueOf(codigoNivel)), codigoNivel);
                                    if ("02".equals(tipoSociedadExtranjera)) {
                                        this.sociedadesPrivadasExtranjeras.put(identificacionSujeto, porcentajeAccionarioNoBolsa);
                                    }
                                }
                            }
                            codigoNivel = 0;
                            identificacionSujeto = null;
                            tipoIdentificacionSujeto = null;
                            tipoSociedadExtranjera = null;
                            valorSujetoPublicoExtranjero = null;
                            porcentajeAccionarioNoBolsa = null;
                            dentroAccionista = false;
                        }
                        if (!E_BENEFICIARIO.equals(etiqueta)) break;
                        this.idsBeneficiariosFinales.put(tipoIdentificacionBeneficiario.concat(identificacionBeneficiario), identificacionBeneficiario);
                        tipoIdentificacionBeneficiario = null;
                        identificacionBeneficiario = null;
                        dentroBeneficiario = false;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Imposible inicializar mecanismo de validacion de APS", e);
        }
    }

    public static ResultadoValidacion validarEsquema(File archivoXML) throws FileNotFoundException {
        ValidacionEsquemaAPS validacionEsquemaAps = new ValidacionEsquemaAPS();
        InputStream xsd = validacionEsquemaAps.obtenerEsquema();
        FileInputStream xml = new FileInputStream(archivoXML);
        return ValidacionEsquemaAPS.validarEsquema((InputStream)xml, (InputStream)xsd);
    }

    public ContextoErrores validarInformacion() throws InterruptedException {
        ContextoErrores ctxErrores = new ContextoErrores(100);
        ValidacionAnexoApsImpl validacionAps = new ValidacionAnexoApsImpl();
        Connection conexion = new ConexionBD().obtenerConexion();
        try {
            try {
                while (this.tieneMasDetalles) {
                    Map<String, Map<Integer, List<RigTmpArchivoDetalle>>> detallesXml = this.obtenerDetalles(100);
                    if (detallesXml == null) {
                        ErrorDetalleAnexoValidacion resumenErr = new ErrorDetalleAnexoValidacion();
                        resumenErr.getListaErrores().add(new ErrorValidacion("", ErrorValidacion.Severidad.ERROR));
                        ctxErrores.addErrorDetalleAnexoValidacion(resumenErr, (Object)"--> El archivo que desea importar no cumple con las especificaciones t\u00e9cnicas de la versi\u00f3n actual del Anexo APS.");
                        break;
                    }
                    String flagUltimoSetDetalles = !this.tieneMasDetalles ? "FIN" : null;
                    validacionAps.validar(new Object[]{0L, E_APS, 0L, ctxErrores, 0L, detallesXml, conexion, this.sociedadesPublicasExtranjeras, this.sociedadesPrivadasExtranjeras, this.idsInformantePadreExtPriv, this.codsNivelInformantePadreExtPriv, this.socPrivadasExtObligaHijos, flagUltimoSetDetalles, this.idsBeneficiariosFinales});
                }
            }
            catch (ExcepcionErroresExcedidos e) {
                PluginLogger.logError((String)"Se han producido demasiados errores de validacion.", (String)"ec.gob.sri.dimm.aps.validacion", (Exception)((Object)e));
                this.sociedadesPublicasExtranjeras.clear();
                this.sociedadesPublicasExtranjeras = null;
                this.sociedadesPrivadasExtranjeras.clear();
                this.sociedadesPrivadasExtranjeras = null;
                this.idsInformantePadreExtPriv.clear();
                this.idsInformantePadreExtPriv = null;
                this.codsNivelInformantePadreExtPriv.clear();
                this.codsNivelInformantePadreExtPriv = null;
                this.socPrivadasExtObligaHijos.clear();
                this.socPrivadasExtObligaHijos = null;
                this.idsBeneficiariosFinales.clear();
                this.idsBeneficiariosFinales = null;
            }
        }
        finally {
            this.sociedadesPublicasExtranjeras.clear();
            this.sociedadesPublicasExtranjeras = null;
            this.sociedadesPrivadasExtranjeras.clear();
            this.sociedadesPrivadasExtranjeras = null;
            this.idsInformantePadreExtPriv.clear();
            this.idsInformantePadreExtPriv = null;
            this.codsNivelInformantePadreExtPriv.clear();
            this.codsNivelInformantePadreExtPriv = null;
            this.socPrivadasExtObligaHijos.clear();
            this.socPrivadasExtObligaHijos = null;
            this.idsBeneficiariosFinales.clear();
            this.idsBeneficiariosFinales = null;
        }
        return ctxErrores;
    }

    private Map<String, Map<Integer, List<RigTmpArchivoDetalle>>> obtenerDetalles(int maximoDetalles) {
        Hashtable<String, Map<Integer, List<RigTmpArchivoDetalle>>> detallesXml = new Hashtable<String, Map<Integer, List<RigTmpArchivoDetalle>>>();
        Hashtable accionistas = new Hashtable();
        Hashtable beneficiarios = new Hashtable();
        try {
            String etiqueta = null;
            boolean dentroInformante = false;
            ArrayList<RigTmpArchivoDetalle> detalles = new ArrayList<RigTmpArchivoDetalle>();
            int numeroDetalle = 0;
            block6: while (this.parserDetalles.hasNext() && numeroDetalle <= maximoDetalles) {
                int eventCode = this.parserDetalles.next();
                switch (eventCode) {
                    case 1: {
                        etiqueta = this.parserDetalles.getLocalName();
                        if (!this.cabeceraValidada) {
                            if (E_APS.equals(etiqueta)) {
                                detalles = new ArrayList();
                                dentroInformante = true;
                                break;
                            }
                            if (E_ACCIONISTAS.equals(etiqueta) || E_BENEFICIARIOS.equals(etiqueta)) {
                                Hashtable<Integer, ArrayList<RigTmpArchivoDetalle>> cabecera = new Hashtable<Integer, ArrayList<RigTmpArchivoDetalle>>();
                                cabecera.put(1, detalles);
                                detallesXml.put(NivelAnexoEnum.aps.name(), cabecera);
                                dentroInformante = false;
                                this.cabeceraValidada = true;
                                break;
                            }
                            if (!dentroInformante) break;
                            detalles.add(new RigTmpArchivoDetalle(etiqueta, this.parserDetalles.getElementText(), Long.valueOf(1L), ""));
                            break;
                        }
                        if (E_ACCIONISTA.equals(etiqueta)) {
                            detalles = new ArrayList();
                            ++numeroDetalle;
                            this.dentroAccionista = true;
                        } else if (this.dentroAccionista) {
                            if (E_INFO_PARTICIPACION_ACCIONARIA.equals(etiqueta) || E_UBICACION_RESIDENCIA_FISCAL.equals(etiqueta)) continue block6;
                            detalles.add(new RigTmpArchivoDetalle(etiqueta, this.parserDetalles.getElementText(), Long.valueOf(numeroDetalle), ""));
                        }
                        if (E_BENEFICIARIO.equals(etiqueta)) {
                            detalles = new ArrayList();
                            ++numeroDetalle;
                            this.dentroBeneficiario = true;
                            break;
                        }
                        if (!this.dentroBeneficiario) break;
                        detalles.add(new RigTmpArchivoDetalle(etiqueta, this.parserDetalles.getElementText(), Long.valueOf(numeroDetalle), ""));
                        break;
                    }
                    case 2: {
                        etiqueta = this.parserDetalles.getLocalName();
                        if (E_ACCIONISTA.equals(etiqueta)) {
                            accionistas.put(numeroDetalle, detalles);
                            this.dentroAccionista = false;
                            break;
                        }
                        if (E_ACCIONISTAS.equals(etiqueta)) {
                            this.tieneMasDetalles = false;
                            break;
                        }
                        if (E_BENEFICIARIO.equals(etiqueta)) {
                            beneficiarios.put(numeroDetalle, detalles);
                            this.tieneMasDetalles = false;
                            break;
                        }
                        if (!E_BENEFICIARIOS.equals(etiqueta)) break;
                        this.tieneMasDetalles = false;
                        break;
                    }
                }
            }
            detallesXml.put(NivelAnexoEnum.accionista.name(), accionistas);
            detallesXml.put(NivelAnexoEnum.beneficiario.name(), beneficiarios);
        }
        catch (XMLStreamException e) {
            this.tieneMasDetalles = false;
            PluginLogger.logError((String)"Error al procesar los detalles del anexo para validar.", (String)"ec.gob.sri.dimm.aps.validacion", (Exception)e);
            return null;
        }
        return detallesXml;
    }

    public static void main(String[] args) {
        ValidacionAPS val = new ValidacionAPS(new File("D:\\Users\\caor220612.AD_UIO\\Desktop\\Temp\\anexos aps\\archivoAnexo_APS_122.xml"));
        val.obtenerDetalles(500);
    }

    public static enum NivelAnexoEnum {
        aps,
        accionista,
        infoParticipacionAccionaria,
        ubicacionResidenciaFiscal,
        beneficiario;

        String ruta;
        String entidad;

        public String getRuta() {
            return this.ruta;
        }

        public String getEntidad() {
            return this.entidad;
        }
    }
}

