/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.impl;

import ec.gob.sri.anexo.prepersistencia.modelo.RigTmpArchivoDetalle;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.AdministradorModelo;
import ec.gob.sri.dimm.aps.modelo.excepciones.ExcepcionContribuyenteNoEncontrado;
import ec.gob.sri.dimm.aps.modelo.impl.ContenedorObjetosImportacion;
import ec.gob.sri.dimm.aps.modelo.obj.AdaptadorInformanteSujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.Beneficiario;
import ec.gob.sri.dimm.aps.modelo.obj.Informante;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.util.UtilValidacion;
import ec.gob.sri.dimm.aps.modelo.util.UtilidadHash;
import ec.gov.sri.dimm.principal.factory.BeanFactory;
import ec.gov.sri.dimm.principal.persistencia.Contribuyente;
import ec.gov.sri.dimm.principal.servicios.ServicioContribuyente;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdministradorModeloAPS
extends AdministradorModelo<Informante> {
    private Set<String> elementosExportados;
    private Deque<SujetoRelacionado> historialSujetos;

    public Document exportar(Informante modelo) {
        Document documento = this.obtenerDoc();
        Element rootElement = modelo.exportar(documento, null);
        this.elementosExportados = new TreeSet<String>();
        this.historialSujetos = new ArrayDeque<SujetoRelacionado>();
        AdaptadorInformanteSujetoRelacionado adapter = new AdaptadorInformanteSujetoRelacionado(modelo);
        this.historialSujetos.add(adapter);
        boolean esPeriodoDesde2024 = UtilValidacion.esAnexoDesdePeriodo2024(modelo.getAnio(), modelo.getMes());
        if (esPeriodoDesde2024) {
            if (modelo.getTipoDeclaracion().equals("02") && (modelo.getTipoSociedad().equals("08") || modelo.getTipoSociedad().equals("09"))) {
                Element beneficiarios = documento.createElement("beneficiarios");
                for (Beneficiario beneficiario : modelo.getBeneficiarios()) {
                    this.exportacionBeneficiario(beneficiario, modelo, documento, beneficiarios);
                }
                rootElement.appendChild(beneficiarios);
            } else {
                Element accionistas = documento.createElement("accionistas");
                for (Participacion participacion : modelo.getParticipaciones()) {
                    this.exportarParticipacion(participacion, modelo, documento, accionistas, 1);
                }
                rootElement.appendChild(accionistas);
                Element beneficiarios = documento.createElement("beneficiarios");
                for (Beneficiario beneficiario : modelo.getBeneficiarios()) {
                    this.exportacionBeneficiario(beneficiario, modelo, documento, beneficiarios);
                }
                rootElement.appendChild(beneficiarios);
            }
        } else {
            Element accionistas = documento.createElement("accionistas");
            for (Participacion participacion : modelo.getParticipaciones()) {
                this.exportarParticipacion(participacion, modelo, documento, accionistas, 1);
            }
            rootElement.appendChild(accionistas);
        }
        this.historialSujetos.clear();
        this.elementosExportados.clear();
        return documento;
    }

    private void exportacionBeneficiario(Beneficiario beneficiario, Informante modelo, Document documento, Element beneficiarios) {
        Element eBeneficiario = beneficiario.exportar(documento, beneficiarios);
        beneficiarios.appendChild(eBeneficiario);
    }

    private void exportarParticipacion(Participacion participacion, Informante modelo, Document documento, Element accionistas, int nivel) {
        participacion.setNivel(nivel);
        String idPadre = participacion.getPropietario() instanceof SujetoRelacionado ? ((SujetoRelacionado)participacion.getPropietario()).getIdentificacion() : modelo.getIdentificacion();
        String md5 = UtilidadHash.generarMD5Participacion(participacion.getSujeto().getTipoIdentificacion(), participacion.getSujeto().getIdentificacion(), idPadre, participacion.getTipoDeRelacion());
        if (this.elementosExportados.add(md5)) {
            boolean exportChildNodes = true;
            if (this.historialSujetos.contains((Object)participacion.getSujeto())) {
                exportChildNodes = false;
            } else {
                this.historialSujetos.add(participacion.getSujeto());
            }
            Element eParticipacion = participacion.exportar(documento, accionistas);
            accionistas.appendChild(eParticipacion);
            if (!participacion.getSujeto().getIdentificacion().equals(modelo.getIdentificacion()) && "E".equals(participacion.getSujeto().getTipoIdentificacion()) && !participacion.getSujeto().isSociedadExtranjeraPublica() && !"00".equals(participacion.getSujeto().getTipoSociedadExtranjera()) && !participacion.getSujeto().getIdentificacion().equals(idPadre) && exportChildNodes) {
                for (Participacion participacionN2 : participacion.getSujeto().getParticipaciones()) {
                    this.exportarParticipacion(participacionN2, modelo, documento, accionistas, nivel + 1);
                }
            } else {
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Informante importar(Document documento) {
        ObjetoModelo objPadre;
        String idPadre;
        void var9_17;
        String[] etiquetasCabecera;
        Informante modelo = new Informante();
        HashMap<String, Element> mapaTemp = new HashMap<String, Element>();
        String[] stringArray = etiquetasCabecera = new String[]{"TipoIDInformante", "IdInformante", "TipoSociedad", "Anio", "Mes", "PorcentajeAccionarioNoBolsa", "codigoOperativo", "PorcentajeAccionarioBolsa", "Anticipada", "TipoDeclaracion"};
        int n = etiquetasCabecera.length;
        int n2 = 0;
        while (n2 < n) {
            String etiqueta = stringArray[n2];
            NodeList nodeList = documento.getElementsByTagName(etiqueta);
            Element eDato = (Element)nodeList.item(0);
            mapaTemp.put(etiqueta, eDato);
            ++n2;
        }
        modelo.importar(null, mapaTemp);
        ServicioContribuyente servicio = (ServicioContribuyente)BeanFactory.getBean((String)"servicioContribuyente");
        Contribuyente contribuyente = servicio.findByRuc(modelo.getIdentificacion());
        if (contribuyente == null) {
            throw new ExcepcionContribuyenteNoEncontrado("El contribuyente con RUC " + modelo.getIdentificacion() + "no esta registrado en la base local " + "del DIMM");
        }
        modelo.setRazonSocial(contribuyente.getRazonSocial());
        ContenedorObjetosImportacion.sujetos.put(modelo.getIdentificacion(), (ObjetoModelo)new AdaptadorInformanteSujetoRelacionado(modelo));
        NodeList nl = documento.getElementsByTagName("accionista");
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                Element eAccionista = (Element)node;
                Participacion participacion = new Participacion();
                participacion.importar(eAccionista, null);
                NodeList listaValor = eAccionista.getElementsByTagName("numeroIdentificacion");
                Element eIdentificacion = (Element)listaValor.item(0);
                SujetoRelacionado suj = (SujetoRelacionado)ContenedorObjetosImportacion.sujetos.get(eIdentificacion.getTextContent().trim());
                NodeList anioValor = documento.getElementsByTagName("Anio");
                Element eAnio = (Element)anioValor.item(0);
                mapaTemp.put("Anio", eAnio);
                if (suj == null) {
                    suj = new SujetoRelacionado();
                    suj.importar(eAccionista, mapaTemp);
                    ContenedorObjetosImportacion.sujetos.put(suj.getIdentificacion(), (ObjetoModelo)suj);
                }
                participacion.setEsBeneficiarioFinal(suj.getEsBeneficiarioFinal());
                participacion.setSujeto(suj);
                String md5 = UtilidadHash.generarMD5Participacion(participacion.getSujeto().getTipoIdentificacion(), participacion.getSujeto().getIdentificacion(), participacion.getIdentificacionAccionistaPadre(), participacion.getTipoDeRelacion());
                ContenedorObjetosImportacion.participaciones.put(md5, participacion);
            }
            ++i;
        }
        NodeList nodeList = documento.getElementsByTagName("beneficiario");
        boolean bl = false;
        while (var9_17 < nodeList.getLength()) {
            Node nodo = nodeList.item((int)var9_17);
            if (nodo.getNodeType() == 1) {
                Element eBeneficiario = (Element)nodo;
                Beneficiario beneficiario = new Beneficiario();
                beneficiario.importar(eBeneficiario, null);
                SujetoRelacionado sujeto = (SujetoRelacionado)ContenedorObjetosImportacion.sujetos.get(modelo.getIdentificacion().trim());
                beneficiario.setSujeto(sujeto);
                String md5 = UtilidadHash.generarMD5Beneficiario(beneficiario.getNumeroIdentificacion(), beneficiario.getFechaNacimiento());
                ContenedorObjetosImportacion.beneficiarios.put(md5, beneficiario);
            }
            ++var9_17;
        }
        for (Map.Entry<String, Participacion> entry : ContenedorObjetosImportacion.participaciones.entrySet()) {
            idPadre = entry.getValue().getIdentificacionAccionistaPadre();
            objPadre = ContenedorObjetosImportacion.sujetos.get(idPadre);
            if (objPadre == null) continue;
            if (objPadre instanceof Informante) {
                ((Informante)objPadre).agregarParticipacion(entry.getValue());
                continue;
            }
            ((SujetoRelacionado)objPadre).agregarParticipacion(entry.getValue());
        }
        for (Map.Entry<String, ObjetoModeloSucesorValidable> entry : ContenedorObjetosImportacion.beneficiarios.entrySet()) {
            idPadre = ((Beneficiario)entry.getValue()).getSujeto().getIdentificacion();
            objPadre = ContenedorObjetosImportacion.sujetos.get(idPadre);
            if (objPadre == null) continue;
            if (objPadre instanceof Informante) {
                ((Informante)objPadre).agregarBeneficiario((Beneficiario)entry.getValue());
                continue;
            }
            ((SujetoRelacionado)objPadre).agregarBeneficiarioFinal((Beneficiario)entry.getValue());
            modelo.agregarBeneficiario((Beneficiario)entry.getValue());
        }
        return modelo;
    }

    public void importarSujetos(Element element) {
        SujetoRelacionado sujeto = new SujetoRelacionado();
        sujeto.importar(element, null);
        ContenedorObjetosImportacion.sujetos.put(sujeto.getIdentificacion(), (ObjetoModelo)sujeto);
    }

    private Document obtenerDoc() {
        Document document = null;
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            document = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return document;
    }

    public Hashtable<String, Hashtable<String, List<RigTmpArchivoDetalle>>> obtenerDatosValidacion(Informante modelo) {
        return null;
    }
}

