/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj;

import ec.gob.sri.dimm.aps.modelo.obj.Informante;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.MnemonicosCatalogos;
import ec.gob.sri.dimm.aps.modelo.util.StringModeloUtils;
import ec.gob.sri.dimm.data.impl.DataCatalogos;

public class AdaptadorInformanteSujetoRelacionado
extends SujetoRelacionado {
    private static final long serialVersionUID = 1302679132213622372L;
    private Informante informante;

    public AdaptadorInformanteSujetoRelacionado(Informante informante) {
        this.informante = informante;
        this.setDenominacion(informante.getRazonSocial());
        this.setTipoIdentificacion("R");
        this.setDescripcionTipoIdentificacion("RUC");
        this.setIdentificacion(informante.getIdentificacion());
        this.setPeriodo(informante.getAnio());
        this.setMes(informante.getMes());
        this.setDescripcionTipoSociedad(DataCatalogos.obtenerNombreDetalleCatalogo((String)MnemonicosCatalogos.TIPO_SOCIEDAD.getMnemonico(), (String)informante.getTipoSociedad()));
        Double porcentajeNoCotizaInformante = informante.getPorcentajeNoCotiza();
        this.setPorcentajeNoCotiza(porcentajeNoCotizaInformante == null ? "0.00" : StringModeloUtils.obtenerFormatoDecimal(porcentajeNoCotizaInformante));
        if ("02".equals(informante.getTipoSociedad())) {
            this.setPorcentajeCotiza(porcentajeNoCotizaInformante == null ? "0.00" : (porcentajeNoCotizaInformante >= 0.0 ? StringModeloUtils.obtenerFormatoDecimal(100.0 - porcentajeNoCotizaInformante) : "0.00"));
        } else {
            this.setPorcentajeCotiza(porcentajeNoCotizaInformante == null ? "0.00" : (porcentajeNoCotizaInformante > 0.0 ? StringModeloUtils.obtenerFormatoDecimal(100.0 - porcentajeNoCotizaInformante) : "0.00"));
        }
        this.setParticipaciones(informante.getParticipaciones());
        this.setDescripcionTipoDeclaracion(informante.getDescripcionTipoDeclaracion());
    }

    public Informante getInformante() {
        return this.informante;
    }
}

