/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ValidacionIdentificacion;
import ec.gob.sri.dimm.aps.modelo.obj.Constantes;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.UbicacionBeneficiarioFinal;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Beneficiario
extends ObjetoModeloSucesorValidable<ObjetoModelo>
implements Exportable,
Importable,
InformacionEditable<Beneficiario> {
    private static final long serialVersionUID = 2833849593555411828L;
    private static final String TAG = "beneficiario";
    public static final String C_TIPO_IDENTIFICACION = "tipoIdentificacion";
    public static final String C_NUMERO_IDENTIFICACION = "numeroIdentificacion";
    public static final String C_PRIMER_NOMBRE = "primerNombre";
    public static final String C_SEGUNDO_NOMBRE = "segundoNombre";
    public static final String C_PRIMER_APELLIDO = "primerApellido";
    public static final String C_SEGUNDO_APELLIDO = "segundoApellido";
    public static final String C_FECHA_NACIMIENTO = "fechaNacimiento";
    public static final String C_POR_PROPIEDAD = "porPropiedad";
    public static final String C_PORCENTAJE_PROPIEDAD = "porcentajePropiedad";
    public static final String C_POR_OTROS_MOTIVOS = "porOtrosMotivos";
    public static final String C_POR_OTROS_RELACIONADOS = "porOtrosRelacionados";
    public static final String C_POR_ADMINISTRACION = "porAdministracion";
    public static final String C_DESCRIPTION_TIPO_ID = "descripcionTipoIdentificacion";
    private String tipoIdentificacion;
    private String numeroIdentificacion;
    private String primerNombre;
    private String segundoNombre;
    private String primerApellido;
    private String segundoApellido;
    private String fechaNacimiento;
    private String porPropiedad;
    private String porcentajePropiedad;
    private String porOtrosMotivos;
    private String porOtrosRelacionados;
    private String porAdministracion;
    private String nombreApellido;
    private String descripcionTipoIdentificacion;
    private UbicacionBeneficiarioFinal ubicacionBeneficiarioFinal;
    private Boolean esEdicion;
    private SujetoRelacionado sujeto = new SujetoRelacionado();

    public void setNombreApellido(String nombreApellido) {
        this.nombreApellido = nombreApellido;
    }

    public String getNombreApellido() {
        this.nombreApellido = this.getPrimerNombre().concat(" ").concat(this.getPrimerApellido());
        return this.nombreApellido;
    }

    public String getDescripcionTipoIdentificacion() {
        return this.descripcionTipoIdentificacion;
    }

    public void setDescripcionTipoIdentificacion(String descripcionTipoIdentificacion) {
        String oldValue = this.descripcionTipoIdentificacion;
        this.descripcionTipoIdentificacion = descripcionTipoIdentificacion;
        this.firePropertyChange(C_DESCRIPTION_TIPO_ID, oldValue, this.descripcionTipoIdentificacion);
    }

    public String getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    public void setTipoIdentificacion(String tipoIdentificacion) {
        String oldValue = this.tipoIdentificacion;
        this.tipoIdentificacion = tipoIdentificacion;
        this.firePropertyChange(C_TIPO_IDENTIFICACION, oldValue, this.tipoIdentificacion);
    }

    public String getNumeroIdentificacion() {
        return this.numeroIdentificacion;
    }

    public void setNumeroIdentificacion(String numeroIdentificacion) {
        String oldValue = this.numeroIdentificacion;
        this.numeroIdentificacion = numeroIdentificacion;
        this.firePropertyChange(C_NUMERO_IDENTIFICACION, oldValue, this.numeroIdentificacion);
    }

    public String getPrimerNombre() {
        return this.primerNombre;
    }

    public void setPrimerNombre(String primerNombre) {
        String oldValue = this.primerNombre;
        this.primerNombre = primerNombre;
        this.firePropertyChange(C_PRIMER_NOMBRE, oldValue, this.primerNombre);
    }

    public String getSegundoNombre() {
        return this.segundoNombre;
    }

    public void setSegundoNombre(String segundoNombre) {
        String oldValue = this.segundoNombre;
        this.segundoNombre = segundoNombre;
        this.firePropertyChange(C_SEGUNDO_NOMBRE, oldValue, this.segundoNombre);
    }

    public String getPrimerApellido() {
        return this.primerApellido;
    }

    public void setPrimerApellido(String primerApellido) {
        String oldValue = this.primerApellido;
        this.primerApellido = primerApellido;
        this.firePropertyChange(C_PRIMER_APELLIDO, oldValue, this.primerApellido);
    }

    public String getSegundoApellido() {
        return this.segundoApellido;
    }

    public void setSegundoApellido(String segundoApellido) {
        String oldValue = this.segundoApellido;
        this.segundoApellido = segundoApellido;
        this.firePropertyChange(C_SEGUNDO_APELLIDO, oldValue, this.segundoApellido);
    }

    public String getFechaNacimiento() {
        return this.fechaNacimiento;
    }

    public void setFechaNacimiento(String fechaNacimiento) {
        String oldValue = this.fechaNacimiento;
        this.fechaNacimiento = fechaNacimiento;
        this.firePropertyChange(C_FECHA_NACIMIENTO, oldValue, this.fechaNacimiento);
    }

    public String getPorPropiedad() {
        return this.porPropiedad;
    }

    public void setPorPropiedad(String porPropiedad) {
        String oldValue = this.porPropiedad;
        this.porPropiedad = porPropiedad;
        this.firePropertyChange(C_POR_PROPIEDAD, oldValue, this.porPropiedad);
    }

    public String getPorcentajePropiedad() {
        return this.porcentajePropiedad;
    }

    public void setPorcentajePropiedad(String porcentajePropiedad) {
        String oldValue = this.porcentajePropiedad;
        this.porcentajePropiedad = porcentajePropiedad;
        this.firePropertyChange(C_PORCENTAJE_PROPIEDAD, oldValue, this.porcentajePropiedad);
    }

    public String getPorOtrosMotivos() {
        return this.porOtrosMotivos;
    }

    public void setPorOtrosMotivos(String porOtrosMotivos) {
        String oldValue = this.porOtrosMotivos;
        this.porOtrosMotivos = porOtrosMotivos;
        this.firePropertyChange(C_POR_OTROS_MOTIVOS, oldValue, this.porOtrosMotivos);
    }

    public String getPorOtrosRelacionados() {
        return this.porOtrosRelacionados;
    }

    public void setPorOtrosRelacionados(String porOtrosRelacionados) {
        String oldValue = this.porOtrosRelacionados;
        this.porOtrosRelacionados = porOtrosRelacionados;
        this.firePropertyChange(C_POR_OTROS_RELACIONADOS, oldValue, this.porOtrosRelacionados);
    }

    public String getPorAdministracion() {
        return this.porAdministracion;
    }

    public void setPorAdministracion(String porAdministracion) {
        String oldValue = this.porAdministracion;
        this.porAdministracion = porAdministracion;
        this.firePropertyChange(C_POR_ADMINISTRACION, oldValue, this.porAdministracion);
    }

    public UbicacionBeneficiarioFinal getUbicacionBeneficiarioFinal() {
        return this.ubicacionBeneficiarioFinal;
    }

    public void setUbicacionBeneficiarioFinal(UbicacionBeneficiarioFinal ubicacionBeneficiarioFinal) {
        this.ubicacionBeneficiarioFinal = ubicacionBeneficiarioFinal;
    }

    public SujetoRelacionado getSujeto() {
        return this.sujeto;
    }

    public void setSujeto(SujetoRelacionado sujeto) {
        this.sujeto = sujeto;
    }

    public Boolean getEsEdicion() {
        return this.esEdicion;
    }

    public void setEsEdicion(Boolean esEdicion) {
        this.esEdicion = esEdicion;
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (StringUtil.isNullOrEmpty((String)this.tipoIdentificacion)) {
            return resultado.fallarValidacion("Es necesario indicar el tipo de identificaci\u00f3n del Beneficiario Final.");
        }
        if (StringUtil.isNullOrEmpty((String)this.numeroIdentificacion)) {
            return resultado.fallarValidacion("Debe ingresar la identificaci\u00f3n de Residencia Fiscal del Beneficiario Final.");
        }
        if (!Pattern.matches("[a-zA-Z0-9]+", this.numeroIdentificacion)) {
            return resultado.fallarValidacion("La identificaci\u00f3n de Residencia Fiscal del Beneficiario Final contiene espacios o caracteres no permitidos");
        }
        if (!(resultado = ValidacionIdentificacion.validarTodaIdentificacion((String)this.tipoIdentificacion, (String)this.numeroIdentificacion, (ResultadoValidacion)resultado, (Integer)5, (Integer)20)).esEstadoExitoso()) {
            return resultado;
        }
        if (StringUtil.isNullOrEmpty((String)this.primerNombre)) {
            return resultado.fallarValidacion("Debe ingresar el primer nombre del Beneficiario Final.");
        }
        if (StringUtil.isNullOrEmpty((String)this.primerApellido)) {
            return resultado.fallarValidacion("Debe ingresar el primer apellido del Beneficiario Final.");
        }
        if (StringUtil.isNullOrEmpty((String)this.fechaNacimiento)) {
            return resultado.fallarValidacion("Debe ingresar la fecha de nacimiento del Beneficiario Final.");
        }
        if (this.fechaNacimiento.length() < 10) {
            return resultado.fallarValidacion("El valor ingresado para fecha de nacimiento del Beneficiario Final no es correcto.");
        }
        if (this.fechaNacimiento.length() == 10) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf.setLenient(false);
            try {
                sdf.parse(this.fechaNacimiento);
            }
            catch (ParseException parseException) {
                return resultado.fallarValidacion("El valor ingresado para fecha de nacimiento del Beneficiario Final no es correcto.");
            }
        }
        if (StringUtil.isNullOrEmpty((String)this.porPropiedad)) {
            return resultado.fallarValidacion("Debe seleccionar el campo Beneficiario Final por Propiedad.");
        }
        if (StringUtil.isNullOrEmpty((String)this.porcentajePropiedad)) {
            return resultado.fallarValidacion("Debe ingresar el Porcentaje de Participaci\u00f3n Efectiva de Propiedad.");
        }
        if (!Pattern.matches("[0-9]{1,3}\\.[0-9]{1,6}|\\d{1,3}", this.porcentajePropiedad)) {
            return resultado.fallarValidacion("El valor ingresado como Porcentaje de Participaci\u00f3n Efectiva de Propiedad no es correcto.");
        }
        BigDecimal porcentaje = new BigDecimal(this.porcentajePropiedad);
        if (porcentaje.compareTo(BigDecimal.ZERO) < 0 || porcentaje.compareTo(Constantes.CIEN) > 0) {
            return resultado.fallarValidacion("El Porcentaje de Participaci\u00f3n Efectiva de Propiedad no puede ser menor que 0 ni mayor a 100.");
        }
        if (StringUtil.isNullOrEmpty((String)this.porOtrosMotivos)) {
            return resultado.fallarValidacion("Debe seleccionar el campo Beneficiario Final por otros motivos de control.");
        }
        if ("08".equals(this.porOtrosMotivos) && StringUtil.isNullOrEmpty((String)this.porOtrosRelacionados)) {
            return resultado.fallarValidacion("Debe ingresar en el campo Otros relacionados al control de la entidad.");
        }
        if ("02".equals(this.porPropiedad) && "09".equals(this.porOtrosMotivos) && StringUtil.isNullOrEmpty((String)this.porAdministracion)) {
            return resultado.fallarValidacion("Debe seleccionar el campo Beneficiario Final por Administraci\u00f3n.");
        }
        return resultado.pasarValidacion();
    }

    public Object importar(Element beneficiario, Map<String, Element> mapaData) {
        this.ubicacionBeneficiarioFinal = new UbicacionBeneficiarioFinal();
        NodeList listaValor = beneficiario.getElementsByTagName(C_TIPO_IDENTIFICACION);
        Element eValor = (Element)listaValor.item(0);
        this.setTipoIdentificacion(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_NUMERO_IDENTIFICACION);
        eValor = (Element)listaValor.item(0);
        this.setNumeroIdentificacion(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_NUMERO_IDENTIFICACION);
        eValor = (Element)listaValor.item(0);
        this.setNumeroIdentificacion(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_PRIMER_NOMBRE);
        eValor = (Element)listaValor.item(0);
        this.setPrimerNombre(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_SEGUNDO_NOMBRE);
        eValor = (Element)listaValor.item(0);
        this.setSegundoNombre(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_PRIMER_APELLIDO);
        eValor = (Element)listaValor.item(0);
        this.setPrimerApellido(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_SEGUNDO_APELLIDO);
        eValor = (Element)listaValor.item(0);
        this.setSegundoApellido(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_FECHA_NACIMIENTO);
        eValor = (Element)listaValor.item(0);
        this.setFechaNacimiento(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_POR_PROPIEDAD);
        eValor = (Element)listaValor.item(0);
        this.setPorPropiedad(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_PORCENTAJE_PROPIEDAD);
        eValor = (Element)listaValor.item(0);
        this.setPorcentajePropiedad(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_POR_OTROS_MOTIVOS);
        eValor = (Element)listaValor.item(0);
        this.setPorOtrosMotivos(eValor.getTextContent());
        listaValor = beneficiario.getElementsByTagName(C_POR_OTROS_RELACIONADOS);
        eValor = (Element)listaValor.item(0);
        this.setPorOtrosRelacionados(eValor.getTextContent());
        this.ubicacionBeneficiarioFinal.importar(beneficiario, mapaData);
        return this;
    }

    public Element exportar(Document documento, Element element) {
        Element beneficiario = documento.createElement(TAG);
        Element eTipoIdentificacion = documento.createElement(C_TIPO_IDENTIFICACION);
        eTipoIdentificacion.setTextContent(StringUtil.isNullOrEmpty((String)this.tipoIdentificacion) ? "NA" : this.tipoIdentificacion);
        beneficiario.appendChild(eTipoIdentificacion);
        Element eNumeroIdentificacion = documento.createElement(C_NUMERO_IDENTIFICACION);
        eNumeroIdentificacion.setTextContent(StringUtil.isNullOrEmpty((String)this.numeroIdentificacion) ? "NA" : this.numeroIdentificacion);
        beneficiario.appendChild(eNumeroIdentificacion);
        Element ePrimerNombre = documento.createElement(C_PRIMER_NOMBRE);
        ePrimerNombre.setTextContent(StringUtil.isNullOrEmpty((String)this.primerNombre) ? "NA" : this.primerNombre);
        beneficiario.appendChild(ePrimerNombre);
        Element eSegundoNombre = documento.createElement(C_SEGUNDO_NOMBRE);
        eSegundoNombre.setTextContent(StringUtil.isNullOrEmpty((String)this.segundoNombre) ? "NA" : this.segundoNombre);
        beneficiario.appendChild(eSegundoNombre);
        Element ePrimerApellido = documento.createElement(C_PRIMER_APELLIDO);
        ePrimerApellido.setTextContent(StringUtil.isNullOrEmpty((String)this.primerApellido) ? "NA" : this.primerApellido);
        beneficiario.appendChild(ePrimerApellido);
        Element eSegundoApellido = documento.createElement(C_SEGUNDO_APELLIDO);
        eSegundoApellido.setTextContent(StringUtil.isNullOrEmpty((String)this.segundoApellido) ? "NA" : this.segundoApellido);
        beneficiario.appendChild(eSegundoApellido);
        Element eFechaNacimiento = documento.createElement(C_FECHA_NACIMIENTO);
        eFechaNacimiento.setTextContent(StringUtil.isNullOrEmpty((String)this.fechaNacimiento) ? "NA" : this.fechaNacimiento);
        beneficiario.appendChild(eFechaNacimiento);
        Element ePorPropiedad = documento.createElement(C_POR_PROPIEDAD);
        ePorPropiedad.setTextContent(StringUtil.isNullOrEmpty((String)this.porPropiedad) ? "NA" : this.porPropiedad);
        beneficiario.appendChild(ePorPropiedad);
        Element ePorcentajePropiedad = documento.createElement(C_PORCENTAJE_PROPIEDAD);
        ePorcentajePropiedad.setTextContent(StringUtil.isNullOrEmpty((String)this.porcentajePropiedad) ? "NA" : this.porcentajePropiedad);
        beneficiario.appendChild(ePorcentajePropiedad);
        Element ePorOtrosMotivos = documento.createElement(C_POR_OTROS_MOTIVOS);
        ePorOtrosMotivos.setTextContent(StringUtil.isNullOrEmpty((String)this.porOtrosMotivos) ? "NA" : this.porOtrosMotivos);
        beneficiario.appendChild(ePorOtrosMotivos);
        Element ePorOtrosRelacionados = documento.createElement(C_POR_OTROS_RELACIONADOS);
        ePorOtrosRelacionados.setTextContent(StringUtil.isNullOrEmpty((String)this.porOtrosRelacionados) ? "NA" : this.porOtrosRelacionados);
        beneficiario.appendChild(ePorOtrosRelacionados);
        Element ePorAdministracion = documento.createElement(C_POR_ADMINISTRACION);
        ePorAdministracion.setTextContent(StringUtil.isNullOrEmpty((String)this.porAdministracion) ? "NA" : this.porAdministracion);
        beneficiario.appendChild(ePorAdministracion);
        this.ubicacionBeneficiarioFinal.exportar(documento, beneficiario);
        return beneficiario;
    }

    public Beneficiario crearCopiaEdicion() {
        Beneficiario copiaEdicion = new Beneficiario();
        copiaEdicion.setTipoIdentificacion(this.tipoIdentificacion);
        copiaEdicion.setNumeroIdentificacion(this.numeroIdentificacion);
        copiaEdicion.setNombreApellido(this.nombreApellido);
        copiaEdicion.setPrimerNombre(this.primerNombre);
        copiaEdicion.setSegundoNombre(this.segundoNombre);
        copiaEdicion.setPrimerApellido(this.primerApellido);
        copiaEdicion.setSegundoApellido(this.segundoApellido);
        copiaEdicion.setFechaNacimiento(this.fechaNacimiento);
        copiaEdicion.setPorPropiedad(this.porPropiedad);
        copiaEdicion.setPorcentajePropiedad(this.porcentajePropiedad);
        copiaEdicion.setPorOtrosMotivos(this.porOtrosMotivos);
        copiaEdicion.setPorOtrosRelacionados(this.porOtrosRelacionados);
        copiaEdicion.setPorAdministracion(this.porAdministracion);
        copiaEdicion.ubicacionBeneficiarioFinal = this.ubicacionBeneficiarioFinal.crearCopiaEdicion();
        copiaEdicion.setEsEdicion(true);
        return copiaEdicion;
    }

    public void actualizarInformacion(Beneficiario copiaEdicion) {
        this.setTipoIdentificacion(copiaEdicion.getTipoIdentificacion());
        this.setNombreApellido(copiaEdicion.getNombreApellido());
        this.setNumeroIdentificacion(copiaEdicion.getNumeroIdentificacion());
        this.setPrimerNombre(copiaEdicion.getPrimerNombre());
        this.setSegundoNombre(copiaEdicion.getSegundoNombre());
        this.setPrimerApellido(copiaEdicion.getPrimerApellido());
        this.setSegundoApellido(copiaEdicion.getSegundoApellido());
        this.setFechaNacimiento(copiaEdicion.getFechaNacimiento());
        this.setPorPropiedad(copiaEdicion.getPorPropiedad());
        this.setPorcentajePropiedad(copiaEdicion.getPorcentajePropiedad());
        this.setPorOtrosMotivos(copiaEdicion.getPorOtrosMotivos());
        this.setPorOtrosRelacionados(copiaEdicion.getPorOtrosRelacionados());
        this.setPorAdministracion(copiaEdicion.getPorAdministracion());
        this.setUbicacionBeneficiarioFinal(copiaEdicion.getUbicacionBeneficiarioFinal());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Beneficiario beneficiario = (Beneficiario)((Object)obj);
        return this.numeroIdentificacion.equals(beneficiario.numeroIdentificacion) && this.tipoIdentificacion.equals(beneficiario.tipoIdentificacion);
    }

    public int hashCode() {
        return this.numeroIdentificacion.hashCode() + this.tipoIdentificacion.hashCode();
    }

    public String toString() {
        return "Beneficiario{Identificacion='" + this.numeroIdentificacion + "', Tipo=" + this.tipoIdentificacion + "}";
    }
}

