/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ValidacionIdentificacion;
import ec.gob.sri.dimm.aps.modelo.obj.Constantes;
import ec.gob.sri.dimm.aps.modelo.obj.DatosUbicacion;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.MnemonicosCatalogos;
import ec.gob.sri.dimm.aps.modelo.util.StringModeloUtils;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeneficiarioFinal
extends ObjetoModeloSucesorValidable<Participacion>
implements Exportable,
Importable,
InformacionEditable<BeneficiarioFinal> {
    private static final long serialVersionUID = -2838874019204216137L;
    public static final String C_DENOMINACION = "denominacion";
    public static final String C_TIPO_IDENTIFICACION = "tipoIdentificacion";
    public static final String C_IDENTIFICACION = "identificacion";
    public static final String C_TIPO_SOCIEDAD = "tipoSociedadExtranjera";
    public static final String C_SOCIEDAD_EXT_PUBLICA = "sociedadExtranjeraPublica";
    public static final String CC_PARTICIPACIONES = "participaciones";
    public static final String C_FIGURA_JURIDICA = "figuraJuridica";
    public static final String C_PORCENTAJE_NO_COTIZA_ACC = "porcentajeNoCotiza";
    public static final String C_PORCENTAJE_COTIZA_ACC = "porcentajeCotiza";
    public static final String C_PARTE_RELACIONADA = "parteRelacionada";
    public static final String C_TIPO_PERSONA = "tipoPersona";
    public static final String C_TIPO_REGIMEN_FISCAL = "tipoRegimenFiscal";
    public static final String C_NEGOCIA_BOLSA = "negociaBolsa";
    public static final String C_MENOR_10_PORCIENTO = "menorDiezPorciento";
    public static final String C_TIPO_SUJETO = "tipoSujeto";
    public static final String C_PRIMER_NOMBRE = "primerNombre";
    public static final String C_SEGUNDO_NOMBRE = "segundoNombre";
    public static final String C_PRIMER_APELLIDO = "primerApellido";
    public static final String C_SEGUNDO_APELLIDO = "segundoApellido";
    public static final String C_NOMBRES_RAZON_SOCIAL = "nombresRazonSocial";
    public static final String C_FIGURA_JURIDICA_OTRO = "figuraJuridicaOtro";
    private static final String NATURAL = "PERSONA NATURAL";
    private static final String SOC_PRIVADA = "SOCIEDAD PRIVADA";
    private static final String SOC_PUBLICA = "SOCIEDAD PUBLICA";
    private String denominacion;
    private String tipoIdentificacion;
    private String descripcionTipoIdentificacion;
    private String identificacion;
    private String tipoSociedadExtranjera;
    private String descripcionTipoSociedad;
    private String tipoRegimenFiscal;
    private String descripcionTipoRegimen;
    private boolean sociedadExtranjeraPublica;
    private String figuraJuridica;
    private String porcentajeNoCotiza;
    private String porcentajeCotiza;
    private boolean parteRelacionada;
    private String tipoPersona;
    private String periodo;
    private boolean menorDiezPorciento;
    private DatosUbicacion datosUbicacion;
    private String tipoSujeto;
    private String primerNombre;
    private String segundoNombre;
    private String primerApellido;
    private String segundoApellido;
    private String nombresRazonSocial;
    private String figuraJuridicaOtro;
    private String mes;
    private List<Participacion> participaciones = new ArrayList<Participacion>();

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (StringUtil.isNullOrEmpty((String)this.tipoIdentificacion)) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de identificaci\u00f3n.");
        }
        if (StringUtil.isNullOrEmpty((String)this.identificacion)) {
            return resultado.fallarValidacion("Debe escribir el n\u00famero de identificaci\u00f3n del trabajador.");
        }
        if (StringUtil.isNullOrEmpty((String)this.denominacion)) {
            return resultado.fallarValidacion("Debe ingresar la Raz\u00f3n Social del Sujeto");
        }
        if (!Pattern.matches("[a-zA-Z0-9][a-zA-Z0-9\\s]{4,499}", this.denominacion)) {
            return resultado.fallarValidacion("La denominaci\u00f3n del sujeto debe tener \u00fanicamente letras y debe tener una longitud de entre 5 y 500 caracteres");
        }
        if (StringUtil.isNullOrEmpty((String)this.tipoRegimenFiscal)) {
            return resultado.fallarValidacion("Debe seleccionar el Tipo de R\u00e9gimen Fiscal");
        }
        if ("E".equals(this.tipoIdentificacion)) {
            if (StringUtil.isNullOrEmpty((String)this.tipoSociedadExtranjera)) {
                return resultado.fallarValidacion("Debe seleccionar el Tipo de Sociedad");
            }
            if (!"00".equals(this.tipoSociedadExtranjera)) {
                if (StringUtil.isNullOrEmpty((String)this.figuraJuridica)) {
                    return resultado.fallarValidacion("Debe llenar el campo Figura Jur\u00eddica para el Tipo de Sociedad Persona Natural");
                }
                if (!Pattern.matches("[a-zA-Z0-9]{2}[a-zA-Z0-9\\s]{0,48}", this.figuraJuridica)) {
                    return resultado.fallarValidacion("El valor ingresado para la figura jur\u00eddica no es correcto. Verifique que no contenga caracteres especiales, tildes ni la letra \u00f1");
                }
            }
            if (this.figuraJuridica.equals("89901") && StringUtil.isNullOrEmpty((String)this.figuraJuridicaOtro)) {
                return resultado.fallarValidacion("Debe llenar el campo Figura Jur\u00eddica Otro.");
            }
            if ("02".equals(this.tipoSociedadExtranjera) && !this.sociedadExtranjeraPublica) {
                if (StringUtil.isNullOrEmpty((String)this.porcentajeNoCotiza)) {
                    return resultado.fallarValidacion("No ha ingresado el porcentaje accionario que no cotiza en bolsa de la sociedad.");
                }
                if (!Pattern.matches("[0-9]{1,3}\\.[0-9]{1,6}|\\d{1,3}", this.porcentajeNoCotiza)) {
                    return resultado.fallarValidacion("El porcentaje accionario tiene un valor incorrecto.");
                }
                if (StringModeloUtils.obtenerNumeroDeDecimales(Double.parseDouble(this.porcentajeNoCotiza)) > 6) {
                    return resultado.fallarValidacion("El valor registrado como porcentaje accionario que no cotiza en bolsa de valores debe tener m\u00e1ximo 6 decimales.");
                }
                if (Double.parseDouble(this.porcentajeNoCotiza) < 0.0 || Double.parseDouble(this.porcentajeNoCotiza) > 100.0) {
                    return resultado.fallarValidacion("El valor registrado como porcentaje accionario no puede ser menor a cero ni mayor a 100.");
                }
            }
        }
        if (!this.isParteRelacionada()) {
            return resultado.pasarValidacionAdvertencia("Por favor verifique que el sujeto '" + this.denominacion + "' no es parte relacionada del Informante.");
        }
        if (!(resultado = ValidacionIdentificacion.validarTodaIdentificacion((String)this.tipoIdentificacion, (String)this.identificacion, (ResultadoValidacion)resultado, (Integer)5, (Integer)20)).esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    public String getPorcentajeNoCotiza() {
        return this.porcentajeNoCotiza;
    }

    public void setPorcentajeNoCotiza(String porcentajeNoCotiza) {
        String oldPorcentajeNoCotiza = this.porcentajeNoCotiza;
        this.porcentajeNoCotiza = porcentajeNoCotiza;
        this.firePropertyChange(C_PORCENTAJE_NO_COTIZA_ACC, oldPorcentajeNoCotiza, this.porcentajeNoCotiza);
    }

    public String getPorcentajeCotiza() {
        return this.porcentajeCotiza;
    }

    public void setPorcentajeCotiza(String porcentajeCotiza) {
        String oldPorcentajeCotiza = this.porcentajeCotiza;
        this.porcentajeCotiza = porcentajeCotiza;
        this.firePropertyChange(C_PORCENTAJE_COTIZA_ACC, oldPorcentajeCotiza, this.porcentajeCotiza);
    }

    public String getDenominacion() {
        return this.denominacion;
    }

    public void setDenominacion(String denominacion) {
        String oldValue = this.denominacion;
        this.denominacion = StringUtil.isNullOrEmpty((String)denominacion) ? denominacion : denominacion.trim().toUpperCase();
        this.firePropertyChange(C_DENOMINACION, oldValue, this.denominacion);
    }

    public String getTipoRegimenFiscal() {
        return this.tipoRegimenFiscal;
    }

    public void setTipoRegimenFiscal(String tipoRegimenFiscal) {
        String oldValue = this.tipoRegimenFiscal;
        this.tipoRegimenFiscal = StringUtil.isNullOrEmpty((String)tipoRegimenFiscal) ? tipoRegimenFiscal : tipoRegimenFiscal.trim().toUpperCase();
        this.firePropertyChange(C_TIPO_REGIMEN_FISCAL, oldValue, this.tipoRegimenFiscal);
    }

    public String getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    public void setTipoIdentificacion(String tipoIdentificacion) {
        String oldValue = this.tipoIdentificacion;
        this.tipoIdentificacion = tipoIdentificacion;
        this.firePropertyChange(C_TIPO_IDENTIFICACION, oldValue, this.tipoIdentificacion);
    }

    public String getIdentificacion() {
        return this.identificacion;
    }

    public void setIdentificacion(String identificacion) {
        String oldValue = this.identificacion;
        this.identificacion = StringUtil.isNullOrEmpty((String)identificacion) ? identificacion : identificacion.toUpperCase();
        this.firePropertyChange(C_IDENTIFICACION, oldValue, this.identificacion);
    }

    public String getTipoSociedadExtranjera() {
        return this.tipoSociedadExtranjera;
    }

    public void setTipoSociedadExtranjera(String tipoSociedadExtranjera) {
        String oldValue = this.tipoSociedadExtranjera;
        this.tipoSociedadExtranjera = tipoSociedadExtranjera;
        this.firePropertyChange(C_TIPO_SOCIEDAD, oldValue, this.tipoSociedadExtranjera);
    }

    public boolean isSociedadExtranjeraPublica() {
        return this.sociedadExtranjeraPublica;
    }

    public void setSociedadExtranjeraPublica(boolean sociedadExtranjeraPublica) {
        boolean oldValue = this.sociedadExtranjeraPublica;
        this.sociedadExtranjeraPublica = sociedadExtranjeraPublica;
        this.firePropertyChange(C_SOCIEDAD_EXT_PUBLICA, oldValue, this.sociedadExtranjeraPublica);
    }

    public boolean isMenorDiezPorciento() {
        return this.menorDiezPorciento;
    }

    public void setMenorDiezPorciento(boolean menorDiezPorciento) {
        boolean oldValue = this.menorDiezPorciento;
        this.menorDiezPorciento = menorDiezPorciento;
        this.firePropertyChange(C_MENOR_10_PORCIENTO, oldValue, this.menorDiezPorciento);
    }

    public String getTipoSujeto() {
        return this.tipoSujeto;
    }

    public void setTipoSujeto(String tipoSujeto) {
        this.tipoSujeto = tipoSujeto;
    }

    public String getPrimerNombre() {
        return this.primerNombre;
    }

    public void setPrimerNombre(String primerNombre) {
        this.primerNombre = primerNombre;
    }

    public String getSegundoNombre() {
        return this.segundoNombre;
    }

    public void setSegundoNombre(String segundoNombre) {
        this.segundoNombre = segundoNombre;
    }

    public String getPrimerApellido() {
        return this.primerApellido;
    }

    public void setPrimerApellido(String primerApellido) {
        this.primerApellido = primerApellido;
    }

    public String getSegundoApellido() {
        return this.segundoApellido;
    }

    public void setSegundoApellido(String segundoApellido) {
        this.segundoApellido = segundoApellido;
    }

    public String getNombresRazonSocial() {
        return this.nombresRazonSocial;
    }

    public void setNombresRazonSocial(String nombresRazonSocial) {
        this.nombresRazonSocial = nombresRazonSocial;
    }

    public void agregarParticipacion(Participacion participacion) {
        participacion.setPropietario((ObjetoModelo)this);
        this.participaciones.add(participacion);
        this.firePropertyChange(CC_PARTICIPACIONES, null, this.participaciones);
    }

    public boolean eliminarParticipacion(Participacion participacion) {
        boolean eliminado = this.participaciones.remove((Object)participacion);
        if (eliminado) {
            this.firePropertyChange(CC_PARTICIPACIONES, null, this.participaciones);
        }
        return eliminado;
    }

    public String getDescripcionTipoIdentificacion() {
        return this.descripcionTipoIdentificacion;
    }

    public void setDescripcionTipoIdentificacion(String descripcionTipoIdentificacion) {
        this.descripcionTipoIdentificacion = descripcionTipoIdentificacion;
    }

    public String getDescripcionTipoSociedad() {
        return this.descripcionTipoSociedad;
    }

    public void setDescripcionTipoSociedad(String descripcionTipoSociedad) {
        this.descripcionTipoSociedad = descripcionTipoSociedad;
    }

    public String getDescripcionTipoRegimen() {
        return this.descripcionTipoRegimen;
    }

    public void setDescripcionTipoRegimen(String descripcionTipoRegimen) {
        this.descripcionTipoRegimen = descripcionTipoRegimen;
    }

    public String getFiguraJuridica() {
        return this.figuraJuridica;
    }

    public void setFiguraJuridica(String figuraJuridica) {
        String oldValue = this.figuraJuridica;
        this.figuraJuridica = StringUtil.isNullOrEmpty((String)figuraJuridica) ? figuraJuridica : figuraJuridica.trim().toUpperCase();
        this.firePropertyChange(C_FIGURA_JURIDICA, oldValue, this.figuraJuridica);
    }

    public String getFiguraJuridicaOtro() {
        return this.figuraJuridicaOtro;
    }

    public void setFiguraJuridicaOtro(String figuraJuridicaOtro) {
        String oldValue = this.figuraJuridicaOtro;
        this.figuraJuridicaOtro = figuraJuridicaOtro;
        this.firePropertyChange(C_FIGURA_JURIDICA_OTRO, oldValue, this.figuraJuridicaOtro);
    }

    public boolean isParteRelacionada() {
        return this.parteRelacionada;
    }

    public String getIsParteRelacionada() {
        return this.parteRelacionada ? "SI" : "NO";
    }

    public void setParteRelacionada(boolean parteRelacionada) {
        boolean oldValue = this.parteRelacionada;
        this.parteRelacionada = parteRelacionada;
        this.firePropertyChange(C_PARTE_RELACIONADA, oldValue, this.parteRelacionada);
    }

    public String getTipoPersona() {
        return this.tipoPersona;
    }

    public void setTipoPersona(String tipoPersona) {
        String oldValue = this.tipoPersona;
        this.tipoPersona = tipoPersona;
        this.firePropertyChange(C_TIPO_PERSONA, oldValue, this.tipoPersona);
    }

    public List<Participacion> getParticipaciones() {
        return this.participaciones;
    }

    protected void setParticipaciones(List<Participacion> participaciones) {
        this.participaciones = participaciones;
    }

    public String getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(String periodo) {
        this.periodo = periodo;
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public Object importar(Element accionista, Map<String, Element> mapaData) {
        DataCatalogos dataCatalogos = new DataCatalogos();
        this.setPeriodo(mapaData.get("Anio").getTextContent());
        this.setMes(mapaData.get("Mes").getTextContent());
        NodeList listaValor = accionista.getElementsByTagName(C_TIPO_IDENTIFICACION);
        Element eValor = (Element)listaValor.item(0);
        this.setTipoIdentificacion(eValor.getTextContent());
        this.setDescripcionTipoIdentificacion(Constantes.IDENTIFICACIONES.get(this.getTipoIdentificacion()));
        listaValor = accionista.getElementsByTagName("numeroIdentificacion");
        eValor = (Element)listaValor.item(0);
        this.setIdentificacion(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName(C_NOMBRES_RAZON_SOCIAL);
        eValor = (Element)listaValor.item(0);
        this.setDenominacion(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName("tipoSociedadExt");
        eValor = (Element)listaValor.item(0);
        this.setTipoSociedadExtranjera(eValor.getTextContent());
        this.setDescripcionTipoSociedad((String)dataCatalogos.obtenerValoresCatalogos(MnemonicosCatalogos.TIPO_SOCIEDAD_EXTRANJERA.getMnemonico()).get(this.tipoSociedadExtranjera));
        listaValor = accionista.getElementsByTagName("figuraJuridicaExt");
        eValor = (Element)listaValor.item(0);
        this.setFiguraJuridica(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName("esSociedadPublicaExt");
        eValor = (Element)listaValor.item(0);
        this.setSociedadExtranjeraPublica(eValor.getTextContent().equalsIgnoreCase("SI"));
        listaValor = accionista.getElementsByTagName("Menor10porc");
        eValor = (Element)listaValor.item(0);
        this.setMenorDiezPorciento(eValor.getTextContent().equalsIgnoreCase("SI"));
        listaValor = accionista.getElementsByTagName("porcentajeAccionarioNoBolsaExt");
        eValor = (Element)listaValor.item(0);
        this.setPorcentajeNoCotiza(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName("porcentajeAccionarioBolsaExt");
        eValor = (Element)listaValor.item(0);
        this.setPorcentajeCotiza(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName(C_TIPO_REGIMEN_FISCAL);
        eValor = (Element)listaValor.item(0);
        this.setTipoRegimenFiscal(eValor.getTextContent());
        this.asignarTipoPersonaTipoIdentificacion();
        listaValor = accionista.getElementsByTagName("infoParticipacionAccionaria");
        Element infoParticipacion = (Element)listaValor.item(0);
        listaValor = accionista.getElementsByTagName("ubicacionResidenciaFiscal");
        Element ubicacion = (Element)listaValor.item(0);
        this.datosUbicacion.importar(ubicacion, null);
        listaValor = infoParticipacion.getElementsByTagName("parteRelacionadaInformante");
        eValor = (Element)listaValor.item(0);
        this.setParteRelacionada("SI".equals(eValor.getTextContent().toUpperCase()));
        return this;
    }

    public Element exportar(Document documento, Element elemento) {
        Element tipIdentificacion = documento.createElement(C_TIPO_IDENTIFICACION);
        tipIdentificacion.setTextContent(this.getTipoIdentificacion());
        elemento.appendChild(tipIdentificacion);
        Element numeroIdentificacion = documento.createElement("numeroIdentificacion");
        numeroIdentificacion.setTextContent(this.getIdentificacion());
        elemento.appendChild(numeroIdentificacion);
        Element nombresRazonSocial = documento.createElement(C_NOMBRES_RAZON_SOCIAL);
        nombresRazonSocial.setTextContent(this.getDenominacion());
        elemento.appendChild(nombresRazonSocial);
        Element tipoSociedadExt = documento.createElement("tipoSociedadExt");
        tipoSociedadExt.setTextContent(StringUtil.isNullOrEmpty((String)this.getTipoSociedadExtranjera()) ? "NA" : this.getTipoSociedadExtranjera());
        elemento.appendChild(tipoSociedadExt);
        Element figuraJuridicaExt = documento.createElement("figuraJuridicaExt");
        figuraJuridicaExt.setTextContent(StringUtil.isNullOrEmpty((String)this.getFiguraJuridica()) ? "NA" : this.getFiguraJuridica());
        elemento.appendChild(figuraJuridicaExt);
        Element isSociedadPublicaExt = documento.createElement("esSociedadPublicaExt");
        isSociedadPublicaExt.setTextContent(this.isSociedadExtranjeraPublica() ? "SI" : "NO");
        elemento.appendChild(isSociedadPublicaExt);
        Element isMenor10porc = documento.createElement("Menor10porc");
        if (Integer.valueOf(this.getPeriodo()) >= 2022) {
            if (this.getTipoSociedadExtranjera() == null || this.getTipoSociedadExtranjera().equalsIgnoreCase("00")) {
                isMenor10porc.setTextContent("NA");
            } else {
                isMenor10porc.setTextContent(this.isMenorDiezPorciento() ? "SI" : "NO");
            }
        } else {
            isMenor10porc.setTextContent("NA");
        }
        elemento.appendChild(isMenor10porc);
        Element porcentajeAccionarioNoBolsaExt = documento.createElement("porcentajeAccionarioNoBolsaExt");
        porcentajeAccionarioNoBolsaExt.setTextContent(StringUtil.isNullOrEmpty((String)this.porcentajeNoCotiza) ? "0.0" : this.porcentajeNoCotiza);
        elemento.appendChild(porcentajeAccionarioNoBolsaExt);
        Element porcentajeAccionarioBolsaExt = documento.createElement("porcentajeAccionarioBolsaExt");
        porcentajeAccionarioBolsaExt.setTextContent(StringUtil.isNullOrEmpty((String)this.porcentajeCotiza) ? "0.0" : this.porcentajeCotiza);
        elemento.appendChild(porcentajeAccionarioBolsaExt);
        return elemento;
    }

    public Element exportarAdicionales(Document documento, Element elemento) {
        Element tipoRegimenFiscal = documento.createElement(C_TIPO_REGIMEN_FISCAL);
        tipoRegimenFiscal.setTextContent(this.tipoRegimenFiscal);
        elemento.appendChild(tipoRegimenFiscal);
        return elemento;
    }

    public BeneficiarioFinal crearCopiaEdicion() {
        BeneficiarioFinal copiaEdicion = new BeneficiarioFinal();
        copiaEdicion.setDenominacion(this.denominacion);
        copiaEdicion.setTipoIdentificacion(this.tipoIdentificacion);
        copiaEdicion.setDescripcionTipoIdentificacion(this.descripcionTipoIdentificacion);
        copiaEdicion.setIdentificacion(this.identificacion);
        copiaEdicion.setTipoSociedadExtranjera(this.tipoSociedadExtranjera);
        copiaEdicion.setDescripcionTipoSociedad(this.descripcionTipoSociedad);
        copiaEdicion.setSociedadExtranjeraPublica(this.sociedadExtranjeraPublica);
        copiaEdicion.setMenorDiezPorciento(this.menorDiezPorciento);
        copiaEdicion.setFiguraJuridica(this.figuraJuridica);
        copiaEdicion.setPorcentajeNoCotiza(this.porcentajeNoCotiza);
        copiaEdicion.setPorcentajeCotiza(this.porcentajeCotiza);
        copiaEdicion.setParteRelacionada(this.parteRelacionada);
        copiaEdicion.setPropietario((ObjetoModelo)((Participacion)this.propietario));
        copiaEdicion.setTipoRegimenFiscal(this.tipoRegimenFiscal);
        copiaEdicion.setDescripcionTipoRegimen(this.descripcionTipoRegimen);
        copiaEdicion.setPeriodo(this.periodo);
        copiaEdicion.setMes(this.mes);
        return copiaEdicion;
    }

    public void actualizarInformacion(BeneficiarioFinal copiaEdicion) {
        this.setDenominacion(copiaEdicion.getDenominacion());
        this.setTipoIdentificacion(copiaEdicion.getTipoIdentificacion());
        this.setDescripcionTipoIdentificacion(copiaEdicion.getDescripcionTipoIdentificacion());
        this.setIdentificacion(copiaEdicion.getIdentificacion());
        this.setTipoSociedadExtranjera(copiaEdicion.getTipoSociedadExtranjera());
        this.setDescripcionTipoSociedad(copiaEdicion.getDescripcionTipoSociedad());
        this.setSociedadExtranjeraPublica(copiaEdicion.isSociedadExtranjeraPublica());
        this.setMenorDiezPorciento(copiaEdicion.isMenorDiezPorciento());
        this.setFiguraJuridica(copiaEdicion.getFiguraJuridica());
        this.setPorcentajeNoCotiza(copiaEdicion.getPorcentajeNoCotiza());
        this.setPorcentajeCotiza(copiaEdicion.getPorcentajeCotiza());
        this.setParteRelacionada(copiaEdicion.isParteRelacionada());
        this.setTipoPersona(copiaEdicion.getTipoPersona());
        this.setTipoRegimenFiscal(copiaEdicion.getTipoRegimenFiscal());
        this.setDescripcionTipoRegimen(copiaEdicion.getDescripcionTipoRegimen());
        this.setPeriodo(copiaEdicion.getPeriodo());
        this.setMes(copiaEdicion.getMes());
    }

    public void asignarTipoPersonaTipoIdentificacion() {
        if ("C".equals(this.tipoIdentificacion) || "P".equals(this.tipoIdentificacion)) {
            this.setTipoPersona(NATURAL);
            return;
        }
        if ("E".equals(this.tipoIdentificacion)) {
            this.setTipoPersona(this.descripcionTipoSociedad);
            return;
        }
        String tercerDigito = this.identificacion.substring(2, 3);
        int digito = Integer.parseInt(tercerDigito);
        switch (digito) {
            case 6: {
                this.setTipoPersona(SOC_PUBLICA);
                break;
            }
            case 9: {
                this.setTipoPersona(SOC_PRIVADA);
                break;
            }
            default: {
                this.setTipoPersona(NATURAL);
            }
        }
    }
}

