/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatosContacto
extends ObjetoModeloSucesorValidable<SujetoRelacionado>
implements Exportable,
Importable,
InformacionEditable<DatosContacto> {
    private static final long serialVersionUID = -3793341333661055432L;
    public static final String C_TELEFONO = "telefono";
    public static final String C_EMAIL = "eMail";
    private String telefono;
    private String eMail;

    public String getTelefono() {
        return this.telefono;
    }

    public void setTelefono(String telefono) {
        String oldTelefono = this.telefono;
        this.telefono = telefono;
        this.firePropertyChange(C_TELEFONO, oldTelefono, this.telefono);
    }

    public String geteMail() {
        return this.eMail;
    }

    public void seteMail(String eMail) {
        String oldEmail = this.eMail;
        this.eMail = eMail;
        this.firePropertyChange(C_EMAIL, oldEmail, eMail);
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (StringUtil.isNullOrEmpty((String)this.telefono)) {
            return resultado.fallarValidacion("Debe ingresar el valor del N\u00famero de Tel\u00e9fono");
        }
        if (!Pattern.matches("\\d{1,12}", this.telefono)) {
            return resultado.fallarValidacion("El N\u00famero de Tel\u00e9fono ingresado es incorrecto ");
        }
        if (StringUtil.isNullOrEmpty((String)this.eMail)) {
            return resultado.fallarValidacion("Debe ingresar el valor de Correo Electr\u00f3nico");
        }
        if (!Pattern.matches("(\\w+([!#$%\\-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*)", this.eMail)) {
            return resultado.fallarValidacion("El Correo Electr\u00f3nico ingresado es incorrecto ");
        }
        return resultado.pasarValidacion();
    }

    public Object importar(Element domicilio, Map<String, Element> mapaData) {
        NodeList listaValor = domicilio.getElementsByTagName(C_TELEFONO);
        Element eValor = (Element)listaValor.item(0);
        this.setTelefono(eValor.getTextContent().equals("NA") ? "" : eValor.getTextContent());
        listaValor = domicilio.getElementsByTagName("correo");
        eValor = (Element)listaValor.item(0);
        this.seteMail(eValor.getTextContent().equals("NA") ? "" : eValor.getTextContent());
        return this;
    }

    public Element exportar(Document documento, Element elemento) {
        Element eTelefono = documento.createElement(C_TELEFONO);
        eTelefono.setTextContent(StringUtil.isNullOrEmpty((String)this.telefono) ? "NA" : this.telefono);
        elemento.appendChild(eTelefono);
        Element eCorreo = documento.createElement("correo");
        eCorreo.setTextContent(StringUtil.isNullOrEmpty((String)this.eMail) ? "NA" : this.eMail);
        elemento.appendChild(eCorreo);
        return elemento;
    }

    public DatosContacto crearCopiaEdicion() {
        DatosContacto copiaEdicion = new DatosContacto();
        copiaEdicion.setTelefono(this.telefono);
        copiaEdicion.seteMail(this.eMail);
        copiaEdicion.setPropietario((ObjetoModelo)((SujetoRelacionado)this.propietario));
        return copiaEdicion;
    }

    public void actualizarInformacion(DatosContacto copiaEdicion) {
        this.setTelefono(copiaEdicion.getTelefono());
        this.seteMail(copiaEdicion.geteMail());
    }
}

