/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ValidacionIdentificacion;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.util.UtilValidacion;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatosIdentificacion
extends ObjetoModeloSucesorValidable<SujetoRelacionado>
implements Exportable,
Importable,
InformacionEditable<DatosIdentificacion> {
    private static final long serialVersionUID = 2833849593555411828L;
    public static final String C_IDENTIFICACION = "identificacion";
    public static final String C_TIPO_IDENTIFICACION = "tipoIdentificacion";
    public static final String C_TIPO_SUJETO = "tipoSujeto";
    public static final String C_PRIMER_NOMBRE = "primerNombre";
    public static final String C_SEGUNDO_NOMBRE = "segundoNombre";
    public static final String C_PRIMER_APELLIDO = "primerApellido";
    public static final String C_SEGUNDO_APELLIDO = "segundoApellido";
    public static final String C_RAZON_SOCIAL = "razonSocial";
    private String tipoIdentificacion;
    private String descripcionTipoIdentificacion;
    private String identificacion;
    private String tipoSujeto;
    private String descripcionTipoSujeto;
    private String primerNombre;
    private String segundoNombre;
    private String primerApellido;
    private String segundoApellido;
    private String razonSocial;
    private String anio;
    private String mes;
    private static String nivelVisual;
    private int nivel = 0;
    private SujetoRelacionado sujeto = new SujetoRelacionado();
    private Participacion participacion = new Participacion();

    public Participacion getParticipacion() {
        return this.participacion;
    }

    public void setParticipacion(Participacion participacion) {
        this.participacion = participacion;
    }

    public String getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    public void setTipoIdentificacion(String tipoIdentificacion) {
        String oldValue = this.tipoIdentificacion;
        this.tipoIdentificacion = tipoIdentificacion;
        this.firePropertyChange(C_TIPO_IDENTIFICACION, oldValue, this.tipoIdentificacion);
    }

    public String getDescripcionTipoIdentificacion() {
        return this.descripcionTipoIdentificacion;
    }

    public void setDescripcionTipoIdentificacion(String descripcionTipoIdentificacion) {
        this.descripcionTipoIdentificacion = descripcionTipoIdentificacion;
    }

    public String getIdentificacion() {
        return this.identificacion;
    }

    public void setIdentificacion(String identificacion) {
        String oldValue = this.identificacion;
        this.identificacion = identificacion;
        this.firePropertyChange(C_IDENTIFICACION, oldValue, this.identificacion);
    }

    public String getTipoSujeto() {
        return this.tipoSujeto;
    }

    public void setTipoSujeto(String tipoSujeto) {
        String oldValue = this.tipoSujeto;
        this.tipoSujeto = tipoSujeto;
        this.firePropertyChange(C_TIPO_SUJETO, oldValue, this.tipoSujeto);
    }

    public String getDescripcionTipoSujeto() {
        return this.descripcionTipoSujeto;
    }

    public void setDescripcionTipoSujeto(String descripcionTipoSujeto) {
        this.descripcionTipoSujeto = descripcionTipoSujeto;
    }

    public String getPrimerNombre() {
        return this.primerNombre;
    }

    public void setPrimerNombre(String primerNombre) {
        String oldValue = this.primerNombre;
        this.primerNombre = primerNombre;
        this.firePropertyChange(C_PRIMER_NOMBRE, oldValue, this.primerNombre);
    }

    public String getSegundoNombre() {
        return this.segundoNombre;
    }

    public void setSegundoNombre(String segundoNombre) {
        String oldValue = this.segundoNombre;
        this.segundoNombre = segundoNombre;
        this.firePropertyChange(C_SEGUNDO_NOMBRE, oldValue, this.segundoNombre);
    }

    public String getPrimerApellido() {
        return this.primerApellido;
    }

    public void setPrimerApellido(String primerApellido) {
        String oldValue = this.primerApellido;
        this.primerApellido = primerApellido;
        this.firePropertyChange(C_PRIMER_APELLIDO, oldValue, this.primerApellido);
    }

    public String getSegundoApellido() {
        return this.segundoApellido;
    }

    public void setSegundoApellido(String segundoApellido) {
        String oldValue = this.segundoApellido;
        this.segundoApellido = segundoApellido;
        this.firePropertyChange(C_SEGUNDO_APELLIDO, oldValue, this.segundoApellido);
    }

    public String getRazonSocial() {
        return this.razonSocial;
    }

    public void setRazonSocial(String razonSocial) {
        String oldValue = this.razonSocial;
        this.razonSocial = razonSocial;
        this.firePropertyChange(C_RAZON_SOCIAL, oldValue, this.razonSocial);
    }

    public String getAnio() {
        return this.anio;
    }

    public void setAnio(String anio) {
        this.anio = anio;
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public SujetoRelacionado getSujeto() {
        return this.sujeto;
    }

    public void setSujeto(SujetoRelacionado sujeto) {
        this.sujeto = sujeto;
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (UtilValidacion.esAnexoDesdePeriodo2024(this.anio, this.mes) && StringUtil.isNullOrEmpty((String)this.tipoSujeto)) {
            return resultado.fallarValidacion("Es necesario indicar el tipo de sujeto.");
        }
        if (StringUtil.isNullOrEmpty((String)this.tipoIdentificacion)) {
            return resultado.fallarValidacion("Es necesario indicar el tipo de identificaci\u00f3n.");
        }
        if (StringUtil.isNullOrEmpty((String)this.identificacion)) {
            return resultado.fallarValidacion("Debe ingresar el n\u00famero de identificaci\u00f3n del sujeto relacionado.");
        }
        if (!Pattern.matches("[a-zA-Z0-9]+", this.identificacion)) {
            return resultado.fallarValidacion("La identificaci\u00f3n del sujeto relacionado contiene espacios o caracteres no permitidos");
        }
        if (!(resultado = ValidacionIdentificacion.validarTodaIdentificacion((String)this.tipoIdentificacion, (String)this.identificacion, (ResultadoValidacion)resultado, (Integer)5, (Integer)20)).esEstadoExitoso()) {
            return resultado;
        }
        if (UtilValidacion.esAnexoDesdePeriodo2024(this.anio, this.mes) && this.tipoSujeto.equals("01")) {
            if (StringUtil.isNullOrEmpty((String)this.primerNombre)) {
                return resultado.fallarValidacion("Debe ingresar el primer nombre del sujeto relacionado.");
            }
            if (StringUtil.isNullOrEmpty((String)this.primerApellido)) {
                return resultado.fallarValidacion("Debe ingresar el primer apellido del sujeto relacionado.");
            }
        }
        if (UtilValidacion.esAnexoDesdePeriodo2024(this.anio, this.mes) ? this.tipoSujeto.equals("02") && StringUtil.isNullOrEmpty((String)this.razonSocial) : StringUtil.isNullOrEmpty((String)this.razonSocial)) {
            return resultado.fallarValidacion("Debe ingresar la raz\u00f3n social del sujeto relacionado.");
        }
        return resultado.pasarValidacion();
    }

    public int getNivel() {
        return this.nivel;
    }

    public void setNivel(int nivel) {
        this.nivel = nivel;
    }

    public DatosIdentificacion crearCopiaEdicion() {
        DatosIdentificacion copiaEdicion = new DatosIdentificacion();
        copiaEdicion.setIdentificacion(this.identificacion);
        copiaEdicion.setTipoIdentificacion(this.tipoIdentificacion);
        copiaEdicion.setTipoSujeto(this.tipoSujeto);
        copiaEdicion.setPrimerNombre(this.primerNombre);
        copiaEdicion.setSegundoNombre(this.segundoNombre);
        copiaEdicion.setPrimerApellido(this.primerApellido);
        copiaEdicion.setSegundoApellido(this.segundoApellido);
        copiaEdicion.setRazonSocial(this.razonSocial);
        return copiaEdicion;
    }

    public void actualizarInformacion(DatosIdentificacion copiaEdicion) {
        this.setIdentificacion(copiaEdicion.getIdentificacion());
        this.setTipoIdentificacion(copiaEdicion.getTipoIdentificacion());
        this.setTipoSujeto(copiaEdicion.getTipoSujeto());
        this.setPrimerNombre(copiaEdicion.getPrimerNombre());
        this.setSegundoNombre(copiaEdicion.getSegundoNombre());
        this.setPrimerApellido(copiaEdicion.getPrimerApellido());
        this.setSegundoApellido(copiaEdicion.getSegundoApellido());
        this.setRazonSocial(copiaEdicion.getRazonSocial());
    }

    public String getNivelVisual() {
        return nivelVisual;
    }

    public static void setNivelVisual(int nivelVisual) {
        DatosIdentificacion.nivelVisual = String.valueOf(nivelVisual);
    }

    public Object importar(Element identificacion, Map<String, Element> mapaData) {
        NodeList listaValor = identificacion.getElementsByTagName(C_TIPO_SUJETO);
        Element eValor = (Element)listaValor.item(0);
        this.setTipoSujeto(eValor == null || eValor.equals("NA") ? "" : eValor.getTextContent());
        this.setDescripcionTipoSujeto(eValor.getTextContent().equals("01") ? "PERSONA NATURAL" : "PERSONA O ESTRUCTURA JURIDICA");
        listaValor = identificacion.getElementsByTagName(C_TIPO_IDENTIFICACION);
        eValor = (Element)listaValor.item(0);
        this.setTipoIdentificacion(eValor == null || eValor.equals("NA") ? "" : eValor.getTextContent());
        listaValor = identificacion.getElementsByTagName("numeroIdentificacion");
        eValor = (Element)listaValor.item(0);
        this.setIdentificacion(eValor == null || eValor.equals("NA") ? "" : eValor.getTextContent());
        listaValor = identificacion.getElementsByTagName(C_PRIMER_NOMBRE);
        eValor = (Element)listaValor.item(0);
        this.setPrimerNombre(eValor == null || eValor.equals("NA") ? "" : eValor.getTextContent());
        listaValor = identificacion.getElementsByTagName(C_SEGUNDO_NOMBRE);
        eValor = (Element)listaValor.item(0);
        this.setSegundoNombre(eValor == null || eValor.equals("NA") ? "" : eValor.getTextContent());
        listaValor = identificacion.getElementsByTagName(C_PRIMER_APELLIDO);
        eValor = (Element)listaValor.item(0);
        this.setPrimerApellido(eValor == null || eValor.equals("NA") ? "" : eValor.getTextContent());
        listaValor = identificacion.getElementsByTagName(C_SEGUNDO_APELLIDO);
        eValor = (Element)listaValor.item(0);
        this.setSegundoApellido(eValor == null || eValor.equals("NA") ? "" : eValor.getTextContent());
        listaValor = identificacion.getElementsByTagName("nombresRazonSocial");
        eValor = (Element)listaValor.item(0);
        this.setRazonSocial(eValor == null || eValor.equals("NA") ? "" : eValor.getTextContent());
        return this;
    }

    public Element exportar(Document identificacion, Element elemento) {
        Element primerNombre = identificacion.createElement(C_PRIMER_NOMBRE);
        primerNombre.setTextContent(StringUtil.isNullOrEmpty((String)this.getPrimerNombre()) ? "NA" : this.getPrimerNombre());
        elemento.appendChild(primerNombre);
        Element segundoNombre = identificacion.createElement(C_SEGUNDO_NOMBRE);
        segundoNombre.setTextContent(StringUtil.isNullOrEmpty((String)this.getSegundoNombre()) ? "NA" : this.getSegundoNombre());
        elemento.appendChild(segundoNombre);
        Element primerApellido = identificacion.createElement(C_PRIMER_APELLIDO);
        primerApellido.setTextContent(StringUtil.isNullOrEmpty((String)this.getPrimerApellido()) ? "NA" : this.getPrimerApellido());
        elemento.appendChild(primerApellido);
        Element segundoApellido = identificacion.createElement(C_SEGUNDO_APELLIDO);
        segundoApellido.setTextContent(StringUtil.isNullOrEmpty((String)this.getSegundoApellido()) ? "NA" : this.getSegundoApellido());
        elemento.appendChild(segundoApellido);
        return elemento;
    }
}

