/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatosUbicacion
extends ObjetoModeloSucesorValidable<SujetoRelacionado>
implements Exportable,
Importable,
InformacionEditable<DatosUbicacion> {
    private static final long serialVersionUID = -2377693516677646669L;
    private String paisRegimenGeneral;
    private String descripcionPaisRegimenGeneral;
    private String paraisoFiscal;
    private String descripcionParaisoFiscal;
    private String paisRelacionadoParaisoFiscal;
    private String descripcionPaisRelacionadoParaisoFiscal;
    private String paisRegimenFiscal;
    private String descripcionPaisRegimenFiscal;
    private String pais;
    private String descripcionPais;
    private String denominacionRegimenFiscal;
    private String estado;
    private String tipoRegimenFiscal;
    private String tipoIdentificacion;
    public static final String C_PAIS_REGIMEN_GENERAL = "paisRegimenGeneral";
    public static final String C_DESCRIPCION_PAIS_REGIMEN_GENERAL = "descripcionPaisRegimenGeneral";
    public static final String C_PARAISO_FISCAL = "paraisoFiscal";
    public static final String C_DESCRIPCION_PARAISO_FISCAL = "descripcionParaisoFiscal";
    public static final String C_PAIS_RELACIONADO_PARAISO_FISCAL = "paisRelacionadoParaisoFiscal";
    public static final String C_DESCRIPCION_PAIS_RELACIONADO_PARAISO_FISCAL = "descripcionPaisRelacionadoParaisoFiscal";
    public static final String C_PAIS_REGIMEN_FISCAL = "paisRegimenFiscal";
    public static final String C_DESCRIPCION_PAIS_REGIMEN_FISCAL = "descripcionPaisRegimenFiscal";
    public static final String C_DENOMINACION_REGIMEN_FISCAL = "denominacionRegimenFiscal";
    public static final String C_PAIS = "pais";
    public static final String C_DESCRIPCION_PAIS = "descripcionPais";
    public static final String C_TIPO_REGIMEN_FISCAL = "tipoRegFiscal";
    public static final String C_ESTADO = "estado";
    public static final String TRF_REGIMEN_GENERAL = "01";
    public static final String TRF_PARAISO_FISCAL = "02";
    public static final String TRF_REGIMEN_FISCAL = "03";
    private Boolean esEdicion;

    public DatosUbicacion() {
    }

    public DatosUbicacion(String tipoIdentificacion, String tipoRegimenFiscal) {
        this.tipoIdentificacion = tipoIdentificacion;
        this.tipoRegimenFiscal = tipoRegimenFiscal;
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (TRF_REGIMEN_GENERAL.equals(this.tipoRegimenFiscal) && !"R".equals(this.tipoIdentificacion) && !"C".equals(this.tipoIdentificacion)) {
            if (StringUtil.isNullOrEmpty((String)this.paisRegimenGeneral)) {
                return resultado.fallarValidacion("Seleccione el Pa\u00eds de Residencia Fiscal");
            }
            resultado = this.validarEstado(resultado, this.paisRegimenGeneral, this.estado);
        }
        if (TRF_PARAISO_FISCAL.equals(this.tipoRegimenFiscal)) {
            if (StringUtil.isNullOrEmpty((String)this.paraisoFiscal)) {
                return resultado.fallarValidacion("Seleccione el Pa\u00eds de R\u00e9gimen Para\u00edso Fiscal");
            }
            if (StringUtil.isNullOrEmpty((String)this.paisRelacionadoParaisoFiscal)) {
                return resultado.fallarValidacion("Seleccione el Pa\u00eds Relacionado a Para\u00edso Fiscal");
            }
            resultado = this.validarEstado(resultado, this.paisRelacionadoParaisoFiscal, this.estado);
        }
        if (TRF_REGIMEN_FISCAL.equals(this.tipoRegimenFiscal)) {
            if (StringUtil.isNullOrEmpty((String)this.paisRegimenFiscal)) {
                return resultado.fallarValidacion("Seleccione el Pa\u00eds R\u00e9gimen Fiscal Preferente o Jurisdicci\u00f3n de menor imposici\u00f3n");
            }
            if (StringUtil.isNullOrEmpty((String)this.denominacionRegimenFiscal)) {
                return resultado.fallarValidacion("Ingrese el R\u00e9gimen Fiscal Preferente o Jurisdicci\u00f3n de menor Imposici\u00f3n");
            }
            if (!Pattern.matches("[a-zA-Z0-9]{4}[a-zA-Z0-9\\s]{0,48}", this.denominacionRegimenFiscal)) {
                return resultado.fallarValidacion("El campo Denominaci\u00f3n Fiscal admite letras n\u00fameros y espacios y debe tener una longitud m\u00ednima de 4 y m\u00e1xima de 50");
            }
            resultado = this.validarEstado(resultado, this.paisRegimenFiscal, this.estado);
        }
        return resultado;
    }

    private ResultadoValidacion validarEstado(ResultadoValidacion resultado, String pais, String estado) {
        if (!"593".equals(pais)) {
            if (StringUtil.isNullOrEmpty((String)estado)) {
                return resultado.fallarValidacion("Debe ingresar el campo Estado/Jurisdicc\u00f3n");
            }
            if (!Pattern.matches("[a-zA-Z0-9]{2}[a-zA-Z0-9\\s]{0,98}", estado)) {
                return resultado.fallarValidacion("El campo Estado no admite caracteres especiales, tildes ni la letra \u00f1 y debe tener una longitud m\u00ednima de 2 y m\u00e1xima de 100");
            }
        }
        return resultado.pasarValidacion();
    }

    public Object importar(Element ubicacion, Map<String, Element> mapaData) {
        DataCatalogos dataCatalogos = new DataCatalogos();
        NodeList listaValor = ubicacion.getElementsByTagName(C_PAIS_REGIMEN_FISCAL);
        Element eValor = (Element)listaValor.item(0);
        if (eValor != null) {
            this.setPaisRegimenGeneral(eValor.getTextContent());
            String descPaisRegimenGeneral = (String)dataCatalogos.obtenerPaises().get(eValor.getTextContent());
            this.setDescripcionPaisRegimenGeneral(StringUtil.isNullOrEmpty((String)descPaisRegimenGeneral) ? "" : descPaisRegimenGeneral);
        }
        this.setPaisRegimenGeneral((eValor = (Element)(listaValor = ubicacion.getElementsByTagName("paisResidenciaFiscal")).item(0)) == null || eValor.equals("NA") ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName("ubicacionJurisdiccion");
        eValor = (Element)listaValor.item(0);
        this.setEstado(eValor == null || eValor.equals("NA") ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName("paisParaisoFiscal");
        eValor = (Element)listaValor.item(0);
        if (eValor != null) {
            this.setParaisoFiscal(eValor.getTextContent());
            String descParaiso = (String)dataCatalogos.obtenerParaisosFiscales().get(eValor.getTextContent());
            this.setDescripcionParaisoFiscal(StringUtil.isNullOrEmpty((String)descParaiso) ? "" : descParaiso);
        }
        if ((eValor = (Element)(listaValor = ubicacion.getElementsByTagName(C_PAIS_RELACIONADO_PARAISO_FISCAL)).item(0)) != null) {
            this.setPaisRelacionadoParaisoFiscal(eValor.getTextContent());
            String descPaisRelacionadoParaiso = (String)dataCatalogos.obtenerPaises().get(eValor.getTextContent());
            this.setDescripcionPaisRelacionadoParaisoFiscal(StringUtil.isNullOrEmpty((String)descPaisRelacionadoParaiso) ? "" : descPaisRelacionadoParaiso);
        }
        if ((eValor = (Element)(listaValor = ubicacion.getElementsByTagName("paisRegimenFiscalPreferente")).item(0)) != null) {
            this.setPaisRegimenFiscal(eValor.getTextContent());
            String descPaisRegimenFiscal = (String)dataCatalogos.obtenerPaises().get(eValor.getTextContent());
            this.setDescripcionPaisRegimenFiscal(StringUtil.isNullOrEmpty((String)descPaisRegimenFiscal) ? "" : descPaisRegimenFiscal);
        }
        this.setDenominacionRegimenFiscal((eValor = (Element)(listaValor = ubicacion.getElementsByTagName("denominacionRegimenFiscalPreferente")).item(0)) == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName("paisRelacionadoOtroRegimenFiscal");
        eValor = (Element)listaValor.item(0);
        if (eValor != null) {
            this.setPais(eValor.getTextContent());
            String descPais = (String)dataCatalogos.obtenerPaises().get(eValor.getTextContent());
            this.setDescripcionPais(StringUtil.isNullOrEmpty((String)descPais) ? "" : descPais);
        }
        return this;
    }

    public Element exportar(Document documento, Element elemento) {
        if (!StringUtil.isNullOrEmpty((String)this.paisRegimenGeneral)) {
            Element ePaisRegimenGeneral = documento.createElement("paisResidenciaFiscal");
            ePaisRegimenGeneral.setTextContent(StringUtil.isNullOrEmpty((String)this.paisRegimenGeneral) ? "NA" : this.paisRegimenGeneral);
            elemento.appendChild(ePaisRegimenGeneral);
        }
        if (!StringUtil.isNullOrEmpty((String)this.estado)) {
            Element eUbicacion = documento.createElement("ubicacionJurisdiccion");
            eUbicacion.setTextContent(StringUtil.isNullOrEmpty((String)this.estado) ? "NA" : this.estado);
            elemento.appendChild(eUbicacion);
        }
        if (!StringUtil.isNullOrEmpty((String)this.paraisoFiscal)) {
            Element eParaisoFiscal = documento.createElement("paisParaisoFiscal");
            eParaisoFiscal.setTextContent(StringUtil.isNullOrEmpty((String)this.paraisoFiscal) ? "NA" : this.paraisoFiscal);
            elemento.appendChild(eParaisoFiscal);
        }
        if (!StringUtil.isNullOrEmpty((String)this.paisRelacionadoParaisoFiscal)) {
            Element ePaisRelacionadoParaiso = documento.createElement(C_PAIS_RELACIONADO_PARAISO_FISCAL);
            ePaisRelacionadoParaiso.setTextContent(StringUtil.isNullOrEmpty((String)this.paisRelacionadoParaisoFiscal) ? "NA" : this.paisRelacionadoParaisoFiscal);
            elemento.appendChild(ePaisRelacionadoParaiso);
        }
        if (!StringUtil.isNullOrEmpty((String)this.paisRegimenFiscal)) {
            Element ePaisRegimenFiscal = documento.createElement("paisRegimenFiscalPreferente");
            ePaisRegimenFiscal.setTextContent(StringUtil.isNullOrEmpty((String)this.paisRegimenFiscal) ? "NA" : this.paisRegimenFiscal);
            elemento.appendChild(ePaisRegimenFiscal);
        }
        if (!StringUtil.isNullOrEmpty((String)this.denominacionRegimenFiscal)) {
            Element eDenominacionRegimenFiscal = documento.createElement("denominacionRegimenFiscalPreferente");
            eDenominacionRegimenFiscal.setTextContent(StringUtil.isNullOrEmpty((String)this.denominacionRegimenFiscal) ? "NA" : this.denominacionRegimenFiscal);
            elemento.appendChild(eDenominacionRegimenFiscal);
        }
        if (!StringUtil.isNullOrEmpty((String)this.pais)) {
            Element ePaisDos = documento.createElement("paisRelacionadoOtroRegimenFiscal");
            ePaisDos.setTextContent(StringUtil.isNullOrEmpty((String)this.pais) ? "NA" : this.pais);
            elemento.appendChild(ePaisDos);
        }
        return elemento;
    }

    public String getPais() {
        return this.pais;
    }

    public void setPais(String pais) {
        String oldValue = this.pais;
        this.pais = pais;
        this.firePropertyChange(C_PAIS, oldValue, this.pais);
    }

    public String getDescripcionPais() {
        return this.descripcionPais;
    }

    public void setDescripcionPais(String descripcionPais) {
        String oldDescripcion = this.descripcionPais;
        this.descripcionPais = descripcionPais;
        this.firePropertyChange(C_DESCRIPCION_PAIS, oldDescripcion, this.descripcionPais);
    }

    public String getPaisRegimenGeneral() {
        return this.paisRegimenGeneral;
    }

    public void setPaisRegimenGeneral(String paisRegimenGeneral) {
        String oldValue = this.paisRegimenGeneral;
        this.paisRegimenGeneral = paisRegimenGeneral;
        this.firePropertyChange(C_PAIS_REGIMEN_GENERAL, oldValue, this.paisRegimenGeneral);
    }

    public String getDescripcionPaisRegimenGeneral() {
        return this.descripcionPaisRegimenGeneral;
    }

    public void setDescripcionPaisRegimenGeneral(String descripcionPaisRegimenGeneral) {
        String oldValue = this.descripcionPaisRegimenGeneral;
        this.descripcionPaisRegimenGeneral = descripcionPaisRegimenGeneral;
        this.firePropertyChange(C_DESCRIPCION_PAIS_REGIMEN_GENERAL, oldValue, this.descripcionPaisRegimenGeneral);
    }

    public String getParaisoFiscal() {
        return this.paraisoFiscal;
    }

    public void setParaisoFiscal(String paraisoFiscal) {
        String oldValue = this.paraisoFiscal;
        this.paraisoFiscal = paraisoFiscal;
        this.firePropertyChange(C_PARAISO_FISCAL, oldValue, this.paraisoFiscal);
    }

    public String getDescripcionParaisoFiscal() {
        return this.descripcionParaisoFiscal;
    }

    public void setDescripcionParaisoFiscal(String descripcionParaisoFiscal) {
        String oldValue = this.descripcionParaisoFiscal;
        this.descripcionParaisoFiscal = descripcionParaisoFiscal;
        this.firePropertyChange(C_DESCRIPCION_PARAISO_FISCAL, oldValue, this.descripcionParaisoFiscal);
    }

    public String getPaisRelacionadoParaisoFiscal() {
        return this.paisRelacionadoParaisoFiscal;
    }

    public void setPaisRelacionadoParaisoFiscal(String paisRelacionadoParaisoFiscal) {
        String oldValue = this.paisRelacionadoParaisoFiscal;
        this.paisRelacionadoParaisoFiscal = paisRelacionadoParaisoFiscal;
        this.firePropertyChange(C_PAIS_RELACIONADO_PARAISO_FISCAL, oldValue, this.paisRelacionadoParaisoFiscal);
    }

    public String getDescripcionPaisRelacionadoParaisoFiscal() {
        return this.descripcionPaisRelacionadoParaisoFiscal;
    }

    public void setDescripcionPaisRelacionadoParaisoFiscal(String descripcionPaisRelacionadoParaisoFiscal) {
        String oldValue = this.descripcionPaisRelacionadoParaisoFiscal;
        this.descripcionPaisRelacionadoParaisoFiscal = descripcionPaisRelacionadoParaisoFiscal;
        this.firePropertyChange(C_DESCRIPCION_PAIS_RELACIONADO_PARAISO_FISCAL, oldValue, this.descripcionPaisRelacionadoParaisoFiscal);
    }

    public String getPaisRegimenFiscal() {
        return this.paisRegimenFiscal;
    }

    public void setPaisRegimenFiscal(String paisRegimenFiscal) {
        String oldValue = this.paisRegimenFiscal;
        this.paisRegimenFiscal = paisRegimenFiscal;
        this.firePropertyChange(C_PAIS_REGIMEN_FISCAL, oldValue, this.paisRegimenFiscal);
    }

    public String getDescripcionPaisRegimenFiscal() {
        return this.descripcionPaisRegimenFiscal;
    }

    public void setDescripcionPaisRegimenFiscal(String descripcionPaisRegimenFiscal) {
        String oldValue = this.descripcionPaisRegimenFiscal;
        this.descripcionPaisRegimenFiscal = descripcionPaisRegimenFiscal;
        this.firePropertyChange(C_DESCRIPCION_PAIS_REGIMEN_FISCAL, oldValue, this.descripcionPaisRegimenFiscal);
    }

    public String getDenominacionRegimenFiscal() {
        return this.denominacionRegimenFiscal;
    }

    public void setDenominacionRegimenFiscal(String denominacionRegimenFiscal) {
        String oldValue = this.denominacionRegimenFiscal;
        this.denominacionRegimenFiscal = denominacionRegimenFiscal;
        this.firePropertyChange(C_DENOMINACION_REGIMEN_FISCAL, oldValue, this.denominacionRegimenFiscal);
    }

    public String getEstado() {
        return this.estado;
    }

    public void setEstado(String estado) {
        String oldValue = this.estado;
        this.estado = estado;
        this.firePropertyChange(C_ESTADO, oldValue, this.estado);
    }

    public String getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    public void setTipoIdentificacion(String tipoIdentificacion) {
        this.tipoIdentificacion = tipoIdentificacion;
    }

    public String getTipoRegimenFiscal() {
        return this.tipoRegimenFiscal;
    }

    public void setTipoRegimenFiscal(String tipoRegimenFiscal) {
        this.tipoRegimenFiscal = tipoRegimenFiscal;
    }

    public Boolean getEsEdicion() {
        return this.esEdicion;
    }

    public void setEsEdicion(Boolean esEdicion) {
        this.esEdicion = esEdicion;
    }

    public DatosUbicacion crearCopiaEdicion() {
        DatosUbicacion copiaEdicion = new DatosUbicacion();
        copiaEdicion.setPaisRegimenGeneral(this.paisRegimenGeneral);
        copiaEdicion.setDescripcionPaisRegimenGeneral(this.descripcionPaisRegimenGeneral);
        copiaEdicion.setParaisoFiscal(this.paraisoFiscal);
        copiaEdicion.setDescripcionParaisoFiscal(this.descripcionParaisoFiscal);
        copiaEdicion.setPaisRelacionadoParaisoFiscal(this.paisRelacionadoParaisoFiscal);
        copiaEdicion.setDescripcionPaisRelacionadoParaisoFiscal(this.descripcionPaisRelacionadoParaisoFiscal);
        copiaEdicion.setPaisRegimenFiscal(this.paisRegimenFiscal);
        copiaEdicion.setDescripcionPaisRegimenFiscal(this.descripcionPaisRegimenFiscal);
        copiaEdicion.setDenominacionRegimenFiscal(this.denominacionRegimenFiscal);
        copiaEdicion.setPais(this.pais);
        copiaEdicion.setDescripcionPais(this.descripcionPais);
        copiaEdicion.setEstado(this.estado);
        copiaEdicion.setPropietario((ObjetoModelo)((SujetoRelacionado)this.propietario));
        copiaEdicion.setEsEdicion(true);
        return copiaEdicion;
    }

    public void actualizarInformacion(DatosUbicacion copiaEdicion) {
        this.setPaisRegimenGeneral(copiaEdicion.getPaisRegimenGeneral());
        this.setDescripcionPaisRegimenGeneral(copiaEdicion.getDescripcionPaisRegimenGeneral());
        this.setParaisoFiscal(copiaEdicion.getParaisoFiscal());
        this.setDescripcionParaisoFiscal(copiaEdicion.getDescripcionParaisoFiscal());
        this.setPaisRelacionadoParaisoFiscal(copiaEdicion.getPaisRelacionadoParaisoFiscal());
        this.setDescripcionPaisRelacionadoParaisoFiscal(copiaEdicion.getDescripcionPaisRelacionadoParaisoFiscal());
        this.setPaisRegimenFiscal(copiaEdicion.getPaisRegimenFiscal());
        this.setDescripcionPaisRegimenFiscal(copiaEdicion.getDescripcionPaisRegimenFiscal());
        this.setDenominacionRegimenFiscal(copiaEdicion.getDenominacionRegimenFiscal());
        this.setPais(copiaEdicion.getPais());
        this.setDescripcionPais(copiaEdicion.getDescripcionPais());
        this.setEstado(copiaEdicion.getEstado());
    }
}

