/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj;

import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.aps.modelo.obj.Beneficiario;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.DatosInformante;
import ec.gob.sri.dimm.aps.modelo.util.StringModeloUtils;
import ec.gob.sri.dimm.aps.modelo.util.UtilValidacion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Informante
extends DatosInformante
implements RaizModelo,
Exportable,
Importable {
    private static final long serialVersionUID = 8522380378894794819L;
    private static final String RAIZ = "aps";
    public static final String CC_PARTICIPACIONES = "participaciones";
    public static final String CC_BENEFICIARIOS = "beneficiarios";
    public static final String PERIODICIDAD_ANTICIPADA = "Anticipada";
    private List<Participacion> participaciones = new ArrayList<Participacion>();
    private List<Beneficiario> beneficiarios = new ArrayList<Beneficiario>();
    private String identificacion;
    private String razonSocial;

    public String getCodigoOperativo() {
        return "APS";
    }

    public void agregarParticipacion(Participacion participacion) {
        participacion.setPropietario(this);
        this.participaciones.add(participacion);
        this.firePropertyChange(CC_PARTICIPACIONES, null, this.participaciones);
    }

    public boolean eliminarParticipacion(Participacion participacion) {
        boolean eliminado = this.participaciones.remove((Object)participacion);
        if (eliminado) {
            this.firePropertyChange(CC_PARTICIPACIONES, null, this.participaciones);
        }
        return eliminado;
    }

    public void agregarBeneficiario(Beneficiario beneficiario) {
        beneficiario.setPropietario(this);
        this.beneficiarios.add(beneficiario);
        this.firePropertyChange(CC_BENEFICIARIOS, null, this.beneficiarios);
    }

    public boolean eliminarBeneficiario(Beneficiario beneficiario) {
        boolean eliminado = this.beneficiarios.remove((Object)beneficiario);
        if (eliminado) {
            this.firePropertyChange(CC_BENEFICIARIOS, null, this.beneficiarios);
        }
        return eliminado;
    }

    public String getIdentificacion() {
        return this.identificacion;
    }

    public void setIdentificacion(String identificacion) {
        this.identificacion = identificacion.toUpperCase();
    }

    public String getRazonSocial() {
        return this.razonSocial;
    }

    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial.toUpperCase();
    }

    public List<Participacion> getParticipaciones() {
        return this.participaciones;
    }

    public void setBeneficiarios(List<Beneficiario> beneficiarios) {
        this.beneficiarios = beneficiarios;
    }

    public List<Beneficiario> getBeneficiarios() {
        return this.beneficiarios;
    }

    public Object importar(Element elemento, Map<String, Element> data) {
        this.setIdentificacion(data.get("IdInformante").getTextContent());
        this.setTipoDeclaracion(data.get("TipoDeclaracion").getTextContent());
        this.setTipoSociedad(data.get("TipoSociedad").getTextContent());
        this.setAnio(data.get("Anio").getTextContent());
        this.setMes(data.get("Mes").getTextContent());
        this.setPorcentajeNoCotiza(Double.parseDouble(data.get("PorcentajeAccionarioNoBolsa").getTextContent()));
        this.setPorcentajeCotiza(Double.parseDouble(data.get("PorcentajeAccionarioBolsa").getTextContent()));
        return this;
    }

    public Element exportar(Document document, Element elemento) {
        Element rootElement = document.createElement(RAIZ);
        document.appendChild(rootElement);
        Element em = document.createElement("TipoIDInformante");
        em.setTextContent("R");
        rootElement.appendChild(em);
        em = document.createElement("IdInformante");
        em.setTextContent(this.getIdentificacion());
        rootElement.appendChild(em);
        em = document.createElement("TipoSociedad");
        em.setTextContent(this.getTipoSociedad());
        rootElement.appendChild(em);
        em = document.createElement("Anio");
        em.setTextContent(this.getAnio());
        rootElement.appendChild(em);
        em = document.createElement("Mes");
        em.setTextContent(this.getMes());
        rootElement.appendChild(em);
        em = document.createElement("PorcentajeAccionarioNoBolsa");
        em.setTextContent(this.getPorcentajeNoCotiza() == null ? "0.00" : StringModeloUtils.obtenerFormatoDecimal(this.getPorcentajeNoCotiza()));
        rootElement.appendChild(em);
        em = document.createElement("codigoOperativo");
        em.setTextContent(this.getCodigoOperativo());
        rootElement.appendChild(em);
        em = document.createElement("PorcentajeAccionarioBolsa");
        em.setTextContent(this.getPorcentajeCotiza() == null ? "0.00" : StringModeloUtils.obtenerFormatoDecimal(this.getPorcentajeCotiza()));
        rootElement.appendChild(em);
        em = document.createElement(PERIODICIDAD_ANTICIPADA);
        em.setTextContent(PERIODICIDAD_ANTICIPADA.equals(this.getPeriodicidad()) ? "SI" : "NO");
        rootElement.appendChild(em);
        em = document.createElement("TipoDeclaracion");
        if (UtilValidacion.esAnexoDesdePeriodo2024(this.getAnio(), this.getMes())) {
            em.setTextContent(this.getTipoDeclaracion());
        } else {
            em.setTextContent("NA");
        }
        rootElement.appendChild(em);
        return rootElement;
    }
}

