/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.aps.modelo.obj.Constantes;
import ec.gob.sri.dimm.aps.modelo.obj.Informante;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.MnemonicosCatalogos;
import ec.gob.sri.dimm.aps.modelo.util.UtilValidacion;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import java.math.BigDecimal;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Participacion
extends ObjetoModeloSucesorValidable<ObjetoModelo>
implements Exportable,
Importable,
InformacionEditable<Participacion> {
    private static final long serialVersionUID = 2833849593555411828L;
    private static final String TAG = "accionista";
    private static final String TAG_INFO = "infoParticipacionAccionaria";
    private static final String TAG_UBICACION_RESIDENCIA_FISCAL = "ubicacionResidenciaFiscal";
    private static String nivelVisual;
    private String porcentajeParticipacion;
    private String tipoDeRelacion;
    private String descripcionTipoDeRelacion;
    private String identificacionAccionistaPadre;
    private String esBeneficiarioFinal;
    private int nivel = 0;
    private SujetoRelacionado sujeto = new SujetoRelacionado();
    public static final String C_TIPO_DE_RELACION = "tipoDeRelacion";
    public static final String C_PORCENTAJE_PARTICIPACION = "porcentajeParticipacion";
    public static final String C_PAIS_RESIDENCIA = "paisResidencia";
    public static final String C_DESCRIPCION_TIPO_RELACION = "descripcionTipoDeRelacion";
    public static final String C_BENEFICIARIO_FINAL = "esBeneficiarioFinal";

    public Participacion() {
        this.sujeto.setPropietario((ObjetoModelo)this);
    }

    public String getEsBeneficiarioFinal() {
        return this.esBeneficiarioFinal;
    }

    public void setEsBeneficiarioFinal(String esBeneficiarioFinal) {
        String oldValue = this.esBeneficiarioFinal;
        this.esBeneficiarioFinal = esBeneficiarioFinal;
        this.firePropertyChange(C_BENEFICIARIO_FINAL, oldValue, this.esBeneficiarioFinal);
    }

    public String getDescripcionTipoDeRelacion() {
        return this.descripcionTipoDeRelacion;
    }

    public void setDescripcionTipoDeRelacion(String descripcionTipoDeRelacion) {
        String oldValue = this.descripcionTipoDeRelacion;
        this.descripcionTipoDeRelacion = descripcionTipoDeRelacion;
        this.firePropertyChange(C_DESCRIPCION_TIPO_RELACION, oldValue, this.descripcionTipoDeRelacion);
    }

    public String getPorcentajeParticipacion() {
        return this.porcentajeParticipacion;
    }

    public void setPorcentajeParticipacion(String porcentajeParticipacion) {
        String oldValue = this.porcentajeParticipacion;
        this.porcentajeParticipacion = porcentajeParticipacion;
        this.firePropertyChange(C_PORCENTAJE_PARTICIPACION, oldValue, this.porcentajeParticipacion);
    }

    public String getTipoDeRelacion() {
        return this.tipoDeRelacion;
    }

    public void setTipoDeRelacion(String tipoDeRelacion) {
        String oldValue = this.tipoDeRelacion;
        this.tipoDeRelacion = tipoDeRelacion;
        this.firePropertyChange(C_TIPO_DE_RELACION, oldValue, this.tipoDeRelacion);
    }

    public SujetoRelacionado getSujeto() {
        return this.sujeto;
    }

    public void setSujeto(SujetoRelacionado sujeto) {
        this.sujeto = sujeto;
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (StringUtil.isNullOrEmpty((String)this.tipoDeRelacion)) {
            return resultado.fallarValidacion("Debe seleccionar el Tipo de Relaci\u00f3n del Sujeto.");
        }
        if (StringUtil.isNullOrEmpty((String)this.porcentajeParticipacion)) {
            return resultado.fallarValidacion("Debe ingresar el Porcentaje de Participaci\u00f3n.");
        }
        if (!Pattern.matches("[0-9]{1,3}\\.[0-9]{1,6}|\\d{1,3}", this.porcentajeParticipacion)) {
            return resultado.fallarValidacion("El valor ingresado como Porcentaje de Participaci\u00f3n no es correcto.");
        }
        BigDecimal porcentaje = new BigDecimal(this.porcentajeParticipacion);
        if (porcentaje.compareTo(BigDecimal.ZERO) < 0 && porcentaje.compareTo(Constantes.CIEN) > 0) {
            return resultado.fallarValidacion("El Porcentaje de Participaci\u00f3n no puede ser menor que 0 ni mayor a 100.");
        }
        String tipoSociedadPadre = (String)this.getContextoValidacion().obtener("tipoSociedadPadre");
        int tipoRelacionado = "NA".equals(this.tipoDeRelacion) ? 0 : Integer.parseInt(this.tipoDeRelacion);
        switch (tipoRelacionado) {
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                boolean permitirCero;
                boolean bl = permitirCero = tipoRelacionado == Integer.parseInt("03") && ("04".equals(tipoSociedadPadre) || "05".equals(tipoSociedadPadre) || "06".equals(tipoSociedadPadre));
                if (permitirCero || porcentaje.compareTo(BigDecimal.ZERO) != 0) break;
                return resultado.fallarValidacion("El Porcentaje de Participaci\u00f3n no puede ser igual a 0.");
            }
            case 4: 
            case 5: {
                if (porcentaje.compareTo(BigDecimal.ZERO) == 0) break;
                return resultado.fallarValidacion("El Porcentaje de Participaci\u00f3n debe ser igual a 0.");
            }
            case 10: {
                if (porcentaje.compareTo(BigDecimal.ZERO) != 0) break;
                return resultado.fallarValidacion("El Porcentaje de Participaci\u00f3n no puede ser igual a 0.");
            }
        }
        if (UtilValidacion.esAnexoDesdePeriodo2024(this.sujeto.getPeriodo(), this.sujeto.getMes()) && StringUtil.isNullOrEmpty((String)this.esBeneficiarioFinal)) {
            return resultado.fallarValidacion("Debe seleccionar el campo \u00bfEs Beneficiario Final?.");
        }
        return resultado.pasarValidacion();
    }

    public Object importar(Element accionista, Map<String, Element> mapaData) {
        NodeList listaValor = accionista.getElementsByTagName("identificacionInformantePadre");
        Element eValor = (Element)listaValor.item(0);
        this.setIdentificacionAccionistaPadre(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName(TAG_INFO);
        Element infoParticipacion = (Element)listaValor.item(0);
        listaValor = infoParticipacion.getElementsByTagName(C_PORCENTAJE_PARTICIPACION);
        eValor = (Element)listaValor.item(0);
        this.setPorcentajeParticipacion(eValor.getTextContent());
        listaValor = infoParticipacion.getElementsByTagName("tipoRelacionadoSociedad");
        eValor = (Element)listaValor.item(0);
        this.setTipoDeRelacion(eValor.getTextContent());
        this.setDescripcionTipoDeRelacion(DataCatalogos.obtenerNombreDetalleCatalogo((String)MnemonicosCatalogos.TIPO_RELACIONADO_SOCIEDAD.getMnemonico(), (String)eValor.getTextContent().trim()));
        return this;
    }

    public Element exportar(Document documento, Element elemento) {
        Element accionista = documento.createElement(TAG);
        this.sujeto.exportar(documento, accionista);
        Element idPadre = documento.createElement("identificacionInformantePadre");
        idPadre.setTextContent(this.getPropietario() instanceof SujetoRelacionado ? ((SujetoRelacionado)this.getPropietario()).getIdentificacion() : ((Informante)this.getPropietario()).getIdentificacion());
        accionista.appendChild(idPadre);
        this.sujeto.exportarAdicionales(documento, accionista);
        Element esBeneficiarioFinal = documento.createElement(C_BENEFICIARIO_FINAL);
        esBeneficiarioFinal.setTextContent(StringUtil.isNullOrEmpty((String)this.getEsBeneficiarioFinal()) ? "NA" : this.getEsBeneficiarioFinal());
        accionista.appendChild(esBeneficiarioFinal);
        Element infoParticipacion = documento.createElement(TAG_INFO);
        Element nivel = documento.createElement("codigoNivel");
        nivel.setTextContent(String.valueOf(this.getNivel()));
        infoParticipacion.appendChild(nivel);
        Element tipoRelacionado = documento.createElement("tipoRelacionadoSociedad");
        tipoRelacionado.setTextContent(StringUtil.isNullOrEmpty((String)this.tipoDeRelacion) ? "NA" : this.tipoDeRelacion);
        infoParticipacion.appendChild(tipoRelacionado);
        Element porcentajePart = documento.createElement(C_PORCENTAJE_PARTICIPACION);
        porcentajePart.setTextContent(StringUtil.isNullOrEmpty((String)this.porcentajeParticipacion) ? "NA" : this.porcentajeParticipacion);
        infoParticipacion.appendChild(porcentajePart);
        Element parteRelacionadaInformante = documento.createElement("parteRelacionadaInformante");
        parteRelacionadaInformante.setTextContent(this.sujeto.isParteRelacionada() ? "SI" : "NO");
        infoParticipacion.appendChild(parteRelacionadaInformante);
        accionista.appendChild(infoParticipacion);
        Element ubicacionResidenciaFiscal = documento.createElement(TAG_UBICACION_RESIDENCIA_FISCAL);
        this.sujeto.getDatosUbicacion().exportar(documento, ubicacionResidenciaFiscal);
        accionista.appendChild(ubicacionResidenciaFiscal);
        return accionista;
    }

    public int getNivel() {
        return this.nivel;
    }

    public void setNivel(int nivel) {
        this.nivel = nivel;
    }

    public String getIdentificacionAccionistaPadre() {
        return this.identificacionAccionistaPadre;
    }

    public void setIdentificacionAccionistaPadre(String identificacionAccionistaPadre) {
        this.identificacionAccionistaPadre = identificacionAccionistaPadre;
    }

    public Participacion crearCopiaEdicion() {
        Participacion copiaEdicion = new Participacion();
        copiaEdicion.setTipoDeRelacion(this.tipoDeRelacion);
        copiaEdicion.setDescripcionTipoDeRelacion(this.descripcionTipoDeRelacion);
        copiaEdicion.setPorcentajeParticipacion(this.porcentajeParticipacion);
        copiaEdicion.setEsBeneficiarioFinal(this.esBeneficiarioFinal);
        copiaEdicion.setPropietario(this.propietario);
        copiaEdicion.sujeto = this.sujeto.crearCopiaEdicion();
        copiaEdicion.sujeto.setPropietario((ObjetoModelo)copiaEdicion);
        return copiaEdicion;
    }

    public void actualizarInformacion(Participacion copiaEdicion) {
        this.setTipoDeRelacion(copiaEdicion.getTipoDeRelacion());
        this.setDescripcionTipoDeRelacion(copiaEdicion.getDescripcionTipoDeRelacion());
        this.setPorcentajeParticipacion(copiaEdicion.getPorcentajeParticipacion());
        this.setEsBeneficiarioFinal(copiaEdicion.getEsBeneficiarioFinal());
    }

    public String getNivelVisual() {
        return nivelVisual;
    }

    public static void setNivelVisual(int nivelVisual) {
        Participacion.nivelVisual = String.valueOf(nivelVisual);
    }
}

