/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ValidacionIdentificacion;
import ec.gob.sri.dimm.aps.modelo.obj.Beneficiario;
import ec.gob.sri.dimm.aps.modelo.obj.Constantes;
import ec.gob.sri.dimm.aps.modelo.obj.DatosContacto;
import ec.gob.sri.dimm.aps.modelo.obj.DatosIdentificacion;
import ec.gob.sri.dimm.aps.modelo.obj.DatosUbicacion;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.MnemonicosCatalogos;
import ec.gob.sri.dimm.aps.modelo.util.StringModeloUtils;
import ec.gob.sri.dimm.aps.modelo.util.UtilValidacion;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SujetoRelacionado
extends ObjetoModeloSucesorValidable<Participacion>
implements Exportable,
Importable,
InformacionEditable<SujetoRelacionado> {
    private static final long serialVersionUID = -2838874019204216137L;
    public static final String C_DENOMINACION = "denominacion";
    public static final String C_TIPO_IDENTIFICACION = "tipoIdentificacion";
    public static final String C_IDENTIFICACION = "identificacion";
    public static final String C_TIPO_SOCIEDAD = "tipoSociedadExtranjera";
    public static final String C_SOCIEDAD_EXT_PUBLICA = "sociedadExtranjeraPublica";
    public static final String CC_PARTICIPACIONES = "participaciones";
    public static final String C_FIGURA_JURIDICA = "figuraJuridica";
    public static final String C_PORCENTAJE_NO_COTIZA_ACC = "porcentajeNoCotiza";
    public static final String C_PORCENTAJE_COTIZA_ACC = "porcentajeCotiza";
    public static final String C_PARTE_RELACIONADA = "parteRelacionada";
    public static final String C_TIPO_PERSONA = "tipoPersona";
    public static final String C_TIPO_REGIMEN_FISCAL = "tipoRegimenFiscal";
    public static final String C_NEGOCIA_BOLSA = "negociaBolsa";
    public static final String C_MENOR_10_PORCIENTO = "menorDiezPorciento";
    public static final String C_TIPO_SUJETO = "tipoSujeto";
    public static final String C_PRIMER_NOMBRE = "primerNombre";
    public static final String C_SEGUNDO_NOMBRE = "segundoNombre";
    public static final String C_PRIMER_APELLIDO = "primerApellido";
    public static final String C_SEGUNDO_APELLIDO = "segundoApellido";
    public static final String C_NOMBRES_RAZON_SOCIAL = "nombresRazonSocial";
    public static final String C_FIGURA_JURIDICA_OTRO = "figuraJuridicaOtro";
    public static final String CC_BENEFICIARIOS_FINALES = "beneficiarios";
    private static final String NATURAL = "PERSONA NATURAL";
    private static final String SOC_PRIVADA = "SOCIEDAD PRIVADA";
    private static final String SOC_PUBLICA = "SOCIEDAD PUBLICA";
    private static final String C_ES_BENEFICIARIO_FINAL = "esBeneficiarioFinal";
    private String denominacion;
    private String tipoIdentificacion;
    private String descripcionTipoIdentificacion;
    private String identificacion;
    private String tipoSociedadExtranjera;
    private String descripcionTipoSociedad;
    private String descripcionTipoDeclaracion;
    private String tipoRegimenFiscal;
    private String descripcionTipoRegimen;
    private boolean sociedadExtranjeraPublica;
    private String figuraJuridica;
    private String porcentajeNoCotiza;
    private String porcentajeCotiza;
    private boolean parteRelacionada;
    private String tipoPersona;
    private String periodo;
    private boolean menorDiezPorciento;
    private String mes;
    private DatosContacto datosContacto;
    private DatosUbicacion datosUbicacion;
    private DatosIdentificacion datosIdentificacion;
    private String tipoSujeto;
    private String primerNombre;
    private String segundoNombre;
    private String primerApellido;
    private String segundoApellido;
    private String nombresRazonSocial;
    private String figuraJuridicaOtro;
    private String esBeneficiarioFinal;
    private List<Participacion> participaciones = new ArrayList<Participacion>();
    private List<Beneficiario> beneficiariosFinales = new ArrayList<Beneficiario>();

    public SujetoRelacionado() {
        this.datosContacto = new DatosContacto();
        this.datosContacto.setPropietario((ObjetoModelo)this);
        this.datosUbicacion = new DatosUbicacion(this.tipoIdentificacion, this.tipoRegimenFiscal);
        this.datosUbicacion.setPropietario((ObjetoModelo)this);
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (StringUtil.isNullOrEmpty((String)this.tipoIdentificacion)) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de identificaci\u00f3n.");
        }
        if (StringUtil.isNullOrEmpty((String)this.identificacion)) {
            return resultado.fallarValidacion("Debe escribir el n\u00famero de identificaci\u00f3n del trabajador.");
        }
        if (StringUtil.isNullOrEmpty((String)this.denominacion)) {
            return resultado.fallarValidacion("Debe ingresar la Raz\u00f3n Social del Sujeto");
        }
        if (!Pattern.matches("[a-zA-Z0-9][a-zA-Z0-9\\s]{4,499}", this.denominacion)) {
            return resultado.fallarValidacion("La denominaci\u00f3n del sujeto debe tener \u00fanicamente letras y debe tener una longitud de entre 5 y 500 caracteres");
        }
        if (StringUtil.isNullOrEmpty((String)this.tipoRegimenFiscal)) {
            return resultado.fallarValidacion("Debe seleccionar el Tipo de R\u00e9gimen Fiscal");
        }
        if ("E".equals(this.tipoIdentificacion)) {
            if (StringUtil.isNullOrEmpty((String)this.tipoSociedadExtranjera)) {
                return resultado.fallarValidacion("Debe seleccionar el Tipo de Sociedad");
            }
            if (UtilValidacion.esAnexoDesdePeriodo2024(this.periodo, this.mes)) {
                if (!"00".equals(this.tipoSociedadExtranjera)) {
                    if (StringUtil.isNullOrEmpty((String)this.figuraJuridica)) {
                        return resultado.fallarValidacion("Debe llenar el campo Figura Jur\u00eddica para el Tipo de Sociedad Persona Natural");
                    }
                    if (!Pattern.matches("[a-zA-Z0-9]{2}[a-zA-Z0-9\\s]{0,48}", this.figuraJuridica)) {
                        return resultado.fallarValidacion("El valor ingresado para la figura jur\u00eddica no es correcto. Verifique que no contenga caracteres especiales, tildes ni la letra \u00f1");
                    }
                }
                if (!"00".equals(this.tipoSociedadExtranjera) && StringUtil.isNullOrEmpty((String)this.figuraJuridicaOtro) && this.figuraJuridica.equals("89901")) {
                    return resultado.fallarValidacion("Debe llenar el campo Figura Jur\u00eddica Otro.");
                }
            }
            if ("02".equals(this.tipoSociedadExtranjera) && !this.sociedadExtranjeraPublica) {
                if (StringUtil.isNullOrEmpty((String)this.porcentajeNoCotiza)) {
                    return resultado.fallarValidacion("No ha ingresado el porcentaje accionario que no cotiza en bolsa de la sociedad.");
                }
                if (!Pattern.matches("[0-9]{1,3}\\.[0-9]{1,6}|\\d{1,3}", this.porcentajeNoCotiza)) {
                    return resultado.fallarValidacion("El porcentaje accionario tiene un valor incorrecto.");
                }
                if (StringModeloUtils.obtenerNumeroDeDecimales(Double.parseDouble(this.porcentajeNoCotiza)) > 6) {
                    return resultado.fallarValidacion("El valor registrado como porcentaje accionario que no cotiza en bolsa de valores debe tener m\u00e1ximo 6 decimales.");
                }
                if (Double.parseDouble(this.porcentajeNoCotiza) < 0.0 || Double.parseDouble(this.porcentajeNoCotiza) > 100.0) {
                    return resultado.fallarValidacion("El valor registrado como porcentaje accionario no puede ser menor a cero ni mayor a 100.");
                }
            }
        }
        if (!this.isParteRelacionada()) {
            return resultado.pasarValidacionAdvertencia("Por favor verifique que el sujeto '" + this.denominacion + "' no es parte relacionada del Informante.");
        }
        if (!(resultado = ValidacionIdentificacion.validarTodaIdentificacion((String)this.tipoIdentificacion, (String)this.identificacion, (ResultadoValidacion)resultado, (Integer)5, (Integer)20)).esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    public String getPorcentajeNoCotiza() {
        return this.porcentajeNoCotiza;
    }

    public void setPorcentajeNoCotiza(String porcentajeNoCotiza) {
        String oldPorcentajeNoCotiza = this.porcentajeNoCotiza;
        this.porcentajeNoCotiza = porcentajeNoCotiza;
        this.firePropertyChange(C_PORCENTAJE_NO_COTIZA_ACC, oldPorcentajeNoCotiza, this.porcentajeNoCotiza);
    }

    public String getPorcentajeCotiza() {
        return this.porcentajeCotiza;
    }

    public void setPorcentajeCotiza(String porcentajeCotiza) {
        String oldPorcentajeCotiza = this.porcentajeCotiza;
        this.porcentajeCotiza = porcentajeCotiza;
        this.firePropertyChange(C_PORCENTAJE_COTIZA_ACC, oldPorcentajeCotiza, this.porcentajeCotiza);
    }

    public String getDenominacion() {
        return this.denominacion;
    }

    public void setDenominacion(String denominacion) {
        String oldValue = this.denominacion;
        this.denominacion = StringUtil.isNullOrEmpty((String)denominacion) ? denominacion : denominacion.trim().toUpperCase();
        this.firePropertyChange(C_DENOMINACION, oldValue, this.denominacion);
    }

    public String getTipoRegimenFiscal() {
        return this.tipoRegimenFiscal;
    }

    public void setTipoRegimenFiscal(String tipoRegimenFiscal) {
        String oldValue = this.tipoRegimenFiscal;
        this.tipoRegimenFiscal = StringUtil.isNullOrEmpty((String)tipoRegimenFiscal) ? tipoRegimenFiscal : tipoRegimenFiscal.trim().toUpperCase();
        this.firePropertyChange(C_TIPO_REGIMEN_FISCAL, oldValue, this.tipoRegimenFiscal);
    }

    public String getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    public void setTipoIdentificacion(String tipoIdentificacion) {
        String oldValue = this.tipoIdentificacion;
        this.tipoIdentificacion = tipoIdentificacion;
        this.firePropertyChange(C_TIPO_IDENTIFICACION, oldValue, this.tipoIdentificacion);
    }

    public String getIdentificacion() {
        return this.identificacion;
    }

    public void setIdentificacion(String identificacion) {
        String oldValue = this.identificacion;
        this.identificacion = StringUtil.isNullOrEmpty((String)identificacion) ? identificacion : identificacion.toUpperCase();
        this.firePropertyChange(C_IDENTIFICACION, oldValue, this.identificacion);
    }

    public String getTipoSociedadExtranjera() {
        return this.tipoSociedadExtranjera;
    }

    public void setTipoSociedadExtranjera(String tipoSociedadExtranjera) {
        String oldValue = this.tipoSociedadExtranjera;
        this.tipoSociedadExtranjera = tipoSociedadExtranjera;
        this.firePropertyChange(C_TIPO_SOCIEDAD, oldValue, this.tipoSociedadExtranjera);
    }

    public boolean isSociedadExtranjeraPublica() {
        return this.sociedadExtranjeraPublica;
    }

    public void setSociedadExtranjeraPublica(boolean sociedadExtranjeraPublica) {
        boolean oldValue = this.sociedadExtranjeraPublica;
        this.sociedadExtranjeraPublica = sociedadExtranjeraPublica;
        this.firePropertyChange(C_SOCIEDAD_EXT_PUBLICA, oldValue, this.sociedadExtranjeraPublica);
    }

    public boolean isMenorDiezPorciento() {
        return this.menorDiezPorciento;
    }

    public void setMenorDiezPorciento(boolean menorDiezPorciento) {
        boolean oldValue = this.menorDiezPorciento;
        this.menorDiezPorciento = menorDiezPorciento;
        this.firePropertyChange(C_MENOR_10_PORCIENTO, oldValue, this.menorDiezPorciento);
    }

    public String getTipoSujeto() {
        return this.tipoSujeto;
    }

    public void setTipoSujeto(String tipoSujeto) {
        String oldValue = this.tipoSujeto;
        this.tipoSujeto = tipoSujeto;
        this.firePropertyChange(C_TIPO_SUJETO, oldValue, this.tipoSujeto);
    }

    public String getPrimerNombre() {
        return this.primerNombre;
    }

    public void setPrimerNombre(String primerNombre) {
        String oldValue = this.primerNombre;
        this.primerNombre = primerNombre;
        this.firePropertyChange(C_PRIMER_NOMBRE, oldValue, this.primerNombre);
    }

    public String getSegundoNombre() {
        return this.segundoNombre;
    }

    public void setSegundoNombre(String segundoNombre) {
        String oldValue = this.segundoNombre;
        this.segundoNombre = segundoNombre;
        this.firePropertyChange(C_SEGUNDO_NOMBRE, oldValue, this.segundoNombre);
    }

    public String getPrimerApellido() {
        return this.primerApellido;
    }

    public void setPrimerApellido(String primerApellido) {
        String oldValue = this.primerApellido;
        this.primerApellido = primerApellido;
        this.firePropertyChange(C_PRIMER_APELLIDO, oldValue, this.primerApellido);
    }

    public String getSegundoApellido() {
        return this.segundoApellido;
    }

    public void setSegundoApellido(String segundoApellido) {
        String oldValue = this.segundoApellido;
        this.segundoApellido = segundoApellido;
        this.firePropertyChange(C_SEGUNDO_APELLIDO, oldValue, this.segundoApellido);
    }

    public String getNombresRazonSocial() {
        return this.nombresRazonSocial;
    }

    public void setNombresRazonSocial(String nombresRazonSocial) {
        String oldValue = this.nombresRazonSocial;
        this.nombresRazonSocial = nombresRazonSocial;
        this.firePropertyChange(C_NOMBRES_RAZON_SOCIAL, oldValue, this.nombresRazonSocial);
    }

    public void agregarParticipacion(Participacion participacion) {
        participacion.setPropietario((ObjetoModelo)this);
        this.participaciones.add(participacion);
        this.firePropertyChange(CC_PARTICIPACIONES, null, this.participaciones);
    }

    public boolean eliminarBeneficiarioFinal(Beneficiario beneficiarioFinal) {
        boolean eliminado = this.beneficiariosFinales.remove((Object)beneficiarioFinal);
        if (eliminado) {
            this.firePropertyChange(CC_BENEFICIARIOS_FINALES, null, this.beneficiariosFinales);
        }
        return eliminado;
    }

    public void agregarBeneficiarioFinal(Beneficiario beneficiarioFinal) {
        beneficiarioFinal.setPropietario((ObjetoModelo)this);
        this.beneficiariosFinales.add(beneficiarioFinal);
        HashSet<Beneficiario> sinDuplicados = new HashSet<Beneficiario>(this.beneficiariosFinales);
        ArrayList<Beneficiario> listaSinDuplicados = new ArrayList<Beneficiario>(sinDuplicados);
        this.firePropertyChange(CC_BENEFICIARIOS_FINALES, null, listaSinDuplicados);
    }

    public boolean eliminarParticipacion(Participacion participacion) {
        boolean eliminado = this.participaciones.remove((Object)participacion);
        if (eliminado) {
            this.firePropertyChange(CC_PARTICIPACIONES, null, this.participaciones);
        }
        return eliminado;
    }

    public String getDescripcionTipoIdentificacion() {
        return this.descripcionTipoIdentificacion;
    }

    public void setDescripcionTipoIdentificacion(String descripcionTipoIdentificacion) {
        this.descripcionTipoIdentificacion = descripcionTipoIdentificacion;
    }

    public String getDescripcionTipoSociedad() {
        return this.descripcionTipoSociedad;
    }

    public void setDescripcionTipoSociedad(String descripcionTipoSociedad) {
        this.descripcionTipoSociedad = descripcionTipoSociedad;
    }

    public String getDescripcionTipoDeclaracion() {
        return this.descripcionTipoDeclaracion;
    }

    public void setDescripcionTipoDeclaracion(String descripcionTipoDeclaracion) {
        this.descripcionTipoDeclaracion = descripcionTipoDeclaracion;
    }

    public String getDescripcionTipoRegimen() {
        return this.descripcionTipoRegimen;
    }

    public void setDescripcionTipoRegimen(String descripcionTipoRegimen) {
        this.descripcionTipoRegimen = descripcionTipoRegimen;
    }

    public String getFiguraJuridica() {
        return this.figuraJuridica;
    }

    public void setFiguraJuridica(String figuraJuridica) {
        String oldValue = this.figuraJuridica;
        this.figuraJuridica = StringUtil.isNullOrEmpty((String)figuraJuridica) ? figuraJuridica : figuraJuridica.trim().toUpperCase();
        this.firePropertyChange(C_FIGURA_JURIDICA, oldValue, this.figuraJuridica);
    }

    public String getFiguraJuridicaOtro() {
        return this.figuraJuridicaOtro;
    }

    public void setFiguraJuridicaOtro(String figuraJuridicaOtro) {
        String oldValue = this.figuraJuridicaOtro;
        this.figuraJuridicaOtro = figuraJuridicaOtro;
        this.firePropertyChange(C_FIGURA_JURIDICA_OTRO, oldValue, this.figuraJuridicaOtro);
    }

    public String getEsBeneficiarioFinal() {
        return this.esBeneficiarioFinal;
    }

    public void setEsBeneficiarioFinal(String esBeneficiarioFinal) {
        String oldValue = this.esBeneficiarioFinal;
        this.esBeneficiarioFinal = esBeneficiarioFinal;
        this.firePropertyChange(C_ES_BENEFICIARIO_FINAL, oldValue, this.esBeneficiarioFinal);
    }

    public boolean isParteRelacionada() {
        return this.parteRelacionada;
    }

    public String getIsParteRelacionada() {
        return this.parteRelacionada ? "SI" : "NO";
    }

    public void setParteRelacionada(boolean parteRelacionada) {
        boolean oldValue = this.parteRelacionada;
        this.parteRelacionada = parteRelacionada;
        this.firePropertyChange(C_PARTE_RELACIONADA, oldValue, this.parteRelacionada);
    }

    public String getTipoPersona() {
        return this.tipoPersona;
    }

    public void setTipoPersona(String tipoPersona) {
        String oldValue = this.tipoPersona;
        this.tipoPersona = tipoPersona;
        this.firePropertyChange(C_TIPO_PERSONA, oldValue, this.tipoPersona);
    }

    public List<Participacion> getParticipaciones() {
        return this.participaciones;
    }

    protected void setParticipaciones(List<Participacion> participaciones) {
        this.participaciones = participaciones;
    }

    public List<Beneficiario> getBeneficiariosFinales() {
        return this.beneficiariosFinales;
    }

    public void setBeneficiariosFinales(List<Beneficiario> beneficiariosFinales) {
        this.beneficiariosFinales = beneficiariosFinales;
    }

    public DatosContacto getDatosContacto() {
        return this.datosContacto;
    }

    public void setDatosContacto(DatosContacto datosContacto) {
        datosContacto.setPropietario((ObjetoModelo)this);
        this.datosContacto = datosContacto;
    }

    public DatosUbicacion getDatosUbicacion() {
        return this.datosUbicacion;
    }

    public void setDatosUbicacion(DatosUbicacion datosUbicacion) {
        datosUbicacion.setPropietario((ObjetoModelo)this);
        this.datosUbicacion = datosUbicacion;
    }

    public DatosIdentificacion getDatosIdentificacion() {
        return this.datosIdentificacion;
    }

    public void setDatosIdentificacion(DatosIdentificacion datosIdentificacion) {
        datosIdentificacion.setPropietario((ObjetoModelo)this);
        this.datosIdentificacion = datosIdentificacion;
    }

    public String getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(String periodo) {
        this.periodo = periodo;
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public Object importar(Element accionista, Map<String, Element> mapaData) {
        DataCatalogos dataCatalogos = new DataCatalogos();
        DatosIdentificacion datosIdentificacion = new DatosIdentificacion();
        this.setDatosIdentificacion(datosIdentificacion);
        this.setPeriodo(mapaData.get("Anio").getTextContent());
        this.setMes(mapaData.get("Mes").getTextContent());
        NodeList listaValor = accionista.getElementsByTagName(C_TIPO_IDENTIFICACION);
        Element eValor = (Element)listaValor.item(0);
        this.setTipoIdentificacion(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName(C_TIPO_SUJETO);
        eValor = (Element)listaValor.item(0);
        this.setTipoSujeto(eValor.getTextContent());
        this.setDescripcionTipoIdentificacion(Constantes.IDENTIFICACIONES.get(this.getTipoIdentificacion()));
        listaValor = accionista.getElementsByTagName("numeroIdentificacion");
        eValor = (Element)listaValor.item(0);
        this.setIdentificacion(eValor.getTextContent());
        this.datosIdentificacion.importar(accionista, mapaData);
        listaValor = accionista.getElementsByTagName(C_NOMBRES_RAZON_SOCIAL);
        eValor = (Element)listaValor.item(0);
        if (eValor.getTextContent().equals("NA")) {
            this.setDenominacion(this.getDatosIdentificacion().getPrimerApellido().concat(" ").concat(this.getDatosIdentificacion().getPrimerNombre()));
            this.setNombresRazonSocial(this.getDatosIdentificacion().getPrimerApellido().concat(" ").concat(this.getDatosIdentificacion().getPrimerNombre()));
        } else {
            this.setDenominacion(eValor.getTextContent());
            this.setNombresRazonSocial(eValor.getTextContent());
        }
        listaValor = accionista.getElementsByTagName("tipoSociedadExt");
        eValor = (Element)listaValor.item(0);
        this.setTipoSociedadExtranjera(eValor.getTextContent());
        this.setDescripcionTipoSociedad((String)dataCatalogos.obtenerValoresCatalogos(MnemonicosCatalogos.TIPO_SOCIEDAD_EXTRANJERA.getMnemonico()).get(this.tipoSociedadExtranjera));
        listaValor = accionista.getElementsByTagName("figuraJuridicaExt");
        eValor = (Element)listaValor.item(0);
        this.setFiguraJuridica(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName("figuraJuridicaOtroExt");
        eValor = (Element)listaValor.item(0);
        this.setFiguraJuridicaOtro(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName("esSociedadPublicaExt");
        eValor = (Element)listaValor.item(0);
        this.setSociedadExtranjeraPublica(eValor.getTextContent().equalsIgnoreCase("SI"));
        listaValor = accionista.getElementsByTagName("Menor10porc");
        eValor = (Element)listaValor.item(0);
        this.setMenorDiezPorciento(eValor.getTextContent().equalsIgnoreCase("SI"));
        listaValor = accionista.getElementsByTagName("porcentajeAccionarioNoBolsaExt");
        eValor = (Element)listaValor.item(0);
        this.setPorcentajeNoCotiza(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName("porcentajeAccionarioBolsaExt");
        eValor = (Element)listaValor.item(0);
        this.setPorcentajeCotiza(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName(C_ES_BENEFICIARIO_FINAL);
        eValor = (Element)listaValor.item(0);
        this.setEsBeneficiarioFinal(eValor.getTextContent());
        listaValor = accionista.getElementsByTagName(C_TIPO_REGIMEN_FISCAL);
        eValor = (Element)listaValor.item(0);
        this.setTipoRegimenFiscal(eValor.getTextContent());
        this.asignarTipoPersonaTipoIdentificacion();
        listaValor = accionista.getElementsByTagName("infoParticipacionAccionaria");
        Element infoParticipacion = (Element)listaValor.item(0);
        listaValor = accionista.getElementsByTagName("ubicacionResidenciaFiscal");
        Element ubicacion = (Element)listaValor.item(0);
        this.datosUbicacion.importar(ubicacion, null);
        listaValor = infoParticipacion.getElementsByTagName("parteRelacionadaInformante");
        eValor = (Element)listaValor.item(0);
        this.setParteRelacionada("SI".equals(eValor.getTextContent().toUpperCase()));
        return this;
    }

    public Element exportar(Document documento, Element elemento) {
        Element tipoSujeto = documento.createElement(C_TIPO_SUJETO);
        if (UtilValidacion.esAnexoDesdePeriodo2024(this.getPeriodo(), this.getMes())) {
            tipoSujeto.setTextContent(this.getTipoSujeto());
        } else {
            tipoSujeto.setTextContent("NA");
        }
        elemento.appendChild(tipoSujeto);
        Element tipIdentificacion = documento.createElement(C_TIPO_IDENTIFICACION);
        tipIdentificacion.setTextContent(this.getTipoIdentificacion());
        elemento.appendChild(tipIdentificacion);
        return elemento;
    }

    public Element exportarPadre(Document documento, Element elemento) {
        Element idPadre = documento.createElement("identificacionInformantePadre");
        elemento.appendChild(idPadre);
        return elemento;
    }

    public Element exportarAdicionales(Document documento, Element elemento) {
        Element numeroIdentificacion = documento.createElement("numeroIdentificacion");
        numeroIdentificacion.setTextContent(StringUtil.isNullOrEmpty((String)this.getIdentificacion()) ? "NA" : this.getIdentificacion());
        elemento.appendChild(numeroIdentificacion);
        this.getDatosIdentificacion().exportar(documento, elemento);
        Element nombresRazonSocial = documento.createElement(C_NOMBRES_RAZON_SOCIAL);
        if ((StringUtil.isNullOrEmpty((String)this.getDatosIdentificacion().getPrimerNombre()) || this.getDatosIdentificacion().getPrimerNombre().equals("NA")) && (StringUtil.isNullOrEmpty((String)this.getDatosIdentificacion().getPrimerApellido()) || this.getDatosIdentificacion().getPrimerApellido().equals("NA"))) {
            nombresRazonSocial.setTextContent(StringUtil.isNullOrEmpty((String)this.getDatosIdentificacion().getRazonSocial()) ? "NA" : this.getDatosIdentificacion().getRazonSocial());
        } else {
            nombresRazonSocial.setTextContent("NA");
        }
        elemento.appendChild(nombresRazonSocial);
        Element tipoRegimenFiscal = documento.createElement(C_TIPO_REGIMEN_FISCAL);
        tipoRegimenFiscal.setTextContent(StringUtil.isNullOrEmpty((String)this.getTipoRegimenFiscal()) ? "NA" : this.getTipoRegimenFiscal());
        elemento.appendChild(tipoRegimenFiscal);
        Element tipoSociedadExt = documento.createElement("tipoSociedadExt");
        tipoSociedadExt.setTextContent(StringUtil.isNullOrEmpty((String)this.getTipoSociedadExtranjera()) ? "NA" : this.getTipoSociedadExtranjera());
        elemento.appendChild(tipoSociedadExt);
        Element figuraJuridicaExt = documento.createElement("figuraJuridicaExt");
        figuraJuridicaExt.setTextContent(StringUtil.isNullOrEmpty((String)this.getFiguraJuridica()) ? "NA" : this.getFiguraJuridica());
        elemento.appendChild(figuraJuridicaExt);
        Element figuraJuridicaOtroExt = documento.createElement("figuraJuridicaOtroExt");
        figuraJuridicaOtroExt.setTextContent(StringUtil.isNullOrEmpty((String)this.getFiguraJuridicaOtro()) ? "NA" : this.getFiguraJuridicaOtro());
        elemento.appendChild(figuraJuridicaOtroExt);
        Element isSociedadPublicaExt = documento.createElement("esSociedadPublicaExt");
        isSociedadPublicaExt.setTextContent(this.isSociedadExtranjeraPublica() ? "SI" : "NO");
        elemento.appendChild(isSociedadPublicaExt);
        Element isMenor10porc = documento.createElement("Menor10porc");
        if (Integer.valueOf(this.getPeriodo()) >= 2022) {
            if (this.getTipoSociedadExtranjera() == null || this.getTipoSociedadExtranjera().equalsIgnoreCase("00") || this.getTipoSociedadExtranjera().equalsIgnoreCase("NA")) {
                isMenor10porc.setTextContent("NA");
            } else {
                isMenor10porc.setTextContent(this.isMenorDiezPorciento() ? "SI" : "NO");
            }
        } else {
            isMenor10porc.setTextContent("NA");
        }
        elemento.appendChild(isMenor10porc);
        Element porcentajeAccionarioNoBolsaExt = documento.createElement("porcentajeAccionarioNoBolsaExt");
        porcentajeAccionarioNoBolsaExt.setTextContent(StringUtil.isNullOrEmpty((String)this.porcentajeNoCotiza) ? "0.0" : this.porcentajeNoCotiza);
        elemento.appendChild(porcentajeAccionarioNoBolsaExt);
        Element porcentajeAccionarioBolsaExt = documento.createElement("porcentajeAccionarioBolsaExt");
        porcentajeAccionarioBolsaExt.setTextContent(StringUtil.isNullOrEmpty((String)this.porcentajeCotiza) ? "0.0" : this.porcentajeCotiza);
        elemento.appendChild(porcentajeAccionarioBolsaExt);
        return elemento;
    }

    public SujetoRelacionado crearCopiaEdicion() {
        SujetoRelacionado copiaEdicion = new SujetoRelacionado();
        copiaEdicion.setDenominacion(this.denominacion);
        copiaEdicion.setTipoIdentificacion(this.tipoIdentificacion);
        copiaEdicion.setDescripcionTipoIdentificacion(this.descripcionTipoIdentificacion);
        copiaEdicion.setIdentificacion(this.identificacion);
        copiaEdicion.setTipoSociedadExtranjera(this.tipoSociedadExtranjera);
        copiaEdicion.setDescripcionTipoSociedad(this.descripcionTipoSociedad);
        copiaEdicion.setSociedadExtranjeraPublica(this.sociedadExtranjeraPublica);
        copiaEdicion.setMenorDiezPorciento(this.menorDiezPorciento);
        copiaEdicion.setFiguraJuridica(this.figuraJuridica);
        copiaEdicion.setFiguraJuridicaOtro(this.figuraJuridicaOtro);
        copiaEdicion.setPorcentajeNoCotiza(this.porcentajeNoCotiza);
        copiaEdicion.setPorcentajeCotiza(this.porcentajeCotiza);
        copiaEdicion.setParteRelacionada(this.parteRelacionada);
        copiaEdicion.setPropietario((ObjetoModelo)((Participacion)this.propietario));
        copiaEdicion.setTipoRegimenFiscal(this.tipoRegimenFiscal);
        copiaEdicion.setDescripcionTipoRegimen(this.descripcionTipoRegimen);
        copiaEdicion.setPeriodo(this.periodo);
        copiaEdicion.setMes(this.mes);
        copiaEdicion.setPrimerNombre(this.primerNombre);
        copiaEdicion.setSegundoNombre(this.segundoNombre);
        copiaEdicion.setPrimerApellido(this.primerApellido);
        copiaEdicion.setSegundoApellido(this.segundoApellido);
        copiaEdicion.setTipoSujeto(this.tipoSujeto);
        copiaEdicion.setNombresRazonSocial(this.nombresRazonSocial);
        copiaEdicion.setEsBeneficiarioFinal(this.esBeneficiarioFinal);
        copiaEdicion.datosContacto = this.datosContacto.crearCopiaEdicion();
        copiaEdicion.datosContacto.setPropietario((ObjetoModelo)copiaEdicion);
        copiaEdicion.datosUbicacion = this.datosUbicacion.crearCopiaEdicion();
        copiaEdicion.datosUbicacion.setPropietario((ObjetoModelo)copiaEdicion);
        copiaEdicion.datosIdentificacion = this.datosIdentificacion.crearCopiaEdicion();
        copiaEdicion.datosIdentificacion.setPropietario((ObjetoModelo)copiaEdicion);
        return copiaEdicion;
    }

    public void actualizarInformacion(SujetoRelacionado copiaEdicion) {
        this.setDenominacion(copiaEdicion.getDenominacion());
        this.setTipoIdentificacion(copiaEdicion.getDatosIdentificacion().getTipoIdentificacion());
        this.setDescripcionTipoIdentificacion(copiaEdicion.getDatosIdentificacion().getDescripcionTipoIdentificacion());
        this.setIdentificacion(copiaEdicion.getDatosIdentificacion().getIdentificacion());
        this.setTipoSociedadExtranjera(copiaEdicion.getTipoSociedadExtranjera());
        this.setDescripcionTipoSociedad(copiaEdicion.getDescripcionTipoSociedad());
        this.setSociedadExtranjeraPublica(copiaEdicion.isSociedadExtranjeraPublica());
        this.setMenorDiezPorciento(copiaEdicion.isMenorDiezPorciento());
        this.setFiguraJuridica(copiaEdicion.getFiguraJuridica());
        this.setFiguraJuridicaOtro(copiaEdicion.getFiguraJuridicaOtro());
        this.setPorcentajeNoCotiza(copiaEdicion.getPorcentajeNoCotiza());
        this.setPorcentajeCotiza(copiaEdicion.getPorcentajeCotiza());
        this.setParteRelacionada(copiaEdicion.isParteRelacionada());
        this.setTipoPersona(copiaEdicion.getTipoPersona());
        this.setTipoRegimenFiscal(copiaEdicion.getTipoRegimenFiscal());
        this.setDescripcionTipoRegimen(copiaEdicion.getDescripcionTipoRegimen());
        this.setPeriodo(copiaEdicion.getPeriodo());
        this.setMes(copiaEdicion.getMes());
        this.setEsBeneficiarioFinal(copiaEdicion.getEsBeneficiarioFinal());
        this.setTipoSujeto(copiaEdicion.getDatosIdentificacion().getTipoSujeto());
    }

    public void asignarTipoPersonaTipoIdentificacion() {
        if ("C".equals(this.tipoIdentificacion) || "P".equals(this.tipoIdentificacion)) {
            this.setTipoPersona(NATURAL);
            return;
        }
        if ("E".equals(this.tipoIdentificacion)) {
            this.setTipoPersona(this.descripcionTipoSociedad);
            return;
        }
        String tercerDigito = this.identificacion.substring(2, 3);
        int digito = Integer.parseInt(tercerDigito);
        switch (digito) {
            case 6: {
                this.setTipoPersona(SOC_PUBLICA);
                break;
            }
            case 9: {
                this.setTipoPersona(SOC_PRIVADA);
                break;
            }
            default: {
                this.setTipoPersona(NATURAL);
            }
        }
    }
}

