/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UbicacionBeneficiarioFinal
extends ObjetoModeloSucesorValidable<ObjetoModelo>
implements Exportable,
Importable,
InformacionEditable<UbicacionBeneficiarioFinal> {
    private static final long serialVersionUID = -2377693516677646669L;
    public static final String C_NACIONALIDAD_UNO = "nacionalidadUno";
    public static final String C_NACIONALIDAD_DOS = "nacionalidadDos";
    public static final String C_NACIONALIDAD_TRES = "nacionalidadTres";
    public static final String C_RESIDENCIA_FISCAL = "residenciaFiscal";
    public static final String C_JURISDICCION = "jurisdiccion";
    public static final String C_PROVINCIA = "provincia";
    public static final String C_CIUDAD = "ciudad";
    public static final String C_CANTON = "canton";
    public static final String C_PARROQUIA = "parroquia";
    public static final String C_CALLE = "calle";
    public static final String C_NUMERO = "numero";
    public static final String C_INTERSECCION = "interseccion";
    public static final String C_CODIGO_POSTAL = "codigoPostal";
    public static final String C_REFERENCIA = "referencia";
    private String nacionalidadUno;
    private String nacionalidadDos;
    private String nacionalidadTres;
    private String residenciaFiscal;
    private String jurisdiccion;
    private String provincia;
    private String ciudad;
    private String canton;
    private String parroquia;
    private String calle;
    private String numero;
    private String interseccion;
    private String codigoPostal;
    private String referencia;
    private Boolean esEdicion;

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (StringUtil.isNullOrEmpty((String)this.nacionalidadUno)) {
            return resultado.fallarValidacion("Debe ingresar el campo Nacionalidad Uno.");
        }
        if (StringUtil.isNullOrEmpty((String)this.residenciaFiscal)) {
            return resultado.fallarValidacion("Debe seleccionar el campo Residencia Fiscal del Beneficiario Final.");
        }
        if (!"593".equals(this.residenciaFiscal)) {
            if (StringUtil.isNullOrEmpty((String)this.jurisdiccion)) {
                return resultado.fallarValidacion("Debe ingresar el campo Estado/Jurisdicci\u00f3n.");
            }
            if (!Pattern.matches("[a-zA-Z0-9]{2}[a-zA-Z0-9\\s]{0,98}", this.jurisdiccion)) {
                return resultado.fallarValidacion("El campo Jurisdicci\u00f3n no admite caracteres especiales, tildes ni la letra \u00f1 y debe tener una longitud m\u00ednima de 2 y m\u00e1xima de 100");
            }
            if (StringUtil.isNullOrEmpty((String)this.ciudad)) {
                return resultado.fallarValidacion("Debe ingresar el campo Ciudad.");
            }
        } else {
            if (StringUtil.isNullOrEmpty((String)this.provincia)) {
                return resultado.fallarValidacion("Debe seleccionar el campo Provincia.");
            }
            if (StringUtil.isNullOrEmpty((String)this.canton)) {
                return resultado.fallarValidacion("Debe seleccionar el campo Cant\u00f3n.");
            }
            if (StringUtil.isNullOrEmpty((String)this.parroquia)) {
                return resultado.fallarValidacion("Debe seleccionar el campo Parroquia.");
            }
        }
        if (StringUtil.isNullOrEmpty((String)this.calle)) {
            return resultado.fallarValidacion("Debe ingresar el campo Calle.");
        }
        if (StringUtil.isNullOrEmpty((String)this.numero)) {
            return resultado.fallarValidacion("Debe ingresar el campo N\u00edmero.");
        }
        if (StringUtil.isNullOrEmpty((String)this.interseccion)) {
            return resultado.fallarValidacion("Debe ingresar el campo Intersecci\u00f3n.");
        }
        if (StringUtil.isNullOrEmpty((String)this.codigoPostal)) {
            return resultado.fallarValidacion("Debe ingresar el campo C\u00f3digo Postal.");
        }
        if (StringUtil.isNullOrEmpty((String)this.referencia)) {
            return resultado.fallarValidacion("Debe ingresar el campo Referencia.");
        }
        return resultado.pasarValidacion();
    }

    private ResultadoValidacion validarJurisdiccion(ResultadoValidacion resultado, String pais, String jurisdiccion) {
        if (!"593".equals(pais)) {
            if (StringUtil.isNullOrEmpty((String)jurisdiccion)) {
                return resultado.fallarValidacion("Debe ingresar el campo Estado/Jurisdicci\u00f3n.");
            }
            if (!Pattern.matches("[a-zA-Z0-9]{2}[a-zA-Z0-9\\s]{0,98}", jurisdiccion)) {
                return resultado.fallarValidacion("El campo Jurisdicci\u00f3n no admite caracteres especiales, tildes ni la letra \u00f1 y debe tener una longitud m\u00ednima de 2 y m\u00e1xima de 100");
            }
        }
        return resultado.pasarValidacion();
    }

    public Object importar(Element ubicacion, Map<String, Element> mapaData) {
        NodeList listaValor = ubicacion.getElementsByTagName(C_NACIONALIDAD_UNO);
        Element eValor = (Element)listaValor.item(0);
        this.setNacionalidadUno(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_NACIONALIDAD_DOS);
        eValor = (Element)listaValor.item(0);
        this.setNacionalidadDos(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_NACIONALIDAD_TRES);
        eValor = (Element)listaValor.item(0);
        this.setNacionalidadTres(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_RESIDENCIA_FISCAL);
        eValor = (Element)listaValor.item(0);
        this.setResidenciaFiscal(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_JURISDICCION);
        eValor = (Element)listaValor.item(0);
        this.setJurisdiccion(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_PROVINCIA);
        eValor = (Element)listaValor.item(0);
        this.setProvincia(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_CIUDAD);
        eValor = (Element)listaValor.item(0);
        this.setCiudad(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_CANTON);
        eValor = (Element)listaValor.item(0);
        this.setCanton(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_PARROQUIA);
        eValor = (Element)listaValor.item(0);
        this.setParroquia(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_CALLE);
        eValor = (Element)listaValor.item(0);
        this.setCalle(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_NUMERO);
        eValor = (Element)listaValor.item(0);
        this.setNumero(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_INTERSECCION);
        eValor = (Element)listaValor.item(0);
        this.setInterseccion(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_CODIGO_POSTAL);
        eValor = (Element)listaValor.item(0);
        this.setCodigoPostal(eValor == null ? "" : eValor.getTextContent());
        listaValor = ubicacion.getElementsByTagName(C_REFERENCIA);
        eValor = (Element)listaValor.item(0);
        this.setReferencia(eValor == null ? "" : eValor.getTextContent());
        return this;
    }

    public Element exportar(Document documento, Element elemento) {
        Element eNacionalidadUno = documento.createElement(C_NACIONALIDAD_UNO);
        eNacionalidadUno.setTextContent(StringUtil.isNullOrEmpty((String)this.nacionalidadUno) ? "NA" : this.nacionalidadUno);
        elemento.appendChild(eNacionalidadUno);
        Element eNacionalidadDos = documento.createElement(C_NACIONALIDAD_DOS);
        eNacionalidadDos.setTextContent(StringUtil.isNullOrEmpty((String)this.nacionalidadDos) ? "NA" : this.nacionalidadDos);
        elemento.appendChild(eNacionalidadDos);
        Element eNacionalidadTres = documento.createElement(C_NACIONALIDAD_TRES);
        eNacionalidadTres.setTextContent(StringUtil.isNullOrEmpty((String)this.nacionalidadTres) ? "NA" : this.nacionalidadTres);
        elemento.appendChild(eNacionalidadTres);
        Element eResidenciaFiscal = documento.createElement(C_RESIDENCIA_FISCAL);
        eResidenciaFiscal.setTextContent(StringUtil.isNullOrEmpty((String)this.residenciaFiscal) ? "NA" : this.residenciaFiscal);
        elemento.appendChild(eResidenciaFiscal);
        Element eJurisdiccion = documento.createElement(C_JURISDICCION);
        eJurisdiccion.setTextContent(StringUtil.isNullOrEmpty((String)this.jurisdiccion) ? "NA" : this.jurisdiccion);
        elemento.appendChild(eJurisdiccion);
        Element eProvincia = documento.createElement(C_PROVINCIA);
        eProvincia.setTextContent(StringUtil.isNullOrEmpty((String)this.provincia) ? "NA" : this.provincia);
        elemento.appendChild(eProvincia);
        Element eCiudad = documento.createElement(C_CIUDAD);
        eCiudad.setTextContent(StringUtil.isNullOrEmpty((String)this.ciudad) ? "NA" : this.ciudad);
        elemento.appendChild(eCiudad);
        Element eCanton = documento.createElement(C_CANTON);
        eCanton.setTextContent(StringUtil.isNullOrEmpty((String)this.canton) ? "NA" : this.canton);
        elemento.appendChild(eCanton);
        Element eParroquia = documento.createElement(C_PARROQUIA);
        eParroquia.setTextContent(StringUtil.isNullOrEmpty((String)this.parroquia) ? "NA" : this.parroquia);
        elemento.appendChild(eParroquia);
        Element eCalle = documento.createElement(C_CALLE);
        eCalle.setTextContent(StringUtil.isNullOrEmpty((String)this.calle) ? "NA" : this.calle);
        elemento.appendChild(eCalle);
        Element eNumero = documento.createElement(C_NUMERO);
        eNumero.setTextContent(StringUtil.isNullOrEmpty((String)this.numero) ? "NA" : this.numero);
        elemento.appendChild(eNumero);
        Element eInterseccion = documento.createElement(C_INTERSECCION);
        eInterseccion.setTextContent(StringUtil.isNullOrEmpty((String)this.interseccion) ? "NA" : this.interseccion);
        elemento.appendChild(eInterseccion);
        Element eCodigoPostal = documento.createElement(C_CODIGO_POSTAL);
        eCodigoPostal.setTextContent(StringUtil.isNullOrEmpty((String)this.codigoPostal) ? "NA" : this.codigoPostal);
        elemento.appendChild(eCodigoPostal);
        Element eReferencia = documento.createElement(C_REFERENCIA);
        eReferencia.setTextContent(StringUtil.isNullOrEmpty((String)this.referencia) ? "NA" : this.referencia);
        elemento.appendChild(eReferencia);
        return elemento;
    }

    public String getNacionalidadUno() {
        return this.nacionalidadUno;
    }

    public void setNacionalidadUno(String nacionalidadUno) {
        String oldValue = this.nacionalidadUno;
        this.nacionalidadUno = nacionalidadUno;
        this.firePropertyChange(C_NACIONALIDAD_UNO, oldValue, this.nacionalidadUno);
    }

    public String getNacionalidadDos() {
        return this.nacionalidadDos;
    }

    public void setNacionalidadDos(String nacionalidadDos) {
        String oldValue = this.nacionalidadDos;
        this.nacionalidadDos = nacionalidadDos;
        this.firePropertyChange(C_NACIONALIDAD_DOS, oldValue, this.nacionalidadDos);
    }

    public String getNacionalidadTres() {
        return this.nacionalidadTres;
    }

    public void setNacionalidadTres(String nacionalidadTres) {
        String oldValue = this.nacionalidadTres;
        this.nacionalidadTres = nacionalidadTres;
        this.firePropertyChange(C_NACIONALIDAD_TRES, oldValue, this.nacionalidadTres);
    }

    public String getResidenciaFiscal() {
        return this.residenciaFiscal;
    }

    public void setResidenciaFiscal(String residenciaFiscal) {
        String oldValue = this.residenciaFiscal;
        this.residenciaFiscal = residenciaFiscal;
        this.firePropertyChange(C_RESIDENCIA_FISCAL, oldValue, this.residenciaFiscal);
    }

    public String getJurisdiccion() {
        return this.jurisdiccion;
    }

    public void setJurisdiccion(String jurisdiccion) {
        String oldValue = this.jurisdiccion;
        this.jurisdiccion = jurisdiccion;
        this.firePropertyChange(C_JURISDICCION, oldValue, this.jurisdiccion);
    }

    public String getProvincia() {
        return this.provincia;
    }

    public void setProvincia(String provincia) {
        String oldValue = this.provincia;
        this.provincia = provincia;
        this.firePropertyChange(C_PROVINCIA, oldValue, this.provincia);
    }

    public String getCiudad() {
        return this.ciudad;
    }

    public void setCiudad(String ciudad) {
        String oldValue = this.ciudad;
        this.ciudad = ciudad;
        this.firePropertyChange(C_CIUDAD, oldValue, this.ciudad);
    }

    public String getCanton() {
        return this.canton;
    }

    public void setCanton(String canton) {
        String oldValue = this.canton;
        this.canton = canton;
        this.firePropertyChange(C_CANTON, oldValue, this.canton);
    }

    public String getParroquia() {
        return this.parroquia;
    }

    public void setParroquia(String parroquia) {
        String oldValue = this.parroquia;
        this.parroquia = parroquia;
        this.firePropertyChange(C_PARROQUIA, oldValue, this.parroquia);
    }

    public String getCalle() {
        return this.calle;
    }

    public void setCalle(String calle) {
        String oldValue = this.calle;
        this.calle = calle;
        this.firePropertyChange(C_CALLE, oldValue, this.calle);
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        String oldValue = this.numero;
        this.numero = numero;
        this.firePropertyChange(C_NUMERO, oldValue, this.numero);
    }

    public String getInterseccion() {
        return this.interseccion;
    }

    public void setInterseccion(String interseccion) {
        String oldValue = this.interseccion;
        this.interseccion = interseccion;
        this.firePropertyChange(C_INTERSECCION, oldValue, this.interseccion);
    }

    public String getCodigoPostal() {
        return this.codigoPostal;
    }

    public void setCodigoPostal(String codigoPostal) {
        String oldValue = this.codigoPostal;
        this.codigoPostal = codigoPostal;
        this.firePropertyChange(C_CODIGO_POSTAL, oldValue, this.codigoPostal);
    }

    public String getReferencia() {
        return this.referencia;
    }

    public void setReferencia(String referencia) {
        String oldValue = this.referencia;
        this.referencia = referencia;
        this.firePropertyChange(C_REFERENCIA, oldValue, this.referencia);
    }

    public Boolean getEsEdicion() {
        return this.esEdicion;
    }

    public void setEsEdicion(Boolean esEdicion) {
        this.esEdicion = esEdicion;
    }

    public UbicacionBeneficiarioFinal crearCopiaEdicion() {
        UbicacionBeneficiarioFinal copiaEdicion = new UbicacionBeneficiarioFinal();
        copiaEdicion.setNacionalidadUno(this.nacionalidadUno);
        copiaEdicion.setNacionalidadDos(this.nacionalidadDos);
        copiaEdicion.setNacionalidadTres(this.nacionalidadTres);
        copiaEdicion.setResidenciaFiscal(this.residenciaFiscal);
        copiaEdicion.setJurisdiccion(this.jurisdiccion);
        copiaEdicion.setProvincia(this.provincia);
        copiaEdicion.setCiudad(this.ciudad);
        copiaEdicion.setCanton(this.canton);
        copiaEdicion.setParroquia(this.parroquia);
        copiaEdicion.setCalle(this.calle);
        copiaEdicion.setNumero(this.numero);
        copiaEdicion.setInterseccion(this.interseccion);
        copiaEdicion.setCodigoPostal(this.codigoPostal);
        copiaEdicion.setReferencia(this.referencia);
        copiaEdicion.setEsEdicion(true);
        return copiaEdicion;
    }

    public void actualizarInformacion(UbicacionBeneficiarioFinal copiaEdicion) {
        this.setNacionalidadUno(copiaEdicion.getNacionalidadUno());
        this.setNacionalidadDos(copiaEdicion.getNacionalidadDos());
        this.setNacionalidadTres(copiaEdicion.getNacionalidadTres());
        this.setResidenciaFiscal(copiaEdicion.getResidenciaFiscal());
        this.setJurisdiccion(copiaEdicion.getJurisdiccion());
        this.setProvincia(copiaEdicion.getProvincia());
        this.setCiudad(copiaEdicion.getCiudad());
        this.setCanton(copiaEdicion.getCanton());
        this.setParroquia(copiaEdicion.getParroquia());
        this.setCalle(copiaEdicion.getCalle());
        this.setNumero(copiaEdicion.getNumero());
        this.setInterseccion(copiaEdicion.getInterseccion());
        this.setCodigoPostal(copiaEdicion.getCodigoPostal());
        this.setReferencia(copiaEdicion.getReferencia());
    }
}

