/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj.asistente;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionInformacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.SoporteValidacionInformacion;
import ec.gob.sri.dimm.aps.modelo.util.StringModeloUtils;

public class DatosInformante
extends ObjetoModelo
implements InformacionValidable {
    private static final long serialVersionUID = -2305508902280276709L;
    public static final String C_ANIO = "anio";
    public static final String C_MES = "mes";
    public static final String C_TIPO_SOCIEDAD = "tipoSociedad";
    public static final String C_TIPO_DECLARACION = "tipoDeclaracion";
    public static final String C_DESCRIPCION_DECLARACION = "descripcionDeclaracion";
    public static final String C_PORCENTAJE_NO_COTIZA = "porcentajeNoCotiza";
    public static final String C_PORCENTAJE_COTIZA = "porcentajeCotiza";
    public static final String C_DECLARACION_MENSUAL = "declaracionMensual";
    public static final String C_PERIODICIDAD = "periodicidad";
    public static final String PERIODICIDAD_ANUAL = "Anual";
    public static final String PERIODICIDAD_MENSUAL = "Mensual";
    public static final String PERIODICIDAD_ANTICIPADA = "Anticipada";
    private String anio;
    private String mes;
    private String tipoSociedad;
    private String tipoDeclaracion;
    private String descripcionTipoDeclaracion;
    private Double porcentajeNoCotiza;
    private Double porcentajeCotiza;
    private boolean declaracionMensual;
    private String periodicidad;
    private final transient SoporteValidacionInformacion soporteValidacion = new SoporteValidacionInformacion(){

        protected ResultadoValidacion validarInformacion() {
            ResultadoValidacion resultado = new ResultadoValidacion();
            if (StringUtil.isNullOrEmpty((String)DatosInformante.this.anio)) {
                return resultado.fallarValidacion("Debe especificar el a\u00f1o de declaraci\u00f3n.");
            }
            if (DatosInformante.this.declaracionMensual && StringUtil.isNullOrEmpty((String)DatosInformante.this.mes)) {
                return resultado.fallarValidacion("Debe especificar el mes de declaraci\u00f3n.");
            }
            if ((DatosInformante.PERIODICIDAD_ANUAL.equals(DatosInformante.this.periodicidad) && Integer.valueOf(DatosInformante.this.anio) > 2023 || DatosInformante.PERIODICIDAD_ANTICIPADA.equals(DatosInformante.this.periodicidad) && Integer.valueOf(DatosInformante.this.anio) > 2023) && StringUtil.isNullOrEmpty((String)DatosInformante.this.tipoDeclaracion)) {
                return resultado.fallarValidacion("Es necesario indicar el tipo de declaraci\u00f3n.");
            }
            if (DatosInformante.PERIODICIDAD_MENSUAL.equals(DatosInformante.this.periodicidad) && Integer.valueOf(DatosInformante.this.anio) > 2023 && Integer.valueOf(DatosInformante.this.mes) > 9 && StringUtil.isNullOrEmpty((String)DatosInformante.this.tipoDeclaracion)) {
                return resultado.fallarValidacion("Es necesario indicar el tipo de declaraci\u00f3n.");
            }
            if (StringUtil.isNullOrEmpty((String)DatosInformante.this.tipoSociedad)) {
                return resultado.fallarValidacion("Es necesario indicar el tipo de sociedad.");
            }
            if (DatosInformante.this.porcentajeNoCotiza == null) {
                return resultado.fallarValidacion("No ha ingresado el porcentaje accionario que no cotiza en bolsa de la sociedad.");
            }
            if (StringModeloUtils.obtenerNumeroDeDecimales(DatosInformante.this.porcentajeNoCotiza) > 6) {
                return resultado.fallarValidacion("El valor registrado como porcentaje accionario que no cotiza en bolsa de valores debe tener m\u00e1ximo 6 decimales.");
            }
            if (DatosInformante.this.porcentajeNoCotiza < 0.0 || DatosInformante.this.porcentajeNoCotiza > 100.0) {
                return resultado.fallarValidacion("El valor registrado como porcentaje accionario que no cotiza en bolsa de valores no es correcto.");
            }
            return resultado.pasarValidacion();
        }
    };

    public String getAnio() {
        return this.anio;
    }

    public void setAnio(String anio) {
        String oldAnio = this.anio;
        this.anio = anio;
        this.firePropertyChange(C_ANIO, oldAnio, this.anio);
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        String oldMes = this.mes;
        this.mes = mes;
        this.firePropertyChange(C_MES, oldMes, this.mes);
    }

    public String getTipoSociedad() {
        return this.tipoSociedad;
    }

    public void setTipoSociedad(String tipoSociedad) {
        String oldTipoSociedad = this.tipoSociedad;
        this.tipoSociedad = tipoSociedad;
        this.firePropertyChange(C_TIPO_SOCIEDAD, oldTipoSociedad, this.tipoSociedad);
    }

    public String getTipoDeclaracion() {
        return this.tipoDeclaracion;
    }

    public void setTipoDeclaracion(String tipoDeclaracion) {
        String oldTipoDeclaracion = this.tipoDeclaracion;
        this.tipoDeclaracion = tipoDeclaracion;
        this.firePropertyChange(C_TIPO_DECLARACION, oldTipoDeclaracion, this.tipoDeclaracion);
    }

    public String getDescripcionTipoDeclaracion() {
        return this.descripcionTipoDeclaracion;
    }

    public void setDescripcionTipoDeclaracion(String descripcionTipoDeclaracion) {
        String oldTipoDeclaracion = this.descripcionTipoDeclaracion;
        this.descripcionTipoDeclaracion = descripcionTipoDeclaracion;
        this.firePropertyChange(C_DESCRIPCION_DECLARACION, oldTipoDeclaracion, this.descripcionTipoDeclaracion);
    }

    public Double getPorcentajeNoCotiza() {
        return this.porcentajeNoCotiza;
    }

    public void setPorcentajeNoCotiza(Double porcentajeNoCotiza) {
        Double oldPorcentajeNoCotiza = this.porcentajeNoCotiza;
        this.porcentajeNoCotiza = porcentajeNoCotiza;
        this.firePropertyChange(C_PORCENTAJE_NO_COTIZA, oldPorcentajeNoCotiza, this.porcentajeNoCotiza);
    }

    public Double getPorcentajeCotiza() {
        return this.porcentajeCotiza;
    }

    public void setPorcentajeCotiza(Double porcentajeCotiza) {
        Double oldPorcentajeCotiza = this.porcentajeNoCotiza;
        this.porcentajeCotiza = porcentajeCotiza;
        this.firePropertyChange(C_PORCENTAJE_COTIZA, oldPorcentajeCotiza, this.porcentajeCotiza);
    }

    public boolean isDeclaracionMensual() {
        return this.declaracionMensual;
    }

    public void setDeclaracionMensual(boolean declaracionMensual) {
        boolean oldDeclaracionMensual = this.declaracionMensual;
        this.declaracionMensual = declaracionMensual;
        this.firePropertyChange(C_DECLARACION_MENSUAL, oldDeclaracionMensual, this.declaracionMensual);
    }

    public ResultadoValidacion validar() {
        return this.soporteValidacion.validar();
    }

    public void setListenerValidacion(ListenerValidacionInformacion listenerValidacion) {
        this.soporteValidacion.setListenerValidacion(listenerValidacion);
    }

    public String getPeriodicidad() {
        return this.periodicidad;
    }

    public void setPeriodicidad(String periodicidad) {
        this.setInfoDeclaracionMensual(periodicidad);
        String oldPeriodicidad = this.periodicidad;
        this.periodicidad = periodicidad;
        this.firePropertyChange(C_PERIODICIDAD, oldPeriodicidad, this.periodicidad);
    }

    private void setInfoDeclaracionMensual(String periodicidad) {
        if (PERIODICIDAD_ANUAL.equals(periodicidad) || PERIODICIDAD_ANTICIPADA.equals(periodicidad)) {
            this.setDeclaracionMensual(false);
        } else {
            this.setDeclaracionMensual(true);
        }
    }
}

