/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj.asistente;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionInformacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.SoporteValidacionInformacion;
import ec.gob.sri.dimm.api.modelo.validacion.ValidacionIdentificacion;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import java.util.regex.Pattern;

public class InformacionNuevaParticipacion
extends ObjetoModelo
implements InformacionValidable {
    private static final long serialVersionUID = 2470894666693996457L;
    public static final String C_TIPO_IDENTIFICACION = "tipoIdentificacion";
    public static final String C_IDENTIFICACION = "identificacion";
    public static final String C_TIPO_SUJETO = "tipoSujeto";
    public static final String C_PRIMER_NOMBRE = "primerNombre";
    public static final String C_SEGUNDO_NOMBRE = "segundoNombre";
    public static final String C_PRIMER_APELLIDO = "primerApellido";
    public static final String C_SEGUNDO_APELLIDO = "segundoApellido";
    public static final String C_RAZON_SOCIAL = "razonSocial";
    private String tipoIdentificacion;
    private String descripcionTipoIdentificacion;
    private String identificacion;
    private String tipoSujeto;
    private String primerNombre;
    private String segundoNombre;
    private String primerApellido;
    private String segundoApellido;
    private String razonSocial;
    private String anio;
    private String mes;
    private Participacion participacion;
    private SujetoRelacionado sujetoExistente;
    private final SoporteValidacionInformacion soporteValidacion = new SoporteValidacionInformacion(){

        protected ResultadoValidacion validarInformacion() {
            ResultadoValidacion resultado = new ResultadoValidacion();
            if ((Integer.valueOf(InformacionNuevaParticipacion.this.anio) > 2023 && Integer.valueOf(InformacionNuevaParticipacion.this.mes) > 9 || Integer.valueOf(InformacionNuevaParticipacion.this.anio) == 2024 && Integer.valueOf(InformacionNuevaParticipacion.this.mes) == 0) && StringUtil.isNullOrEmpty((String)InformacionNuevaParticipacion.this.tipoSujeto)) {
                return resultado.fallarValidacion("Es necesario indicar el tipo de sujeto.");
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevaParticipacion.this.tipoIdentificacion)) {
                return resultado.fallarValidacion("Es necesario indicar el tipo de identificaci\u00f3n.");
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevaParticipacion.this.identificacion)) {
                return resultado.fallarValidacion("Debe ingresar el n\u00famero de identificaci\u00f3n del sujeto relacionado.");
            }
            if (!Pattern.matches("[a-zA-Z0-9]+", InformacionNuevaParticipacion.this.identificacion)) {
                return resultado.fallarValidacion("La identificaci\u00f3n del sujeto relacionado contiene espacios o caracteres no permitidos");
            }
            resultado = ValidacionIdentificacion.validarTodaIdentificacion((String)InformacionNuevaParticipacion.this.tipoIdentificacion, (String)InformacionNuevaParticipacion.this.identificacion, (ResultadoValidacion)resultado, (Integer)5, (Integer)20);
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
            if ((Integer.valueOf(InformacionNuevaParticipacion.this.anio) > 2023 && Integer.valueOf(InformacionNuevaParticipacion.this.mes) > 9 || Integer.valueOf(InformacionNuevaParticipacion.this.anio) == 2024 && Integer.valueOf(InformacionNuevaParticipacion.this.mes) == 0) && InformacionNuevaParticipacion.this.tipoSujeto.equals("01")) {
                if (StringUtil.isNullOrEmpty((String)InformacionNuevaParticipacion.this.primerNombre)) {
                    return resultado.fallarValidacion("Debe ingresar el primer nombre del sujeto relacionado.");
                }
                if (StringUtil.isNullOrEmpty((String)InformacionNuevaParticipacion.this.primerApellido)) {
                    return resultado.fallarValidacion("Debe ingresar el primer apellido del sujeto relacionado.");
                }
            }
            if (Integer.valueOf(InformacionNuevaParticipacion.this.anio) > 2023 && Integer.valueOf(InformacionNuevaParticipacion.this.mes) > 9 || Integer.valueOf(InformacionNuevaParticipacion.this.anio) == 2024 && Integer.valueOf(InformacionNuevaParticipacion.this.mes) == 0 ? InformacionNuevaParticipacion.this.tipoSujeto.equals("02") && StringUtil.isNullOrEmpty((String)InformacionNuevaParticipacion.this.razonSocial) : StringUtil.isNullOrEmpty((String)InformacionNuevaParticipacion.this.razonSocial)) {
                return resultado.fallarValidacion("Debe ingresar la raz\u00f3n social del sujeto relacionado.");
            }
            return resultado.pasarValidacion();
        }
    };

    public InformacionNuevaParticipacion(String anio, String mes) {
        this.participacion = new Participacion();
        this.participacion.setPropietario(this);
        this.anio = anio;
        this.mes = mes;
    }

    public String getTipoSujeto() {
        return this.tipoSujeto;
    }

    public void setTipoSujeto(String tipoSujeto) {
        String oldValue = this.tipoSujeto;
        this.tipoSujeto = tipoSujeto;
        this.firePropertyChange(C_TIPO_SUJETO, oldValue, this.tipoSujeto);
    }

    public String getPrimerNombre() {
        return this.primerNombre;
    }

    public void setPrimerNombre(String primerNombre) {
        String oldValue = this.primerNombre;
        this.primerNombre = primerNombre;
        this.firePropertyChange(C_PRIMER_NOMBRE, oldValue, this.primerNombre);
    }

    public String getSegundoNombre() {
        return this.segundoNombre;
    }

    public void setSegundoNombre(String segundoNombre) {
        String oldValue = this.segundoNombre;
        this.segundoNombre = segundoNombre;
        this.firePropertyChange(C_SEGUNDO_NOMBRE, oldValue, this.segundoNombre);
    }

    public String getPrimerApellido() {
        return this.primerApellido;
    }

    public void setPrimerApellido(String primerApellido) {
        String oldValue = this.primerApellido;
        this.primerApellido = primerApellido;
        this.firePropertyChange(C_PRIMER_APELLIDO, oldValue, this.primerApellido);
    }

    public String getSegundoApellido() {
        return this.segundoApellido;
    }

    public void setSegundoApellido(String segundoApellido) {
        String oldValue = this.segundoApellido;
        this.segundoApellido = segundoApellido;
        this.firePropertyChange(C_SEGUNDO_APELLIDO, oldValue, this.segundoApellido);
    }

    public String getRazonSocial() {
        return this.razonSocial;
    }

    public void setRazonSocial(String razonSocial) {
        String oldValue = this.razonSocial;
        this.razonSocial = razonSocial;
        this.firePropertyChange(C_RAZON_SOCIAL, oldValue, this.razonSocial);
    }

    public String getIdentificacion() {
        return this.identificacion;
    }

    public void setIdentificacion(String identificacion) {
        String oldIdentificacion = this.identificacion;
        this.identificacion = identificacion;
        this.firePropertyChange(C_IDENTIFICACION, oldIdentificacion, this.identificacion);
    }

    public String getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    public void setTipoIdentificacion(String tipoIdentificacion) {
        String oldTipoIdentificacion = this.tipoIdentificacion;
        this.tipoIdentificacion = tipoIdentificacion;
        this.firePropertyChange(C_TIPO_IDENTIFICACION, oldTipoIdentificacion, this.tipoIdentificacion);
    }

    public String getDescripcionTipoIdentificacion() {
        return this.descripcionTipoIdentificacion;
    }

    public void setDescripcionTipoIdentificacion(String descripcionTipoIdentificacion) {
        this.descripcionTipoIdentificacion = descripcionTipoIdentificacion;
    }

    public Participacion getParticipacion() {
        return this.participacion;
    }

    public void setParticipacion(Participacion participacion) {
        this.participacion = participacion;
    }

    public SujetoRelacionado getSujetoExistente() {
        return this.sujetoExistente;
    }

    public void setSujetoExistente(SujetoRelacionado sujetoExistente) {
        this.sujetoExistente = sujetoExistente;
    }

    public ResultadoValidacion validar() {
        return this.soporteValidacion.validar();
    }

    public void setListenerValidacion(ListenerValidacionInformacion listenerValidacion) {
        this.soporteValidacion.setListenerValidacion(listenerValidacion);
    }
}

