/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj.asistente;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.ArchivoTemporalAnexo;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionInformacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.SoporteValidacionInformacion;
import ec.gob.sri.dimm.aps.modelo.obj.Informante;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.DatosInformante;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.ModoCreacionAnexo;
import ec.gov.sri.dimm.principal.persistencia.Contribuyente;
import java.util.regex.Pattern;

public class InformacionNuevoAnexo
extends ObjetoModelo
implements InformacionValidable {
    private static final long serialVersionUID = -6629251036602183665L;
    public static final String CO_CONTRIBUYENTE = "contribuyente";
    private ModoCreacionAnexo modoCreacionAnexo = ModoCreacionAnexo.NINGUNO;
    private Contribuyente contribuyente;
    private DatosInformante datosInformante;
    private ArchivoTemporalAnexo versionBase;
    private Informante modeloDatosBase;
    private SoporteValidacionInformacion soporteValidacion = new SoporteValidacionInformacion(){

        protected ResultadoValidacion validarInformacion() {
            ResultadoValidacion resultado = new ResultadoValidacion();
            if (!Pattern.matches("[a-zA-Z0-9][a-zA-Z0-9\\s]{4,499}", InformacionNuevoAnexo.this.contribuyente.getRazonSocial())) {
                return resultado.fallarValidacion("La raz\u00f3n social del contribuyente debe contener \u00fanicamente letras y debe tener una longitud de entre 5 y 500 caracteres.");
            }
            return resultado.pasarValidacion();
        }
    };

    public InformacionNuevoAnexo() {
        this.datosInformante = new DatosInformante();
    }

    public ModoCreacionAnexo getModoCreacionAnexo() {
        return this.modoCreacionAnexo;
    }

    public void setModoCreacionAnexo(ModoCreacionAnexo modoCreacionAnexo) {
        this.modoCreacionAnexo = modoCreacionAnexo;
    }

    public Contribuyente getContribuyente() {
        return this.contribuyente;
    }

    public void setContribuyente(Contribuyente contribuyente) {
        Contribuyente oldValue = this.contribuyente;
        this.contribuyente = contribuyente;
        this.firePropertyChange(CO_CONTRIBUYENTE, oldValue, this.contribuyente);
    }

    public DatosInformante getDatosInformante() {
        return this.datosInformante;
    }

    public ArchivoTemporalAnexo getVersionBase() {
        return this.versionBase;
    }

    public void setVersionBase(ArchivoTemporalAnexo versionBase) {
        this.versionBase = versionBase;
    }

    public Informante getModeloDatosBase() {
        return this.modeloDatosBase;
    }

    public void setModeloDatosBase(Informante modeloDatosBase) {
        this.modeloDatosBase = modeloDatosBase;
    }

    public ResultadoValidacion validar() {
        return this.soporteValidacion.validar();
    }

    public void setListenerValidacion(ListenerValidacionInformacion listenerValidacion) {
        this.soporteValidacion.setListenerValidacion(listenerValidacion);
    }
}

