/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj.asistente;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionInformacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.SoporteValidacionInformacion;
import ec.gob.sri.dimm.api.modelo.validacion.ValidacionIdentificacion;
import ec.gob.sri.dimm.aps.modelo.obj.Constantes;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.UbicacionBeneficiarioFinal;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class InformacionNuevoBeneficiarioFinal
extends ObjetoModelo
implements InformacionValidable {
    private static final long serialVersionUID = 2470894666693996457L;
    public static final String C_TIPO_IDENTIFICACION = "tipoIdentificacion";
    public static final String C_NUMERO_IDENTIFICACION = "numeroIdentificacion";
    public static final String C_PRIMER_NOMBRE = "primerNombre";
    public static final String C_SEGUNDO_NOMBRE = "segundoNombre";
    public static final String C_PRIMER_APELLIDO = "primerApellido";
    public static final String C_SEGUNDO_APELLIDO = "segundoApellido";
    public static final String C_FECHA_NACIMIENTO = "fechaNacimiento";
    public static final String C_POR_PROPIEDAD = "porPropiedad";
    public static final String C_PORCENTAJE_PROPIEDAD = "porcentajePropiedad";
    public static final String C_POR_OTROS_MOTIVOS = "porOtrosMotivos";
    public static final String C_POR_OTROS_RELACIONADOS = "porOtrosRelacionados";
    public static final String C_POR_ADMINISTRACION = "porAdministracion";
    private String tipoIdentificacion;
    private String numeroIdentificacion;
    private String primerNombre;
    private String segundoNombre;
    private String primerApellido;
    private String segundoApellido;
    private String fechaNacimiento;
    private String porPropiedad;
    private String porcentajePropiedad;
    private String porOtrosMotivos;
    private String porOtrosRelacionados;
    private String porAdministracion;
    private UbicacionBeneficiarioFinal ubicacionBeneficiarioFinal;
    private Participacion participacion;
    private SujetoRelacionado sujetoExistente;
    private final SoporteValidacionInformacion soporteValidacion = new SoporteValidacionInformacion(){

        protected ResultadoValidacion validarInformacion() {
            ResultadoValidacion resultado = new ResultadoValidacion();
            if (StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.tipoIdentificacion)) {
                return resultado.fallarValidacion("Es necesario indicar el tipo de identificaci\u00f3n del Beneficiario Final.");
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.numeroIdentificacion)) {
                return resultado.fallarValidacion("Debe ingresar la identificaci\u00f3n de Residencia Fiscal del Beneficiario Final.");
            }
            if (!Pattern.matches("[a-zA-Z0-9]+", InformacionNuevoBeneficiarioFinal.this.numeroIdentificacion)) {
                return resultado.fallarValidacion("La identificaci\u00f3n de Residencia Fiscal del Beneficiario Final contiene espacios o caracteres no permitidos");
            }
            resultado = ValidacionIdentificacion.validarTodaIdentificacion((String)InformacionNuevoBeneficiarioFinal.this.tipoIdentificacion, (String)InformacionNuevoBeneficiarioFinal.this.numeroIdentificacion, (ResultadoValidacion)resultado, (Integer)5, (Integer)20);
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.primerNombre)) {
                return resultado.fallarValidacion("Debe ingresar el primer nombre del Beneficiario Final.");
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.segundoNombre)) {
                return resultado.fallarValidacion("Debe ingresar el segundo nombre del Beneficiario Final.");
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.primerApellido)) {
                return resultado.fallarValidacion("Debe ingresar el primer apellido del Beneficiario Final.");
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.segundoApellido)) {
                return resultado.fallarValidacion("Debe ingresar el segundo apellido del Beneficiario Final.");
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.fechaNacimiento)) {
                return resultado.fallarValidacion("Debe ingresar la fecha de nacimiento del Beneficiario Final.");
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.porPropiedad)) {
                return resultado.fallarValidacion("Debe seleccionar el campo Beneficiario Final por Propiedad.");
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.porcentajePropiedad)) {
                return resultado.fallarValidacion("Debe ingresar el Porcentaje de Participaci\u00f3n Efectiva de Propiedad.");
            }
            if (!Pattern.matches("[0-9]{1,3}\\.[0-9]{1,6}|\\d{1,3}", InformacionNuevoBeneficiarioFinal.this.porcentajePropiedad)) {
                return resultado.fallarValidacion("El valor ingresado como Porcentaje de Participaci\u00f3n Efectiva de Propiedad no es correcto.");
            }
            BigDecimal porcentaje = new BigDecimal(InformacionNuevoBeneficiarioFinal.this.porcentajePropiedad);
            if (porcentaje.compareTo(BigDecimal.ZERO) < 0 || porcentaje.compareTo(Constantes.CIEN) > 0) {
                return resultado.fallarValidacion("El Porcentaje de Participaci\u00f3n Efectiva de Propiedad no puede ser menor que 0 ni mayor a 100.");
            }
            if (StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.porOtrosMotivos)) {
                return resultado.fallarValidacion("Debe seleccionar el campo Beneficiario Final por otros motivos de control.");
            }
            if ("08".equals(InformacionNuevoBeneficiarioFinal.this.porOtrosMotivos) && StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.porOtrosRelacionados)) {
                return resultado.fallarValidacion("Debe ingresar en el campo Otros relacionados al control de la entidad.");
            }
            if ("02".equals(InformacionNuevoBeneficiarioFinal.this.porPropiedad) && "09".equals(InformacionNuevoBeneficiarioFinal.this.porOtrosMotivos) && StringUtil.isNullOrEmpty((String)InformacionNuevoBeneficiarioFinal.this.porAdministracion)) {
                return resultado.fallarValidacion("Debe seleccionar el campo Beneficiario Final por Administraci\u00f3n.");
            }
            return resultado.pasarValidacion();
        }
    };

    public InformacionNuevoBeneficiarioFinal() {
        this.ubicacionBeneficiarioFinal = new UbicacionBeneficiarioFinal();
    }

    public String getNumeroIdentificacion() {
        return this.numeroIdentificacion;
    }

    public void setNumeroIdentificacion(String numeroIdentificacion) {
        String oldNumeroIdentificacion = this.numeroIdentificacion;
        this.numeroIdentificacion = numeroIdentificacion;
        this.firePropertyChange(C_NUMERO_IDENTIFICACION, oldNumeroIdentificacion, this.numeroIdentificacion);
    }

    public String getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    public void setTipoIdentificacion(String tipoIdentificacion) {
        String oldTipoIdentificacion = this.tipoIdentificacion;
        this.tipoIdentificacion = tipoIdentificacion;
        this.firePropertyChange(C_TIPO_IDENTIFICACION, oldTipoIdentificacion, this.tipoIdentificacion);
    }

    public String getPrimerNombre() {
        return this.primerNombre;
    }

    public void setPrimerNombre(String primerNombre) {
        String oldValue = this.primerNombre;
        this.primerNombre = primerNombre;
        this.firePropertyChange(C_PRIMER_NOMBRE, oldValue, this.primerNombre);
    }

    public String getSegundoNombre() {
        return this.segundoNombre;
    }

    public void setSegundoNombre(String segundoNombre) {
        String oldValue = this.segundoNombre;
        this.segundoNombre = segundoNombre;
        this.firePropertyChange(C_SEGUNDO_NOMBRE, oldValue, this.segundoNombre);
    }

    public String getPrimerApellido() {
        return this.primerApellido;
    }

    public void setPrimerApellido(String primerApellido) {
        String oldValue = this.primerApellido;
        this.primerApellido = primerApellido;
        this.firePropertyChange(C_PRIMER_APELLIDO, oldValue, this.primerApellido);
    }

    public String getSegundoApellido() {
        return this.segundoApellido;
    }

    public void setSegundoApellido(String segundoApellido) {
        String oldValue = this.segundoApellido;
        this.segundoApellido = segundoApellido;
        this.firePropertyChange(C_SEGUNDO_APELLIDO, oldValue, this.segundoApellido);
    }

    public String getFechaNacimiento() {
        return this.fechaNacimiento;
    }

    public void setFechaNacimiento(String fechaNacimiento) {
        String oldValue = this.fechaNacimiento;
        this.fechaNacimiento = fechaNacimiento;
        this.firePropertyChange(C_FECHA_NACIMIENTO, oldValue, this.fechaNacimiento);
    }

    public String getPorPropiedad() {
        return this.porPropiedad;
    }

    public void setPorPropiedad(String porPropiedad) {
        String oldValue = this.porPropiedad;
        this.porPropiedad = porPropiedad;
        this.firePropertyChange(C_POR_PROPIEDAD, oldValue, this.porPropiedad);
    }

    public String getPorcentajePropiedad() {
        return this.porcentajePropiedad;
    }

    public void setPorcentajePropiedad(String porcentajePropiedad) {
        String oldValue = this.porcentajePropiedad;
        this.porcentajePropiedad = porcentajePropiedad;
        this.firePropertyChange(C_PORCENTAJE_PROPIEDAD, oldValue, this.porcentajePropiedad);
    }

    public String getPorOtrosMotivos() {
        return this.porOtrosMotivos;
    }

    public void setPorOtrosMotivos(String porOtrosMotivos) {
        String oldValue = this.porOtrosMotivos;
        this.porOtrosMotivos = porOtrosMotivos;
        this.firePropertyChange(C_POR_OTROS_MOTIVOS, oldValue, this.porOtrosMotivos);
    }

    public String getPorOtrosRelacionados() {
        return this.porOtrosRelacionados;
    }

    public void setPorOtrosRelacionados(String porOtrosRelacionados) {
        String oldValue = this.porOtrosRelacionados;
        this.porOtrosRelacionados = porOtrosRelacionados;
        this.firePropertyChange(C_POR_OTROS_RELACIONADOS, oldValue, this.porOtrosRelacionados);
    }

    public String getPorAdministracion() {
        return this.porAdministracion;
    }

    public void setPorAdministracion(String porAdministracion) {
        String oldValue = this.porAdministracion;
        this.porAdministracion = porAdministracion;
        this.firePropertyChange(C_POR_ADMINISTRACION, oldValue, this.porAdministracion);
    }

    public UbicacionBeneficiarioFinal getUbicacionBeneficiarioFinal() {
        return this.ubicacionBeneficiarioFinal;
    }

    public void setUbicacionBeneficiarioFinal(UbicacionBeneficiarioFinal ubicacionBeneficiarioFinal) {
        this.ubicacionBeneficiarioFinal = ubicacionBeneficiarioFinal;
    }

    public SujetoRelacionado getSujetoExistente() {
        return this.sujetoExistente;
    }

    public void setSujetoExistente(SujetoRelacionado sujetoExistente) {
        this.sujetoExistente = sujetoExistente;
    }

    public Participacion getParticipacion() {
        return this.participacion;
    }

    public void setParticipacion(Participacion participacion) {
        this.participacion = participacion;
    }

    public ResultadoValidacion validar() {
        return this.soporteValidacion.validar();
    }

    public void setListenerValidacion(ListenerValidacionInformacion listenerValidacion) {
        this.soporteValidacion.setListenerValidacion(listenerValidacion);
    }
}

