/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj.asistente.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombre;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.MnemonicosCatalogos;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloValoresDatosInformante
implements ModeloValores {
    private boolean inicializado;
    private DataCatalogos dc = new DataCatalogos();
    private final Map<String, ElementoNombre> anios = new LinkedHashMap<String, ElementoNombre>();
    private final Map<String, ElementoNombreValor<String>> meses = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposSociedad = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tipoDeclaracion = new LinkedHashMap<String, ElementoNombreValor<String>>();

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTodosAnios();
            this.cargarMeses();
            this.cargarTiposSociedad();
            this.cargarTipoDeclaracion();
            this.inicializado = true;
        }
    }

    public void obtenerMeses() {
        this.cargarMeses();
    }

    public void obtenerAnioAnticipado(boolean isAnticipada) {
        if (isAnticipada) {
            this.cargarAnios(true);
        } else {
            this.cargarAnios();
            this.cargarMeses();
            this.cargarTiposSociedad();
        }
    }

    public void obtenerAnios(Integer periodicidad) {
        switch (periodicidad) {
            case 0: {
                this.cargarAnios();
                this.inicializarMeses();
                break;
            }
            case 1: {
                this.cargarTodosAnios();
                this.cargarMeses();
                break;
            }
            case 2: {
                this.cargarAnios(true);
                this.inicializarMeses();
            }
        }
    }

    public void inicializarAnios() {
        this.anios.clear();
    }

    public void inicializarMeses() {
        this.meses.clear();
    }

    public List<ElementoNombre> getAnios() {
        return new ArrayList<ElementoNombre>(this.anios.values());
    }

    public List<ElementoNombreValor<String>> getMeses() {
        return new ArrayList<ElementoNombreValor<String>>(this.meses.values());
    }

    public List<ElementoNombreValor<String>> getTiposSociedad() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposSociedad.values());
    }

    public List<ElementoNombreValor<String>> getTipoDeclaracion() {
        return new ArrayList<ElementoNombreValor<String>>(this.tipoDeclaracion.values());
    }

    private void cargarTodosAnios() {
        this.anios.clear();
        int anioActual = GregorianCalendar.getInstance().get(1);
        int i = 2012;
        while (i <= anioActual) {
            String anio = String.valueOf(i);
            this.anios.put(anio, new ElementoNombre(anio));
            ++i;
        }
    }

    private void cargarAnios() {
        this.anios.clear();
        int anioActual = GregorianCalendar.getInstance().get(1);
        int i = 2012;
        while (i <= anioActual - 1) {
            String anio = String.valueOf(i);
            this.anios.put(anio, new ElementoNombre(anio));
            ++i;
        }
    }

    private void cargarAnios(boolean anticipada) {
        this.anios.clear();
        String anioActual = String.valueOf(GregorianCalendar.getInstance().get(1));
        this.anios.put(anioActual, new ElementoNombre(anioActual));
    }

    private void cargarMeses() {
        this.meses.clear();
        this.meses.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("Enero", (Object)"01"));
        this.meses.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("Febrero", (Object)"02"));
        this.meses.put("03", (ElementoNombreValor<String>)new ElementoNombreValor("Marzo", (Object)"03"));
        this.meses.put("04", (ElementoNombreValor<String>)new ElementoNombreValor("Abril", (Object)"04"));
        this.meses.put("05", (ElementoNombreValor<String>)new ElementoNombreValor("Mayo", (Object)"05"));
        this.meses.put("06", (ElementoNombreValor<String>)new ElementoNombreValor("Junio", (Object)"06"));
        this.meses.put("07", (ElementoNombreValor<String>)new ElementoNombreValor("Julio", (Object)"07"));
        this.meses.put("08", (ElementoNombreValor<String>)new ElementoNombreValor("Agosto", (Object)"08"));
        this.meses.put("09", (ElementoNombreValor<String>)new ElementoNombreValor("Septiembre", (Object)"09"));
        this.meses.put("10", (ElementoNombreValor<String>)new ElementoNombreValor("Octubre", (Object)"10"));
        this.meses.put("11", (ElementoNombreValor<String>)new ElementoNombreValor("Noviembre", (Object)"11"));
        this.meses.put("12", (ElementoNombreValor<String>)new ElementoNombreValor("Diciembre", (Object)"12"));
    }

    private void cargarTipoDeclaracion() {
        this.tipoDeclaracion.clear();
        this.tipoDeclaracion.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("COMPOSICION SOCIETARIA", (Object)"01"));
        this.tipoDeclaracion.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("BENEFICIARIO FINAL", (Object)"02"));
    }

    public ElementoNombre obtenerAnio(String codigoAnio) {
        return StringUtil.isNullOrEmpty((String)codigoAnio) ? null : this.anios.get(codigoAnio);
    }

    public ElementoNombreValor<String> obtenerMes(String codigoMes) {
        return StringUtil.isNullOrEmpty((String)codigoMes) ? null : this.meses.get(codigoMes);
    }

    public ElementoNombreValor<String> obtenerTipoSociedad(String tipoSociedad) {
        return StringUtil.isNullOrEmpty((String)tipoSociedad) ? null : this.tiposSociedad.get(tipoSociedad);
    }

    public ElementoNombreValor<String> obtenerTipoDeclaracion(String codigoTipoDeclaracion) {
        return StringUtil.isNullOrEmpty((String)codigoTipoDeclaracion) ? null : this.tipoDeclaracion.get(codigoTipoDeclaracion);
    }

    private void cargarTiposSociedad() {
        this.tiposSociedad.clear();
        Map cTiposSociedad = this.dc.obtenerValoresCatalogos(MnemonicosCatalogos.TIPO_SOCIEDAD.getMnemonico());
        for (Map.Entry tipoSociedad : cTiposSociedad.entrySet()) {
            this.tiposSociedad.put((String)tipoSociedad.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)tipoSociedad.getValue(), (Object)((String)tipoSociedad.getKey())));
        }
    }

    public void cargarTipoSociedadPorTipoDeclaracion(String codigoTipoDeclaracion, String anio, String mes) {
        this.tiposSociedad.clear();
        if (codigoTipoDeclaracion != null) {
            Map cTiposSociedad = this.dc.TipoSociedadPorTipoDeclaracion(MnemonicosCatalogos.TIPO_SOCIEDAD.getMnemonico(), codigoTipoDeclaracion);
            for (Map.Entry tipoSociedad : cTiposSociedad.entrySet()) {
                this.tiposSociedad.put((String)tipoSociedad.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)tipoSociedad.getValue(), (Object)((String)tipoSociedad.getKey())));
            }
        } else {
            this.tiposSociedad.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("SOCIEDADES EN GENERAL", (Object)"01"));
            this.tiposSociedad.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("SOCIEDADES QUE COTIZAN SUS ACCIONES EN BOLSAS DE VALORES", (Object)"02"));
            this.tiposSociedad.put("03", (ElementoNombreValor<String>)new ElementoNombreValor("FIDEICOMISOS", (Object)"03"));
            this.tiposSociedad.put("04", (ElementoNombreValor<String>)new ElementoNombreValor("INSTITUCIONES SIN FINES DE LUCRO", (Object)"04"));
            this.tiposSociedad.put("05", (ElementoNombreValor<String>)new ElementoNombreValor("SECTOR ECONOMICO POPULAR Y SOLIDARIO", (Object)"05"));
            this.tiposSociedad.put("06", (ElementoNombreValor<String>)new ElementoNombreValor("SECTOR FINANCIERO POPULAR Y SOLIDARIO", (Object)"06"));
            this.tiposSociedad.put("07", (ElementoNombreValor<String>)new ElementoNombreValor("FONDOS DE INVERSION", (Object)"07"));
        }
    }
}

