/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj.asistente.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloValoresParticipacionBeneficiarioFinal
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> tiposIdentificacion;
    private final Map<String, ElementoNombreValor<String>> tiposBeneficiarioFinalPorPropiedad = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposBeneficiarioFinalPorControl = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposBeneficiarioFinalPorAdministracion = new LinkedHashMap<String, ElementoNombreValor<String>>();

    public ModeloValoresParticipacionBeneficiarioFinal() {
        this.tiposIdentificacion = new LinkedHashMap<String, ElementoNombreValor<String>>();
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposIdentificacion();
            this.cargarTiposBeneficiarioFinalPorPropiedad();
            this.cargarTiposBeneficiarioFinalPorControl();
            this.cargarTiposBeneficiarioFinalPorAdministracion();
            this.inicializado = true;
        }
    }

    public List<ElementoNombreValor<String>> getTiposBeneficiarioFinalPorPropiedad() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposBeneficiarioFinalPorPropiedad.values());
    }

    private void cargarTiposBeneficiarioFinalPorPropiedad() {
        this.tiposBeneficiarioFinalPorPropiedad.clear();
        this.tiposBeneficiarioFinalPorPropiedad.put("SI", (ElementoNombreValor<String>)new ElementoNombreValor("SI", (Object)"SI"));
        this.tiposBeneficiarioFinalPorPropiedad.put("NO", (ElementoNombreValor<String>)new ElementoNombreValor("NO", (Object)"NO"));
    }

    public List<ElementoNombreValor<String>> getTiposBeneficiarioFinalPorControl() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposBeneficiarioFinalPorControl.values());
    }

    private void cargarTiposBeneficiarioFinalPorControl() {
        this.tiposBeneficiarioFinalPorControl.clear();
        this.tiposBeneficiarioFinalPorControl.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("DERECHO A VOTO", (Object)"01"));
        this.tiposBeneficiarioFinalPorControl.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("PODER PARA CAMBIAR MIEMBROS DE LA ENTIDAD", (Object)"02"));
        this.tiposBeneficiarioFinalPorControl.put("03", (ElementoNombreValor<String>)new ElementoNombreValor("PODER DE INFLUENCIA O VETO DE DECICSIONES", (Object)"03"));
        this.tiposBeneficiarioFinalPorControl.put("04", (ElementoNombreValor<String>)new ElementoNombreValor("APODERADO", (Object)"04"));
        this.tiposBeneficiarioFinalPorControl.put("05", (ElementoNombreValor<String>)new ElementoNombreValor("RESPONSABLE DE TITULOS DE DEUDA DE LA ENTIDAD", (Object)"05"));
        this.tiposBeneficiarioFinalPorControl.put("06", (ElementoNombreValor<String>)new ElementoNombreValor("PODER DE DECISION EN LOS ACUERDOS FINANCIEROS", (Object)"06"));
        this.tiposBeneficiarioFinalPorControl.put("07", (ElementoNombreValor<String>)new ElementoNombreValor("OPERATIVOS Y/O COMERCIALES QUE SE ADOPTEN", (Object)"07"));
        this.tiposBeneficiarioFinalPorControl.put("08", (ElementoNombreValor<String>)new ElementoNombreValor("OTROS RELACIONADO A CONTROL DE LA ENTIDAD", (Object)"08"));
        this.tiposBeneficiarioFinalPorControl.put("09", (ElementoNombreValor<String>)new ElementoNombreValor("NO APLICA", (Object)"09"));
    }

    public List<ElementoNombreValor<String>> getTiposBeneficiarioFinalPorAdministracion() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposBeneficiarioFinalPorAdministracion.values());
    }

    private void cargarTiposBeneficiarioFinalPorAdministracion() {
        this.tiposBeneficiarioFinalPorAdministracion.clear();
        this.tiposBeneficiarioFinalPorAdministracion.put("SI", (ElementoNombreValor<String>)new ElementoNombreValor("SI", (Object)"SI"));
        this.tiposBeneficiarioFinalPorAdministracion.put("NO", (ElementoNombreValor<String>)new ElementoNombreValor("NO", (Object)"NO"));
    }

    public List<ElementoNombreValor<String>> getTiposIdentificacion() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposIdentificacion.values());
    }

    private void cargarTiposIdentificacion() {
        this.tiposIdentificacion.clear();
        this.tiposIdentificacion.put("C", (ElementoNombreValor<String>)new ElementoNombreValor("CEDULA", (Object)"C"));
        this.tiposIdentificacion.put("P", (ElementoNombreValor<String>)new ElementoNombreValor("PASAPORTE", (Object)"P"));
        this.tiposIdentificacion.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
        this.tiposIdentificacion.put("E", (ElementoNombreValor<String>)new ElementoNombreValor("IDENTIFICACION DEL EXTERIOR", (Object)"E"));
    }

    public ElementoNombreValor<String> obtenerTipoBeneficiarioFinalPorPropiedad(String tipoBeneficiarioFinalPorPropiedad) {
        return StringUtil.isNullOrEmpty((String)tipoBeneficiarioFinalPorPropiedad) ? null : this.tiposBeneficiarioFinalPorPropiedad.get(tipoBeneficiarioFinalPorPropiedad);
    }

    public ElementoNombreValor<String> obtenerTipoBeneficiarioFinalPorControl(String tipoBeneficiarioFinalPorControl) {
        return StringUtil.isNullOrEmpty((String)tipoBeneficiarioFinalPorControl) ? null : this.tiposBeneficiarioFinalPorControl.get(tipoBeneficiarioFinalPorControl);
    }

    public ElementoNombreValor<String> obtenerTipoBeneficiarioFinalPorAdministracion(String tipoBeneficiarioFinalPorAdministracion) {
        return StringUtil.isNullOrEmpty((String)tipoBeneficiarioFinalPorAdministracion) ? null : this.tiposBeneficiarioFinalPorAdministracion.get(tipoBeneficiarioFinalPorAdministracion);
    }

    public ElementoNombreValor<String> obtenerTipoIdentificacionPorTipo(String tipoIdentificacion) {
        return StringUtil.isNullOrEmpty((String)tipoIdentificacion) ? null : this.tiposIdentificacion.get(tipoIdentificacion);
    }
}

