/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj.asistente.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.aps.modelo.util.UtilValidacion;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloValoresParticipacionIdentificacion
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> tiposIdentificacion = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposSujeto = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private String tipoDeclaracion;
    private String tipoSociedad;
    private String anio;
    private String mes;

    public ModeloValoresParticipacionIdentificacion(String tipoDeclaracion, String tipoSociedad, String anio, String mes) {
        this.tipoDeclaracion = tipoDeclaracion;
        this.tipoSociedad = tipoSociedad;
        this.anio = anio;
        this.mes = mes;
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposIdentificacion();
            this.cargarTipoSujeto();
            this.inicializado = true;
        }
    }

    public List<ElementoNombreValor<String>> getTiposSujeto() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposSujeto.values());
    }

    private void cargarTipoSujeto() {
        boolean esPeriodoDesde2024 = UtilValidacion.esAnexoDesdePeriodo2024(this.anio, this.mes);
        if (esPeriodoDesde2024) {
            this.tiposSujeto.clear();
            if (this.tipoDeclaracion.equals("02") && this.tipoSociedad.equals("10")) {
                this.tiposSujeto.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("PERSONA O ESTRUCTURA JURIDICA", (Object)"02"));
            } else {
                this.tiposSujeto.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("PERSONA NATURAL", (Object)"01"));
                this.tiposSujeto.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("PERSONA O ESTRUCTURA JURIDICA", (Object)"02"));
            }
        }
    }

    public List<ElementoNombreValor<String>> getTiposIdentificacion() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposIdentificacion.values());
    }

    private void cargarTiposIdentificacion() {
        this.tiposIdentificacion.clear();
        this.tiposIdentificacion.put("C", (ElementoNombreValor<String>)new ElementoNombreValor("CEDULA", (Object)"C"));
        this.tiposIdentificacion.put("P", (ElementoNombreValor<String>)new ElementoNombreValor("PASAPORTE", (Object)"P"));
        this.tiposIdentificacion.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
        this.tiposIdentificacion.put("E", (ElementoNombreValor<String>)new ElementoNombreValor("IDENTIFICACION DEL EXTERIOR", (Object)"E"));
    }

    public ElementoNombreValor<String> obtenerTipoIdentificacion(String tipoIdentificacion) {
        return StringUtil.isNullOrEmpty((String)tipoIdentificacion) ? null : this.tiposIdentificacion.get(tipoIdentificacion);
    }

    public ElementoNombreValor<String> obtenerTipoSujeto(String tipoSujeto) {
        return StringUtil.isNullOrEmpty((String)tipoSujeto) ? null : this.tiposSujeto.get(tipoSujeto);
    }

    public void cargarTipoIdentificacionPorTipoSujeto(String tipoSujeto) {
        this.tiposIdentificacion.clear();
        if (tipoSujeto.equals("01")) {
            this.tiposIdentificacion.put("C", (ElementoNombreValor<String>)new ElementoNombreValor("CEDULA", (Object)"C"));
            this.tiposIdentificacion.put("P", (ElementoNombreValor<String>)new ElementoNombreValor("PASAPORTE", (Object)"P"));
            this.tiposIdentificacion.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
            this.tiposIdentificacion.put("E", (ElementoNombreValor<String>)new ElementoNombreValor("IDENTIFICACION DEL EXTERIOR", (Object)"E"));
        }
        if (tipoSujeto.equals("02")) {
            if (this.tipoDeclaracion.equals("02") && this.tipoSociedad.equals("10")) {
                this.tiposIdentificacion.put("E", (ElementoNombreValor<String>)new ElementoNombreValor("IDENTIFICACION DEL EXTERIOR", (Object)"E"));
            } else {
                this.tiposIdentificacion.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
                this.tiposIdentificacion.put("E", (ElementoNombreValor<String>)new ElementoNombreValor("IDENTIFICACION DEL EXTERIOR", (Object)"E"));
            }
        }
    }
}

