/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj.asistente.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.MnemonicosCatalogos;
import ec.gob.sri.dimm.aps.modelo.util.UtilValidacion;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloValoresParticipacionInfo
implements ModeloValores {
    private boolean inicializado;
    private DataCatalogos dc;
    private Map<String, ElementoNombreValor<String>> tiposRelacion;
    private final Map<String, ElementoNombreValor<String>> beneficiarioFinal;
    private String tipoDeclaracion;
    private String tipoSociedadExtranjera;
    private String anio;
    private String mes;

    public ModeloValoresParticipacionInfo(String anio, String mes, String tipoDeclaracion, String tipoSociedadPadre) {
        this.tipoDeclaracion = tipoDeclaracion;
        this.tipoSociedadExtranjera = tipoSociedadPadre;
        this.anio = anio;
        this.mes = mes;
        this.dc = new DataCatalogos();
        this.tiposRelacion = new LinkedHashMap<String, ElementoNombreValor<String>>();
        this.beneficiarioFinal = new LinkedHashMap<String, ElementoNombreValor<String>>();
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposRelacion();
            this.cargarBeneficiarioFinal();
            this.inicializado = true;
        }
    }

    public List<ElementoNombreValor<String>> getBeneficiarioFinal() {
        return new ArrayList<ElementoNombreValor<String>>(this.beneficiarioFinal.values());
    }

    public List<ElementoNombreValor<String>> getTiposRelacion() {
        LinkedHashMap<String, ElementoNombreValor<String>> copiaTiposRelacion = new LinkedHashMap<String, ElementoNombreValor<String>>(this.tiposRelacion);
        if (StringUtil.isNullOrEmpty((String)this.tipoSociedadExtranjera)) {
            return new ArrayList<ElementoNombreValor<String>>(this.tiposRelacion.values());
        }
        boolean esPeriodoDesde2024 = UtilValidacion.esAnexoDesdePeriodo2024(this.anio, this.mes);
        if (esPeriodoDesde2024) {
            if ("02".equals(this.tipoDeclaracion) && "10".equals(this.tipoSociedadExtranjera)) {
                this.tiposRelacion.clear();
                this.tiposRelacion.put("12", (ElementoNombreValor<String>)new ElementoNombreValor("FIDUCIARIO", (Object)"12"));
            } else {
                int tipoSociedad = Integer.parseInt(this.tipoSociedadExtranjera);
                if (tipoSociedad < 3) {
                    copiaTiposRelacion.remove("01");
                    copiaTiposRelacion.remove("02");
                    copiaTiposRelacion.remove("03");
                    copiaTiposRelacion.remove("06");
                    copiaTiposRelacion.remove("07");
                    copiaTiposRelacion.remove("08");
                    copiaTiposRelacion.remove("12");
                    copiaTiposRelacion.remove("13");
                    copiaTiposRelacion.remove("14");
                } else if (tipoSociedad == 3 || tipoSociedad == 10) {
                    copiaTiposRelacion.remove("01");
                    copiaTiposRelacion.remove("02");
                    copiaTiposRelacion.remove("03");
                    copiaTiposRelacion.remove("05");
                    copiaTiposRelacion.remove("08");
                    copiaTiposRelacion.remove("09");
                    copiaTiposRelacion.remove("10");
                    copiaTiposRelacion.remove("11");
                } else if (tipoSociedad == 4) {
                    copiaTiposRelacion.remove("01");
                    copiaTiposRelacion.remove("02");
                    copiaTiposRelacion.remove("03");
                    copiaTiposRelacion.remove("06");
                    copiaTiposRelacion.remove("07");
                    copiaTiposRelacion.remove("12");
                    copiaTiposRelacion.remove("13");
                    copiaTiposRelacion.remove("14");
                } else if (tipoSociedad == 5 || tipoSociedad == 6) {
                    copiaTiposRelacion.remove("01");
                    copiaTiposRelacion.remove("02");
                    copiaTiposRelacion.remove("03");
                    copiaTiposRelacion.remove("06");
                    copiaTiposRelacion.remove("07");
                    copiaTiposRelacion.remove("08");
                    copiaTiposRelacion.remove("12");
                    copiaTiposRelacion.remove("13");
                    copiaTiposRelacion.remove("14");
                } else if (tipoSociedad == 7) {
                    copiaTiposRelacion.remove("01");
                    copiaTiposRelacion.remove("02");
                    copiaTiposRelacion.remove("03");
                    copiaTiposRelacion.remove("04");
                    copiaTiposRelacion.remove("06");
                    copiaTiposRelacion.remove("07");
                    copiaTiposRelacion.remove("08");
                    copiaTiposRelacion.remove("12");
                    copiaTiposRelacion.remove("13");
                    copiaTiposRelacion.remove("14");
                }
            }
        } else {
            int tipoSociedad = Integer.parseInt(this.tipoSociedadExtranjera);
            copiaTiposRelacion.remove("06");
            copiaTiposRelacion.remove("07");
            copiaTiposRelacion.put("06", (ElementoNombreValor<String>)new ElementoNombreValor("CONSTITUYENTE", (Object)"06"));
            copiaTiposRelacion.put("07", (ElementoNombreValor<String>)new ElementoNombreValor("BENEFICIARIO", (Object)"07"));
            if (tipoSociedad < 3) {
                copiaTiposRelacion.remove("06");
                copiaTiposRelacion.remove("07");
                copiaTiposRelacion.remove("08");
                copiaTiposRelacion.remove("10");
                copiaTiposRelacion.remove("11");
                copiaTiposRelacion.remove("12");
                copiaTiposRelacion.remove("13");
                copiaTiposRelacion.remove("14");
            } else if (tipoSociedad == 3) {
                copiaTiposRelacion.remove("01");
                copiaTiposRelacion.remove("02");
                copiaTiposRelacion.remove("08");
                copiaTiposRelacion.remove("10");
                copiaTiposRelacion.remove("11");
                copiaTiposRelacion.remove("12");
                copiaTiposRelacion.remove("13");
                copiaTiposRelacion.remove("14");
            } else if (tipoSociedad > 3 && tipoSociedad < 7) {
                copiaTiposRelacion.remove("01");
                copiaTiposRelacion.remove("02");
                copiaTiposRelacion.remove("06");
                copiaTiposRelacion.remove("07");
                copiaTiposRelacion.remove("10");
                copiaTiposRelacion.remove("11");
                copiaTiposRelacion.remove("12");
                copiaTiposRelacion.remove("13");
                copiaTiposRelacion.remove("14");
            } else {
                copiaTiposRelacion.remove("01");
                copiaTiposRelacion.remove("02");
                copiaTiposRelacion.remove("04");
                copiaTiposRelacion.remove("06");
                copiaTiposRelacion.remove("07");
                copiaTiposRelacion.remove("08");
                copiaTiposRelacion.remove("10");
                copiaTiposRelacion.remove("11");
                copiaTiposRelacion.remove("12");
                copiaTiposRelacion.remove("13");
                copiaTiposRelacion.remove("14");
            }
        }
        return new ArrayList<ElementoNombreValor<String>>(copiaTiposRelacion.values());
    }

    public void cargarEsBeneficiarioPorTipoSujeto(String tipoSujeto) {
        this.cargarBeneficiarioFinal();
        if ("03".equals(this.tipoSociedadExtranjera) && "01".equals(tipoSujeto)) {
            this.beneficiarioFinal.remove("NO");
            this.beneficiarioFinal.remove("NA");
        } else if (!"03".equals(this.tipoSociedadExtranjera) && "01".equals(tipoSujeto)) {
            this.beneficiarioFinal.remove("NA");
        } else {
            this.beneficiarioFinal.remove("SI");
            this.beneficiarioFinal.remove("NO");
        }
    }

    private void cargarBeneficiarioFinal() {
        this.beneficiarioFinal.clear();
        this.beneficiarioFinal.put("SI", (ElementoNombreValor<String>)new ElementoNombreValor("SI", (Object)"SI"));
        this.beneficiarioFinal.put("NO", (ElementoNombreValor<String>)new ElementoNombreValor("NO", (Object)"NO"));
        this.beneficiarioFinal.put("NA", (ElementoNombreValor<String>)new ElementoNombreValor("NO APLICA", (Object)"NA"));
    }

    private void cargarTiposRelacion() {
        this.tiposRelacion.clear();
        Map cTiposRelacion = this.dc.obtenerValoresCatalogos(MnemonicosCatalogos.TIPO_RELACIONADO_SOCIEDAD.getMnemonico());
        for (Map.Entry tipoRelacion : cTiposRelacion.entrySet()) {
            this.tiposRelacion.put((String)tipoRelacion.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)tipoRelacion.getValue(), (Object)((String)tipoRelacion.getKey())));
        }
    }

    public ElementoNombreValor<String> obtenerTipoRelacion(String tipoRelacion) {
        return StringUtil.isNullOrEmpty((String)tipoRelacion) ? null : this.tiposRelacion.get(tipoRelacion);
    }

    public ElementoNombreValor<String> obtenerEsBeneficiarioFinal(String esBeneficiario) {
        return StringUtil.isNullOrEmpty((String)esBeneficiario) ? null : this.beneficiarioFinal.get(esBeneficiario);
    }
}

