/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj.asistente.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.MnemonicosCatalogos;
import ec.gob.sri.dimm.aps.modelo.util.UtilValidacion;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloValoresParticipacionSujeto
implements ModeloValores {
    private boolean inicializado;
    private DataCatalogos dc = new DataCatalogos();
    private String tipoDeclaracion;
    private String tipoSociedad;
    private String anio;
    private String mes;
    private String tipoSujeto;
    private String tipoIdentificacion;
    private final Map<String, ElementoNombreValor<String>> tiposIdentificacion;
    private final Map<String, ElementoNombreValor<String>> tiposSujetoExtranjero;
    private final Map<String, ElementoNombreValor<String>> tiposRegimenFiscal;

    public ModeloValoresParticipacionSujeto(String tipoDeclaracion, String tipoSociedad, String anio, String mes, String tipoSujeto, String tipoIdentificacion) {
        this.tipoDeclaracion = tipoDeclaracion;
        this.tipoSociedad = tipoSociedad;
        this.anio = anio;
        this.mes = mes;
        this.tipoSujeto = tipoSujeto;
        this.tipoIdentificacion = tipoIdentificacion;
        this.tiposIdentificacion = new LinkedHashMap<String, ElementoNombreValor<String>>();
        this.tiposSujetoExtranjero = new LinkedHashMap<String, ElementoNombreValor<String>>();
        this.tiposRegimenFiscal = new LinkedHashMap<String, ElementoNombreValor<String>>();
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposIdentificacion();
            this.cargarTiposSujetoExtranjero();
            this.cargarTiposRegimenFiscal();
            this.inicializado = true;
        }
    }

    public List<ElementoNombreValor<String>> getTiposIdentificacion() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposIdentificacion.values());
    }

    public List<ElementoNombreValor<String>> getTiposSociedad() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposSujetoExtranjero.values());
    }

    public List<ElementoNombreValor<String>> getTiposRegimenFiscal() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposRegimenFiscal.values());
    }

    private void cargarTiposIdentificacion() {
        this.tiposIdentificacion.clear();
        this.tiposIdentificacion.put("C", (ElementoNombreValor<String>)new ElementoNombreValor("CEDULA", (Object)"C"));
        this.tiposIdentificacion.put("P", (ElementoNombreValor<String>)new ElementoNombreValor("PASAPORTE", (Object)"P"));
        this.tiposIdentificacion.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
        this.tiposIdentificacion.put("E", (ElementoNombreValor<String>)new ElementoNombreValor("IDENTIFICACION DEL EXTERIOR", (Object)"E"));
    }

    private void cargarTiposSujetoExtranjero() {
        this.tiposSujetoExtranjero.clear();
        Map cTiposSujetosExtranjeros = this.dc.obtenerValoresCatalogos(MnemonicosCatalogos.TIPO_SOCIEDAD_EXTRANJERA.getMnemonico());
        for (Map.Entry tipoSujetoExtranjero : cTiposSujetosExtranjeros.entrySet()) {
            this.tiposSujetoExtranjero.put((String)tipoSujetoExtranjero.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)tipoSujetoExtranjero.getValue(), (Object)((String)tipoSujetoExtranjero.getKey())));
        }
        if (UtilValidacion.esAnexoDesdePeriodo2024(this.anio, this.mes)) {
            this.tiposSujetoExtranjero.remove("03");
            if ("02".equals(this.tipoDeclaracion) && "10".equals(this.tipoSociedad)) {
                this.tiposSujetoExtranjero.clear();
                this.tiposSujetoExtranjero.put("NA", (ElementoNombreValor<String>)new ElementoNombreValor("NO APLICA", (Object)"NA"));
            }
        } else {
            this.tiposSujetoExtranjero.remove("10");
        }
        this.cargarTipoSociedadExtranjera();
    }

    private void cargarTipoSociedadExtranjera() {
        if ("02".equals(this.tipoSujeto) && "E".equals(this.tipoIdentificacion)) {
            this.tiposSujetoExtranjero.remove("00");
        }
        if ("01".equals(this.tipoSujeto) && "E".equals(this.tipoIdentificacion)) {
            this.tiposSujetoExtranjero.clear();
            this.tiposSujetoExtranjero.put("00", (ElementoNombreValor<String>)new ElementoNombreValor("PERSONA NATURAL", (Object)"00"));
        }
    }

    private void cargarTiposRegimenFiscal() {
        this.tiposRegimenFiscal.clear();
        this.tiposRegimenFiscal.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("REGIMEN GENERAL", (Object)"01"));
        this.tiposRegimenFiscal.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("PARAISO FISCAL", (Object)"02"));
        this.tiposRegimenFiscal.put("03", (ElementoNombreValor<String>)new ElementoNombreValor("REGIMEN FISCAL PREFERENTE O JURISDICCION DE MENOR IMPOSICION", (Object)"03"));
    }

    public ElementoNombreValor<String> obtenerTipoIdentificacion(String tipoIdentificacion) {
        return StringUtil.isNullOrEmpty((String)tipoIdentificacion) ? null : this.tiposIdentificacion.get(tipoIdentificacion);
    }

    public ElementoNombreValor<String> obtenerTipoSujeto(String tipoSociedadExtranjera) {
        return StringUtil.isNullOrEmpty((String)tipoSociedadExtranjera) ? null : this.tiposSujetoExtranjero.get(tipoSociedadExtranjera);
    }

    public ElementoNombreValor<String> obtenerTipoRegimenFiscal(String tipoRegimenFiscal) {
        return StringUtil.isNullOrEmpty((String)tipoRegimenFiscal) ? null : this.tiposRegimenFiscal.get(tipoRegimenFiscal);
    }
}

