/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.obj.asistente.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.aps.modelo.util.UtilValidacion;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class ModeloValoresParticipacionUbicacion
implements ModeloValores {
    private boolean inicializado;
    private DataCatalogos dc = new DataCatalogos();
    private String tipoDeclaracion;
    private String tipoSociedad;
    private String periodo;
    private String mes;
    private static Map<String, ElementoNombreValor<String>> figuraJuridica = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private static Map<String, ElementoNombreValor<String>> paises = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private static Map<String, ElementoNombreValor<String>> paisesSinParaisoFiscal = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private static Map<String, ElementoNombreValor<String>> paraisosFiscales = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private static Map<String, ElementoNombreValor<String>> paisesOpcionales = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private static Map<String, ElementoNombreValor<String>> provincias = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> cantones = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> parroquias = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private String provinciaActual = "";
    private String cantonActual = "";

    public ModeloValoresParticipacionUbicacion(String tipoDeclaracion, String tipoSociedad, String periodo, String mes) {
        this.tipoDeclaracion = tipoDeclaracion;
        this.tipoSociedad = tipoSociedad;
        this.periodo = periodo;
        this.mes = mes;
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarPaises();
            this.cargarPaisesOpcionales();
            this.cargarParaisosFiscales();
            this.cargarProvincias();
            this.inicializado = true;
        }
    }

    public void inicializar(String provincia, String canton) {
        if (!this.inicializado) {
            this.cargarCantones(provincia);
            this.cargarParroquias(canton);
        }
        this.inicializar();
    }

    public void inicializar(int periodo, String tipoIdentificacion) {
        if (!this.inicializado) {
            this.cargarPaisesSinParaisoFiscal(periodo, tipoIdentificacion);
        }
        this.inicializar();
    }

    public void obtenerPaisRelacionadoParaisoFiscal(String codigoParaiso) {
        if (codigoParaiso != null) {
            this.cargarPaisRelacionadoParaisoFiscal(codigoParaiso);
        }
    }

    public void obtenerFiguraJuridicaRelacionadaPais(String codigoPais) {
        if (codigoPais != null) {
            this.cargarFiguraJuridicaRelacionadaPais(codigoPais);
        }
    }

    private void cargarFiguraJuridicaRelacionadaPais(String codigoPais) {
        figuraJuridica.clear();
        if ("02".equals(this.tipoDeclaracion) && "10".equals(this.tipoSociedad)) {
            figuraJuridica.put("NA", (ElementoNombreValor<String>)new ElementoNombreValor("NO APLICA", (Object)"NA"));
        } else {
            TreeSet<ElementoNombreValor<String>> oFiguraJuridica = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
            try {
                Map cFiguraJuridica = this.dc.obtenerFiguraJuridcaPorCodigoPais(codigoPais);
                for (Map.Entry entry : cFiguraJuridica.entrySet()) {
                    oFiguraJuridica.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
                }
                for (ElementoNombreValor elementoNombreValor : oFiguraJuridica) {
                    figuraJuridica.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
                }
            }
            catch (SQLException sQLException) {
                figuraJuridica.clear();
            }
        }
    }

    public List<ElementoNombreValor<String>> getPaises() {
        return new ArrayList<ElementoNombreValor<String>>(paises.values());
    }

    public List<ElementoNombreValor<String>> getPaisesOpcionales() {
        return new ArrayList<ElementoNombreValor<String>>(paisesOpcionales.values());
    }

    public List<ElementoNombreValor<String>> getPaisesSinParaisoFiscal() {
        return new ArrayList<ElementoNombreValor<String>>(paisesSinParaisoFiscal.values());
    }

    public List<ElementoNombreValor<String>> getParaisosFiscales() {
        return new ArrayList<ElementoNombreValor<String>>(paraisosFiscales.values());
    }

    public List<ElementoNombreValor<String>> getProvincias() {
        return new ArrayList<ElementoNombreValor<String>>(provincias.values());
    }

    public List<ElementoNombreValor<String>> getCantones() {
        return new ArrayList<ElementoNombreValor<String>>(this.cantones.values());
    }

    public List<ElementoNombreValor<String>> getParroquias() {
        return new ArrayList<ElementoNombreValor<String>>(this.parroquias.values());
    }

    public List<ElementoNombreValor<String>> getFiguraJuridica() {
        return new ArrayList<ElementoNombreValor<String>>(figuraJuridica.values());
    }

    private void cargarPaises() {
        paises.clear();
        TreeSet<ElementoNombreValor<String>> oPaises = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        Map cPaises = this.dc.obtenerPaises();
        oPaises.add((ElementoNombreValor<String>)new ElementoNombreValor("", (Object)""));
        for (Map.Entry entry : cPaises.entrySet()) {
            oPaises.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oPaises) {
            paises.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
    }

    private void cargarPaisesOpcionales() {
        paisesOpcionales.clear();
        TreeSet<ElementoNombreValor<String>> oPaises = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        Map cPaises = this.dc.obtenerPaises();
        for (Map.Entry entry : cPaises.entrySet()) {
            oPaises.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oPaises) {
            paisesOpcionales.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
    }

    private void cargarPaisRelacionadoParaisoFiscal(String codigoParaiso) {
        paises.clear();
        TreeSet<ElementoNombreValor<String>> oPaises = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        try {
            Map cPaises = this.dc.obtenerPaisRelacionadoParaisoFiscal(codigoParaiso);
            for (Map.Entry entry : cPaises.entrySet()) {
                oPaises.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
            }
            for (ElementoNombreValor elementoNombreValor : oPaises) {
                paises.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
            }
        }
        catch (SQLException sQLException) {
            paises.clear();
        }
    }

    private void cargarPaisesSinParaisoFiscal(int anio, String tipoIdentificacion) {
        paisesSinParaisoFiscal.clear();
        TreeSet<ElementoNombreValor<String>> oPaises = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        Map cPaises = this.dc.obtenerPaisesSinParaisoFiscal();
        for (Map.Entry entry : cPaises.entrySet()) {
            oPaises.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oPaises) {
            System.out.println("DAVID_01 " + (String)elementoNombreValor.getValor());
            paisesSinParaisoFiscal.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
        if (anio >= 2022 && tipoIdentificacion.equals("E")) {
            paisesSinParaisoFiscal.remove("593");
        }
        this.removerPaisesAndorraPanama(paisesSinParaisoFiscal);
    }

    private void removerPaisesAndorraPanama(Map<String, ElementoNombreValor<String>> paisesSinParaiso) {
        LocalDate fechaVigenciaAndorra = new LocalDate(2025, 1, 1);
        LocalDate fechaVigenciaPanama = new LocalDate(2025, 1, 1);
        LocalDate fechaDeclaracion = UtilValidacion.obtenerFechaDeclaracion(this.periodo, this.mes).toLocalDate();
        if (fechaDeclaracion.isBefore((ReadablePartial)fechaVigenciaAndorra)) {
            paisesSinParaiso.remove("233");
        }
        if (fechaDeclaracion.isBefore((ReadablePartial)fechaVigenciaPanama)) {
            paisesSinParaiso.remove("118");
        }
    }

    private void cargarParaisosFiscales() {
        paraisosFiscales.clear();
        TreeSet<ElementoNombreValor<String>> oParaisosFiscales = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        Map cParaisosFiscales = new HashMap();
        cParaisosFiscales = this.periodo == null && this.mes == null ? this.dc.obtenerParaisosFiscales() : this.dc.obtenerParaisosFiscales(UtilValidacion.obtenerFechaDeclaracion(this.periodo, this.mes).toLocalDate());
        for (Map.Entry entry : cParaisosFiscales.entrySet()) {
            oParaisosFiscales.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oParaisosFiscales) {
            paraisosFiscales.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
    }

    private void cargarProvincias() {
        provincias.clear();
        TreeSet<ElementoNombreValor<String>> oProvincias = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        Map cProvincias = this.dc.obtenerProvincias();
        for (Map.Entry entry : cProvincias.entrySet()) {
            oProvincias.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oProvincias) {
            provincias.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
    }

    public void cargarCantones(String provincia) {
        if (this.provinciaActual.equals(provincia)) {
            return;
        }
        this.cantones.clear();
        TreeSet<ElementoNombreValor<String>> oCantones = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        Map cCantones = this.dc.obtenerCantonesPorProvincia(provincia);
        for (Map.Entry entry : cCantones.entrySet()) {
            oCantones.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oCantones) {
            this.cantones.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
        this.provinciaActual = provincia;
    }

    public void cargarParroquias(String canton) {
        if (this.cantonActual.equals(canton)) {
            return;
        }
        this.parroquias.clear();
        TreeSet<ElementoNombreValor<String>> oParroquias = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        Map cParroquias = this.dc.obtenerParroquiasPorCanton(canton);
        for (Map.Entry entry : cParroquias.entrySet()) {
            oParroquias.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oParroquias) {
            this.parroquias.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
        this.cantonActual = canton;
    }

    public ElementoNombreValor<String> obtenerPais(String pais) {
        return StringUtil.isNullOrEmpty((String)pais) ? null : paises.get(pais);
    }

    public ElementoNombreValor<String> obtenerPaisOpcionales(String pais) {
        return StringUtil.isNullOrEmpty((String)pais) ? null : paisesOpcionales.get(pais);
    }

    public ElementoNombreValor<String> obtenerParaisoFiscal(String paraiso) {
        return StringUtil.isNullOrEmpty((String)paraiso) ? null : paraisosFiscales.get(paraiso);
    }

    public ElementoNombreValor<String> obtenerPaisSinParaisoFiscal(String pais) {
        return StringUtil.isNullOrEmpty((String)pais) ? null : paisesSinParaisoFiscal.get(pais);
    }

    public ElementoNombreValor<String> obtenerProvincia(String provincia) {
        return StringUtil.isNullOrEmpty((String)provincia) ? null : provincias.get(provincia);
    }

    public ElementoNombreValor<String> obtenerCanton(String provincia, String canton) {
        if (StringUtil.isNullOrEmpty((String)provincia) || StringUtil.isNullOrEmpty((String)canton)) {
            return null;
        }
        ElementoNombreValor<String> eCanton = this.cantones.get(canton);
        if (eCanton == null) {
            this.cargarCantones(provincia);
            eCanton = this.cantones.get(canton);
        }
        return eCanton;
    }

    public ElementoNombreValor<String> obtenerParroquia(String canton, String parroquia) {
        if (StringUtil.isNullOrEmpty((String)canton) || StringUtil.isNullOrEmpty((String)parroquia)) {
            return null;
        }
        ElementoNombreValor<String> eParroquia = this.parroquias.get(parroquia);
        if (eParroquia == null) {
            this.cargarParroquias(canton);
            eParroquia = this.parroquias.get(parroquia);
        }
        return eParroquia;
    }

    public ElementoNombreValor<String> obtenerFiguraJuridica(String idFiguraJuridica) {
        return StringUtil.isNullOrEmpty((String)idFiguraJuridica) ? null : figuraJuridica.get(idFiguraJuridica);
    }

    private Comparator<ElementoNombreValor<String>> getComparadorElementoNombreValor() {
        return new Comparator<ElementoNombreValor<String>>(){

            @Override
            public int compare(ElementoNombreValor<String> e1, ElementoNombreValor<String> e2) {
                return e1.getEtiqueta().compareTo(e2.getEtiqueta());
            }
        };
    }
}

