/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.aps.modelo.talonresumen;

import ec.gob.sri.anexo.aps.persistencia.modelo.RigApsDataTalonResumen;
import ec.gob.sri.anexo.aps.persistencia.util.NemonicoCatalogoEnum;
import ec.gob.sri.anexo.aps.persistencia.util.TipoIdEnum;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.aps.modelo.obj.Beneficiario;
import ec.gob.sri.dimm.aps.modelo.obj.Informante;
import ec.gob.sri.dimm.aps.modelo.obj.Participacion;
import ec.gob.sri.dimm.aps.modelo.obj.SujetoRelacionado;
import ec.gob.sri.dimm.aps.modelo.obj.asistente.valores.ModeloValoresDatosInformante;
import ec.gob.sri.dimm.aps.modelo.talonresumen.PorcentajeConteo;
import ec.gob.sri.dimm.aps.modelo.util.UtilValidacion;
import ec.gob.sri.dimm.aps.modelo.util.UtilidadHash;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TalonResumenAPS {
    private static Properties propertiesTalonResumen;
    private static Properties propertiesBeneficiarioTalonResumen;
    private final StringBuilder talonResumen = new StringBuilder();
    private Set<String> elementosSumados;

    public File generarTalonResumen(Informante modelo) throws FileNotFoundException, IOException {
        this.elementosSumados = new TreeSet<String>();
        PluginLogger.logInfo((String)"generarTalonResumen::Se procedera a generar el Talon Resumen para el Reporte REBEFICS!!", (String)"ec.gob.sri.dimm.aps.modelo");
        this.cargarPropiedades("/resources/APS_talonResumen.properties");
        this.cargarPropiedadesBeneficiarios("/resources/APS_talonResumenBeneficiario.properties");
        DataCatalogos dataCatalogos = new DataCatalogos();
        String nombreArchivo = "ABT_talonResumen.html";
        String dir1 = String.valueOf(File.separator) + ".dimmData";
        String dir2 = String.valueOf(File.separator) + "talon_resumen";
        String userHome = System.getProperty("user.home");
        String rutaCompleta = String.valueOf(userHome) + dir1;
        File folder = new File(rutaCompleta);
        if (folder.exists()) {
            PluginLogger.logInfo((String)("ya existe el directorio:" + rutaCompleta), (String)"ec.gob.sri.dimm.aps.modelo");
        } else {
            folder.mkdir();
        }
        rutaCompleta = String.valueOf(rutaCompleta) + dir2;
        folder = new File(rutaCompleta);
        if (folder.exists()) {
            PluginLogger.logInfo((String)("ya existe el directorio:" + rutaCompleta), (String)"ec.gob.sri.dimm.aps.modelo");
        } else {
            folder.mkdir();
        }
        String logo = propertiesTalonResumen.getProperty("aps.logoTalonResumen");
        String cabecera = propertiesTalonResumen.getProperty("aps.cabeceraTalonResumen");
        cabecera = cabecera.replace("#NUM_INDENTIFICACION#", modelo.getIdentificacion());
        ModeloValoresDatosInformante modeloVal = new ModeloValoresDatosInformante();
        modeloVal.inicializar();
        cabecera = cabecera.replace("#PERIODO#", modelo.getMes().equals("00") ? modelo.getAnio() : String.valueOf(modeloVal.obtenerMes(modelo.getMes()).getNombre()) + " " + modelo.getAnio());
        DateFormat format = DateFormat.getDateInstance();
        cabecera = cabecera.replace("#FECHA#", format.format(Calendar.getInstance().getTime()));
        String inicio = propertiesTalonResumen.getProperty("aps.inicio");
        String fin = propertiesTalonResumen.getProperty("aps.fin");
        ArrayList<String> listaTiposRelacionados = new ArrayList<String>();
        ArrayList<Long> codigosTipos = new ArrayList<Long>();
        List<TipoIdEnum> listaTiposId = Arrays.asList(TipoIdEnum.values());
        TreeMap<Long, String> claveValorBeneficiario = new TreeMap<Long, String>();
        List<TipoBeneficiarioEnum> listaEnumTiposBeneficiarios = Arrays.asList(TipoBeneficiarioEnum.values());
        ArrayList<String> listaTiposBeneficiarios = new ArrayList<String>();
        ArrayList<Long> codigosTiposBeneficiario = new ArrayList<Long>();
        for (TipoBeneficiarioEnum tipo : listaEnumTiposBeneficiarios) {
            listaTiposBeneficiarios.add(tipo.getCodigo());
            codigosTiposBeneficiario.add(Long.parseLong(tipo.getCodigo()));
            claveValorBeneficiario.put(Long.valueOf(tipo.codigo), tipo.getCodigo());
        }
        TreeMap<Long, String> claveValorCatalogos = new TreeMap<Long, String>();
        Map mapaCatalogos = dataCatalogos.obtenerValoresCatalogos(NemonicoCatalogoEnum.TIPO_RELACIONADO_SOCIEDAD.getNemonico());
        for (Map.Entry entry : mapaCatalogos.entrySet()) {
            if (UtilValidacion.esAnexoDesdePeriodo2024(modelo.getAnio(), modelo.getMes())) {
                if (((String)entry.getKey()).equals("01") || ((String)entry.getKey()).equals("02") || ((String)entry.getKey()).equals("03")) continue;
                listaTiposRelacionados.add((String)entry.getValue());
                codigosTipos.add(Long.parseLong((String)entry.getKey()));
                claveValorCatalogos.put(Long.parseLong((String)entry.getKey()), (String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals("10") || ((String)entry.getKey()).equals("11") || ((String)entry.getKey()).equals("12") || ((String)entry.getKey()).equals("13") || ((String)entry.getKey()).equals("14")) continue;
            listaTiposRelacionados.add((String)entry.getValue());
            codigosTipos.add(Long.parseLong((String)entry.getKey()));
            claveValorCatalogos.put(Long.parseLong((String)entry.getKey()), (String)entry.getValue());
        }
        List<RigApsDataTalonResumen> listaTrDirectos = this.generarDatosTalonResumenNivel1(modelo);
        List<RigApsDataTalonResumen> listaTotalDirectos = this.calcularTotalNivel(listaTrDirectos, codigosTipos);
        List<RigApsDataTalonResumen> listaTrSecundarios = this.generarDatosTalonResumenOtrosNiveles(modelo);
        List<RigApsDataTalonResumen> listaTotalSecundarios = this.calcularTotalNivel(listaTrSecundarios, codigosTipos);
        List<RigApsDataTalonResumen> listaTrBeneficiarios = this.generarDatosTalonResumenBeneficiarios(modelo);
        List<RigApsDataTalonResumen> listaTotalBeneficiarios = this.calcularTotalesBeneficiarios(listaTrBeneficiarios, codigosTiposBeneficiario);
        this.talonResumen.append(logo);
        this.talonResumen.append(cabecera);
        this.talonResumen.append(inicio);
        this.getDataTalonResumen(listaTiposRelacionados, listaTiposId, listaTrDirectos, listaTotalDirectos, "DIRECTOS", claveValorCatalogos);
        this.getDataTalonResumen(listaTiposRelacionados, listaTiposId, listaTrSecundarios, listaTotalSecundarios, "SECUNDARIOS", claveValorCatalogos);
        if (UtilValidacion.esAnexoDesdePeriodo2024(modelo.getAnio(), modelo.getMes())) {
            this.getDataTalonResumenBeneficiarios(listaTiposBeneficiarios, listaTiposId, listaTrBeneficiarios, listaTotalBeneficiarios, claveValorBeneficiario);
        }
        this.talonResumen.append(fin);
        return this.guardarTalonResumen(rutaCompleta, nombreArchivo, this.talonResumen.toString());
    }

    private void getDataTalonResumenBeneficiarios(List<String> listaTiposBeneficiarios, List<TipoIdEnum> listaTiposId, List<RigApsDataTalonResumen> listaData, List<RigApsDataTalonResumen> listaTotal, Map<Long, String> claveValorBeneficiario) {
        String tagDos = propertiesBeneficiarioTalonResumen.getProperty("aps.tag.dos");
        String tagTres = propertiesBeneficiarioTalonResumen.getProperty("aps.tag.tres");
        String tagCuatro = propertiesBeneficiarioTalonResumen.getProperty("aps.tag.cuatro");
        String tagCinco = propertiesBeneficiarioTalonResumen.getProperty("aps.tag.cinco");
        String tagSeis = propertiesBeneficiarioTalonResumen.getProperty("aps.tag.seis");
        String tagSiete = propertiesBeneficiarioTalonResumen.getProperty("aps.tag.siete");
        String tagOcho = propertiesBeneficiarioTalonResumen.getProperty("aps.tag.ocho");
        StringBuilder tiposBeneficiarios = new StringBuilder();
        StringBuilder labelTotalesBeneficiarios = new StringBuilder();
        StringBuilder tiposId = new StringBuilder();
        for (String tipoBeneficiario : listaTiposBeneficiarios) {
            tiposBeneficiarios.append(tagTres.replace("#TIPO_BENEFICIARIO#", TipoBeneficiarioEnum.fromCodigo(tipoBeneficiario)));
            labelTotalesBeneficiarios.append(tagSiete.replace("#TOTAL#", "#" + tipoBeneficiario + "#"));
        }
        for (TipoIdEnum tipoId : listaTiposId) {
            tiposId.append(tagCuatro.replace("#TIPO_ID#", tipoId.getNombreTipo()));
            for (String beneficiario : listaTiposBeneficiarios) {
                tiposId.append(this.getValorTalonResumenBeneficiario(beneficiario, tipoId.name(), tagCinco, listaData, claveValorBeneficiario));
            }
        }
        this.talonResumen.append(tagDos);
        this.talonResumen.append((CharSequence)tiposBeneficiarios);
        this.talonResumen.append((CharSequence)tiposId);
        this.talonResumen.append(tagSeis.replace("#LABEL_TOTAL#", "Total"));
        this.talonResumen.append(TalonResumenAPS.getTotalTalonResumenBeneficiario(listaTotal, listaTiposBeneficiarios, labelTotalesBeneficiarios.toString(), claveValorBeneficiario));
        this.talonResumen.append(tagOcho);
    }

    private String getValorTalonResumenBeneficiario(String beneficiario, String name, String tagCinco, List<RigApsDataTalonResumen> listaData, Map<Long, String> claveValorBeneficiario) {
        String valorFila = "";
        if (listaData.isEmpty()) {
            valorFila = tagCinco.replace("#VALOR#", "&nbsp;");
        } else {
            for (RigApsDataTalonResumen value : listaData) {
                if (claveValorBeneficiario.get(value.getCodigoRelacionSociedad()).equals(beneficiario) && value.getTipoIdAccionista().equals(name)) {
                    valorFila = tagCinco.replace("#VALOR#", value.getConteoRegistro().toString());
                    break;
                }
                valorFila = tagCinco.replace("#VALOR#", "&nbsp;");
            }
        }
        return valorFila;
    }

    private List<RigApsDataTalonResumen> calcularTotalesBeneficiarios(List<RigApsDataTalonResumen> listaTrBeneficiarios, List<Long> codigosTipos) {
        ArrayList<RigApsDataTalonResumen> resultado = new ArrayList<RigApsDataTalonResumen>();
        Hashtable<Long, RigApsDataTalonResumen> mapaTipos = new Hashtable<Long, RigApsDataTalonResumen>();
        for (Long l : codigosTipos) {
            mapaTipos.put(l, new RigApsDataTalonResumen(l.longValue(), Long.valueOf(0L), BigDecimal.ZERO));
        }
        for (RigApsDataTalonResumen rigApsDataTalonResumen : listaTrBeneficiarios) {
            RigApsDataTalonResumen tmp = (RigApsDataTalonResumen)mapaTipos.get(rigApsDataTalonResumen.getCodigoRelacionSociedad());
            tmp.setConteoRegistro(Long.valueOf(tmp.getConteoRegistro() + rigApsDataTalonResumen.getConteoRegistro()));
            tmp.setPorcentajeParticipacion(tmp.getPorcentajeParticipacion().add(rigApsDataTalonResumen.getPorcentajeParticipacion()));
            mapaTipos.put(rigApsDataTalonResumen.getCodigoRelacionSociedad(), tmp);
        }
        for (Map.Entry entry : mapaTipos.entrySet()) {
            resultado.add((RigApsDataTalonResumen)entry.getValue());
        }
        return resultado;
    }

    private String getValorTalonResumen(String tipoRelacionado, String tipoId, String tagCinco, List<RigApsDataTalonResumen> listaData, String codigoSeccion, Map<Long, String> claveValorCatalogos) {
        String valorFila = "";
        if (listaData.isEmpty()) {
            valorFila = tagCinco.replace("#VALOR#", "&nbsp;");
        } else {
            for (RigApsDataTalonResumen value : listaData) {
                if (claveValorCatalogos.get(value.getCodigoRelacionSociedad()).equals(tipoRelacionado) && value.getTipoIdAccionista().equals(tipoId)) {
                    if (codigoSeccion.equals("SECUNDARIOS")) {
                        valorFila = tagCinco.replace("#VALOR#", value.getConteoRegistro().toString());
                        break;
                    }
                    valorFila = tagCinco.replace("#VALOR#", claveValorCatalogos.get(value.getCodigoRelacionSociedad()).equals("MIEMBRO DE DIRECTORIO") || claveValorCatalogos.get(value.getCodigoRelacionSociedad()).equals("ADMINISTRADOR") || claveValorCatalogos.get(value.getCodigoRelacionSociedad()).equals("APODERADO GENERAL") ? value.getConteoRegistro().toString() : value.getPorcentajeParticipacion() + "%");
                    break;
                }
                valorFila = tagCinco.replace("#VALOR#", "&nbsp;");
            }
        }
        return valorFila;
    }

    private void getDataTalonResumen(List<String> listaTiposRelacionados, List<TipoIdEnum> listaTiposId, List<RigApsDataTalonResumen> listaData, List<RigApsDataTalonResumen> listaTotal, String codigoSeccion, Map<Long, String> claveValorCatalogos) {
        String tagDos = propertiesTalonResumen.getProperty("aps.tag.dos");
        String tagTres = propertiesTalonResumen.getProperty("aps.tag.tres");
        String tagCuatro = propertiesTalonResumen.getProperty("aps.tag.cuatro");
        String tagCinco = propertiesTalonResumen.getProperty("aps.tag.cinco");
        String tagSeis = propertiesTalonResumen.getProperty("aps.tag.seis");
        String tagSiete = propertiesTalonResumen.getProperty("aps.tag.siete");
        String tagOcho = propertiesTalonResumen.getProperty("aps.tag.ocho");
        StringBuilder tiposRelacionados = new StringBuilder();
        StringBuilder labelTotales = new StringBuilder();
        StringBuilder tiposId = new StringBuilder();
        for (String tipoRelacionado : listaTiposRelacionados) {
            tiposRelacionados.append(tagTres.replace("#TIPO_RELACIONADO#", tipoRelacionado));
            labelTotales.append(tagSiete.replace("#TOTAL#", "#" + tipoRelacionado + "#"));
        }
        for (TipoIdEnum tipoId : listaTiposId) {
            tiposId.append(tagCuatro.replace("#TIPO_ID#", tipoId.getNombreTipo()));
            for (String tipoRelacionado : listaTiposRelacionados) {
                tiposId.append(this.getValorTalonResumen(tipoRelacionado, tipoId.name(), tagCinco, listaData, codigoSeccion, claveValorCatalogos));
            }
        }
        this.talonResumen.append(tagDos.replace("#DIR_SEC#", codigoSeccion));
        this.talonResumen.append((CharSequence)tiposRelacionados);
        this.talonResumen.append((CharSequence)tiposId);
        this.talonResumen.append(tagSeis.replace("#LABEL_TOTAL#", "Total"));
        this.talonResumen.append(TalonResumenAPS.getTotalTalonResumen(listaTotal, listaTiposRelacionados, labelTotales.toString(), codigoSeccion, claveValorCatalogos));
        this.talonResumen.append(tagOcho);
    }

    private static String getTotalTalonResumen(List<RigApsDataTalonResumen> listaTotal, List<String> listaTiposRelacionados, String labelTotales, String codigoSeccion, Map<Long, String> claveValorCatalogos) {
        for (RigApsDataTalonResumen r : listaTotal) {
            labelTotales = codigoSeccion.equals("SECUNDARIOS") ? labelTotales.replace("#" + claveValorCatalogos.get(r.getCodigoRelacionSociedad()) + "#", r.getConteoRegistro().toString()) : labelTotales.replace("#" + claveValorCatalogos.get(r.getCodigoRelacionSociedad()) + "#", claveValorCatalogos.get(r.getCodigoRelacionSociedad()).equals("MIEMBRO DE DIRECTORIO") || claveValorCatalogos.get(r.getCodigoRelacionSociedad()).equals("ADMINISTRADOR") || claveValorCatalogos.get(r.getCodigoRelacionSociedad()).equals("APODERADO GENERAL") ? r.getConteoRegistro().toString() : r.getPorcentajeParticipacion() + "%");
        }
        for (String s : listaTiposRelacionados) {
            labelTotales = labelTotales.replace("#" + s + "#", " ");
        }
        return labelTotales;
    }

    private static String getTotalTalonResumenBeneficiario(List<RigApsDataTalonResumen> listaTotal, List<String> listaTiposRelacionados, String labelTotales, Map<Long, String> claveValorCatalogos) {
        for (RigApsDataTalonResumen r : listaTotal) {
            labelTotales = labelTotales.replace("#" + claveValorCatalogos.get(r.getCodigoRelacionSociedad()) + "#", r.getConteoRegistro().toString());
        }
        for (String s : listaTiposRelacionados) {
            labelTotales = labelTotales.replace("#" + s + "#", " ");
        }
        return labelTotales;
    }

    private List<RigApsDataTalonResumen> generarDatosTalonResumenBeneficiarios(Informante modelo) {
        Hashtable data = new Hashtable();
        ArrayList<RigApsDataTalonResumen> listaResultados = new ArrayList<RigApsDataTalonResumen>();
        data.put("C", new Hashtable());
        data.put("P", new Hashtable());
        data.put("R", new Hashtable());
        data.put("E", new Hashtable());
        for (Beneficiario beneficiario : modelo.getBeneficiarios()) {
            PorcentajeConteo objDetalle;
            Map mapExportar = (Map)data.get(beneficiario.getTipoIdentificacion());
            if ("SI".equals(beneficiario.getPorPropiedad())) {
                if (mapExportar.containsKey(TipoBeneficiarioEnum.POR_PROPIEDAD.getCodigo())) {
                    objDetalle = (PorcentajeConteo)mapExportar.get(TipoBeneficiarioEnum.POR_PROPIEDAD.getCodigo());
                    objDetalle.setConteo(objDetalle.getConteo() + 1);
                    mapExportar.put(TipoBeneficiarioEnum.POR_PROPIEDAD.getCodigo(), objDetalle);
                } else {
                    mapExportar.put(TipoBeneficiarioEnum.POR_PROPIEDAD.getCodigo(), new PorcentajeConteo(new BigDecimal(1), 1));
                }
            }
            if (beneficiario.getPorOtrosMotivos() != null && !"09".equals(beneficiario.getPorOtrosMotivos())) {
                if (mapExportar.containsKey(TipoBeneficiarioEnum.POR_MOTIVOS_CONTROL.getCodigo())) {
                    objDetalle = (PorcentajeConteo)mapExportar.get(TipoBeneficiarioEnum.POR_MOTIVOS_CONTROL.getCodigo());
                    objDetalle.setConteo(objDetalle.getConteo() + 1);
                    mapExportar.put(TipoBeneficiarioEnum.POR_MOTIVOS_CONTROL.getCodigo(), objDetalle);
                } else {
                    mapExportar.put(TipoBeneficiarioEnum.POR_MOTIVOS_CONTROL.getCodigo(), new PorcentajeConteo(new BigDecimal(1), 1));
                }
            }
            if (!"SI".equals(beneficiario.getPorAdministracion())) continue;
            if (mapExportar.containsKey(TipoBeneficiarioEnum.POR_ADMINISTRACION.getCodigo())) {
                objDetalle = (PorcentajeConteo)mapExportar.get(TipoBeneficiarioEnum.POR_ADMINISTRACION.getCodigo());
                objDetalle.setConteo(objDetalle.getConteo() + 1);
                mapExportar.put(TipoBeneficiarioEnum.POR_ADMINISTRACION.getCodigo(), objDetalle);
                continue;
            }
            mapExportar.put(TipoBeneficiarioEnum.POR_ADMINISTRACION.getCodigo(), new PorcentajeConteo(new BigDecimal(1), 1));
        }
        Map mapExportar = (Map)data.get("C");
        this.exportarPorTipoId(listaResultados, mapExportar, "C");
        mapExportar = (Map)data.get("P");
        this.exportarPorTipoId(listaResultados, mapExportar, "P");
        mapExportar = (Map)data.get("R");
        this.exportarPorTipoId(listaResultados, mapExportar, "R");
        mapExportar = (Map)data.get("E");
        this.exportarPorTipoId(listaResultados, mapExportar, "E");
        return listaResultados;
    }

    private List<RigApsDataTalonResumen> generarDatosTalonResumenNivel1(Informante modelo) {
        Hashtable data = new Hashtable();
        ArrayList<RigApsDataTalonResumen> listaResultados = new ArrayList<RigApsDataTalonResumen>();
        data.put("C", new Hashtable());
        data.put("P", new Hashtable());
        data.put("R", new Hashtable());
        data.put("E", new Hashtable());
        for (Participacion participacion : modelo.getParticipaciones()) {
            Map mapExportar = (Map)data.get(participacion.getSujeto().getTipoIdentificacion());
            if (mapExportar.containsKey(participacion.getTipoDeRelacion())) {
                PorcentajeConteo objDetalle = (PorcentajeConteo)mapExportar.get(participacion.getTipoDeRelacion());
                objDetalle.setConteo(objDetalle.getConteo() + 1);
                objDetalle.setPorcentaje(objDetalle.getPorcentaje().add(new BigDecimal(participacion.getPorcentajeParticipacion())));
                mapExportar.put(participacion.getTipoDeRelacion(), objDetalle);
                continue;
            }
            mapExportar.put(participacion.getTipoDeRelacion(), new PorcentajeConteo(new BigDecimal(participacion.getPorcentajeParticipacion()), 1));
        }
        Map mapExportar = (Map)data.get("C");
        this.exportarPorTipoId(listaResultados, mapExportar, "C");
        mapExportar = (Map)data.get("P");
        this.exportarPorTipoId(listaResultados, mapExportar, "P");
        mapExportar = (Map)data.get("R");
        this.exportarPorTipoId(listaResultados, mapExportar, "R");
        mapExportar = (Map)data.get("E");
        this.exportarPorTipoId(listaResultados, mapExportar, "E");
        return listaResultados;
    }

    private List<RigApsDataTalonResumen> calcularTotalNivel(List<RigApsDataTalonResumen> listaResultados, List<Long> listaTiposRelacionados) {
        ArrayList<RigApsDataTalonResumen> resultado = new ArrayList<RigApsDataTalonResumen>();
        Hashtable<Long, RigApsDataTalonResumen> mapaTipos = new Hashtable<Long, RigApsDataTalonResumen>();
        for (Long l : listaTiposRelacionados) {
            mapaTipos.put(l, new RigApsDataTalonResumen(l.longValue(), Long.valueOf(0L), BigDecimal.ZERO));
        }
        for (RigApsDataTalonResumen rigApsDataTalonResumen : listaResultados) {
            RigApsDataTalonResumen tmp = (RigApsDataTalonResumen)mapaTipos.get(rigApsDataTalonResumen.getCodigoRelacionSociedad());
            tmp.setConteoRegistro(Long.valueOf(tmp.getConteoRegistro() + rigApsDataTalonResumen.getConteoRegistro()));
            tmp.setPorcentajeParticipacion(tmp.getPorcentajeParticipacion().add(rigApsDataTalonResumen.getPorcentajeParticipacion()));
            mapaTipos.put(rigApsDataTalonResumen.getCodigoRelacionSociedad(), tmp);
        }
        for (Map.Entry entry : mapaTipos.entrySet()) {
            resultado.add((RigApsDataTalonResumen)entry.getValue());
        }
        return resultado;
    }

    private List<RigApsDataTalonResumen> generarDatosTalonResumenOtrosNiveles(Informante modelo) {
        Hashtable<String, Map<String, PorcentajeConteo>> data = new Hashtable<String, Map<String, PorcentajeConteo>>();
        data.put("C", new Hashtable());
        data.put("P", new Hashtable());
        data.put("R", new Hashtable());
        data.put("E", new Hashtable());
        ArrayList<RigApsDataTalonResumen> listaResultados = new ArrayList<RigApsDataTalonResumen>();
        for (Participacion participacion : modelo.getParticipaciones()) {
            if (participacion.getSujeto().getIdentificacion().equals(modelo.getIdentificacion()) || !"E".equals(participacion.getSujeto().getTipoIdentificacion()) || participacion.getSujeto().isSociedadExtranjeraPublica() || "00".equals(participacion.getSujeto().getTipoSociedadExtranjera())) continue;
            for (Participacion nivel2 : participacion.getSujeto().getParticipaciones()) {
                this.generarDataParticipacion(nivel2, data, modelo);
            }
        }
        Map mapExportar = (Map)data.get("C");
        this.exportarPorTipoId(listaResultados, mapExportar, "C");
        mapExportar = (Map)data.get("P");
        this.exportarPorTipoId(listaResultados, mapExportar, "P");
        mapExportar = (Map)data.get("R");
        this.exportarPorTipoId(listaResultados, mapExportar, "R");
        mapExportar = (Map)data.get("E");
        this.exportarPorTipoId(listaResultados, mapExportar, "E");
        return listaResultados;
    }

    private void generarDataParticipacion(Participacion participacion, Map<String, Map<String, PorcentajeConteo>> data, Informante modelo) {
        Map<String, PorcentajeConteo> mapExportar = data.get(participacion.getSujeto().getTipoIdentificacion());
        String md5 = UtilidadHash.generarMD5Participacion(participacion.getSujeto().getTipoIdentificacion(), participacion.getSujeto().getIdentificacion(), participacion.getPropietario() instanceof SujetoRelacionado ? ((SujetoRelacionado)participacion.getPropietario()).getIdentificacion() : modelo.getIdentificacion(), participacion.getTipoDeRelacion());
        if (this.elementosSumados.add(md5)) {
            if (mapExportar.containsKey(participacion.getTipoDeRelacion())) {
                PorcentajeConteo objDetalle = mapExportar.get(participacion.getTipoDeRelacion());
                objDetalle.setConteo(objDetalle.getConteo() + 1);
                objDetalle.setPorcentaje(objDetalle.getPorcentaje().add(new BigDecimal(participacion.getPorcentajeParticipacion())));
                mapExportar.put(participacion.getTipoDeRelacion(), objDetalle);
            } else {
                mapExportar.put(participacion.getTipoDeRelacion(), new PorcentajeConteo(new BigDecimal(participacion.getPorcentajeParticipacion()), 1));
            }
            if (!participacion.getSujeto().getIdentificacion().equals(modelo.getIdentificacion()) && "E".equals(participacion.getSujeto().getTipoIdentificacion()) && !participacion.getSujeto().isSociedadExtranjeraPublica() && !"00".equals(participacion.getSujeto().getTipoSociedadExtranjera())) {
                for (Participacion part : participacion.getSujeto().getParticipaciones()) {
                    this.generarDataParticipacion(part, data, modelo);
                }
            } else {
                return;
            }
        }
    }

    private void exportarPorTipoId(List<RigApsDataTalonResumen> listaResultados, Map<String, PorcentajeConteo> mapExportar, String tipoId) {
        if (mapExportar != null) {
            for (String tipoRelacion : mapExportar.keySet()) {
                listaResultados.add(new RigApsDataTalonResumen(Long.parseLong(tipoRelacion), tipoId, Long.valueOf(mapExportar.get(tipoRelacion).getConteo()), mapExportar.get(tipoRelacion).getPorcentaje()));
            }
        }
    }

    private void cargarPropiedades(String filePath) throws FileNotFoundException, IOException {
        if (propertiesTalonResumen == null) {
            propertiesTalonResumen = new Properties();
            InputStream is = TalonResumenAPS.class.getResourceAsStream(filePath);
            propertiesTalonResumen.load(is);
        }
    }

    private void cargarPropiedadesBeneficiarios(String filePath) throws FileNotFoundException, IOException {
        if (propertiesBeneficiarioTalonResumen == null) {
            propertiesBeneficiarioTalonResumen = new Properties();
            InputStream is = TalonResumenAPS.class.getResourceAsStream(filePath);
            propertiesBeneficiarioTalonResumen.load(is);
        }
    }

    private File guardarTalonResumen(String directorio, String nombreArchivo, String talonResumenFinal) {
        OutputStreamWriter oos = null;
        File archivo = null;
        try {
            try {
                archivo = new File(directorio, nombreArchivo);
                oos = new OutputStreamWriter(new FileOutputStream(archivo));
                oos.write(talonResumenFinal);
            }
            catch (IOException ioe) {
                throw new RuntimeException("guardarTalonResumen()::directorio" + directorio, ioe);
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            oos = null;
            talonResumenFinal = null;
        }
        return archivo;
    }

    public static enum TipoBeneficiarioEnum {
        POR_PROPIEDAD("01", "POR PROPIEDAD"),
        POR_MOTIVOS_CONTROL("02", "POR OTROS MOTIVOS DE CONTROL"),
        POR_ADMINISTRACION("03", "POR ADMINISTRACION");

        private String codigo;
        private String tipo;

        private TipoBeneficiarioEnum(String codigo, String tipo) {
            this.codigo = codigo;
            this.tipo = tipo;
        }

        public String getCodigo() {
            return this.codigo;
        }

        public String getTipo() {
            return this.tipo;
        }

        public static String fromCodigo(String codigo) {
            TipoBeneficiarioEnum[] tipoBeneficiarioEnumArray = TipoBeneficiarioEnum.values();
            int n = tipoBeneficiarioEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                TipoBeneficiarioEnum beneficiario = tipoBeneficiarioEnumArray[n2];
                if (beneficiario.getCodigo() == codigo) {
                    return beneficiario.getTipo();
                }
                ++n2;
            }
            throw new IllegalArgumentException("C\u00f3digo inv\u00e1lido: " + codigo);
        }
    }
}

